/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.app.services;

import com.atlassian.jira.exception.NotFoundException;
import com.atlassian.jira.migration.app.CloudMigrationRegistrar;
import com.atlassian.jira.migration.execution.CachedPlanStatusService;
import com.atlassian.jira.migration.migration.Migration;
import com.atlassian.jira.migration.migration.MigrationRepository;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.progress.AppsProgressService;
import com.atlassian.migration.app.dto.RerunEnablementDto;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0010J*\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0010R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/app/services/AppRerunService;", "", "cloudMigrationRegistrar", "Lcom/atlassian/jira/migration/app/CloudMigrationRegistrar;", "migrationRepository", "Lcom/atlassian/jira/migration/migration/MigrationRepository;", "planStore", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "appsProgressService", "Lcom/atlassian/jira/migration/progress/AppsProgressService;", "planStatusService", "Lcom/atlassian/jira/migration/execution/CachedPlanStatusService;", "(Lcom/atlassian/jira/migration/app/CloudMigrationRegistrar;Lcom/atlassian/jira/migration/migration/MigrationRepository;Lcom/atlassian/jira/migration/plan/PlanRepository;Lcom/atlassian/jira/migration/progress/AppsProgressService;Lcom/atlassian/jira/migration/execution/CachedPlanStatusService;)V", "isRerunEnabled", "Lcom/atlassian/migration/app/dto/RerunEnablementDto;", "containerId", "", "planId", "serverAppKey", "transferId", "rerunAppMigration", "", "jira-migration-plugin"})
public final class AppRerunService {
    @NotNull
    private final CloudMigrationRegistrar cloudMigrationRegistrar;
    @NotNull
    private final MigrationRepository migrationRepository;
    @NotNull
    private final PlanRepository planStore;
    @NotNull
    private final AppsProgressService appsProgressService;
    @NotNull
    private final CachedPlanStatusService planStatusService;

    @Inject
    public AppRerunService(@NotNull CloudMigrationRegistrar cloudMigrationRegistrar, @NotNull MigrationRepository migrationRepository, @NotNull PlanRepository planStore, @NotNull AppsProgressService appsProgressService, @NotNull CachedPlanStatusService planStatusService) {
        Intrinsics.checkNotNullParameter((Object)((Object)cloudMigrationRegistrar), (String)"cloudMigrationRegistrar");
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        Intrinsics.checkNotNullParameter((Object)planStore, (String)"planStore");
        Intrinsics.checkNotNullParameter((Object)appsProgressService, (String)"appsProgressService");
        Intrinsics.checkNotNullParameter((Object)planStatusService, (String)"planStatusService");
        this.cloudMigrationRegistrar = cloudMigrationRegistrar;
        this.migrationRepository = migrationRepository;
        this.planStore = planStore;
        this.appsProgressService = appsProgressService;
        this.planStatusService = planStatusService;
    }

    @NotNull
    public final RerunEnablementDto isRerunEnabled(@NotNull String containerId, @NotNull String planId, @NotNull String serverAppKey, @Nullable String transferId) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)serverAppKey, (String)"serverAppKey");
        Plan plan2 = this.planStore.get(planId);
        if (plan2 != null) {
            Plan it = plan2;
            boolean bl = false;
            String cloudId2 = it.getCloudId();
            return this.cloudMigrationRegistrar.isRerunEnabled(cloudId2, containerId, serverAppKey, transferId);
        }
        throw new NotFoundException("Plan was not found");
    }

    public static /* synthetic */ RerunEnablementDto isRerunEnabled$default(AppRerunService appRerunService, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = null;
        }
        return appRerunService.isRerunEnabled(string, string2, string3, string4);
    }

    public final void rerunAppMigration(@NotNull String planId, @NotNull String containerId, @NotNull String serverAppKey, @Nullable String transferId) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        Intrinsics.checkNotNullParameter((Object)serverAppKey, (String)"serverAppKey");
        Plan plan2 = this.planStore.get(planId);
        Migration migration = this.migrationRepository.findLatestByPlanId(planId);
        if (plan2 == null || migration == null) {
            throw new IllegalArgumentException("No migration found for planId " + planId);
        }
        MigrationRepository.clearAppStatusForRerun$default(this.migrationRepository, migration.getMigrationId(), null, 2, null);
        this.appsProgressService.clearAppProgressCache(plan2.getCloudId(), migration.getMigrationId());
        this.planStatusService.clearCacheForPlan(plan2);
        this.cloudMigrationRegistrar.rerunMigration(plan2.getCloudId(), migration.getMigrationId(), containerId, serverAppKey, transferId);
    }

    public static /* synthetic */ void rerunAppMigration$default(AppRerunService appRerunService, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = null;
        }
        appRerunService.rerunAppMigration(string, string2, string3, string4);
    }
}

