/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.assessment;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.jira.migration.MigrationServicesConfiguration;
import com.atlassian.jira.migration.assessment.AppAggregatorClient;
import com.atlassian.jira.migration.assessment.AppAggregatorResponse;
import com.atlassian.jira.migration.assessment.AppUsageCheckRequest;
import com.atlassian.jira.migration.assessment.AppUsageCheckResponse;
import com.atlassian.jira.migration.assessment.BulkAppAggregatorResponse;
import com.atlassian.jira.migration.common.Hosting;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.httpclient.AbstractPluginHttpClientKt;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpClient;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpRequest;
import com.atlassian.jira.migration.httpclient.MigrationUserAgentProvider;
import com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException;
import com.atlassian.migration.app.MigrationAppAggregatorClient;
import com.atlassian.migration.app.dto.check.DisabledCheck;
import com.atlassian.sal.api.license.LicenseHandler;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u0000 M2\u00020\u0001:\u0001MB/\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00140,2\u0006\u0010-\u001a\u00020\u0013H\u0002J\u0018\u0010.\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u0013H\u0007J\u0018\u00100\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u0013H\u0002J\u0018\u00101\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u0013H\u0002J\u001a\u00102\u001a\u0004\u0018\u00010\u00142\u0006\u0010-\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u0013H\u0002J\u001e\u00103\u001a\u00020#2\u0006\u00104\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u00132\u0006\u00105\u001a\u00020\u0013J \u00106\u001a\u00020#2\u0006\u00104\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u00132\u0006\u00105\u001a\u00020\u0013H\u0002J\"\u00107\u001a\b\u0012\u0004\u0012\u00020\u00140,2\u0006\u0010-\u001a\u00020\u00132\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00130\u001dJ$\u00109\u001a\b\u0012\u0004\u0012\u00020\u00140,2\u0006\u0010-\u001a\u00020\u00132\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00130\u001dH\u0002J\u001e\u0010:\u001a\u00020;2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00130\u001d2\u0006\u0010-\u001a\u00020\u0013H\u0002J\u001a\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00140,2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00130\u001dJ\u000e\u0010=\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u0013J\b\u0010>\u001a\u00020\u0013H\u0002J\u001c\u0010?\u001a\b\u0012\u0004\u0012\u00020@0\u001d2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00130\u001dH\u0016J\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00130\u001d2\u0006\u0010C\u001a\u00020\u0013H\u0002J\u000e\u0010D\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u0013J\u000e\u0010E\u001a\u00020F2\u0006\u0010/\u001a\u00020\u0013J\u000e\u0010G\u001a\u00020F2\u0006\u0010/\u001a\u00020\u0013J&\u0010H\u001a\u00020*2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00130\u001d2\u0006\u0010J\u001a\u00020\u00132\u0006\u0010C\u001a\u00020\u0013H\u0002J\u0006\u0010K\u001a\u00020*J\u0006\u0010L\u001a\u00020*R3\u0010\u0010\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0004\u0012\u00020\u00140\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R3\u0010\u0019\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0004\u0012\u00020\u00140\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0018\u001a\u0004\b\u001a\u0010\u0016R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR3\u0010\"\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0004\u0012\u00020#0\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u0018\u001a\u0004\b$\u0010\u0016R-\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u001d0\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u0018\u001a\u0004\b'\u0010\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/atlassian/jira/migration/assessment/AppAggregatorClient;", "Lcom/atlassian/migration/app/MigrationAppAggregatorClient;", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "licenseHandler", "Lcom/atlassian/sal/api/license/LicenseHandler;", "userAgentProvider", "Lcom/atlassian/jira/migration/httpclient/MigrationUserAgentProvider;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "migrationServicesConfiguration", "Lcom/atlassian/jira/migration/MigrationServicesConfiguration;", "(Lcom/atlassian/cache/CacheManager;Lcom/atlassian/sal/api/license/LicenseHandler;Lcom/atlassian/jira/migration/httpclient/MigrationUserAgentProvider;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Lcom/atlassian/jira/migration/MigrationServicesConfiguration;)V", "httpClient", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClient;", "(Lcom/atlassian/cache/CacheManager;Lcom/atlassian/sal/api/license/LicenseHandler;Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClient;Lcom/atlassian/jira/migration/MigrationServicesConfiguration;)V", "appAggregatorCache", "Lcom/atlassian/cache/Cache;", "Lkotlin/Pair;", "", "Lcom/atlassian/jira/migration/assessment/AppAggregatorResponse;", "getAppAggregatorCache", "()Lcom/atlassian/cache/Cache;", "appAggregatorCache$delegate", "Lkotlin/Lazy;", "appAggregatorNotFoundCache", "getAppAggregatorNotFoundCache", "appAggregatorNotFoundCache$delegate", "appAssessmentBlacklist", "", "getAppAssessmentBlacklist", "()Ljava/util/Set;", "appAssessmentReliableList", "getAppAssessmentReliableList", "appUsageAvailabilityCache", "Lcom/atlassian/jira/migration/assessment/AppUsageCheckResponse;", "getAppUsageAvailabilityCache", "appUsageAvailabilityCache$delegate", "appsListCache", "getAppsListCache", "appsListCache$delegate", "cacheSuccessAndNotFoundAppResponses", "", "apps", "", "hosting", "getAppData", "pluginKey", "getAppDataFromAppAggregatorService", "getAppDataFromCache", "getAppDataOnlyFromCache", "getAppUsageAvailability", "product", "version", "getAppUsageAvailabilityFromMaa", "getBatchAppData", "pluginKeys", "getBatchAppDataFromAggregatorService", "getBatchAppDataRequest", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpRequest;", "getBatchServerAppData", "getCloudAppData", "getDCOrServerHosting", "getDisabledAppVendorChecks", "Lcom/atlassian/migration/app/dto/check/DisabledCheck;", "serverAppKeys", "getListFromAppAggregator", "path", "getServerAppData", "isAppReliable", "", "isBlacklisted", "validateAndReloadAppListCache", "appListName", "key", "validateAndReloadBlacklist", "validateAndReloadReliableList", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppAggregatorClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppAggregatorClient.kt\ncom/atlassian/jira/migration/assessment/AppAggregatorClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,384:1\n1#2:385\n1#2:398\n51#3:386\n51#3:387\n51#3:413\n51#3:430\n1603#4,9:388\n1855#4:397\n1856#4:399\n1612#4:400\n766#4:401\n857#4:402\n2624#4,3:403\n858#4:406\n1360#4:407\n1446#4,5:408\n766#4:414\n857#4,2:415\n1549#4:417\n1620#4,3:418\n1549#4:421\n1620#4,3:422\n766#4:425\n857#4,2:426\n1855#4,2:428\n*S KotlinDebug\n*F\n+ 1 AppAggregatorClient.kt\ncom/atlassian/jira/migration/assessment/AppAggregatorClient\n*L\n270#1:398\n191#1:386\n226#1:387\n289#1:413\n357#1:430\n270#1:388,9\n270#1:397\n270#1:399\n270#1:400\n274#1:401\n274#1:402\n274#1:403,3\n274#1:406\n276#1:407\n276#1:408,5\n292#1:414\n292#1:415,2\n293#1:417\n293#1:418,3\n308#1:421\n308#1:422,3\n331#1:425\n331#1:426,2\n332#1:428,2\n*E\n"})
public final class AppAggregatorClient
implements MigrationAppAggregatorClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LicenseHandler licenseHandler;
    @NotNull
    private final MigrationPluginHttpClient httpClient;
    @NotNull
    private final MigrationServicesConfiguration migrationServicesConfiguration;
    @NotNull
    private final Lazy appAggregatorCache$delegate;
    @NotNull
    private final Lazy appUsageAvailabilityCache$delegate;
    @NotNull
    private final Lazy appAggregatorNotFoundCache$delegate;
    @NotNull
    private final Lazy appsListCache$delegate;
    @NotNull
    private static final String GET_APP_DATA_URL = "aggregator/{pluginKey}";
    @NotNull
    private static final String GET_BATCH_APP_DATA_URL = "aggregator/batch";
    @NotNull
    private static final String GET_BLACKLIST_URL = "aggregator/resources/blacklist";
    @NotNull
    private static final String GET_RELIABLE_LIST_URL = "aggregator/resources/reliablelist";
    @NotNull
    private static final String GET_DISABLED_APP_VENDOR_CHECK_SPEC_URL = "aggregator/app/checks/disabled";
    @NotNull
    private static final String APP_USAGE_CHECK_URL = "aggregator/app/usage/config";
    private static final Logger log = LoggerFactory.getLogger(AppAggregatorClient.class);
    @NotNull
    private static final String APP_ASSESSMENT_BLACKLIST_KEY = "appAssessmentBlacklistKey";
    @NotNull
    private static final String APP_ASSESSMENT_RELIABLE_LIST_KEY = "appAssessmentReliableListKey";
    public static final int BATCH_APP_DATA_CHUNK_SIZE = 50;

    public AppAggregatorClient(@NotNull CacheManager cacheManager, @NotNull LicenseHandler licenseHandler, @NotNull MigrationPluginHttpClient httpClient, @NotNull MigrationServicesConfiguration migrationServicesConfiguration) {
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        Intrinsics.checkNotNullParameter((Object)licenseHandler, (String)"licenseHandler");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        this.licenseHandler = licenseHandler;
        this.httpClient = httpClient;
        this.migrationServicesConfiguration = migrationServicesConfiguration;
        this.appAggregatorCache$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Cache<Pair<? extends String, ? extends String>, AppAggregatorResponse>>(cacheManager){
            final /* synthetic */ CacheManager $cacheManager;
            {
                this.$cacheManager = $cacheManager;
                super(0);
            }

            @NotNull
            public final Cache<Pair<String, String>, AppAggregatorResponse> invoke() {
                return this.$cacheManager.getCache(AppAggregatorClient.class.getName() + ".app.aggregator.data", null, new CacheSettingsBuilder().expireAfterWrite(55L, TimeUnit.MINUTES).maxEntries(1000).replicateViaInvalidation().remote().build());
            }
        }));
        this.appUsageAvailabilityCache$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Cache<Pair<? extends String, ? extends String>, AppUsageCheckResponse>>(cacheManager){
            final /* synthetic */ CacheManager $cacheManager;
            {
                this.$cacheManager = $cacheManager;
                super(0);
            }

            @NotNull
            public final Cache<Pair<String, String>, AppUsageCheckResponse> invoke() {
                return this.$cacheManager.getCache(AppAggregatorClient.class.getName() + ".app.usage.availability", null, new CacheSettingsBuilder().expireAfterWrite(55L, TimeUnit.MINUTES).maxEntries(5).replicateViaInvalidation().remote().build());
            }
        }));
        this.appAggregatorNotFoundCache$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Cache<Pair<? extends String, ? extends String>, AppAggregatorResponse>>(cacheManager){
            final /* synthetic */ CacheManager $cacheManager;
            {
                this.$cacheManager = $cacheManager;
                super(0);
            }

            @NotNull
            public final Cache<Pair<String, String>, AppAggregatorResponse> invoke() {
                return this.$cacheManager.getCache(AppAggregatorClient.class.getName() + ".app.aggregator.data.not.found", null, new CacheSettingsBuilder().expireAfterWrite(1L, TimeUnit.DAYS).maxEntries(1000).replicateViaInvalidation().remote().build());
            }
        }));
        this.appsListCache$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Cache<String, Set<? extends String>>>(cacheManager){
            final /* synthetic */ CacheManager $cacheManager;
            {
                this.$cacheManager = $cacheManager;
                super(0);
            }

            @NotNull
            public final Cache<String, Set<String>> invoke() {
                return this.$cacheManager.getCache(AppAggregatorClient.class.getName() + ".app.lists", null, new CacheSettingsBuilder().expireAfterWrite(1L, TimeUnit.DAYS).maxEntries(2).replicateViaInvalidation().remote().build());
            }
        }));
        log.info("app aggregator service base url : " + this.migrationServicesConfiguration.getAppAggregatorServiceBaseURI());
        this.getAppAggregatorCache().removeAll();
        this.getAppsListCache().removeAll();
        this.getAppUsageAvailabilityCache().removeAll();
    }

    private final Cache<Pair<String, String>, AppAggregatorResponse> getAppAggregatorCache() {
        Lazy lazy = this.appAggregatorCache$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Cache)object;
    }

    private final Cache<Pair<String, String>, AppUsageCheckResponse> getAppUsageAvailabilityCache() {
        Lazy lazy = this.appUsageAvailabilityCache$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Cache)object;
    }

    private final Cache<Pair<String, String>, AppAggregatorResponse> getAppAggregatorNotFoundCache() {
        Lazy lazy = this.appAggregatorNotFoundCache$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Cache)object;
    }

    private final Cache<String, Set<String>> getAppsListCache() {
        Lazy lazy = this.appsListCache$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Cache)object;
    }

    private final Set<String> getAppAssessmentBlacklist() {
        Object object = this.getAppsListCache().get((Object)APP_ASSESSMENT_BLACKLIST_KEY, () -> AppAggregatorClient._get_appAssessmentBlacklist_$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Set)object;
    }

    private final Set<String> getAppAssessmentReliableList() {
        Object object = this.getAppsListCache().get((Object)APP_ASSESSMENT_RELIABLE_LIST_KEY, () -> AppAggregatorClient._get_appAssessmentReliableList_$lambda$1(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Set)object;
    }

    @Inject
    public AppAggregatorClient(@NotNull CacheManager cacheManager, @NotNull LicenseHandler licenseHandler, @NotNull MigrationUserAgentProvider userAgentProvider, @NotNull ObjectMapperFactory objectMapperFactory, @NotNull MigrationServicesConfiguration migrationServicesConfiguration) {
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        Intrinsics.checkNotNullParameter((Object)licenseHandler, (String)"licenseHandler");
        Intrinsics.checkNotNullParameter((Object)userAgentProvider, (String)"userAgentProvider");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        this(cacheManager, licenseHandler, new MigrationPluginHttpClient(userAgentProvider, objectMapperFactory.createObjectMapperHandlingUnknownFields()), migrationServicesConfiguration);
    }

    @NotNull
    public final AppAggregatorResponse getServerAppData(@NotNull String pluginKey) {
        Intrinsics.checkNotNullParameter((Object)pluginKey, (String)"pluginKey");
        return this.getAppData(this.getDCOrServerHosting(), pluginKey);
    }

    @NotNull
    public final List<AppAggregatorResponse> getBatchServerAppData(@NotNull Set<String> pluginKeys) {
        Intrinsics.checkNotNullParameter(pluginKeys, (String)"pluginKeys");
        return this.getBatchAppData(this.getDCOrServerHosting(), pluginKeys);
    }

    private final String getDCOrServerHosting() {
        boolean isDataCenter2 = this.licenseHandler.getAllProductLicenses().stream().anyMatch(arg_0 -> AppAggregatorClient.getDCOrServerHosting$lambda$2(getDCOrServerHosting.isDataCenter.1.INSTANCE, arg_0));
        return isDataCenter2 ? Hosting.DATACENTER.getValue() : Hosting.SERVER.getValue();
    }

    @NotNull
    public final AppAggregatorResponse getCloudAppData(@NotNull String pluginKey) {
        Intrinsics.checkNotNullParameter((Object)pluginKey, (String)"pluginKey");
        return this.getAppData(Hosting.CLOUD.getValue(), pluginKey);
    }

    @VisibleForTesting
    @NotNull
    public final AppAggregatorResponse getAppData(@NotNull String hosting, @NotNull String pluginKey) {
        Intrinsics.checkNotNullParameter((Object)hosting, (String)"hosting");
        Intrinsics.checkNotNullParameter((Object)pluginKey, (String)"pluginKey");
        AppAggregatorResponse appData = this.getAppDataFromCache(hosting, pluginKey);
        if (appData.getAggregatorHttpErrorCode() != null) {
            Integer n = appData.getAggregatorHttpErrorCode();
            int n2 = 404;
            if (n != null && n == n2 || appData.getAggregatorHttpErrorCode() >= 500) {
                this.getAppAggregatorCache().remove((Object)new Pair((Object)hosting, (Object)pluginKey));
            }
        }
        return appData;
    }

    private final AppAggregatorResponse getAppDataFromCache(String hosting, String pluginKey) {
        AppAggregatorResponse appAggregatorResponse = (AppAggregatorResponse)this.getAppAggregatorNotFoundCache().get((Object)new Pair((Object)hosting, (Object)pluginKey));
        if (appAggregatorResponse != null) {
            AppAggregatorResponse it = appAggregatorResponse;
            boolean bl = false;
            return it;
        }
        Object object = this.getAppAggregatorCache().get((Object)new Pair((Object)hosting, (Object)pluginKey), () -> AppAggregatorClient.getAppDataFromCache$lambda$4(this, hosting, pluginKey));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (AppAggregatorResponse)object;
    }

    public final void validateAndReloadBlacklist() {
        this.validateAndReloadAppListCache(this.getAppAssessmentBlacklist(), APP_ASSESSMENT_BLACKLIST_KEY, GET_BLACKLIST_URL);
    }

    public final void validateAndReloadReliableList() {
        this.validateAndReloadAppListCache(this.getAppAssessmentReliableList(), APP_ASSESSMENT_RELIABLE_LIST_KEY, GET_RELIABLE_LIST_URL);
    }

    @NotNull
    public Set<DisabledCheck> getDisabledAppVendorChecks(@NotNull Set<String> serverAppKeys) {
        Set set;
        Intrinsics.checkNotNullParameter(serverAppKeys, (String)"serverAppKeys");
        try {
            boolean $i$f$jacksonTypeRef = false;
            set = (Set)this.httpClient.execute(new MigrationPluginHttpRequest("POST", AbstractPluginHttpClientKt.buildURI$default(this.migrationServicesConfiguration.getAppAggregatorServiceBaseURI(), GET_DISABLED_APP_VENDOR_CHECK_SPEC_URL, new String[0], null, 8, null), SetsKt.setOf((Object)200), serverAppKeys, null, null, 48, null).acceptsJson().contentTypeJson(), (TypeReference)new TypeReference<HashSet<DisabledCheck>>(){});
        }
        catch (UnexpectedStatusCodeException ex) {
            log.warn("Communication with app aggregator service failed with message : " + ex.getMessage() + ", \n Returning empty list.");
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final void validateAndReloadAppListCache(Set<String> appListName, String key, String path) {
        log.info("Checking if List for " + key + " is valid or not.");
        if (appListName.isEmpty()) {
            this.getAppsListCache().put((Object)key, this.getListFromAppAggregator(path));
            log.info("Successfully reloaded list for the " + key + " from " + path + '.');
        }
    }

    public final boolean isBlacklisted(@NotNull String pluginKey) {
        Intrinsics.checkNotNullParameter((Object)pluginKey, (String)"pluginKey");
        return this.getAppAssessmentBlacklist().contains(pluginKey);
    }

    public final boolean isAppReliable(@NotNull String pluginKey) {
        Intrinsics.checkNotNullParameter((Object)pluginKey, (String)"pluginKey");
        return this.getAppAssessmentReliableList().contains(pluginKey);
    }

    @NotNull
    public final AppUsageCheckResponse getAppUsageAvailability(@NotNull String product, @NotNull String hosting, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)product, (String)"product");
        Intrinsics.checkNotNullParameter((Object)hosting, (String)"hosting");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Object object = this.getAppUsageAvailabilityCache().get((Object)new Pair((Object)hosting, (Object)version), () -> AppAggregatorClient.getAppUsageAvailability$lambda$5(this, product, hosting, version));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (AppUsageCheckResponse)object;
    }

    private final AppUsageCheckResponse getAppUsageAvailabilityFromMaa(String product, String hosting, String version) {
        AppUsageCheckResponse appUsageCheckResponse;
        try {
            boolean $i$f$jacksonTypeRef = false;
            appUsageCheckResponse = (AppUsageCheckResponse)this.httpClient.execute(new MigrationPluginHttpRequest("POST", AbstractPluginHttpClientKt.buildURI$default(this.migrationServicesConfiguration.getAppAggregatorServiceBaseURI(), APP_USAGE_CHECK_URL, new String[0], null, 8, null), null, new AppUsageCheckRequest(product, hosting, version), null, null, 52, null).contentTypeJson().acceptsJson(), (TypeReference)new TypeReference<AppUsageCheckResponse>(){});
        }
        catch (UnexpectedStatusCodeException ex) {
            log.warn("Communication with app aggregator service failed with message : " + ex.getMessage() + " when checking app usage availability.");
            appUsageCheckResponse = new AppUsageCheckResponse(false, null, null, null, null, 30, null);
        }
        return appUsageCheckResponse;
    }

    private final AppAggregatorResponse getAppDataFromAppAggregatorService(String hosting, String pluginKey) {
        Object object;
        try {
            object = new String[]{pluginKey};
            String[] stringArray = object;
            object = new Pair[]{TuplesKt.to((Object)"application", (Object)"jira"), TuplesKt.to((Object)"hosting", (Object)hosting)};
            object = this.httpClient.execute(new MigrationPluginHttpRequest("GET", AbstractPluginHttpClientKt.buildURI(this.migrationServicesConfiguration.getAppAggregatorServiceBaseURI(), GET_APP_DATA_URL, stringArray, CollectionsKt.listOf((Object[])object)), null, null, null, null, 60, null), AppAggregatorResponse.class);
        }
        catch (UnexpectedStatusCodeException ex) {
            AppAggregatorResponse errorResponse = AppAggregatorResponse.Companion.errorResponse(ex.getStatusCode());
            if (ex.getStatusCode() != 404) {
                log.warn("Communication with app aggregator service failed with message : " + ex.getMessage() + ", for pluginKey: " + pluginKey + ". \n Returning default values.");
            } else {
                this.getAppAggregatorNotFoundCache().put((Object)new Pair((Object)hosting, (Object)pluginKey), (Object)errorResponse);
            }
            object = errorResponse;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AppAggregatorResponse> getBatchAppData(@NotNull String hosting, @NotNull Set<String> pluginKeys) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$filterTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)hosting, (String)"hosting");
        Intrinsics.checkNotNullParameter(pluginKeys, (String)"pluginKeys");
        Iterable $this$mapNotNull$iv = pluginKeys;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<AppAggregatorResponse> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            AppAggregatorResponse it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String pluginKey = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.getAppDataOnlyFromCache(hosting, pluginKey) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List appDataFromCache = (List)destination$iv$iv;
        Iterable $this$filter$iv = pluginKeys;
        boolean $i$f$filter22 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block6: {
                String pluginKey = (String)element$iv$iv;
                boolean bl4 = false;
                Iterable $this$none$iv = appDataFromCache;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        AppAggregatorResponse it = (AppAggregatorResponse)element$iv;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)it.getKey(), (Object)pluginKey)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Set remainingPluginKeys = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Iterable $i$f$filter22 = CollectionsKt.chunked((Iterable)remainingPluginKeys, (int)50);
        boolean $i$f$flatMap = false;
        destination$iv$iv2 = $this$flatMap$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List chunk = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.getBatchAppDataFromAggregatorService(hosting, CollectionsKt.toSet((Iterable)chunk));
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        List appData = (List)destination$iv$iv3;
        log.info("Found " + appDataFromCache.size() + " app data from cache. Found " + appData.size() + " app data from MAA.");
        return CollectionsKt.plus((Collection)appDataFromCache, (Iterable)appData);
    }

    /*
     * WARNING - void declaration
     */
    private final List<AppAggregatorResponse> getBatchAppDataFromAggregatorService(String hosting, Set<String> pluginKeys) {
        MigrationPluginHttpRequest request = this.getBatchAppDataRequest(pluginKeys, hosting);
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            AppAggregatorResponse it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            boolean $i$f$jacksonTypeRef = false;
            BulkAppAggregatorResponse remoteResult = (BulkAppAggregatorResponse)this.httpClient.execute(request, (TypeReference)new TypeReference<BulkAppAggregatorResponse>(){});
            Iterable iterable = remoteResult.getApps();
            boolean $i$f$filter = false;
            void var8_12 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (AppAggregatorResponse)element$iv$iv;
                boolean bl = false;
                if (!(it.getKey() != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                AppAggregatorResponse appAggregatorResponse;
                it = (AppAggregatorResponse)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (it.getErrorResponseHttpStatusCode() == null || it.getErrorResponseHttpStatusCode() < 400) {
                    appAggregatorResponse = it;
                } else {
                    String string = it.getKey();
                    Intrinsics.checkNotNull((Object)string);
                    appAggregatorResponse = AppAggregatorResponse.Companion.errorResponse(string, it.getErrorResponseHttpStatusCode());
                }
                collection.add(appAggregatorResponse);
            }
            List response2 = (List)destination$iv$iv;
            this.cacheSuccessAndNotFoundAppResponses(response2, hosting);
            return response2;
        }
        catch (UnexpectedStatusCodeException ex) {
            log.error("Communication with app aggregator service failed to POST: " + request.getUri().getPath() + ", with message : " + ex.getMessage() + ", for pluginKeys: " + pluginKeys + '.');
            Iterable $this$map$iv = pluginKeys;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(AppAggregatorResponse.Companion.errorResponse(it, ex.getStatusCode()));
            }
            return (List)destination$iv$iv;
        }
    }

    private final MigrationPluginHttpRequest getBatchAppDataRequest(Set<String> pluginKeys, String hosting) {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"application", (Object)"jira"), TuplesKt.to((Object)"hosting", (Object)hosting)};
        return new MigrationPluginHttpRequest("POST", AbstractPluginHttpClientKt.buildURI(this.migrationServicesConfiguration.getAppAggregatorServiceBaseURI(), GET_BATCH_APP_DATA_URL, new String[0], CollectionsKt.listOf((Object[])objectArray)), null, pluginKeys, null, null, 52, null).acceptsJson().contentTypeJson();
    }

    /*
     * WARNING - void declaration
     */
    private final void cacheSuccessAndNotFoundAppResponses(List<AppAggregatorResponse> apps, String hosting) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = apps;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AppAggregatorResponse it = (AppAggregatorResponse)element$iv$iv;
            boolean bl = false;
            if (!it.successOrNotFound()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AppAggregatorResponse it = (AppAggregatorResponse)element$iv;
            boolean bl = false;
            String string = it.getKey();
            Intrinsics.checkNotNull((Object)string);
            Pair key = new Pair((Object)hosting, (Object)string);
            if (it.success()) {
                this.getAppAggregatorCache().put((Object)key, (Object)it);
                continue;
            }
            this.getAppAggregatorNotFoundCache().put((Object)key, (Object)it);
        }
    }

    private final AppAggregatorResponse getAppDataOnlyFromCache(String hosting, String pluginKey) {
        AppAggregatorResponse appAggregatorResponse = (AppAggregatorResponse)this.getAppAggregatorCache().get((Object)new Pair((Object)hosting, (Object)pluginKey));
        if (appAggregatorResponse == null) {
            appAggregatorResponse = (AppAggregatorResponse)this.getAppAggregatorNotFoundCache().get((Object)new Pair((Object)hosting, (Object)pluginKey));
        }
        return appAggregatorResponse;
    }

    private final Set<String> getListFromAppAggregator(String path) {
        Set set;
        try {
            boolean $i$f$jacksonTypeRef = false;
            set = (Set)this.httpClient.execute(new MigrationPluginHttpRequest("GET", AbstractPluginHttpClientKt.buildURI$default(this.migrationServicesConfiguration.getAppAggregatorServiceBaseURI(), path, new String[0], null, 8, null), null, null, null, null, 60, null), (TypeReference)new TypeReference<HashSet<String>>(){});
        }
        catch (UnexpectedStatusCodeException ex) {
            log.warn("Communication with app aggregator service failed with message : " + ex.getMessage() + ", \n Returning empty for path " + path + " list.");
            set = SetsKt.emptySet();
        }
        return set;
    }

    private static final Set _get_appAssessmentBlacklist_$lambda$0(AppAggregatorClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getListFromAppAggregator(GET_BLACKLIST_URL);
    }

    private static final Set _get_appAssessmentReliableList_$lambda$1(AppAggregatorClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getListFromAppAggregator(GET_RELIABLE_LIST_URL);
    }

    private static final boolean getDCOrServerHosting$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final AppAggregatorResponse getAppDataFromCache$lambda$4(AppAggregatorClient this$0, String $hosting, String $pluginKey) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$hosting, (String)"$hosting");
        Intrinsics.checkNotNullParameter((Object)$pluginKey, (String)"$pluginKey");
        return this$0.getAppDataFromAppAggregatorService($hosting, $pluginKey);
    }

    private static final AppUsageCheckResponse getAppUsageAvailability$lambda$5(AppAggregatorClient this$0, String $product, String $hosting, String $version) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$product, (String)"$product");
        Intrinsics.checkNotNullParameter((Object)$hosting, (String)"$hosting");
        Intrinsics.checkNotNullParameter((Object)$version, (String)"$version");
        return this$0.getAppUsageAvailabilityFromMaa($product, $hosting, $version);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/assessment/AppAggregatorClient$Companion;", "", "()V", "APP_ASSESSMENT_BLACKLIST_KEY", "", "getAPP_ASSESSMENT_BLACKLIST_KEY$annotations", "getAPP_ASSESSMENT_BLACKLIST_KEY", "()Ljava/lang/String;", "APP_ASSESSMENT_RELIABLE_LIST_KEY", "getAPP_ASSESSMENT_RELIABLE_LIST_KEY", "APP_USAGE_CHECK_URL", "BATCH_APP_DATA_CHUNK_SIZE", "", "GET_APP_DATA_URL", "GET_BATCH_APP_DATA_URL", "GET_BLACKLIST_URL", "GET_DISABLED_APP_VENDOR_CHECK_SPEC_URL", "GET_RELIABLE_LIST_URL", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getAPP_ASSESSMENT_BLACKLIST_KEY() {
            return APP_ASSESSMENT_BLACKLIST_KEY;
        }

        @VisibleForTesting
        public static /* synthetic */ void getAPP_ASSESSMENT_BLACKLIST_KEY$annotations() {
        }

        @NotNull
        public final String getAPP_ASSESSMENT_RELIABLE_LIST_KEY() {
            return APP_ASSESSMENT_RELIABLE_LIST_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

