/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.assessment;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.jira.migration.analytics.AnalyticsEventService;
import com.atlassian.jira.migration.assessment.AppAggregatorClient;
import com.atlassian.jira.migration.assessment.AppAggregatorResponse;
import com.atlassian.jira.migration.assessment.AppAssessmentInfo;
import com.atlassian.jira.migration.assessment.AppAssessmentProperty;
import com.atlassian.jira.migration.assessment.AppAssessmentRepository;
import com.atlassian.jira.migration.assessment.PluginManager;
import com.atlassian.jira.migration.sen.SENSupplier;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.migration.app.AppCloudCapability;
import com.atlassian.migration.app.MigratabliltyInfo;
import com.atlassian.migration.app.dto.MigrationPath;
import com.atlassian.plugin.Plugin;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\b\u0007\u0018\u0000 /2\u00020\u0001:\u0001/B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u001e\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u001e\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J$\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0016H\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J$\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u000fH\u0002J2\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0&2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160'2\u0006\u0010(\u001a\u00020)J,\u0010*\u001a\u00020\"2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0&2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160'2\u0006\u0010(\u001a\u00020)H\u0002J&\u0010+\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0&2\u0006\u0010,\u001a\u00020\u000fH\u0002J\u001e\u0010-\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/atlassian/jira/migration/assessment/AppAssessmentAnalyticsEventService;", "", "pluginManager", "Lcom/atlassian/jira/migration/assessment/PluginManager;", "appAssessmentRepository", "Lcom/atlassian/jira/migration/assessment/AppAssessmentRepository;", "aggregatorService", "Lcom/atlassian/jira/migration/assessment/AppAggregatorClient;", "senSupplier", "Lcom/atlassian/jira/migration/sen/SENSupplier;", "analyticsEventService", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;", "(Lcom/atlassian/jira/migration/assessment/PluginManager;Lcom/atlassian/jira/migration/assessment/AppAssessmentRepository;Lcom/atlassian/jira/migration/assessment/AppAggregatorClient;Lcom/atlassian/jira/migration/sen/SENSupplier;Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;)V", "attributesFromAggregator", "", "", "appKey", "attributesFromLocalPluginAccessor", "attributesFromUserInput", "getMigrationState", "Lkotlin/Pair;", "appData", "Lcom/atlassian/jira/migration/assessment/AppAggregatorResponse;", "getState", "Lcom/atlassian/migration/app/AppCloudCapability;", "plugin", "Lcom/atlassian/plugin/Plugin;", "appAggregatorResponse", "needsUpgrade", "", "resolveAppCloudCapability", "appCloudCapability", "cloudMigrationAssistantCompatibility", "saveAppsFetchedEvent", "", "jiraUser", "Lcom/atlassian/jira/user/ApplicationUser;", "appKeys", "", "", "timeToCompleteMs", "", "saveBatchAppsFetchedEvent", "saveEventsForAction", "sourceEvent", "savePropertyChangedEvent", "appProperty", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppAssessmentAnalyticsEventService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppAssessmentAnalyticsEventService.kt\ncom/atlassian/jira/migration/assessment/AppAssessmentAnalyticsEventService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n1#2:235\n1208#3,2:236\n1238#3,4:238\n1855#3,2:242\n*S KotlinDebug\n*F\n+ 1 AppAssessmentAnalyticsEventService.kt\ncom/atlassian/jira/migration/assessment/AppAssessmentAnalyticsEventService\n*L\n64#1:236,2\n64#1:238,4\n87#1:242,2\n*E\n"})
public final class AppAssessmentAnalyticsEventService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PluginManager pluginManager;
    @NotNull
    private final AppAssessmentRepository appAssessmentRepository;
    @NotNull
    private final AppAggregatorClient aggregatorService;
    @NotNull
    private final SENSupplier senSupplier;
    @NotNull
    private final AnalyticsEventService analyticsEventService;
    private static final Logger log = LoggerFactory.getLogger(AppAssessmentAnalyticsEventService.class);
    @NotNull
    private static final String APP_AVAILABLE_CLOUD_KEY = "appAvailableCloud";
    @NotNull
    private static final String FOUND_MARKETPLACE_KEY = "foundMarketplace";
    @NotNull
    private static final String APP_LATEST_VERSION_KEY = "appLatestAvailableVersion";
    @NotNull
    private static final String CAN_BE_MIGRATED_KEY = "canBeMigrated";
    @NotNull
    private static final String MIN_VERSION_MIGRATION = "minVersionMigration";
    @NotNull
    private static final String MIGRATE_STATE = "migrationState";
    @NotNull
    private static final String AUTOMATIC = "Automatic";
    @NotNull
    private static final String INSTALL_ONLY = "Install_Only";

    @Inject
    public AppAssessmentAnalyticsEventService(@NotNull PluginManager pluginManager, @NotNull AppAssessmentRepository appAssessmentRepository, @NotNull AppAggregatorClient aggregatorService, @NotNull SENSupplier senSupplier, @NotNull AnalyticsEventService analyticsEventService) {
        Intrinsics.checkNotNullParameter((Object)pluginManager, (String)"pluginManager");
        Intrinsics.checkNotNullParameter((Object)appAssessmentRepository, (String)"appAssessmentRepository");
        Intrinsics.checkNotNullParameter((Object)aggregatorService, (String)"aggregatorService");
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        this.pluginManager = pluginManager;
        this.appAssessmentRepository = appAssessmentRepository;
        this.aggregatorService = aggregatorService;
        this.senSupplier = senSupplier;
        this.analyticsEventService = analyticsEventService;
    }

    public final void saveAppsFetchedEvent(@NotNull ApplicationUser jiraUser, @NotNull Collection<String> appKeys, @NotNull List<AppAggregatorResponse> appData, long timeToCompleteMs) {
        Intrinsics.checkNotNullParameter((Object)jiraUser, (String)"jiraUser");
        Intrinsics.checkNotNullParameter(appKeys, (String)"appKeys");
        Intrinsics.checkNotNullParameter(appData, (String)"appData");
        this.saveEventsForAction(jiraUser, appKeys, "appFetched");
        this.saveBatchAppsFetchedEvent(appKeys, appData, timeToCompleteMs);
    }

    public final void savePropertyChangedEvent(@NotNull ApplicationUser jiraUser, @NotNull String appKey, @NotNull String appProperty) {
        Intrinsics.checkNotNullParameter((Object)jiraUser, (String)"jiraUser");
        Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
        Intrinsics.checkNotNullParameter((Object)appProperty, (String)"appProperty");
        String string = appProperty;
        String sourceEvent = Intrinsics.areEqual((Object)string, (Object)AppAssessmentProperty.ASSESSMENT_STATUS.getValue()) ? "appStatusChanged" : (Intrinsics.areEqual((Object)string, (Object)AppAssessmentProperty.MIGRATION_NOTES.getValue()) ? "appNotesAdded" : (Intrinsics.areEqual((Object)string, (Object)AppAssessmentProperty.ALTERNATIVE_APP_KEY.getValue()) ? "alternativeAppChanged" : null));
        Plugin plugin = this.pluginManager.getPlugin(appKey);
        if (plugin != null && sourceEvent != null) {
            this.saveEventsForAction(jiraUser, CollectionsKt.listOf((Object)appKey), sourceEvent);
        } else {
            log.warn("Unable to generate analytics event for change on property " + appProperty + " of application " + appKey);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void saveBatchAppsFetchedEvent(Collection<String> appKeys, List<AppAggregatorResponse> appData, long timeToCompleteMs) {
        try {
            void $this$associateByTo$iv$iv;
            Object object;
            Object v0;
            Object object22;
            block4: {
                Iterable iterable = appData;
                for (Object object22 : iterable) {
                    AppAggregatorResponse it = (AppAggregatorResponse)object22;
                    boolean bl = false;
                    if (!(!it.successOrNotFound())) continue;
                    v0 = object22;
                    break block4;
                }
                v0 = null;
            }
            int failureErrorCode = (object = (AppAggregatorResponse)v0) != null && (object = ((AppAggregatorResponse)object).getAggregatorHttpErrorCode()) != null ? (Integer)object : 0;
            Iterable $this$associateBy$iv = appData;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            object22 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                AppAggregatorResponse appAggregatorResponse = (AppAggregatorResponse)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                AppAggregatorResponse it = (AppAggregatorResponse)element$iv$iv;
                String string = it.getKey();
                boolean bl2 = false;
                Integer n = it.getAggregatorHttpErrorCode();
                Integer n2 = n != null ? n : 0;
                map.put(string, n2);
            }
            Map appKeyResultMap = destination$iv$iv;
            GenericOperationalEvent event = ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(System.currentTimeMillis()).action("fetched")).actionSubject("batchApp")).sen(this.senSupplier.getFirstSen())).addAttribute("timeToCompleteMs", (Object)timeToCompleteMs)).addAttribute("appKeyResultMap", (Object)appKeyResultMap)).addAttribute("appDataCount", (Object)appData.size())).addAttribute("appCount", (Object)appKeys.size())).addAttribute("failureErrorCode", (Object)failureErrorCode)).build();
            Intrinsics.checkNotNull((Object)event);
            AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)event, null, 2, null);
        }
        catch (Throwable e) {
            log.warn("Unable to generate/send analytics for action subject batchAppFetched", e);
        }
    }

    private final void saveEventsForAction(ApplicationUser jiraUser, Collection<String> appKeys, String sourceEvent) {
        try {
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String batchId = string;
            long timestamp = System.currentTimeMillis();
            Iterable $this$forEach$iv = appKeys;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CharSequence charSequence;
                String it = (String)element$iv;
                boolean bl = false;
                Map attributes = new LinkedHashMap();
                attributes.putAll(this.attributesFromLocalPluginAccessor(it));
                attributes.putAll(this.attributesFromAggregator(it));
                attributes.putAll(this.attributesFromUserInput(it));
                GenericOperationalEvent.Builder eventBuilder = new GenericOperationalEvent.Builder(timestamp);
                GenericOperationalEvent.Builder builder = (GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)eventBuilder.source(sourceEvent)).contextContainer("appBatch", batchId)).actionSubject("pluginStatistics", it)).action("reported");
                CharSequence charSequence2 = jiraUser.getEmailAddress();
                if (StringsKt.isBlank((CharSequence)charSequence2)) {
                    GenericOperationalEvent.Builder builder2 = builder;
                    boolean bl2 = false;
                    charSequence = null;
                    builder = builder2;
                } else {
                    charSequence = charSequence2;
                }
                ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)builder.email((String)charSequence)).sen(this.senSupplier.getFirstSen())).withAttributes(attributes)).build();
                GenericOperationalEvent genericOperationalEvent = eventBuilder.build();
                Intrinsics.checkNotNullExpressionValue((Object)genericOperationalEvent, (String)"build(...)");
                AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)genericOperationalEvent, null, 2, null);
            }
        }
        catch (Throwable e) {
            log.warn("Unable to generate/send analytics sourceEvent: " + sourceEvent, e);
        }
    }

    private final Map<String, Object> attributesFromLocalPluginAccessor(String appKey) {
        Object object;
        block3: {
            block2: {
                object = this.pluginManager.getPlugin(appKey);
                if (object == null) break block2;
                Plugin plugin = object;
                boolean bl = false;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"appName", (Object)plugin.getName()), TuplesKt.to((Object)"appServerInstalledVersion", (Object)plugin.getPluginInformation().getVersion()), TuplesKt.to((Object)"appEnabled", (Object)PluginManager.Companion.isPluginEnabled(plugin))};
                Map map = MapsKt.mapOf((Pair[])pairArray);
                object = map;
                if (map != null) break block3;
            }
            object = MapsKt.emptyMap();
        }
        return object;
    }

    private final Map<String, Object> attributesFromAggregator(String appKey) {
        Map map;
        block10: {
            AppAggregatorResponse $this$attributesFromAggregator_u24lambda_u248;
            block7: {
                CharSequence charSequence;
                String string;
                Pair[] pairArray;
                int n;
                String string2;
                String string3;
                String string4;
                CharSequence charSequence2;
                Pair[] pairArray2;
                String cloudMigAssistantComp;
                String migState;
                block9: {
                    block8: {
                        CharSequence charSequence3;
                        $this$attributesFromAggregator_u24lambda_u248 = this.aggregatorService.getServerAppData(appKey);
                        boolean bl = false;
                        if (!$this$attributesFromAggregator_u24lambda_u248.successOrNotFound()) break block7;
                        Pair<String, String> pair = this.getMigrationState(appKey, $this$attributesFromAggregator_u24lambda_u248);
                        migState = (String)pair.component1();
                        cloudMigAssistantComp = (String)pair.component2();
                        pairArray2 = new Pair[6];
                        pairArray2[0] = TuplesKt.to((Object)APP_AVAILABLE_CLOUD_KEY, (Object)String.valueOf($this$attributesFromAggregator_u24lambda_u248.getHasCloud()));
                        charSequence2 = $this$attributesFromAggregator_u24lambda_u248.getLatestVersion();
                        pairArray2[1] = TuplesKt.to((Object)FOUND_MARKETPLACE_KEY, (Object)String.valueOf(!(charSequence2 == null || charSequence2.length() == 0)));
                        Pair[] pairArray3 = pairArray2;
                        int n2 = 2;
                        string4 = APP_LATEST_VERSION_KEY;
                        string3 = $this$attributesFromAggregator_u24lambda_u248.getLatestVersion();
                        if (string3 == null) break block8;
                        CharSequence charSequence4 = string3;
                        if (StringsKt.isBlank((CharSequence)charSequence4)) {
                            string2 = string4;
                            n = n2;
                            pairArray = pairArray3;
                            boolean bl2 = false;
                            string = "";
                            pairArray3 = pairArray;
                            n2 = n;
                            string4 = string2;
                            charSequence3 = string;
                        } else {
                            charSequence3 = charSequence4;
                        }
                        if ((string3 = (String)charSequence3) != null) break block9;
                    }
                    string3 = "";
                }
                pairArray3[n2] = TuplesKt.to((Object)string4, (Object)string3);
                Pair[] pairArray4 = pairArray2;
                int n3 = 3;
                String string5 = CAN_BE_MIGRATED_KEY;
                charSequence2 = $this$attributesFromAggregator_u24lambda_u248.getMigratable();
                if (StringsKt.isBlank((CharSequence)charSequence2)) {
                    string2 = string5;
                    n = n3;
                    pairArray = pairArray4;
                    boolean bl = false;
                    string = "";
                    pairArray4 = pairArray;
                    n3 = n;
                    string5 = string2;
                    charSequence = string;
                } else {
                    charSequence = charSequence2;
                }
                pairArray4[n3] = TuplesKt.to((Object)string5, (Object)charSequence);
                pairArray2[4] = TuplesKt.to((Object)MIN_VERSION_MIGRATION, (Object)cloudMigAssistantComp);
                pairArray2[5] = TuplesKt.to((Object)MIGRATE_STATE, (Object)migState);
                map = MapsKt.mapOf((Pair[])pairArray2);
                break block10;
            }
            String errorString = "error " + $this$attributesFromAggregator_u24lambda_u248.getAggregatorHttpErrorCode();
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)APP_AVAILABLE_CLOUD_KEY, (Object)errorString), TuplesKt.to((Object)FOUND_MARKETPLACE_KEY, (Object)errorString), TuplesKt.to((Object)APP_LATEST_VERSION_KEY, (Object)errorString), TuplesKt.to((Object)CAN_BE_MIGRATED_KEY, (Object)errorString)};
            map = MapsKt.mapOf((Pair[])pairArray);
        }
        return map;
    }

    private final Map<String, Object> attributesFromUserInput(String appKey) {
        AppAssessmentInfo assessmentInfo = this.appAssessmentRepository.getOrDefault(appKey);
        boolean bl = false;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"appAssessmentStatus", (Object)((Object)assessmentInfo.getMigrationStatus())), TuplesKt.to((Object)"appAssessmentNotesPresent", (Object)(((CharSequence)assessmentInfo.getMigrationNotes()).length() > 0 ? 1 : 0)), TuplesKt.to((Object)"alternativeAppKey", (Object)assessmentInfo.getAlternativeAppKey())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final Pair<String, String> getMigrationState(String appKey, AppAggregatorResponse appData) {
        Plugin plugin = this.pluginManager.getPlugin(appKey);
        if (plugin != null) {
            Plugin $this$getMigrationState_u24lambda_u2410 = plugin;
            boolean bl = false;
            AppCloudCapability migratableState = this.getState($this$getMigrationState_u24lambda_u2410, appData);
            String string = $this$getMigrationState_u24lambda_u2410.getPluginInformation().getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersion(...)");
            String string2 = appData.getCloudMigrationAssistantCompatibility();
            if (string2 == null) {
                string2 = "";
            }
            return this.resolveAppCloudCapability(migratableState, MigratabliltyInfo.Companion.calculateNextMigratableVersion(string, string2, appData.getCloudMigrationAssistantCompatibilityRangeList()));
        }
        return new Pair((Object)"", (Object)"");
    }

    private final AppCloudCapability getState(Plugin plugin, AppAggregatorResponse appAggregatorResponse) {
        boolean needsUpgrade = this.needsUpgrade(appAggregatorResponse, plugin);
        AppCloudCapability appCloudCapability = AppCloudCapability.fromMigrationPath((MigrationPath)appAggregatorResponse.getMigrationPath(), (boolean)needsUpgrade);
        Intrinsics.checkNotNullExpressionValue((Object)appCloudCapability, (String)"fromMigrationPath(...)");
        return appCloudCapability;
    }

    private final boolean needsUpgrade(AppAggregatorResponse appAggregatorResponse, Plugin plugin) {
        boolean needsUpgrade = false;
        try {
            boolean bl;
            Object object = appAggregatorResponse.getCloudMigrationAssistantCompatibility();
            if ((object == null || StringsKt.isBlank((CharSequence)object)) && ((object = (Collection)appAggregatorResponse.getCloudMigrationAssistantCompatibilityRangeList()) == null || object.isEmpty())) {
                bl = needsUpgrade;
            } else if (appAggregatorResponse.getCloudMigrationAssistantCompatibilityRangeList() != null && !((Collection)appAggregatorResponse.getCloudMigrationAssistantCompatibilityRangeList()).isEmpty()) {
                String string = plugin.getPluginInformation().getVersion();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersion(...)");
                bl = MigratabliltyInfo.Companion.needsUpgrade(string, appAggregatorResponse.getCloudMigrationAssistantCompatibilityRangeList());
            } else {
                bl = MigratabliltyInfo.Companion.needsUpgrade(plugin.getPluginInformation().getVersion(), appAggregatorResponse.getCloudMigrationAssistantCompatibility());
            }
            return bl;
        }
        catch (MigratabliltyInfo.MigrabilityVersionException ex) {
            needsUpgrade = true;
            Object[] objectArray = new Object[]{plugin.getPluginInformation().getVersion(), appAggregatorResponse.getCloudMigrationAssistantCompatibility(), appAggregatorResponse.getCloudMigrationAssistantCompatibilityRangeList(), ex};
            log.warn("Failed to check if app needs upgrade pluginVersion={}, cloudMigrationAssistantCompatibility={}, cloudMigrationAssistantCompatibilityRanges={}", objectArray);
            return needsUpgrade;
        }
    }

    private final Pair<String, String> resolveAppCloudCapability(AppCloudCapability appCloudCapability, String cloudMigrationAssistantCompatibility) {
        Pair pair;
        switch (WhenMappings.$EnumSwitchMapping$0[appCloudCapability.ordinal()]) {
            case 1: 
            case 2: {
                pair = new Pair((Object)AUTOMATIC, (Object)cloudMigrationAssistantCompatibility);
                break;
            }
            case 3: {
                pair = new Pair((Object)INSTALL_ONLY, (Object)cloudMigrationAssistantCompatibility);
                break;
            }
            case 4: {
                pair = new Pair((Object)"Manual", (Object)"");
                break;
            }
            case 5: {
                pair = new Pair((Object)"No", (Object)"");
                break;
            }
            default: {
                pair = new Pair((Object)"Unknown", (Object)"");
            }
        }
        return pair;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/assessment/AppAssessmentAnalyticsEventService$Companion;", "", "()V", "APP_AVAILABLE_CLOUD_KEY", "", "APP_LATEST_VERSION_KEY", "AUTOMATIC", "CAN_BE_MIGRATED_KEY", "FOUND_MARKETPLACE_KEY", "INSTALL_ONLY", "MIGRATE_STATE", "MIN_VERSION_MIGRATION", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AppCloudCapability.values().length];
            try {
                nArray[AppCloudCapability.yes.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppCloudCapability.upgrade.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppCloudCapability.install_only.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppCloudCapability.manual.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppCloudCapability.no.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

