/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.assessment;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.migration.assessment.AppAssessmentEntity;
import com.atlassian.jira.migration.assessment.AppAssessmentInfo;
import com.atlassian.jira.migration.assessment.AppAssessmentStatus;
import com.atlassian.jira.migration.assessment.AssessmentConsent;
import com.atlassian.jira.migration.common.StringExtensionsKt;
import com.atlassian.migration.app.AccessScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0010\u001a\u00020\fJ\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\fJ\u001e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\f2\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007J\u000e\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/assessment/AppAssessmentRepository;", "", "ao", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;)V", "allAppAssessmentInfo", "", "Lcom/atlassian/jira/migration/assessment/AppAssessmentInfo;", "convertToSet", "", "Lcom/atlassian/migration/app/AccessScope;", "accessScopes", "", "findAppsNeededInCloud", "", "findByAppKey", "key", "getOrDefault", "appKey", "default", "Lkotlin/Function0;", "save", "", "appInfo", "saveOrUpdate", "toAssessmentInfo", "entity", "Lcom/atlassian/jira/migration/assessment/AppAssessmentEntity;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppAssessmentRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppAssessmentRepository.kt\ncom/atlassian/jira/migration/assessment/AppAssessmentRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,111:1\n1#2:112\n1549#3:113\n1620#3,3:114\n766#3:125\n857#3,2:126\n1549#3:128\n1620#3,3:129\n11065#4:117\n11400#4,3:118\n11065#4:121\n11400#4,3:122\n*S KotlinDebug\n*F\n+ 1 AppAssessmentRepository.kt\ncom/atlassian/jira/migration/assessment/AppAssessmentRepository\n*L\n41#1:113\n41#1:114,3\n74#1:125\n74#1:126,2\n75#1:128\n75#1:129,3\n54#1:117\n54#1:118,3\n60#1:121\n60#1:122,3\n*E\n"})
public final class AppAssessmentRepository {
    @NotNull
    private final ActiveObjects ao;

    @Inject
    public AppAssessmentRepository(@NotNull ActiveObjects ao) {
        Intrinsics.checkNotNullParameter((Object)ao, (String)"ao");
        this.ao = ao;
    }

    @NotNull
    public final AppAssessmentInfo getOrDefault(@NotNull String appKey) {
        Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
        return this.getOrDefault(appKey, (Function0<AppAssessmentInfo>)((Function0)new Function0<AppAssessmentInfo>(appKey){
            final /* synthetic */ String $appKey;
            {
                this.$appKey = $appKey;
                super(0);
            }

            @NotNull
            public final AppAssessmentInfo invoke() {
                return new AppAssessmentInfo(this.$appKey, null, null, null, null, null, 62, null);
            }
        }));
    }

    @NotNull
    public final AppAssessmentInfo getOrDefault(@NotNull String appKey, @NotNull Function0<AppAssessmentInfo> function0) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
                Intrinsics.checkNotNullParameter(function0, (String)"default");
                object = (AppAssessmentEntity)this.ao.get(AppAssessmentEntity.class, (Object)appKey);
                if (object == null) break block2;
                AppAssessmentEntity p0 = object;
                boolean bl = false;
                AppAssessmentInfo appAssessmentInfo = this.toAssessmentInfo(p0);
                object = appAssessmentInfo;
                if (appAssessmentInfo != null) break block3;
            }
            object = (AppAssessmentInfo)function0.invoke();
        }
        return object;
    }

    public static /* synthetic */ AppAssessmentInfo getOrDefault$default(AppAssessmentRepository appAssessmentRepository, String string, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = (Function0)new Function0<AppAssessmentInfo>(string){
                final /* synthetic */ String $appKey;
                {
                    this.$appKey = $appKey;
                    super(0);
                }

                @NotNull
                public final AppAssessmentInfo invoke() {
                    return new AppAssessmentInfo(this.$appKey, null, null, null, null, null, 62, null);
                }
            };
        }
        return appAssessmentRepository.getOrDefault(string, (Function0<AppAssessmentInfo>)function0);
    }

    private final void save(AppAssessmentInfo appInfo) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"APP_KEY", (Object)appInfo.getAppKey()), TuplesKt.to((Object)"MIGRATION_STATUS", (Object)((Object)appInfo.getMigrationStatus())), TuplesKt.to((Object)"MIGRATION_NOTES", (Object)appInfo.getMigrationNotes()), TuplesKt.to((Object)"ALTERNATIVE_APP_KEY", (Object)appInfo.getAlternativeAppKey()), TuplesKt.to((Object)"CONSENT", (Object)((Object)appInfo.getConsent())), TuplesKt.to((Object)"ACCESS_SCOPES", (Object)CollectionsKt.joinToString$default((Iterable)appInfo.getAccessScopes(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null))};
        this.ao.create(AppAssessmentEntity.class, MapsKt.mapOf((Pair[])pairArray));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<AppAssessmentInfo> findAppsNeededInCloud() {
        void $this$mapTo$iv$iv;
        Object[] objectArray = new Object[]{AppAssessmentStatus.Needed};
        RawEntity[] rawEntityArray = this.ao.find(AppAssessmentEntity.class, Query.select().where("MIGRATION_STATUS = ?", objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        Iterable $this$map$iv = ArraysKt.toList((Object[])rawEntityArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AppAssessmentEntity appAssessmentEntity = (AppAssessmentEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.toAssessmentInfo((AppAssessmentEntity)it));
        }
        return (List)destination$iv$iv;
    }

    public final void saveOrUpdate(@NotNull AppAssessmentInfo appInfo) {
        block2: {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)appInfo, (String)"appInfo");
            AppAssessmentEntity appAssessmentEntity = (AppAssessmentEntity)this.ao.get(AppAssessmentEntity.class, (Object)appInfo.getAppKey());
            if (appAssessmentEntity != null) {
                AppAssessmentEntity it = appAssessmentEntity;
                boolean bl = false;
                it.setMigrationNotes(appInfo.getMigrationNotes());
                it.setMigrationStatus(appInfo.getMigrationStatus());
                it.setAlternativeAppKey(appInfo.getAlternativeAppKey());
                it.setConsent(appInfo.getConsent());
                it.setAccessScopes(CollectionsKt.joinToString$default((Iterable)appInfo.getAccessScopes(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
                it.save();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block2;
            this.save(appInfo);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AppAssessmentInfo> allAppAssessmentInfo() {
        void $this$mapTo$iv$iv;
        RawEntity[] rawEntityArray = this.ao.find(AppAssessmentEntity.class);
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        Object[] $this$map$iv = rawEntityArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            AppAssessmentEntity appAssessmentEntity = (AppAssessmentEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toAssessmentInfo((AppAssessmentEntity)p0));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AppAssessmentInfo> findByAppKey(@NotNull String key) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object[] objectArray = new Object[]{key};
        RawEntity[] rawEntityArray = this.ao.find(AppAssessmentEntity.class, Query.select().where("APP_KEY = ?", objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        Object[] $this$map$iv = rawEntityArray;
        boolean $i$f$map = false;
        Object[] objectArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AppAssessmentEntity appAssessmentEntity = (AppAssessmentEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.toAssessmentInfo((AppAssessmentEntity)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final AppAssessmentInfo toAssessmentInfo(@NotNull AppAssessmentEntity entity) {
        AssessmentConsent assessmentConsent;
        String string;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        String string2 = entity.getAppKey();
        AppAssessmentStatus appAssessmentStatus = entity.getMigrationStatus();
        String string3 = entity.getMigrationNotes();
        if (string3 == null) {
            string3 = "";
        }
        if ((string = entity.getAlternativeAppKey()) == null) {
            string = "";
        }
        if ((assessmentConsent = entity.getConsent()) == null) {
            assessmentConsent = AssessmentConsent.NotGiven;
        }
        return new AppAssessmentInfo(string2, appAssessmentStatus, string3, string, assessmentConsent, this.convertToSet(entity.getAccessScopes()));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final Set<AccessScope> convertToSet(String accessScopes) {
        Set set;
        if (accessScopes != null) {
            String[] stringArray = new String[]{","};
            List list = StringsKt.split$default((CharSequence)accessScopes, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (list != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Iterable iterable = list;
                boolean $i$f$filter22 = false;
                void var6_7 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!StringExtensionsKt.isNotNullOrBlank(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $i$f$filter22 = (List)destination$iv$iv;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String bl = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(AccessScope.valueOf((String)it));
                }
                Set set2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                if (set2 != null) {
                    set = set2;
                    return set;
                }
            }
        }
        set = SetsKt.emptySet();
        return set;
    }
}

