/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.assessment;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.migration.amsclient.DefaultAppMigrationServiceClient;
import com.atlassian.jira.migration.app.CloudMigrationRegistrar;
import com.atlassian.jira.migration.assessment.AppAggregatorClient;
import com.atlassian.jira.migration.assessment.AppAggregatorResponse;
import com.atlassian.jira.migration.assessment.AppAssessmentAnalyticsEventService;
import com.atlassian.jira.migration.assessment.AppAssessmentInfo;
import com.atlassian.jira.migration.assessment.AppAssessmentProperty;
import com.atlassian.jira.migration.assessment.AppAssessmentRepository;
import com.atlassian.jira.migration.assessment.AppAssessmentService;
import com.atlassian.jira.migration.assessment.AppAssessmentServiceKt;
import com.atlassian.jira.migration.assessment.AppAssessmentStatsResponse;
import com.atlassian.jira.migration.assessment.AppAssessmentStatus;
import com.atlassian.jira.migration.assessment.AppConsent;
import com.atlassian.jira.migration.assessment.AppDataSummaries;
import com.atlassian.jira.migration.assessment.AppDto;
import com.atlassian.jira.migration.assessment.AppListResponse;
import com.atlassian.jira.migration.assessment.AppSummary;
import com.atlassian.jira.migration.assessment.AppUsageCheckService;
import com.atlassian.jira.migration.assessment.AppsNeededInCloud;
import com.atlassian.jira.migration.assessment.AssessmentConsent;
import com.atlassian.jira.migration.assessment.CloudAppDto;
import com.atlassian.jira.migration.assessment.CloudAppsInfoRequest;
import com.atlassian.jira.migration.assessment.ConsentStatus;
import com.atlassian.jira.migration.assessment.PluginManager;
import com.atlassian.jira.migration.assessment.ReliabilityState;
import com.atlassian.jira.migration.assessment.TrivalentState;
import com.atlassian.jira.migration.assessment.UpdateAllAppAssessmentRequest;
import com.atlassian.jira.migration.assessment.UpdateAppAssessmentRequest;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.common.Constants;
import com.atlassian.jira.migration.events.AppAssessmentUpdatedEvent;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.plan.AppsMigrationOption;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.utils.MigrationModeUtil;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.migration.app.AccessScope;
import com.atlassian.migration.app.AppCloudCapability;
import com.atlassian.migration.app.MigratabliltyInfo;
import com.atlassian.migration.app.dto.AppCloudSiteInfo;
import com.atlassian.migration.app.dto.MigrationPath;
import com.atlassian.plugin.Plugin;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 w2\u00020\u0001:\u0001wBo\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020!J\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)H\u0007J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020'0&H\u0007J4\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020-2\u0016\b\u0002\u0010.\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020!\u0018\u00010/2\n\b\u0002\u00100\u001a\u0004\u0018\u000101H\u0002J \u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u001f2\u0006\u00107\u001a\u000201H\u0002J\u001c\u00108\u001a\u0004\u0018\u00010\u001f2\u0006\u00109\u001a\u00020\u001f2\b\u0010:\u001a\u0004\u0018\u00010\u001fH\u0002J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020!0 H\u0007J\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=2\u0006\u0010?\u001a\u00020\u001fH\u0002J\f\u0010@\u001a\b\u0012\u0004\u0012\u00020#0&J\u0014\u0010A\u001a\b\u0012\u0004\u0012\u00020!0B2\u0006\u0010?\u001a\u00020\u001fJ\b\u0010C\u001a\u00020DH\u0002J\f\u0010E\u001a\b\u0012\u0004\u0012\u00020'0FJ\u0006\u0010G\u001a\u00020HJ\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u001f0=J\u0014\u0010J\u001a\b\u0012\u0004\u0012\u0002030F2\u0006\u0010K\u001a\u00020LJ\"\u0010M\u001a\u00020N2\u0006\u0010$\u001a\u00020!2\u0006\u0010O\u001a\u0002012\b\u0010,\u001a\u0004\u0018\u00010-H\u0002J\u001c\u0010P\u001a\b\u0012\u0004\u0012\u00020\u001f0=2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u001f0=H\u0002J\u0006\u0010R\u001a\u00020SJ\u0018\u0010T\u001a\b\u0012\u0004\u0012\u00020'0F2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)J$\u0010U\u001a\b\u0012\u0004\u0012\u00020\u001f0=2\u0006\u0010V\u001a\u00020W2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u001f0=H\u0002J\u001a\u0010X\u001a\u0004\u0018\u00010Y2\u0006\u0010Z\u001a\u00020\u001f2\u0006\u0010[\u001a\u00020\\H\u0007J\u0016\u0010]\u001a\b\u0012\u0004\u0012\u00020>0=2\u0006\u0010?\u001a\u00020\u001fH\u0002J\u0016\u0010^\u001a\u00020\\2\u0006\u0010,\u001a\u00020-2\u0006\u0010_\u001a\u000201J*\u0010`\u001a\u00020a2\b\u0010b\u001a\u0004\u0018\u00010a2\b\b\u0002\u0010c\u001a\u00020W2\u000e\b\u0002\u0010d\u001a\b\u0012\u0004\u0012\u00020\u001f0=J\u0010\u0010e\u001a\u00020f2\u0006\u0010Z\u001a\u00020\u001fH\u0007J\u0006\u0010g\u001a\u00020fJ\u0010\u0010h\u001a\u00020f2\u0006\u0010$\u001a\u00020!H\u0002J\u000e\u0010i\u001a\u00020f2\u0006\u0010?\u001a\u00020\u001fJ\u0018\u0010j\u001a\u00020f2\u0006\u0010_\u001a\u0002012\u0006\u0010,\u001a\u00020-H\u0002J\u000e\u0010k\u001a\u00020f2\u0006\u0010l\u001a\u00020NJ\u000e\u0010m\u001a\u00020f2\u0006\u0010?\u001a\u00020\u001fJ\u000e\u0010n\u001a\u00020o2\u0006\u0010K\u001a\u00020pJ\u000e\u0010q\u001a\u00020o2\u0006\u0010K\u001a\u00020rJ(\u0010q\u001a\u00020o2\u0006\u0010s\u001a\u00020\u001f2\u0006\u0010t\u001a\u00020!2\u0006\u0010u\u001a\u00020\u001f2\u0006\u0010?\u001a\u00020\u001fH\u0002J\u000e\u0010v\u001a\u00020#2\u0006\u0010K\u001a\u00020rR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006x"}, d2={"Lcom/atlassian/jira/migration/assessment/AppAssessmentService;", "", "appAssessmentRepository", "Lcom/atlassian/jira/migration/assessment/AppAssessmentRepository;", "pluginManager", "Lcom/atlassian/jira/migration/assessment/PluginManager;", "appAssessmentAnalyticsEventService", "Lcom/atlassian/jira/migration/assessment/AppAssessmentAnalyticsEventService;", "jiraAuthenticationContext", "Lcom/atlassian/jira/security/JiraAuthenticationContext;", "appAggregatorClient", "Lcom/atlassian/jira/migration/assessment/AppAggregatorClient;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "cloudMigrationRegistrar", "Lcom/atlassian/jira/migration/app/CloudMigrationRegistrar;", "appMigrationServiceClient", "Lcom/atlassian/jira/migration/amsclient/DefaultAppMigrationServiceClient;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "migratabliltyInfo", "Lcom/atlassian/migration/app/MigratabliltyInfo;", "appUsageCheckService", "Lcom/atlassian/jira/migration/assessment/AppUsageCheckService;", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "eventPublisher", "Lcom/atlassian/event/api/EventPublisher;", "(Lcom/atlassian/jira/migration/assessment/AppAssessmentRepository;Lcom/atlassian/jira/migration/assessment/PluginManager;Lcom/atlassian/jira/migration/assessment/AppAssessmentAnalyticsEventService;Lcom/atlassian/jira/security/JiraAuthenticationContext;Lcom/atlassian/jira/migration/assessment/AppAggregatorClient;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/app/CloudMigrationRegistrar;Lcom/atlassian/jira/migration/amsclient/DefaultAppMigrationServiceClient;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/migration/app/MigratabliltyInfo;Lcom/atlassian/jira/migration/assessment/AppUsageCheckService;Lcom/atlassian/cache/CacheManager;Lcom/atlassian/event/api/EventPublisher;)V", "appsNeededInCloudCache", "Lcom/atlassian/cache/Cache;", "", "", "Lcom/atlassian/jira/migration/assessment/AppAssessmentInfo;", "buildAppConsent", "Lcom/atlassian/jira/migration/assessment/AppConsent;", "appInfo", "buildAppSummaries", "", "Lcom/atlassian/jira/migration/assessment/AppSummary;", "user", "Lcom/atlassian/jira/user/ApplicationUser;", "buildAppSummariesWithoutAnalytics", "buildAppSummary", "plugin", "Lcom/atlassian/plugin/Plugin;", "assessedPlugins", "", "serverAppData", "Lcom/atlassian/jira/migration/assessment/AppAggregatorResponse;", "buildCloudAppDto", "Lcom/atlassian/jira/migration/assessment/CloudAppDto;", "amsAppData", "Lcom/atlassian/migration/app/dto/AppCloudSiteInfo;", "cloudUrl", "maaAppData", "buildCloudAppInstallationUrl", "siteUrl", "relativeAppInstallUrl", "fetchAppsThatWouldBeMigratedToCloud", "getAccessScopesDeclaredByApp", "", "Lcom/atlassian/migration/app/AccessScope;", "appKey", "getAllAppsNeedingConsent", "getAppAssessmentInfoByAppKey", "Ljava/util/Optional;", "getAppSummaries", "Lcom/atlassian/jira/migration/assessment/AppDataSummaries;", "getAppsAssessment", "Lcom/atlassian/jira/migration/assessment/AppListResponse;", "getAppsNeededInCloud", "Lcom/atlassian/jira/migration/assessment/AppsNeededInCloud;", "getAppsThatWouldBeMigratedToCloud", "getCloudAppsInfo", "request", "Lcom/atlassian/jira/migration/assessment/CloudAppsInfoRequest;", "getConsentStatus", "Lcom/atlassian/jira/migration/assessment/ConsentStatus;", "response", "getIncludedCloudAppKeys", "includedApps", "getPluginStats", "Lcom/atlassian/jira/migration/assessment/AppAssessmentStatsResponse;", "getPlugins", "getPreloadableApps", "migrationMode", "Lcom/atlassian/jira/migration/plan/ProjectDataMigrationMode;", "getReliabilityState", "Lcom/atlassian/jira/migration/assessment/ReliabilityState;", "pluginKey", "migratableState", "Lcom/atlassian/migration/app/AppCloudCapability;", "getSavedAccessScopes", "getState", "appAggregatorResponse", "getUpdatedAppsMigrationOption", "Lcom/atlassian/jira/migration/plan/AppsMigrationOption;", "appsMigrationOption", "projectDataMigrationMode", "userRequestedApps", "hasAutomaticPath", "", "hasNonPreloadableApps", "isAccessScopesUpdated", "isAppConsented", "needsUpgrade", "requiresUserConsent", "consentStatus", "savedAccessScopesAreCurrent", "updateAllAppAssessment", "", "Lcom/atlassian/jira/migration/assessment/UpdateAllAppAssessmentRequest;", "updateAppAssessment", "Lcom/atlassian/jira/migration/assessment/UpdateAppAssessmentRequest;", "appProperty", "currentAssessment", "requestValue", "updateAppConsent", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppAssessmentService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppAssessmentService.kt\ncom/atlassian/jira/migration/assessment/AppAssessmentService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,511:1\n1855#2,2:512\n1549#2:514\n1620#2,3:515\n766#2:518\n857#2,2:519\n1549#2:521\n1620#2,3:522\n1747#2,3:525\n766#2:528\n857#2,2:529\n1549#2:531\n1620#2,3:532\n1549#2:535\n1620#2,3:536\n1549#2:539\n1620#2,2:540\n1622#2:543\n1360#2:544\n1446#2,5:545\n1603#2,9:550\n1855#2:559\n1856#2:561\n1612#2:562\n819#2:563\n847#2,2:564\n1549#2:566\n1620#2,3:567\n766#2:570\n857#2,2:571\n1549#2:573\n1620#2,3:574\n1549#2:577\n1620#2,3:578\n1#3:542\n1#3:560\n*S KotlinDebug\n*F\n+ 1 AppAssessmentService.kt\ncom/atlassian/jira/migration/assessment/AppAssessmentService\n*L\n103#1:512,2\n157#1:514\n157#1:515,3\n194#1:518\n194#1:519,2\n195#1:521\n195#1:522,3\n248#1:525,3\n269#1:528\n269#1:529,2\n272#1:531\n272#1:532,3\n294#1:535\n294#1:536,3\n297#1:539\n297#1:540,2\n297#1:543\n306#1:544\n306#1:545,5\n307#1:550,9\n307#1:559\n307#1:561\n307#1:562\n308#1:563\n308#1:564,2\n330#1:566\n330#1:567,3\n333#1:570\n333#1:571,2\n334#1:573\n334#1:574,3\n348#1:577\n348#1:578,3\n307#1:560\n*E\n"})
public final class AppAssessmentService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AppAssessmentRepository appAssessmentRepository;
    @NotNull
    private final PluginManager pluginManager;
    @NotNull
    private final AppAssessmentAnalyticsEventService appAssessmentAnalyticsEventService;
    @NotNull
    private final JiraAuthenticationContext jiraAuthenticationContext;
    @NotNull
    private final AppAggregatorClient appAggregatorClient;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final CloudMigrationRegistrar cloudMigrationRegistrar;
    @NotNull
    private final DefaultAppMigrationServiceClient appMigrationServiceClient;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final MigratabliltyInfo migratabliltyInfo;
    @NotNull
    private final AppUsageCheckService appUsageCheckService;
    @NotNull
    private final CacheManager cacheManager;
    @NotNull
    private final EventPublisher eventPublisher;
    @NotNull
    private final Cache<String, Collection<AppAssessmentInfo>> appsNeededInCloudCache;
    private static final Logger log = LoggerFactory.getLogger(AppAssessmentService.class);
    @NotNull
    public static final String UPM_MANAGE_URL = "/plugins/servlet/upm";
    @NotNull
    public static final String EMPTY_STRING = "";
    @NotNull
    private static final String APPS_NEEDED_IN_CLOUD_CACHE_NAME = AppAssessmentService.class.getName() + ".classic.mig.status.data";
    @NotNull
    public static final String APPS_NEEDED_IN_CLOUD_CACHE_KEY = "APPS_NEEDED_IN_CLOUD";
    public static final long CACHE_EXPIRY_TIME_IN_DAYS = 7L;

    @Inject
    public AppAssessmentService(@NotNull AppAssessmentRepository appAssessmentRepository, @NotNull PluginManager pluginManager, @NotNull AppAssessmentAnalyticsEventService appAssessmentAnalyticsEventService, @NotNull JiraAuthenticationContext jiraAuthenticationContext, @NotNull AppAggregatorClient appAggregatorClient, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull CloudMigrationRegistrar cloudMigrationRegistrar, @NotNull DefaultAppMigrationServiceClient appMigrationServiceClient, @NotNull MigrationFeatures migrationFeatures, @NotNull MigratabliltyInfo migratabliltyInfo, @NotNull AppUsageCheckService appUsageCheckService, @NotNull CacheManager cacheManager, @NotNull EventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter((Object)appAssessmentRepository, (String)"appAssessmentRepository");
        Intrinsics.checkNotNullParameter((Object)pluginManager, (String)"pluginManager");
        Intrinsics.checkNotNullParameter((Object)appAssessmentAnalyticsEventService, (String)"appAssessmentAnalyticsEventService");
        Intrinsics.checkNotNullParameter((Object)jiraAuthenticationContext, (String)"jiraAuthenticationContext");
        Intrinsics.checkNotNullParameter((Object)appAggregatorClient, (String)"appAggregatorClient");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)((Object)cloudMigrationRegistrar), (String)"cloudMigrationRegistrar");
        Intrinsics.checkNotNullParameter((Object)appMigrationServiceClient, (String)"appMigrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)migratabliltyInfo, (String)"migratabliltyInfo");
        Intrinsics.checkNotNullParameter((Object)appUsageCheckService, (String)"appUsageCheckService");
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        this.appAssessmentRepository = appAssessmentRepository;
        this.pluginManager = pluginManager;
        this.appAssessmentAnalyticsEventService = appAssessmentAnalyticsEventService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.appAggregatorClient = appAggregatorClient;
        this.cloudSiteRepository = cloudSiteRepository;
        this.cloudMigrationRegistrar = cloudMigrationRegistrar;
        this.appMigrationServiceClient = appMigrationServiceClient;
        this.migrationFeatures = migrationFeatures;
        this.migratabliltyInfo = migratabliltyInfo;
        this.appUsageCheckService = appUsageCheckService;
        this.cacheManager = cacheManager;
        this.eventPublisher = eventPublisher;
        CacheSettings cacheSettings = new CacheSettingsBuilder().expireAfterWrite(7L, TimeUnit.DAYS).replicateViaInvalidation().remote().build();
        Intrinsics.checkNotNullExpressionValue((Object)cacheSettings, (String)"build(...)");
        CacheSettings cacheSetting = cacheSettings;
        Cache cache2 = this.cacheManager.getCache(APPS_NEEDED_IN_CLOUD_CACHE_NAME, null, cacheSetting);
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"getCache(...)");
        this.appsNeededInCloudCache = cache2;
        this.appsNeededInCloudCache.removeAll();
    }

    @NotNull
    public final AppListResponse<AppSummary> getAppsAssessment() {
        return new AppListResponse<AppSummary>(AppAssessmentService.buildAppSummaries$default(this, null, 1, null));
    }

    public final void updateAppAssessment(@NotNull UpdateAppAssessmentRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String appKey = request.getAppKey();
        AppAssessmentInfo currentAssessment2 = this.appAssessmentRepository.getOrDefault(appKey, (Function0<AppAssessmentInfo>)((Function0)new Function0<AppAssessmentInfo>(appKey, this){
            final /* synthetic */ String $appKey;
            final /* synthetic */ AppAssessmentService this$0;
            {
                this.$appKey = $appKey;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AppAssessmentInfo invoke() {
                return new AppAssessmentInfo(this.$appKey, null, null, null, null, AppAssessmentService.access$getAccessScopesDeclaredByApp(this.this$0, this.$appKey), 30, null);
            }
        }));
        String requestValue = request.getValue();
        String appProperty = request.getAppProperty();
        this.updateAppAssessment(appProperty, currentAssessment2, requestValue, appKey);
        this.eventPublisher.publish((Object)new AppAssessmentUpdatedEvent());
    }

    public final void updateAllAppAssessment(@NotNull UpdateAllAppAssessmentRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Iterable $this$forEach$iv = this.appAssessmentRepository.allAppAssessmentInfo();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AppAssessmentInfo currentAssessment2 = (AppAssessmentInfo)element$iv;
            boolean bl = false;
            this.updateAppAssessment(request.getAppProperty(), currentAssessment2, request.getValue(), currentAssessment2.getAppKey());
        }
        this.eventPublisher.publish((Object)new AppAssessmentUpdatedEvent());
    }

    private final void updateAppAssessment(String appProperty, AppAssessmentInfo currentAssessment2, String requestValue, String appKey) {
        AppAssessmentInfo appAssessmentInfo;
        String string = appProperty;
        if (Intrinsics.areEqual((Object)string, (Object)AppAssessmentProperty.ASSESSMENT_STATUS.getValue())) {
            appAssessmentInfo = AppAssessmentInfo.copy$default(currentAssessment2, null, AppAssessmentStatus.valueOf(requestValue), null, null, null, null, 61, null);
        } else if (Intrinsics.areEqual((Object)string, (Object)AppAssessmentProperty.MIGRATION_NOTES.getValue())) {
            appAssessmentInfo = AppAssessmentInfo.copy$default(currentAssessment2, null, null, requestValue, null, null, null, 59, null);
        } else if (Intrinsics.areEqual((Object)string, (Object)AppAssessmentProperty.ALTERNATIVE_APP_KEY.getValue())) {
            appAssessmentInfo = AppAssessmentInfo.copy$default(currentAssessment2, null, null, null, requestValue, null, null, 55, null);
        } else if (Intrinsics.areEqual((Object)string, (Object)AppAssessmentProperty.CONSENT_STATUS.getValue())) {
            appAssessmentInfo = AppAssessmentInfo.copy$default(currentAssessment2, null, null, null, null, AssessmentConsent.valueOf(requestValue), this.cloudMigrationRegistrar.getAccessScopesByApp(appKey), 15, null);
        } else {
            throw new IllegalArgumentException("Unsupported app property : " + appProperty);
        }
        AppAssessmentInfo updatedAssessment = appAssessmentInfo;
        this.appAssessmentRepository.saveOrUpdate(updatedAssessment);
        this.appsNeededInCloudCache.removeAll();
        ApplicationUser applicationUser = this.jiraAuthenticationContext.getLoggedInUser();
        Intrinsics.checkNotNullExpressionValue((Object)applicationUser, (String)"getLoggedInUser(...)");
        this.appAssessmentAnalyticsEventService.savePropertyChangedEvent(applicationUser, appKey, appProperty);
    }

    @NotNull
    public final AppConsent updateAppConsent(@NotNull UpdateAppAssessmentRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.updateAppAssessment(request);
        return this.buildAppConsent(this.appAssessmentRepository.getOrDefault(request.getAppKey()));
    }

    @NotNull
    public final AppAssessmentStatsResponse getPluginStats() {
        return new AppAssessmentStatsResponse(this.pluginManager.getEligibleAppsForAssessment().size());
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final List<AppSummary> buildAppSummaries(@Nullable ApplicationUser user) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        long startTime = System.currentTimeMillis();
        AppDataSummaries appDataSummaries = this.getAppSummaries();
        List<AppSummary> appSummaries = appDataSummaries.component1();
        List<AppAggregatorResponse> appData = appDataSummaries.component2();
        long timeToCompleteMs = System.currentTimeMillis() - startTime;
        ApplicationUser currentUser = user;
        if (currentUser == null) {
            currentUser = this.jiraAuthenticationContext.getLoggedInUser();
        }
        ApplicationUser applicationUser = currentUser;
        Intrinsics.checkNotNull((Object)applicationUser);
        Iterable iterable = appSummaries;
        ApplicationUser applicationUser2 = applicationUser;
        AppAssessmentAnalyticsEventService appAssessmentAnalyticsEventService = this.appAssessmentAnalyticsEventService;
        boolean $i$f$map = false;
        void var12_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AppSummary appSummary = (AppSummary)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKey());
        }
        collection = (List)destination$iv$iv;
        appAssessmentAnalyticsEventService.saveAppsFetchedEvent(applicationUser2, collection, appData, timeToCompleteMs);
        return appSummaries;
    }

    public static /* synthetic */ List buildAppSummaries$default(AppAssessmentService appAssessmentService, ApplicationUser applicationUser, int n, Object object) {
        if ((n & 1) != 0) {
            applicationUser = null;
        }
        return appAssessmentService.buildAppSummaries(applicationUser);
    }

    @VisibleForTesting
    @NotNull
    public final List<AppSummary> buildAppSummariesWithoutAnalytics() {
        return this.getAppSummaries().getAppSummary();
    }

    @NotNull
    public final AppListResponse<CloudAppDto> getCloudAppsInfo(@NotNull CloudAppsInfoRequest request) {
        AppListResponse appListResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String cloudId2 = request.getCloudId();
        CloudSite cloudSite2 = this.cloudSiteRepository.getSite(cloudId2);
        if (cloudSite2 == null) {
            throw new IllegalArgumentException("Failed to find cloudSite entry for requested cloudId: " + cloudId2);
        }
        CloudSite site = cloudSite2;
        if (!((Collection)request.getAppKeys()).isEmpty()) {
            List cloudAppsSummary2 = this.appMigrationServiceClient.getAppInfoForSite(cloudId2, request.getAppKeys()).getApps().parallelStream().map(arg_0 -> AppAssessmentService.getCloudAppsInfo$lambda$2((Function1)new Function1<AppCloudSiteInfo, CloudAppDto>(this, site){
                final /* synthetic */ AppAssessmentService this$0;
                final /* synthetic */ CloudSite $site;
                {
                    this.this$0 = $receiver;
                    this.$site = $site;
                    super(1);
                }

                public final CloudAppDto invoke(AppCloudSiteInfo it) {
                    Intrinsics.checkNotNull((Object)it);
                    String string = this.$site.getCloudUrl().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    return AppAssessmentService.access$buildCloudAppDto(this.this$0, it, string, AppAssessmentService.access$getAppAggregatorClient$p(this.this$0).getCloudAppData(it.getKey()));
                }
            }, arg_0)).collect(Collectors.toList());
            Intrinsics.checkNotNull(cloudAppsSummary2);
            appListResponse = new AppListResponse(cloudAppsSummary2);
        } else {
            appListResponse = new AppListResponse(CollectionsKt.emptyList());
        }
        return appListResponse;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AppConsent> getAllAppsNeedingConsent() {
        void $this$mapTo$iv$iv;
        AppAssessmentInfo it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.appAssessmentRepository.findAppsNeededInCloud();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (AppAssessmentInfo)element$iv$iv;
            boolean bl = false;
            if (!(this.pluginManager.getPlugin(it.getAppKey()) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (AppAssessmentInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.buildAppConsent(it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final AppConsent buildAppConsent(@NotNull AppAssessmentInfo appInfo) {
        String string;
        Intrinsics.checkNotNullParameter((Object)appInfo, (String)"appInfo");
        AppAggregatorResponse appData = this.appAggregatorClient.getServerAppData(appInfo.getAppKey());
        Plugin plugin = this.pluginManager.getPlugin(appInfo.getAppKey());
        String string2 = appInfo.getAppKey();
        String string3 = (String)CollectionsKt.first((Iterable)this.migratabliltyInfo.getCloudAppKeys(appInfo.getAppKey(), appData.getCloudKey()));
        String string4 = AppAssessmentServiceKt.getAppName(appData, plugin, appInfo.getAppKey());
        Plugin plugin2 = plugin;
        if ((plugin2 != null && (plugin2 = plugin2.getPluginInformation()) != null ? plugin2.getVendorName() : (string = null)) == null) {
            string = "Unknown";
        }
        return new AppConsent(string2, string3, string4, string, this.getConsentStatus(appInfo, appData, plugin), appData.getContactSupport(), appData.getPrivacyPolicyUrl(), appData.getIcon(), appData.getTopVendor(), appInfo.getAccessScopes(), Constants.buildPageUrl$default(Constants.INSTANCE, UPM_MANAGE_URL, null, 2, null));
    }

    public final boolean savedAccessScopesAreCurrent(@NotNull String appKey) {
        Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
        Set<AccessScope> accessScopesFromPlugin = this.getAccessScopesDeclaredByApp(appKey);
        Set<AccessScope> savedAccessScopes = this.getSavedAccessScopes(appKey);
        return Intrinsics.areEqual(accessScopesFromPlugin, savedAccessScopes);
    }

    public final boolean isAppConsented(@NotNull String appKey) {
        Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
        Optional<AppAssessmentInfo> maybeAppAssessmentInfo = this.getAppAssessmentInfoByAppKey(appKey);
        return maybeAppAssessmentInfo.isPresent() ? AssessmentConsent.Given == maybeAppAssessmentInfo.get().getConsent() : false;
    }

    @NotNull
    public final Optional<AppAssessmentInfo> getAppAssessmentInfoByAppKey(@NotNull String appKey) {
        Optional<Object> optional;
        Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
        List<AppAssessmentInfo> result2 = this.appAssessmentRepository.findByAppKey(appKey);
        if (result2.isEmpty()) {
            Optional<AppAssessmentInfo> optional2 = Optional.empty();
            Intrinsics.checkNotNull(optional2);
            optional = optional2;
        } else {
            Optional<Object> optional3 = Optional.of(CollectionsKt.first(result2));
            Intrinsics.checkNotNull(optional3);
            optional = optional3;
        }
        return optional;
    }

    public final boolean requiresUserConsent(@NotNull ConsentStatus consentStatus) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)consentStatus), (String)"consentStatus");
        switch (WhenMappings.$EnumSwitchMapping$0[consentStatus.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                bl = true;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public final boolean hasNonPreloadableApps() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getAppsNeededInCloud().getApps();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AppDto it = (AppDto)element$iv;
                    boolean bl2 = false;
                    if (!(!it.getPreloadable())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AppsMigrationOption getUpdatedAppsMigrationOption(@Nullable AppsMigrationOption appsMigrationOption, @NotNull ProjectDataMigrationMode projectDataMigrationMode, @NotNull Set<String> userRequestedApps) {
        AppsMigrationOption appsMigrationOption2;
        Intrinsics.checkNotNullParameter((Object)((Object)projectDataMigrationMode), (String)"projectDataMigrationMode");
        Intrinsics.checkNotNullParameter(userRequestedApps, (String)"userRequestedApps");
        if (this.migrationFeatures.getEnableAppMigrationsDevMode()) {
            Set includedApps = this.cloudMigrationRegistrar.getRegisteredServerKeys();
            Set<String> includedCloudApps = this.getIncludedCloudAppKeys(includedApps);
            appsMigrationOption2 = new AppsMigrationOption(true, null, includedApps, includedCloudApps, false, SetsKt.emptySet(), 2, null);
        } else if (appsMigrationOption != null && (appsMigrationOption.getMigrate() || MigrationModeUtil.INSTANCE.isAppDataPreloadMode(projectDataMigrationMode))) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            AppDto it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable includedCloudApps = this.getAppsNeededInCloud().getApps();
            boolean $i$f$filter = false;
            void var7_9 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (AppDto)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !appsMigrationOption.getExcludedAppsRequested().contains(it.getKey()) && (userRequestedApps.isEmpty() || userRequestedApps.contains(it.getKey()));
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (AppDto)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getKey());
            }
            Set includedApps = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Set<String> includeCloudAppKeys = this.getIncludedCloudAppKeys(includedApps);
            appsMigrationOption2 = new AppsMigrationOption(appsMigrationOption.getMigrate(), appsMigrationOption.getExcludedAppsRequested(), includedApps, includeCloudAppKeys, appsMigrationOption.getPreload(), this.getPreloadableApps(projectDataMigrationMode, includedApps));
        } else {
            appsMigrationOption2 = new AppsMigrationOption(false, SetsKt.emptySet(), SetsKt.emptySet(), null, false, null, 56, null);
        }
        return appsMigrationOption2;
    }

    public static /* synthetic */ AppsMigrationOption getUpdatedAppsMigrationOption$default(AppAssessmentService appAssessmentService, AppsMigrationOption appsMigrationOption, ProjectDataMigrationMode projectDataMigrationMode, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            projectDataMigrationMode = ProjectDataMigrationMode.ALL;
        }
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        return appAssessmentService.getUpdatedAppsMigrationOption(appsMigrationOption, projectDataMigrationMode, set);
    }

    /*
     * WARNING - void declaration
     */
    private final AppDataSummaries getAppSummaries() {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        List<Plugin> pluginsEligibleForAssessment = this.pluginManager.getEligibleAppsForAssessment();
        Map<String, AppAssessmentInfo> map = this.appAssessmentRepository.allAppAssessmentInfo().stream().collect(Collectors.toMap(arg_0 -> AppAssessmentService.getAppSummaries$lambda$8((Function1)getAppSummaries.assessedPlugins.1.INSTANCE, arg_0), Function.identity()));
        Intrinsics.checkNotNullExpressionValue(map, (String)"collect(...)");
        Map<String, AppAssessmentInfo> assessedPlugins2 = map;
        Iterable $this$map$iv = pluginsEligibleForAssessment;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Plugin plugin = (Plugin)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKey());
        }
        Set pluginKeys = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        List<AppAggregatorResponse> appData = this.appAggregatorClient.getBatchServerAppData(pluginKeys);
        Iterable $this$map$iv2 = pluginsEligibleForAssessment;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object v1;
            void plugin;
            block3: {
                Plugin plugin2 = (Plugin)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                Iterable iterable2 = appData;
                for (Object t : iterable2) {
                    AppAggregatorResponse pluginData = (AppAggregatorResponse)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)pluginData.getKey(), (Object)plugin.getKey())) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            AppAggregatorResponse pluginData = v1;
            collection.add(this.buildAppSummary((Plugin)plugin, assessedPlugins2, pluginData));
        }
        List appSummaries = (List)destination$iv$iv2;
        return new AppDataSummaries(appSummaries, appData);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getIncludedCloudAppKeys(Set<String> includedApps) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        void $this$mapNotNullTo$iv$iv;
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable iterable = includedApps;
        CloudMigrationRegistrar cloudMigrationRegistrar = this.cloudMigrationRegistrar;
        boolean $i$f$flatMap = false;
        void var6_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String p0 = (String)element$iv$iv;
            boolean bl = false;
            list$iv$iv = cloudMigrationRegistrar.getRegisteredCloudKeys(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set listenerCloudAppKeys = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$mapNotNull$iv = includedApps;
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        list$iv$iv = $this$forEach$iv$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.appAggregatorClient.getServerAppData(it).getCloudKey() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapNotNullTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            if (charSequence == null || charSequence.length() == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set marketplaceCloudAppKeys = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return SetsKt.plus((Set)listenerCloudAppKeys, (Iterable)marketplaceCloudAppKeys);
    }

    private final Set<String> getPreloadableApps(ProjectDataMigrationMode migrationMode, Set<String> includedApps) {
        Set preloadableApps = new LinkedHashSet();
        if (MigrationModeUtil.INSTANCE.isAppDataPreloadMode(migrationMode)) {
            for (String appKey : includedApps) {
                if (!this.cloudMigrationRegistrar.isPreloadable(appKey)) continue;
                preloadableApps.add(appKey);
            }
        }
        return preloadableApps;
    }

    @NotNull
    public final AppListResponse<AppSummary> getPlugins(@Nullable ApplicationUser user) {
        return new AppListResponse<AppSummary>((Collection)this.buildAppSummaries(user));
    }

    public static /* synthetic */ AppListResponse getPlugins$default(AppAssessmentService appAssessmentService, ApplicationUser applicationUser, int n, Object object) {
        if ((n & 1) != 0) {
            applicationUser = null;
        }
        return appAssessmentService.getPlugins(applicationUser);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final AppsNeededInCloud getAppsNeededInCloud() {
        $this$map$iv = this.fetchAppsThatWouldBeMigratedToCloud();
        $i$f$map = false;
        var4_3 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var9_8 = (AppAssessmentInfo)item$iv$iv;
            var11_10 = destination$iv$iv;
            $i$a$-map-AppAssessmentService$getAppsNeededInCloud$neededInCloudAppKeys$1 = false;
            var11_10.add(it.getAppKey());
        }
        neededInCloudAppKeys = (List)destination$iv$iv;
        $this$filter$iv = this.pluginManager.getEligibleAppsForAssessment();
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Plugin)element$iv$iv;
            $i$a$-filter-AppAssessmentService$getAppsNeededInCloud$1 = false;
            if (!neededInCloudAppKeys.contains(it.getKey())) ** GOTO lbl-1000
            v0 = it.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getKey(...)");
            if (this.hasAutomaticPath(v0)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            it = (Plugin)item$iv$iv;
            var12_12 = destination$iv$iv;
            $i$a$-map-AppAssessmentService$getAppsNeededInCloud$2 = false;
            v2 = it.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getKey(...)");
            v3 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getName(...)");
            if (!this.migrationFeatures.getAppDataPreloadEnabledGA()) ** GOTO lbl-1000
            v4 = it.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getKey(...)");
            if (this.cloudMigrationRegistrar.isPreloadable(v4)) {
                v5 = true;
            } else lbl-1000:
            // 2 sources

            {
                v5 = false;
            }
            var12_12.add(new AppDto(v2, v3, v5));
        }
        var13_13 = (List)destination$iv$iv;
        return new AppsNeededInCloud(var13_13);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> getAppsThatWouldBeMigratedToCloud() {
        void $this$mapTo$iv$iv;
        if (this.migrationFeatures.getEnableAppMigrationsDevMode()) {
            return this.cloudMigrationRegistrar.getRegisteredServerKeys();
        }
        Iterable $this$map$iv = this.getAppsNeededInCloud().getApps();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AppDto appDto = (AppDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKey());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @VisibleForTesting
    @NotNull
    public final Collection<AppAssessmentInfo> fetchAppsThatWouldBeMigratedToCloud() {
        Object object = this.appsNeededInCloudCache.get((Object)APPS_NEEDED_IN_CLOUD_CACHE_KEY, () -> AppAssessmentService.fetchAppsThatWouldBeMigratedToCloud$lambda$18(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Collection)object;
    }

    @VisibleForTesting
    public final boolean hasAutomaticPath(@NotNull String pluginKey) {
        Plugin plugin;
        Intrinsics.checkNotNullParameter((Object)pluginKey, (String)"pluginKey");
        AppAggregatorResponse appAggregatorResponse = this.appAggregatorClient.getServerAppData(pluginKey);
        Plugin plugin2 = plugin = this.pluginManager.getPlugin(pluginKey);
        if (plugin2 != null) {
            Plugin it = plugin2;
            boolean bl = false;
            AppCloudCapability migratableState = this.getState(plugin, appAggregatorResponse);
            return AppCloudCapability.yes == migratableState || AppCloudCapability.install_only == migratableState || AppCloudCapability.upgrade == migratableState;
        }
        return false;
    }

    @NotNull
    public final AppCloudCapability getState(@NotNull Plugin plugin, @NotNull AppAggregatorResponse appAggregatorResponse) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)appAggregatorResponse, (String)"appAggregatorResponse");
        boolean needsUpgrade = this.needsUpgrade(appAggregatorResponse, plugin);
        AppCloudCapability appCloudCapability = AppCloudCapability.fromMigrationPath((MigrationPath)appAggregatorResponse.getMigrationPath(), (boolean)needsUpgrade);
        Intrinsics.checkNotNullExpressionValue((Object)appCloudCapability, (String)"fromMigrationPath(...)");
        return appCloudCapability;
    }

    private final boolean needsUpgrade(AppAggregatorResponse appAggregatorResponse, Plugin plugin) {
        boolean needsUpgrade = false;
        try {
            boolean bl;
            Object object = appAggregatorResponse.getCloudMigrationAssistantCompatibility();
            if ((object == null || StringsKt.isBlank((CharSequence)object)) && ((object = (Collection)appAggregatorResponse.getCloudMigrationAssistantCompatibilityRangeList()) == null || object.isEmpty())) {
                bl = needsUpgrade;
            } else if (appAggregatorResponse.getCloudMigrationAssistantCompatibilityRangeList() != null && !((Collection)appAggregatorResponse.getCloudMigrationAssistantCompatibilityRangeList()).isEmpty()) {
                String string = plugin.getPluginInformation().getVersion();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersion(...)");
                bl = MigratabliltyInfo.Companion.needsUpgrade(string, appAggregatorResponse.getCloudMigrationAssistantCompatibilityRangeList());
            } else {
                bl = MigratabliltyInfo.Companion.needsUpgrade(plugin.getPluginInformation().getVersion(), appAggregatorResponse.getCloudMigrationAssistantCompatibility());
            }
            return bl;
        }
        catch (MigratabliltyInfo.MigrabilityVersionException ex) {
            needsUpgrade = true;
            Object[] objectArray = new Object[]{plugin.getPluginInformation().getVersion(), appAggregatorResponse.getCloudMigrationAssistantCompatibility(), appAggregatorResponse.getCloudMigrationAssistantCompatibilityRangeList(), ex};
            log.info("Failed to check if app needs upgrade pluginVersion={}, cloudMigrationAssistantCompatibility={}, cloudMigrationAssistantCompatibilityRanges={}", objectArray);
            return needsUpgrade;
        }
    }

    private final ConsentStatus getConsentStatus(AppAssessmentInfo appInfo, AppAggregatorResponse response2, Plugin plugin) {
        ConsentStatus consentStatus;
        Plugin plugin2 = plugin;
        Intrinsics.checkNotNull((Object)plugin2);
        switch (WhenMappings.$EnumSwitchMapping$1[this.getState(plugin2, response2).ordinal()]) {
            case 1: {
                consentStatus = ConsentStatus.ServerAppOutdated;
                break;
            }
            case 2: {
                consentStatus = ConsentStatus.NoMigrationNeeded;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                consentStatus = ConsentStatus.NoAutomatedMigrationPath;
                break;
            }
            case 6: {
                boolean updatedAccessScopes = this.isAccessScopesUpdated(appInfo);
                return !updatedAccessScopes ? ConsentStatus.ConsentOutdated : (AssessmentConsent.NotGiven == appInfo.getConsent() ? ConsentStatus.ConsentNotGiven : ConsentStatus.ConsentGiven);
            }
            default: {
                consentStatus = ConsentStatus.NoMigrationNeeded;
            }
        }
        return consentStatus;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final AppSummary buildAppSummary(Plugin plugin, Map<String, AppAssessmentInfo> assessedPlugins2, AppAggregatorResponse serverAppData) {
        boolean bl;
        String string;
        AppAggregatorResponse appAggregatorResponse;
        Map<String, AppAssessmentInfo> map = assessedPlugins2;
        AppAssessmentInfo appAssessmentInfo = map != null ? map.get(plugin.getKey()) : null;
        AppAssessmentStatus migrationStatus = null;
        String migrationNotes = null;
        String alternativeAppKey = null;
        if (appAssessmentInfo != null) {
            migrationStatus = appAssessmentInfo.getMigrationStatus();
            migrationNotes = appAssessmentInfo.getMigrationNotes();
            alternativeAppKey = appAssessmentInfo.getAlternativeAppKey();
        }
        if ((appAggregatorResponse = serverAppData) == null) {
            String string2 = plugin.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getKey(...)");
            appAggregatorResponse = this.appAggregatorClient.getServerAppData(string2);
        }
        AppAggregatorResponse appAggregatorResponse2 = appAggregatorResponse;
        AppCloudCapability migratableState = this.getState(plugin, appAggregatorResponse2);
        String string3 = plugin.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getKey(...)");
        String string4 = this.appUsageCheckService.getAppUsageInsightsPath(string3);
        if (string4 != null) {
            String appUsageInsightPath = string4;
            boolean bl2 = false;
            string = Constants.buildPageUrl$default(Constants.INSTANCE, appUsageInsightPath, null, 2, null);
        } else {
            string = null;
        }
        String appUsageInsightsUrl = string;
        String string5 = plugin.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getKey(...)");
        String string6 = plugin.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getName(...)");
        String string7 = appAggregatorResponse2.getIcon();
        boolean bl3 = PluginManager.Companion.isPluginEnabled(plugin);
        boolean bl4 = appAggregatorResponse2.getHasCloud();
        String string8 = appAggregatorResponse2.getCloudUrl();
        String string9 = plugin.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getKey(...)");
        String string10 = (String)CollectionsKt.first((Iterable)this.migratabliltyInfo.getCloudAppKeys(string9, appAggregatorResponse2.getCloudKey()));
        String string11 = TrivalentState.Companion.mapFeatureDifferenceState(appAggregatorResponse2.getFeatureDifference());
        String string12 = appAggregatorResponse2.getFeatureDifferenceUrl();
        String string13 = migratableState.toString();
        String string14 = appAggregatorResponse2.getMigrationPathInstructions();
        String string15 = appAggregatorResponse2.getContactSupport();
        AppAssessmentStatus appAssessmentStatus = Optional.ofNullable(migrationStatus).orElse(AppAssessmentStatus.Unassigned);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)appAssessmentStatus), (String)"orElse(...)");
        String string16 = Optional.ofNullable(migrationNotes).orElse(EMPTY_STRING);
        Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"orElse(...)");
        String string17 = Optional.ofNullable(alternativeAppKey).orElse(EMPTY_STRING);
        Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"orElse(...)");
        String string18 = Constants.buildPageUrl$default(Constants.INSTANCE, UPM_MANAGE_URL, null, 2, null);
        String string19 = plugin.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string19, (String)"getKey(...)");
        ReliabilityState reliabilityState = this.getReliabilityState(string19, migratableState);
        String string20 = reliabilityState != null ? reliabilityState.toString() : null;
        String string21 = appAggregatorResponse2.getMigrationRoadmapRequest();
        String string22 = plugin.getPluginInformation().getVendorName();
        Intrinsics.checkNotNullExpressionValue((Object)string22, (String)"getVendorName(...)");
        String string23 = appAggregatorResponse2.getCloudVersionDevelopmentRoadmap();
        if (this.migrationFeatures.getAppDataPreloadEnabledGA()) {
            String string24 = plugin.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string24, (String)"getKey(...)");
            if (this.cloudMigrationRegistrar.isPreloadable(string24)) {
                bl = true;
                return new AppSummary(string5, string6, string7, bl3, bl4, string8, string10, string11, string12, string13, string14, string15, appAssessmentStatus, string16, string17, string18, string20, string21, string22, appUsageInsightsUrl, string23, bl);
            }
        }
        bl = false;
        return new AppSummary(string5, string6, string7, bl3, bl4, string8, string10, string11, string12, string13, string14, string15, appAssessmentStatus, string16, string17, string18, string20, string21, string22, appUsageInsightsUrl, string23, bl);
    }

    static /* synthetic */ AppSummary buildAppSummary$default(AppAssessmentService appAssessmentService, Plugin plugin, Map map, AppAggregatorResponse appAggregatorResponse, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        if ((n & 4) != 0) {
            appAggregatorResponse = null;
        }
        return appAssessmentService.buildAppSummary(plugin, map, appAggregatorResponse);
    }

    @VisibleForTesting
    @Nullable
    public final ReliabilityState getReliabilityState(@NotNull String pluginKey, @NotNull AppCloudCapability migratableState) {
        Intrinsics.checkNotNullParameter((Object)pluginKey, (String)"pluginKey");
        Intrinsics.checkNotNullParameter((Object)migratableState, (String)"migratableState");
        this.appAggregatorClient.validateAndReloadReliableList();
        if (AppCloudCapability.yes != migratableState && AppCloudCapability.install_only != migratableState) {
            return null;
        }
        if (this.appAggregatorClient.isAppReliable(pluginKey)) {
            return ReliabilityState.BETA;
        }
        return ReliabilityState.ALPHA;
    }

    private final boolean isAccessScopesUpdated(AppAssessmentInfo appInfo) {
        return Intrinsics.areEqual(this.appAssessmentRepository.getOrDefault(appInfo.getAppKey()).getAccessScopes(), (Object)this.cloudMigrationRegistrar.getAccessScopesByApp(appInfo.getAppKey()));
    }

    private final Set<AccessScope> getAccessScopesDeclaredByApp(String appKey) {
        return this.cloudMigrationRegistrar.getAccessScopesByApp(appKey);
    }

    private final Set<AccessScope> getSavedAccessScopes(String appKey) {
        return this.getAppAssessmentInfoByAppKey(appKey).get().getAccessScopes();
    }

    private final CloudAppDto buildCloudAppDto(AppCloudSiteInfo amsAppData, String cloudUrl, AppAggregatorResponse maaAppData) {
        return new CloudAppDto(amsAppData.getKey(), AppAssessmentServiceKt.getAppName(maaAppData, this.pluginManager.getPlugin(amsAppData.getKey()), amsAppData.getKey()), maaAppData.getIcon(), maaAppData.getCloudUrl(), this.buildCloudAppInstallationUrl(cloudUrl, maaAppData.getRelativeCloudAppInstallUrl()), maaAppData.getPrivacyPolicyUrl(), maaAppData.getContactSupport(), amsAppData.getInstalled());
    }

    private final String buildCloudAppInstallationUrl(String siteUrl, String relativeAppInstallUrl) {
        String string;
        String string2 = relativeAppInstallUrl;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = siteUrl + '/' + it;
        } else {
            string = null;
        }
        return string;
    }

    private static final CloudAppDto getCloudAppsInfo$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CloudAppDto)$tmp0.invoke(p0);
    }

    private static final String getAppSummaries$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final Collection fetchAppsThatWouldBeMigratedToCloud$lambda$18(AppAssessmentService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.appAssessmentRepository.findAppsNeededInCloud();
    }

    public static final /* synthetic */ Set access$getAccessScopesDeclaredByApp(AppAssessmentService $this, String appKey) {
        return $this.getAccessScopesDeclaredByApp(appKey);
    }

    public static final /* synthetic */ CloudAppDto access$buildCloudAppDto(AppAssessmentService $this, AppCloudSiteInfo amsAppData, String cloudUrl, AppAggregatorResponse maaAppData) {
        return $this.buildCloudAppDto(amsAppData, cloudUrl, maaAppData);
    }

    public static final /* synthetic */ AppAggregatorClient access$getAppAggregatorClient$p(AppAssessmentService $this) {
        return $this.appAggregatorClient;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/assessment/AppAssessmentService$Companion;", "", "()V", "APPS_NEEDED_IN_CLOUD_CACHE_KEY", "", "APPS_NEEDED_IN_CLOUD_CACHE_NAME", "getAPPS_NEEDED_IN_CLOUD_CACHE_NAME$annotations", "getAPPS_NEEDED_IN_CLOUD_CACHE_NAME", "()Ljava/lang/String;", "CACHE_EXPIRY_TIME_IN_DAYS", "", "EMPTY_STRING", "UPM_MANAGE_URL", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getAPPS_NEEDED_IN_CLOUD_CACHE_NAME() {
            return APPS_NEEDED_IN_CLOUD_CACHE_NAME;
        }

        @VisibleForTesting
        public static /* synthetic */ void getAPPS_NEEDED_IN_CLOUD_CACHE_NAME$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ConsentStatus.values().length];
            try {
                nArray[ConsentStatus.ConsentGiven.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConsentStatus.ConsentNotGiven.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConsentStatus.ConsentOutdated.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConsentStatus.ServerAppOutdated.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConsentStatus.NoMigrationNeeded.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConsentStatus.NoMigratingAlternative.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConsentStatus.NoAutomatedMigrationPath.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AppCloudCapability.values().length];
            try {
                nArray[AppCloudCapability.upgrade.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppCloudCapability.install_only.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppCloudCapability.no.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppCloudCapability.unknown.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppCloudCapability.manual.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppCloudCapability.yes.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

