/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.assessment;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.jira.migration.analytics.AnalyticsEventService;
import com.atlassian.jira.migration.assessment.AppAggregatorClient;
import com.atlassian.jira.migration.assessment.AppUsageCheckResponse;
import com.atlassian.jira.migration.assessment.AppUsagePromptResponse;
import com.atlassian.jira.migration.assessment.PluginManager;
import com.atlassian.jira.migration.sen.SENSupplier;
import com.atlassian.jira.migration.version.JiraMigrationVersionService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.Plugin;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/atlassian/jira/migration/assessment/AppUsageCheckService;", "", "jiraAuthenticationContext", "Lcom/atlassian/jira/security/JiraAuthenticationContext;", "jiraMigrationVersionService", "Lcom/atlassian/jira/migration/version/JiraMigrationVersionService;", "pluginManager", "Lcom/atlassian/jira/migration/assessment/PluginManager;", "senSupplier", "Lcom/atlassian/jira/migration/sen/SENSupplier;", "appAggregatorClient", "Lcom/atlassian/jira/migration/assessment/AppAggregatorClient;", "analyticsEventService", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;", "(Lcom/atlassian/jira/security/JiraAuthenticationContext;Lcom/atlassian/jira/migration/version/JiraMigrationVersionService;Lcom/atlassian/jira/migration/assessment/PluginManager;Lcom/atlassian/jira/migration/sen/SENSupplier;Lcom/atlassian/jira/migration/assessment/AppAggregatorClient;Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getAppUsageAvailability", "Lcom/atlassian/jira/migration/assessment/AppUsagePromptResponse;", "getAppUsageInsightsPath", "", "appKey", "sendAppUsageAvailabilityCheckAnalytics", "appUsageCheckResponse", "Lcom/atlassian/jira/migration/assessment/AppUsageCheckResponse;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppUsageCheckService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppUsageCheckService.kt\ncom/atlassian/jira/migration/assessment/AppUsageCheckService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public final class AppUsageCheckService {
    @NotNull
    private final JiraAuthenticationContext jiraAuthenticationContext;
    @NotNull
    private final JiraMigrationVersionService jiraMigrationVersionService;
    @NotNull
    private final PluginManager pluginManager;
    @NotNull
    private final SENSupplier senSupplier;
    @NotNull
    private final AppAggregatorClient appAggregatorClient;
    @NotNull
    private final AnalyticsEventService analyticsEventService;
    private final Logger log;

    @Inject
    public AppUsageCheckService(@NotNull JiraAuthenticationContext jiraAuthenticationContext, @NotNull JiraMigrationVersionService jiraMigrationVersionService, @NotNull PluginManager pluginManager, @NotNull SENSupplier senSupplier, @NotNull AppAggregatorClient appAggregatorClient, @NotNull AnalyticsEventService analyticsEventService) {
        Intrinsics.checkNotNullParameter((Object)jiraAuthenticationContext, (String)"jiraAuthenticationContext");
        Intrinsics.checkNotNullParameter((Object)jiraMigrationVersionService, (String)"jiraMigrationVersionService");
        Intrinsics.checkNotNullParameter((Object)pluginManager, (String)"pluginManager");
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        Intrinsics.checkNotNullParameter((Object)appAggregatorClient, (String)"appAggregatorClient");
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.jiraMigrationVersionService = jiraMigrationVersionService;
        this.pluginManager = pluginManager;
        this.senSupplier = senSupplier;
        this.appAggregatorClient = appAggregatorClient;
        this.analyticsEventService = analyticsEventService;
        this.log = LoggerFactory.getLogger(AppUsageCheckService.class);
    }

    @NotNull
    public final AppUsagePromptResponse getAppUsageAvailability() {
        String hosting = this.senSupplier.getHosting().getValue();
        AppUsageCheckResponse appUsageCheckResponse = this.appAggregatorClient.getAppUsageAvailability("jira", hosting, this.jiraMigrationVersionService.getJiraServerVersion());
        this.sendAppUsageAvailabilityCheckAnalytics(appUsageCheckResponse);
        AppUsagePromptResponse appUsagePromptResponse = new AppUsagePromptResponse(false, null, null, null, 14, null);
        if (appUsageCheckResponse.getAppKey() != null && this.pluginManager.getPlugin(appUsageCheckResponse.getAppKey()) == null) {
            appUsagePromptResponse = appUsageCheckResponse.getAppUsageAvailable() ? new AppUsagePromptResponse(true, true, appUsageCheckResponse.getSearchPath(), appUsageCheckResponse.getPromptFrequencySeconds()) : new AppUsagePromptResponse(true, false, null, appUsageCheckResponse.getPromptFrequencySeconds(), 4, null);
        }
        return appUsagePromptResponse;
    }

    @Nullable
    public final String getAppUsageInsightsPath(@NotNull String appKey) {
        String appUsageInsightsPath;
        block1: {
            Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
            appUsageInsightsPath = null;
            String hosting = this.senSupplier.getHosting().getValue();
            AppUsageCheckResponse appUsageCheckResponse = this.appAggregatorClient.getAppUsageAvailability("jira", hosting, this.jiraMigrationVersionService.getJiraServerVersion());
            String string = appUsageCheckResponse.getAppKey();
            if (string == null) break block1;
            String it = string;
            boolean bl = false;
            Plugin appUsagePlugin = this.pluginManager.getPlugin(appUsageCheckResponse.getAppKey());
            if (appUsagePlugin != null && PluginManager.Companion.isPluginEnabled(appUsagePlugin)) {
                String string2 = appUsageCheckResponse.getAppUsageInsightsPath();
                Intrinsics.checkNotNull((Object)string2);
                String string3 = string2;
                Object[] objectArray = new Object[]{appKey};
                String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                appUsageInsightsPath = string4;
            }
        }
        return appUsageInsightsPath;
    }

    private final Object sendAppUsageAvailabilityCheckAnalytics(AppUsageCheckResponse appUsageCheckResponse) {
        Object object;
        try {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"appUsageAvailable", (Object)appUsageCheckResponse.getAppUsageAvailable()), TuplesKt.to((Object)"productFamily", (Object)"jira"), TuplesKt.to((Object)"productVersion", (Object)this.jiraMigrationVersionService.getJiraServerVersion()), TuplesKt.to((Object)"hosting", (Object)this.senSupplier.getHosting().getValue())};
            Map attributes = MapsKt.mutableMapOf((Pair[])pairArray);
            if (appUsageCheckResponse.getAppKey() != null) {
                boolean bl;
                Plugin plugin = this.pluginManager.getPlugin(appUsageCheckResponse.getAppKey());
                Map map = attributes;
                Pair[] pairArray2 = new Pair[5];
                pairArray2[0] = TuplesKt.to((Object)"appUsagePluginInstalled", (Object)(plugin != null ? 1 : 0));
                Pair[] pairArray3 = pairArray2;
                int n = 1;
                String string = "appUsagePluginEnabled";
                Plugin plugin2 = plugin;
                if (plugin2 != null) {
                    Plugin plugin3 = plugin2;
                    String string2 = string;
                    int n2 = n;
                    Pair[] pairArray4 = pairArray3;
                    Map map2 = map;
                    boolean bl2 = false;
                    boolean bl3 = PluginManager.Companion.isPluginEnabled(plugin);
                    map = map2;
                    pairArray3 = pairArray4;
                    n = n2;
                    string = string2;
                    bl = bl3;
                } else {
                    bl = false;
                }
                pairArray3[n] = TuplesKt.to((Object)string, (Object)bl);
                Plugin plugin4 = plugin;
                pairArray2[2] = TuplesKt.to((Object)"appUsagePluginVersion", plugin4 != null && (plugin4 = plugin4.getPluginInformation()) != null ? plugin4.getVersion() : null);
                Object object2 = plugin;
                pairArray2[3] = TuplesKt.to((Object)"appUsagePluginInstalledTimeStamp", object2 != null && (object2 = object2.getDateInstalled()) != null ? Long.valueOf(((Date)object2).getTime()) : null);
                Object object3 = plugin;
                pairArray2[4] = TuplesKt.to((Object)"appUsagePluginEnabledTimeStamp", object3 != null && (object3 = object3.getDateEnabled()) != null ? Long.valueOf(((Date)object3).getTime()) : null);
                map.putAll(MapsKt.mapOf((Pair[])pairArray2));
            }
            GenericOperationalEvent event = ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(Instant.now().toEpochMilli()).source("appUsagePromptModal")).actionSubject("appUsagePluginAvailabilityCheck")).action("executed")).sen(this.senSupplier.getFirstSen())).withAttributes(attributes)).build();
            Intrinsics.checkNotNull((Object)event);
            object = this.analyticsEventService.saveAnalyticsEvent((EventDto)event, this.jiraAuthenticationContext.getLoggedInUser().getEmailAddress());
        }
        catch (Exception ex) {
            this.log.warn("Unable to send app usage prompt analytics : " + ex.getMessage());
            object = Unit.INSTANCE;
        }
        return object;
    }
}

