/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.assessment;

import com.atlassian.jira.migration.MigrationServicesConfiguration;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.guardrails.AssessmentZipOutputStreamResult;
import com.atlassian.jira.migration.guardrails.CloudJobType;
import com.atlassian.jira.migration.guardrails.InstanceAssessmentZipExporter;
import com.atlassian.jira.migration.guardrails.rest.CloudRequestServiceProviderLocal;
import com.atlassian.jira.migration.utils.UuidProvider;
import com.atlassian.plugins.cloud.connect.companion.client.CloudContext;
import com.atlassian.plugins.cloud.connect.companion.client.CloudObjectMapper;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequest;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestMethod;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestService;
import com.atlassian.plugins.cloud.connect.companion.client.CloudResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0016H\u0002J(\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u0002J*\u0010%\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001a2\u0018\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0'H\u0002J\u0006\u0010*\u001a\u00020\u0018J&\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020/2\u0006\u0010\u001d\u001a\u00020\u001aJ\u001e\u00100\u001a\u00020\u00182\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00140\u001c2\u0006\u00102\u001a\u000203H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/atlassian/jira/migration/assessment/InstanceAssessmentUploadService;", "", "instanceAssessmentZipExporter", "Lcom/atlassian/jira/migration/guardrails/InstanceAssessmentZipExporter;", "cloudRequestServiceProvider", "Lcom/atlassian/jira/migration/guardrails/rest/CloudRequestServiceProviderLocal;", "migrationServicesConfiguration", "Lcom/atlassian/jira/migration/MigrationServicesConfiguration;", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "uuidProvider", "Lcom/atlassian/jira/migration/utils/UuidProvider;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/guardrails/InstanceAssessmentZipExporter;Lcom/atlassian/jira/migration/guardrails/rest/CloudRequestServiceProviderLocal;Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/utils/UuidProvider;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "createZipDate", "", "createZipFile", "Ljava/nio/file/Path;", "failInCloud", "", "jobType", "Lcom/atlassian/jira/migration/guardrails/CloudJobType;", "sendFinishAssessmentRequest", "Lcom/atlassian/plugins/cloud/connect/companion/client/CloudResponse;", "cloudJobType", "zipPath", "sendRequestToCloudService", "url", "Ljava/net/URL;", "method", "Lcom/atlassian/plugins/cloud/connect/companion/client/CloudRequestMethod;", "body", "upload", "zipCreator", "Lkotlin/Function2;", "Ljava/io/OutputStream;", "Lcom/atlassian/jira/migration/guardrails/AssessmentZipOutputStreamResult;", "uploadAssessmentZip", "uploadDiscoverZip", "jobId", "queryId", "startTimestamp", "", "validateResponse", "cloudResponse", "expectedStatus", "", "jira-migration-plugin"})
public final class InstanceAssessmentUploadService {
    @NotNull
    private final InstanceAssessmentZipExporter instanceAssessmentZipExporter;
    @NotNull
    private final CloudRequestServiceProviderLocal cloudRequestServiceProvider;
    @NotNull
    private final MigrationServicesConfiguration migrationServicesConfiguration;
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final UuidProvider uuidProvider;
    @NotNull
    private final ObjectMapper objectMapper;

    @Inject
    public InstanceAssessmentUploadService(@NotNull InstanceAssessmentZipExporter instanceAssessmentZipExporter, @NotNull CloudRequestServiceProviderLocal cloudRequestServiceProvider, @NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull LocalFileDataOutput localFileDataOutput, @NotNull UuidProvider uuidProvider, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)instanceAssessmentZipExporter, (String)"instanceAssessmentZipExporter");
        Intrinsics.checkNotNullParameter((Object)cloudRequestServiceProvider, (String)"cloudRequestServiceProvider");
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)uuidProvider, (String)"uuidProvider");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.instanceAssessmentZipExporter = instanceAssessmentZipExporter;
        this.cloudRequestServiceProvider = cloudRequestServiceProvider;
        this.migrationServicesConfiguration = migrationServicesConfiguration;
        this.localFileDataOutput = localFileDataOutput;
        this.uuidProvider = uuidProvider;
        this.objectMapper = objectMapperFactory.createObjectMapper();
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public final void failInCloud(@NotNull CloudJobType jobType) {
        Intrinsics.checkNotNullParameter((Object)((Object)jobType), (String)"jobType");
        CloudResponse cloudResponse = InstanceAssessmentUploadService.sendFinishAssessmentRequest$default(this, jobType, null, 2, null);
        this.validateResponse((CloudResponse<String>)cloudResponse, 200);
    }

    public final void uploadAssessmentZip() {
        this.upload(CloudJobType.ASSESSMENT, (Function2<? super String, ? super OutputStream, ? extends AssessmentZipOutputStreamResult>)((Function2)new Function2<String, OutputStream, AssessmentZipOutputStreamResult>((Object)this.instanceAssessmentZipExporter){

            @NotNull
            public final AssessmentZipOutputStreamResult invoke(@NotNull String p0, @NotNull OutputStream p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((InstanceAssessmentZipExporter)this.receiver).export(p0, p1);
            }
        }));
    }

    public final void uploadDiscoverZip(@NotNull String jobId, @NotNull String queryId, long startTimestamp, @NotNull CloudJobType cloudJobType) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        Intrinsics.checkNotNullParameter((Object)queryId, (String)"queryId");
        Intrinsics.checkNotNullParameter((Object)((Object)cloudJobType), (String)"cloudJobType");
        this.upload(cloudJobType, (Function2<? super String, ? super OutputStream, ? extends AssessmentZipOutputStreamResult>)((Function2)new Function2<String, OutputStream, AssessmentZipOutputStreamResult>(this, jobId, queryId, startTimestamp){
            final /* synthetic */ InstanceAssessmentUploadService this$0;
            final /* synthetic */ String $jobId;
            final /* synthetic */ String $queryId;
            final /* synthetic */ long $startTimestamp;
            {
                this.this$0 = $receiver;
                this.$jobId = $jobId;
                this.$queryId = $queryId;
                this.$startTimestamp = $startTimestamp;
                super(2);
            }

            @NotNull
            public final AssessmentZipOutputStreamResult invoke(@NotNull String date, @NotNull OutputStream output) {
                Intrinsics.checkNotNullParameter((Object)date, (String)"date");
                Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                return InstanceAssessmentUploadService.access$getInstanceAssessmentZipExporter$p(this.this$0).exportDiscover(this.$jobId, this.$queryId, this.$startTimestamp, date, output);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void upload(CloudJobType cloudJobType, Function2<? super String, ? super OutputStream, ? extends AssessmentZipOutputStreamResult> zipCreator) {
        Path zipPath = this.createZipFile();
        try {
            Closeable closeable = new FileOutputStream(zipPath.toFile());
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)closeable;
                boolean bl = false;
                AssessmentZipOutputStreamResult result2 = (AssessmentZipOutputStreamResult)zipCreator.invoke((Object)this.createZipDate(), (Object)it);
                if (result2 instanceof AssessmentZipOutputStreamResult.Failed) {
                    throw new WebApplicationException(((AssessmentZipOutputStreamResult.Failed)result2).getError());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            CloudResponse<String> cloudResponse = this.sendFinishAssessmentRequest(cloudJobType, zipPath);
            this.validateResponse(cloudResponse, 202);
        }
        finally {
            Files.deleteIfExists(zipPath);
        }
    }

    private final Path createZipFile() {
        Path zipPath = this.localFileDataOutput.temporaryFilesDirectory().resolve("assessment-" + this.uuidProvider.get());
        Files.createDirectories(zipPath.getParent(), new FileAttribute[0]);
        Files.createFile(zipPath, new FileAttribute[0]);
        Intrinsics.checkNotNull((Object)zipPath);
        return zipPath;
    }

    private final CloudResponse<String> sendFinishAssessmentRequest(CloudJobType cloudJobType, Path zipPath) {
        Object[] objectArray = new Object[]{cloudJobType.name()};
        URL url = UriBuilder.fromUri((URI)this.migrationServicesConfiguration.getPortfolioAnalyzerServiceBaseURI()).path("l1-assessments").queryParam("jobType", objectArray).build(new Object[0]).toURL();
        Intrinsics.checkNotNull((Object)url);
        Path path = zipPath;
        return this.sendRequestToCloudService(url, CloudRequestMethod.PUT, path != null ? path.toFile() : null);
    }

    static /* synthetic */ CloudResponse sendFinishAssessmentRequest$default(InstanceAssessmentUploadService instanceAssessmentUploadService, CloudJobType cloudJobType, Path path, int n, Object object) {
        if ((n & 2) != 0) {
            path = null;
        }
        return instanceAssessmentUploadService.sendFinishAssessmentRequest(cloudJobType, path);
    }

    private final CloudResponse<String> sendRequestToCloudService(URL url, CloudRequestMethod method, Object body) {
        CloudRequestService cloudRequestService = this.cloudRequestServiceProvider.getCloudRequestService();
        CloudRequest.HeaderCollector request = CloudRequest.builder((Object)body).method(method).url(url).cloudContext(CloudContext.defaultContext());
        if (body instanceof File) {
            request.header("Content-Type", "multipart/form-data");
        }
        CloudResponse cloudResponse = cloudRequestService.sendRequest(request.build(), String.class, new CloudObjectMapper(this){
            final /* synthetic */ InstanceAssessmentUploadService this$0;
            {
                this.this$0 = $receiver;
            }

            public <T> T readValue(@Nullable byte[] p0, @Nullable Class<T> p1) {
                return (T)this.this$0.getObjectMapper().readValue(p0, p1);
            }

            @NotNull
            public byte[] writeValueAsBytes(@Nullable Object p0) {
                byte[] byArray = this.this$0.getObjectMapper().writeValueAsBytes(p0);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"writeValueAsBytes(...)");
                return byArray;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)cloudResponse, (String)"sendRequest(...)");
        return cloudResponse;
    }

    private final void validateResponse(CloudResponse<String> cloudResponse, int expectedStatus) {
        if (cloudResponse.getStatusCode() != expectedStatus) {
            throw new WebApplicationException(Response.status((int)cloudResponse.getStatusCode()).entity(cloudResponse.getBody()).build());
        }
    }

    private final String createZipDate() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String string = formatter.format(LocalDateTime.now());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    public static final /* synthetic */ InstanceAssessmentZipExporter access$getInstanceAssessmentZipExporter$p(InstanceAssessmentUploadService $this) {
        return $this.instanceAssessmentZipExporter;
    }
}

