/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.assessment;

import com.atlassian.jira.migration.assessment.AppAggregatorClient;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0010\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/assessment/PluginManager;", "", "pluginAccessor", "Lcom/atlassian/plugin/PluginAccessor;", "pluginMetadataManager", "Lcom/atlassian/plugin/metadata/PluginMetadataManager;", "appAggregatorClient", "Lcom/atlassian/jira/migration/assessment/AppAggregatorClient;", "(Lcom/atlassian/plugin/PluginAccessor;Lcom/atlassian/plugin/metadata/PluginMetadataManager;Lcom/atlassian/jira/migration/assessment/AppAggregatorClient;)V", "getEligibleAppsForAssessment", "", "Lcom/atlassian/plugin/Plugin;", "getPlugin", "appKey", "", "isEligibleAppForAssessment", "", "plugin", "Companion", "jira-migration-plugin"})
public final class PluginManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PluginAccessor pluginAccessor;
    @NotNull
    private final PluginMetadataManager pluginMetadataManager;
    @NotNull
    private final AppAggregatorClient appAggregatorClient;

    @Inject
    public PluginManager(@NotNull PluginAccessor pluginAccessor, @NotNull PluginMetadataManager pluginMetadataManager, @NotNull AppAggregatorClient appAggregatorClient) {
        Intrinsics.checkNotNullParameter((Object)pluginAccessor, (String)"pluginAccessor");
        Intrinsics.checkNotNullParameter((Object)pluginMetadataManager, (String)"pluginMetadataManager");
        Intrinsics.checkNotNullParameter((Object)appAggregatorClient, (String)"appAggregatorClient");
        this.pluginAccessor = pluginAccessor;
        this.pluginMetadataManager = pluginMetadataManager;
        this.appAggregatorClient = appAggregatorClient;
    }

    @NotNull
    public final List<Plugin> getEligibleAppsForAssessment() {
        this.appAggregatorClient.validateAndReloadBlacklist();
        List<Plugin> list = this.pluginAccessor.getPlugins().parallelStream().filter(arg_0 -> PluginManager.getEligibleAppsForAssessment$lambda$0((Function1)new Function1<Plugin, Boolean>((Object)this.pluginMetadataManager){

            @NotNull
            public final Boolean invoke(Plugin p0) {
                return ((PluginMetadataManager)this.receiver).isUserInstalled(p0);
            }
        }, arg_0)).filter(arg_0 -> PluginManager.getEligibleAppsForAssessment$lambda$1((Function1)new Function1<Plugin, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull Plugin p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return PluginManager.access$isEligibleAppForAssessment((PluginManager)this.receiver, p0);
            }
        }, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
        return list;
    }

    @Nullable
    public final Plugin getPlugin(@NotNull String appKey) {
        Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
        return this.pluginAccessor.getPlugin(appKey);
    }

    private final boolean isEligibleAppForAssessment(Plugin plugin) {
        boolean bl;
        String string = plugin.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        if (this.appAggregatorClient.isBlacklisted(string)) {
            bl = false;
        } else if (!PluginManager.Companion.isAtlassianReserved(plugin)) {
            bl = true;
        } else {
            String string2 = plugin.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getKey(...)");
            Integer n = this.appAggregatorClient.getServerAppData(string2).getAggregatorHttpErrorCode();
            int n2 = 404;
            bl = n == null || n != n2;
        }
        return bl;
    }

    private static final boolean getEligibleAppsForAssessment$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getEligibleAppsForAssessment$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isEligibleAppForAssessment(PluginManager $this, Plugin plugin) {
        return $this.isEligibleAppForAssessment(plugin);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/assessment/PluginManager$Companion;", "", "()V", "isAtlassianReserved", "", "plugin", "Lcom/atlassian/plugin/Plugin;", "isPluginEnabled", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isPluginEnabled(@NotNull Plugin plugin) {
            Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
            return PluginState.ENABLED == plugin.getPluginState();
        }

        private final boolean isAtlassianReserved(Plugin plugin) {
            boolean bl;
            if (StringsKt.equals((String)plugin.getPluginInformation().getVendorName(), (String)"atlassian", (boolean)true)) {
                bl = true;
            } else {
                String string = plugin.getPluginInformation().getVendorUrl();
                bl = string != null ? StringsKt.contains((CharSequence)string, (CharSequence)"atlassian.com", (boolean)true) : false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

