/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.assessment.rest;

import com.atlassian.jira.migration.assessment.AppAssessmentService;
import com.atlassian.jira.migration.assessment.AppListResponse;
import com.atlassian.jira.migration.assessment.AppUsageCheckService;
import com.atlassian.jira.migration.assessment.CloudAppsInfoRequest;
import com.atlassian.jira.migration.assessment.ConsentRequestDto;
import com.atlassian.jira.migration.assessment.UpdateAllAppAssessmentRequest;
import com.atlassian.jira.migration.assessment.UpdateAppAssessmentRequest;
import com.atlassian.jira.migration.consent.AppConsentService;
import com.atlassian.jira.migration.infrastructure.rest.ResponseUtils;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.Collection;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Path(value="app")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\nH\u0007J\b\u0010\f\u001a\u00020\nH\u0007J\b\u0010\r\u001a\u00020\nH\u0007J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\b\u0010\u0011\u001a\u00020\nH\u0007J\b\u0010\u0012\u001a\u00020\nH\u0007J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0019H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/assessment/rest/AppAssessmentResource;", "", "appAssessmentService", "Lcom/atlassian/jira/migration/assessment/AppAssessmentService;", "appConsentService", "Lcom/atlassian/jira/migration/consent/AppConsentService;", "appUsageCheckService", "Lcom/atlassian/jira/migration/assessment/AppUsageCheckService;", "(Lcom/atlassian/jira/migration/assessment/AppAssessmentService;Lcom/atlassian/jira/migration/consent/AppConsentService;Lcom/atlassian/jira/migration/assessment/AppUsageCheckService;)V", "getAppAssessments", "Ljavax/ws/rs/core/Response;", "getAppUsageAvailability", "getAppsNeededInCloud", "getAppsWithConsentStatus", "getCloudAppsInfo", "request", "Lcom/atlassian/jira/migration/assessment/CloudAppsInfoRequest;", "getPluginStats", "getSharedConsentForMarketplacePartners", "saveSharedConsentForMarketplacePartners", "consentRequestDto", "Lcom/atlassian/jira/migration/assessment/ConsentRequestDto;", "updateAllppAssessments", "Lcom/atlassian/jira/migration/assessment/UpdateAllAppAssessmentRequest;", "updateAppAssessments", "Lcom/atlassian/jira/migration/assessment/UpdateAppAssessmentRequest;", "updateAppConsent", "jira-migration-plugin"})
public final class AppAssessmentResource {
    @NotNull
    private final AppAssessmentService appAssessmentService;
    @NotNull
    private final AppConsentService appConsentService;
    @NotNull
    private final AppUsageCheckService appUsageCheckService;

    @Inject
    public AppAssessmentResource(@NotNull AppAssessmentService appAssessmentService, @NotNull AppConsentService appConsentService, @NotNull AppUsageCheckService appUsageCheckService) {
        Intrinsics.checkNotNullParameter((Object)appAssessmentService, (String)"appAssessmentService");
        Intrinsics.checkNotNullParameter((Object)appConsentService, (String)"appConsentService");
        Intrinsics.checkNotNullParameter((Object)appUsageCheckService, (String)"appUsageCheckService");
        this.appAssessmentService = appAssessmentService;
        this.appConsentService = appConsentService;
        this.appUsageCheckService = appUsageCheckService;
    }

    @GET
    @Path(value="/")
    @NotNull
    public final Response getAppAssessments() {
        return ResponseUtils.INSTANCE.ok(this.appAssessmentService.getAppsAssessment());
    }

    @GET
    @Path(value="/stats")
    @NotNull
    public final Response getPluginStats() {
        return ResponseUtils.INSTANCE.ok(this.appAssessmentService.getPluginStats());
    }

    @GET
    @Path(value="/list/neededInCloud")
    @NotNull
    public final Response getAppsNeededInCloud() {
        return ResponseUtils.INSTANCE.ok(this.appAssessmentService.getAppsNeededInCloud());
    }

    @POST
    @Path(value="/update")
    @NotNull
    public final Response updateAppAssessments(@NotNull UpdateAppAssessmentRequest request) {
        Response response2;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            this.appAssessmentService.updateAppAssessment(request);
            response2 = ResponseUtils.INSTANCE.ok("Updated successfully");
        }
        catch (IllegalArgumentException exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "";
            }
            response2 = ResponseUtils.INSTANCE.badRequest(string);
        }
        return response2;
    }

    @POST
    @Path(value="/update/all")
    @NotNull
    public final Response updateAllppAssessments(@NotNull UpdateAllAppAssessmentRequest request) {
        Response response2;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            this.appAssessmentService.updateAllAppAssessment(request);
            response2 = ResponseUtils.INSTANCE.ok("Updated successfully");
        }
        catch (IllegalArgumentException exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "";
            }
            response2 = ResponseUtils.INSTANCE.badRequest(string);
        }
        return response2;
    }

    @POST
    @Path(value="/siteinfo")
    @NotNull
    public final Response getCloudAppsInfo(@NotNull CloudAppsInfoRequest request) {
        Response response2;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            response2 = ResponseUtils.INSTANCE.ok(this.appAssessmentService.getCloudAppsInfo(request));
        }
        catch (IllegalArgumentException exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "";
            }
            response2 = ResponseUtils.INSTANCE.badRequest(string);
        }
        return response2;
    }

    @POST
    @Path(value="/consent/update")
    @NotNull
    public final Response updateAppConsent(@NotNull UpdateAppAssessmentRequest request) {
        Response response2;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            response2 = ResponseUtils.INSTANCE.ok(this.appAssessmentService.updateAppConsent(request));
        }
        catch (IllegalArgumentException exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "";
            }
            response2 = ResponseUtils.INSTANCE.badRequest(string);
        }
        return response2;
    }

    @GET
    @Path(value="/consent")
    @NotNull
    public final Response getAppsWithConsentStatus() {
        return ResponseUtils.INSTANCE.ok(new AppListResponse((Collection)this.appAssessmentService.getAllAppsNeedingConsent()));
    }

    @GET
    @Path(value="/consent/allowAppMigrationsDataShare")
    @NotNull
    public final Response getSharedConsentForMarketplacePartners() {
        return ResponseUtils.INSTANCE.ok(this.appConsentService.getSharedConsentForMarketplacePartners());
    }

    @PUT
    @Path(value="/consent/allowAppMigrationsDataShare")
    @NotNull
    public final Response saveSharedConsentForMarketplacePartners(@NotNull ConsentRequestDto consentRequestDto) {
        Intrinsics.checkNotNullParameter((Object)consentRequestDto, (String)"consentRequestDto");
        return ResponseUtils.INSTANCE.ok(this.appConsentService.saveSharedConsentForMarketplacePartners(consentRequestDto.getDisplayedText()));
    }

    @GET
    @Path(value="/prompt/usage")
    @NotNull
    public final Response getAppUsageAvailability() {
        return ResponseUtils.INSTANCE.ok(this.appUsageCheckService.getAppUsageAvailability());
    }
}

