/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.auth;

import com.atlassian.jira.migration.auth.CurrentUser;
import com.atlassian.jira.migration.infrastructure.rest.ResponseUtils;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.sun.jersey.spi.container.ResourceFilters;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Path(value="auth")
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/auth/AuthResource;", "", "userManager", "Lcom/atlassian/sal/api/user/UserManager;", "(Lcom/atlassian/sal/api/user/UserManager;)V", "getCurrentUser", "Ljavax/ws/rs/core/Response;", "request", "Ljavax/servlet/http/HttpServletRequest;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAuthResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthResource.kt\ncom/atlassian/jira/migration/auth/AuthResource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,38:1\n1#2:39\n*E\n"})
public final class AuthResource {
    @NotNull
    private final UserManager userManager;

    @Inject
    public AuthResource(@NotNull UserManager userManager) {
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        this.userManager = userManager;
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="/current-user")
    @Produces(value={"application/json"})
    @NotNull
    public final Response getCurrentUser(@Context @NotNull HttpServletRequest request) {
        CurrentUser currentUser;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        UserProfile user = this.userManager.getRemoteUser(request);
        ResponseUtils responseUtils = ResponseUtils.INSTANCE;
        UserProfile userProfile = user;
        if (userProfile != null) {
            void it;
            UserProfile userProfile2 = userProfile;
            ResponseUtils responseUtils2 = responseUtils;
            boolean bl = false;
            String string = it.getFullName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullName(...)");
            String string2 = it.getEmail();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getEmail(...)");
            currentUser = new CurrentUser(string, string2);
            responseUtils = responseUtils2;
        } else {
            currentUser = null;
        }
        return responseUtils.okOrNotFound(currentUser);
    }
}

