/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.avatar;

import com.atlassian.jira.migration.avatar.Avatar;
import com.atlassian.jira.migration.avatar.AvatarMediaIdService;
import com.atlassian.jira.migration.avatar.AvatarService;
import com.atlassian.jira.migration.avatar.MediaUploadInfo;
import com.atlassian.jira.migration.avatar.MigratedAvatarRepository;
import com.atlassian.jira.migration.mediaclient.MediaClient;
import com.atlassian.migration.api.ContainerToken;
import java.io.Serializable;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J&\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/atlassian/jira/migration/avatar/AvatarMediaIdService;", "", "avatarService", "Lcom/atlassian/jira/migration/avatar/AvatarService;", "migratedAvatarRepository", "Lcom/atlassian/jira/migration/avatar/MigratedAvatarRepository;", "mediaClient", "Lcom/atlassian/jira/migration/mediaclient/MediaClient;", "(Lcom/atlassian/jira/migration/avatar/AvatarService;Lcom/atlassian/jira/migration/avatar/MigratedAvatarRepository;Lcom/atlassian/jira/migration/mediaclient/MediaClient;)V", "createMigrationFileIfNotExists", "Lcom/atlassian/jira/migration/avatar/Avatar$MigratedInfo;", "avatarWithInfo", "Lcom/atlassian/jira/migration/avatar/Avatar$Info;", "mediaClientId", "", "createMigrationFileWithFileMediaId", "generateMediaFileIds", "", "containerToken", "Lcom/atlassian/migration/api/ContainerToken;", "onProgressUpdate", "Lkotlin/Function0;", "", "generateMediaFileIdsForProject", "projectId", "", "jira-migration-plugin"})
public final class AvatarMediaIdService {
    @NotNull
    private final AvatarService avatarService;
    @NotNull
    private final MigratedAvatarRepository migratedAvatarRepository;
    @NotNull
    private final MediaClient mediaClient;

    @Inject
    public AvatarMediaIdService(@NotNull AvatarService avatarService, @NotNull MigratedAvatarRepository migratedAvatarRepository, @NotNull MediaClient mediaClient) {
        Intrinsics.checkNotNullParameter((Object)avatarService, (String)"avatarService");
        Intrinsics.checkNotNullParameter((Object)migratedAvatarRepository, (String)"migratedAvatarRepository");
        Intrinsics.checkNotNullParameter((Object)mediaClient, (String)"mediaClient");
        this.avatarService = avatarService;
        this.migratedAvatarRepository = migratedAvatarRepository;
        this.mediaClient = mediaClient;
    }

    public final int generateMediaFileIds(@NotNull ContainerToken containerToken, @NotNull Function0<Unit> onProgressUpdate2) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter(onProgressUpdate2, (String)"onProgressUpdate");
        Serializable serializable = containerToken.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)serializable, (String)"getValue(...)");
        return this.generateMediaFileIds(this.mediaClient.getMediaClientId((String)((Object)serializable)), onProgressUpdate2);
    }

    public static /* synthetic */ int generateMediaFileIds$default(AvatarMediaIdService avatarMediaIdService, ContainerToken containerToken, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = generateMediaFileIds.1.INSTANCE;
        }
        return avatarMediaIdService.generateMediaFileIds(containerToken, (Function0<Unit>)function0);
    }

    public final int generateMediaFileIds(@NotNull String mediaClientId, @NotNull Function0<Unit> onProgressUpdate2) {
        Intrinsics.checkNotNullParameter((Object)mediaClientId, (String)"mediaClientId");
        Intrinsics.checkNotNullParameter(onProgressUpdate2, (String)"onProgressUpdate");
        return SequencesKt.count((Sequence)SequencesKt.filter((Sequence)SequencesKt.onEach((Sequence)SequencesKt.map(this.avatarService.findAllCustomProjectAvatarsIncludingDifferentSizes(), (Function1)((Function1)new Function1<Avatar.Info, Avatar.MigratedInfo>(this, mediaClientId){
            final /* synthetic */ AvatarMediaIdService this$0;
            final /* synthetic */ String $mediaClientId;
            {
                this.this$0 = $receiver;
                this.$mediaClientId = $mediaClientId;
                super(1);
            }

            @NotNull
            public final Avatar.MigratedInfo invoke(@NotNull Avatar.Info avatar) {
                Intrinsics.checkNotNullParameter((Object)avatar, (String)"avatar");
                return AvatarMediaIdService.access$createMigrationFileIfNotExists(this.this$0, avatar, this.$mediaClientId);
            }
        })), (Function1)((Function1)new Function1<Avatar.MigratedInfo, Unit>(onProgressUpdate2){
            final /* synthetic */ Function0<Unit> $onProgressUpdate;
            {
                this.$onProgressUpdate = $onProgressUpdate;
                super(1);
            }

            public final void invoke(@NotNull Avatar.MigratedInfo it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$onProgressUpdate.invoke();
            }
        })), (Function1)generateMediaFileIds.5.INSTANCE));
    }

    public static /* synthetic */ int generateMediaFileIds$default(AvatarMediaIdService avatarMediaIdService, String string, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = generateMediaFileIds.2.INSTANCE;
        }
        return avatarMediaIdService.generateMediaFileIds(string, (Function0<Unit>)function0);
    }

    public final int generateMediaFileIdsForProject(long projectId, @NotNull String mediaClientId, @NotNull Function0<Unit> onProgressUpdate2) {
        Intrinsics.checkNotNullParameter((Object)mediaClientId, (String)"mediaClientId");
        Intrinsics.checkNotNullParameter(onProgressUpdate2, (String)"onProgressUpdate");
        return SequencesKt.count((Sequence)SequencesKt.filter((Sequence)SequencesKt.onEach((Sequence)SequencesKt.map(this.avatarService.findProjectAvatarsIncludingDifferentSizes(projectId), (Function1)((Function1)new Function1<Avatar.Info, Avatar.MigratedInfo>(this, mediaClientId){
            final /* synthetic */ AvatarMediaIdService this$0;
            final /* synthetic */ String $mediaClientId;
            {
                this.this$0 = $receiver;
                this.$mediaClientId = $mediaClientId;
                super(1);
            }

            @NotNull
            public final Avatar.MigratedInfo invoke(@NotNull Avatar.Info avatar) {
                Intrinsics.checkNotNullParameter((Object)avatar, (String)"avatar");
                return AvatarMediaIdService.access$createMigrationFileIfNotExists(this.this$0, avatar, this.$mediaClientId);
            }
        })), (Function1)((Function1)new Function1<Avatar.MigratedInfo, Unit>(onProgressUpdate2){
            final /* synthetic */ Function0<Unit> $onProgressUpdate;
            {
                this.$onProgressUpdate = $onProgressUpdate;
                super(1);
            }

            public final void invoke(@NotNull Avatar.MigratedInfo it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$onProgressUpdate.invoke();
            }
        })), (Function1)generateMediaFileIdsForProject.4.INSTANCE));
    }

    public static /* synthetic */ int generateMediaFileIdsForProject$default(AvatarMediaIdService avatarMediaIdService, long l, String string, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = generateMediaFileIdsForProject.1.INSTANCE;
        }
        return avatarMediaIdService.generateMediaFileIdsForProject(l, string, (Function0<Unit>)function0);
    }

    private final synchronized Avatar.MigratedInfo createMigrationFileIfNotExists(Avatar.Info avatarWithInfo, String mediaClientId) {
        Avatar.MigratedInfo migratedInfo = this.migratedAvatarRepository.findMigratedAvatar(avatarWithInfo.getId(), avatarWithInfo.getSize(), mediaClientId);
        if (migratedInfo == null) {
            migratedInfo = this.createMigrationFileWithFileMediaId(avatarWithInfo, mediaClientId);
        }
        return migratedInfo;
    }

    private final Avatar.MigratedInfo createMigrationFileWithFileMediaId(Avatar.Info avatarWithInfo, String mediaClientId) {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return MigratedAvatarRepository.DefaultImpls.recordMigration$default(this.migratedAvatarRepository, avatarWithInfo, new MediaUploadInfo(string, mediaClientId, null, 4, null), false, 4, null);
    }

    public static final /* synthetic */ Avatar.MigratedInfo access$createMigrationFileIfNotExists(AvatarMediaIdService $this, Avatar.Info avatarWithInfo, String mediaClientId) {
        return $this.createMigrationFileIfNotExists(avatarWithInfo, mediaClientId);
    }
}

