/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.avatar;

import com.atlassian.jira.migration.avatar.Avatar;
import com.atlassian.jira.migration.avatar.AvatarService;
import com.atlassian.jira.migration.avatar.MigratedAvatarRepository;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J&\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/avatar/AvatarQueryFacade;", "Lcom/atlassian/jira/migration/avatar/Avatar$Facade$Query;", "avatarService", "Lcom/atlassian/jira/migration/avatar/AvatarService;", "migratedAvatarRepository", "Lcom/atlassian/jira/migration/avatar/MigratedAvatarRepository;", "(Lcom/atlassian/jira/migration/avatar/AvatarService;Lcom/atlassian/jira/migration/avatar/MigratedAvatarRepository;)V", "findAllCustomAvatarsIncludingDifferentSizes", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/jira/migration/avatar/Avatar$Info;", "findAllCustomProjectAvatarsIncludingDifferentSizes", "findById", "Lcom/atlassian/jira/migration/avatar/Avatar;", "avatarId", "", "findMigratedInfo", "Lcom/atlassian/jira/migration/avatar/Avatar$MigratedInfo;", "serverAvatarId", "avatarSize", "Lcom/atlassian/jira/migration/avatar/Avatar$Size;", "Lcom/atlassian/jira/migration/avatar/MigrationAvatarSize;", "mediaClientId", "", "findProjectAvatarsIncludingDifferentSizes", "projectId", "getSizeFromParam", "param", "jira-migration-plugin"})
public final class AvatarQueryFacade
implements Avatar.Facade.Query {
    @NotNull
    private final AvatarService avatarService;
    @NotNull
    private final MigratedAvatarRepository migratedAvatarRepository;

    @Inject
    public AvatarQueryFacade(@NotNull AvatarService avatarService, @NotNull MigratedAvatarRepository migratedAvatarRepository) {
        Intrinsics.checkNotNullParameter((Object)avatarService, (String)"avatarService");
        Intrinsics.checkNotNullParameter((Object)migratedAvatarRepository, (String)"migratedAvatarRepository");
        this.avatarService = avatarService;
        this.migratedAvatarRepository = migratedAvatarRepository;
    }

    @Override
    @NotNull
    public Sequence<Avatar.Info> findAllCustomAvatarsIncludingDifferentSizes() {
        return this.avatarService.findAllCustomAvatarsIncludingDifferentSizes();
    }

    @Override
    @NotNull
    public Sequence<Avatar.Info> findProjectAvatarsIncludingDifferentSizes(long projectId) {
        return this.avatarService.findProjectAvatarsIncludingDifferentSizes(projectId);
    }

    @Override
    @NotNull
    public Sequence<Avatar.Info> findAllCustomProjectAvatarsIncludingDifferentSizes() {
        return this.avatarService.findAllCustomProjectAvatarsIncludingDifferentSizes();
    }

    @Override
    @Nullable
    public Avatar findById(long avatarId) {
        return this.avatarService.findById(avatarId);
    }

    @Override
    @Nullable
    public Avatar.MigratedInfo findMigratedInfo(long serverAvatarId, @NotNull Avatar.Size avatarSize, @NotNull String mediaClientId) {
        Intrinsics.checkNotNullParameter((Object)avatarSize, (String)"avatarSize");
        Intrinsics.checkNotNullParameter((Object)mediaClientId, (String)"mediaClientId");
        return this.migratedAvatarRepository.findMigratedAvatar(serverAvatarId, avatarSize, mediaClientId);
    }

    @Override
    @NotNull
    public Avatar.Size getSizeFromParam(@NotNull String param) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        return new Avatar.Size(param);
    }
}

