/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.avatar;

import com.atlassian.jira.migration.avatar.Avatar;
import com.atlassian.jira.migration.avatar.AvatarRepository;
import com.atlassian.jira.migration.avatar.AvatarService;
import com.atlassian.jira.migration.avatar.JiraAvatarService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0011\u001a\u00020\u000fJ\u0012\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0013*\u00020\rH\u0002J.\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0013*\u00020\r2\u001a\u0010\u0014\u001a\u0016\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/avatar/AvatarService;", "", "avatarRepository", "Lcom/atlassian/jira/migration/avatar/AvatarRepository;", "jiraAvatarService", "Lcom/atlassian/jira/migration/avatar/JiraAvatarService;", "(Lcom/atlassian/jira/migration/avatar/AvatarRepository;Lcom/atlassian/jira/migration/avatar/JiraAvatarService;)V", "findAllCustomAvatarsIncludingDifferentSizes", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/jira/migration/avatar/Avatar$Info;", "findAllCustomProjectAvatarsIncludingDifferentSizes", "findAllSystemAvatarsIncludingDifferentSizes", "findById", "Lcom/atlassian/jira/migration/avatar/Avatar;", "id", "", "findProjectAvatarsIncludingDifferentSizes", "projectId", "findAllFilesWithDifferentSizes", "", "fileFinder", "Lkotlin/Function2;", "Lcom/atlassian/jira/migration/avatar/Avatar$Size;", "Ljava/io/File;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAvatarService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvatarService.kt\ncom/atlassian/jira/migration/avatar/AvatarService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1603#2,9:55\n1855#2:64\n1856#2:66\n1612#2:67\n1549#2:68\n1620#2,3:69\n1#3:65\n*S KotlinDebug\n*F\n+ 1 AvatarService.kt\ncom/atlassian/jira/migration/avatar/AvatarService\n*L\n47#1:55,9\n47#1:64\n47#1:66\n47#1:67\n52#1:68\n52#1:69,3\n47#1:65\n*E\n"})
public final class AvatarService {
    @NotNull
    private final AvatarRepository avatarRepository;
    @NotNull
    private final JiraAvatarService jiraAvatarService;

    @Inject
    public AvatarService(@NotNull AvatarRepository avatarRepository, @NotNull JiraAvatarService jiraAvatarService) {
        Intrinsics.checkNotNullParameter((Object)avatarRepository, (String)"avatarRepository");
        Intrinsics.checkNotNullParameter((Object)jiraAvatarService, (String)"jiraAvatarService");
        this.avatarRepository = avatarRepository;
        this.jiraAvatarService = jiraAvatarService;
    }

    @NotNull
    public final Sequence<Avatar.Info> findAllCustomAvatarsIncludingDifferentSizes() {
        return SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)AvatarRepository.DefaultImpls.findAll$default(this.avatarRepository, 0L, 1, null)), (Function1)findAllCustomAvatarsIncludingDifferentSizes.1.INSTANCE), (Function1)((Function1)new Function1<Avatar, List<? extends Avatar.Info>>(this){
            final /* synthetic */ AvatarService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final List<Avatar.Info> invoke(@NotNull Avatar it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AvatarService.access$findAllFilesWithDifferentSizes(this.this$0, it);
            }
        }));
    }

    @NotNull
    public final Sequence<Avatar.Info> findProjectAvatarsIncludingDifferentSizes(long projectId) {
        return SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.avatarRepository.findAllByProject(projectId)), (Function1)findProjectAvatarsIncludingDifferentSizes.1.INSTANCE), (Function1)((Function1)new Function1<Avatar, List<? extends Avatar.Info>>(this){
            final /* synthetic */ AvatarService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final List<Avatar.Info> invoke(@NotNull Avatar it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AvatarService.access$findAllFilesWithDifferentSizes(this.this$0, it);
            }
        }));
    }

    @NotNull
    public final Sequence<Avatar.Info> findAllCustomProjectAvatarsIncludingDifferentSizes() {
        return SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)this.avatarRepository.findByAvatarTypeBySystemEnum(Avatar.AvatarType.PROJECT, Avatar.SystemFlag.CUSTOM)), (Function1)((Function1)new Function1<Avatar, List<? extends Avatar.Info>>(this){
            final /* synthetic */ AvatarService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final List<Avatar.Info> invoke(@NotNull Avatar it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AvatarService.access$findAllFilesWithDifferentSizes(this.this$0, it);
            }
        }));
    }

    @NotNull
    public final Sequence<Avatar.Info> findAllSystemAvatarsIncludingDifferentSizes() {
        return SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)AvatarRepository.DefaultImpls.findAll$default(this.avatarRepository, 0L, 1, null)), (Function1)findAllSystemAvatarsIncludingDifferentSizes.1.INSTANCE), (Function1)((Function1)new Function1<Avatar, List<? extends Avatar.Info>>(this){
            final /* synthetic */ AvatarService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final List<Avatar.Info> invoke(@NotNull Avatar it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AvatarService.access$findAllFilesWithDifferentSizes(this.this$0, it);
            }
        }));
    }

    @Nullable
    public final Avatar findById(long id) {
        return this.avatarRepository.find(id);
    }

    private final List<Avatar.Info> findAllFilesWithDifferentSizes(Avatar $this$findAllFilesWithDifferentSizes) {
        KFunction kFunction;
        Avatar avatar = $this$findAllFilesWithDifferentSizes;
        if (avatar instanceof Avatar.CustomAvatar) {
            kFunction = (KFunction)new Function2<Avatar, Avatar.Size, File>((Object)this.jiraAvatarService){

                @Nullable
                public final File invoke(@NotNull Avatar p0, @NotNull Avatar.Size p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return ((JiraAvatarService)this.receiver).findCustomAvatarFile(p0, p1);
                }
            };
        } else if (avatar instanceof Avatar.SystemAvatar) {
            kFunction = (KFunction)new Function2<Avatar, Avatar.Size, File>((Object)this.jiraAvatarService){

                @Nullable
                public final File invoke(@NotNull Avatar p0, @NotNull Avatar.Size p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return ((JiraAvatarService)this.receiver).findSystemAvatarFile(p0, p1);
                }
            };
        } else {
            throw new NoWhenBranchMatchedException();
        }
        KFunction fileFinder = kFunction;
        boolean bl = false;
        return this.findAllFilesWithDifferentSizes($this$findAllFilesWithDifferentSizes, (Function2<? super Avatar, ? super Avatar.Size, ? extends File>)((Function2)fileFinder));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Avatar.Info> findAllFilesWithDifferentSizes(Avatar $this$findAllFilesWithDifferentSizes, Function2<? super Avatar, ? super Avatar.Size, ? extends File> fileFinder) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.jiraAvatarService.findAllSizes();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Pair pair = $this$forEach$iv$iv$iv.iterator();
        while (pair.hasNext()) {
            Pair pair2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = pair.next();
            boolean bl = false;
            Avatar.Size size = (Avatar.Size)element$iv$iv;
            boolean bl2 = false;
            if ((File)fileFinder.invoke((Object)$this$findAllFilesWithDifferentSizes, (Object)size) != null) {
                File file2;
                boolean bl3 = false;
                pair2 = TuplesKt.to((Object)size, (Object)file2);
            } else {
                pair2 = null;
            }
            if (pair2 == null) continue;
            Pair it$iv$iv = pair2;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Avatar.Size size = (Avatar.Size)pair.component1();
            File file3 = (File)pair.component2();
            collection.add(new Avatar.Info($this$findAllFilesWithDifferentSizes, size, file3));
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ List access$findAllFilesWithDifferentSizes(AvatarService $this, Avatar $receiver) {
        return $this.findAllFilesWithDifferentSizes($receiver);
    }
}

