/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.avatar.adapters;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.migration.avatar.Avatar;
import com.atlassian.jira.migration.avatar.MediaUploadInfo;
import com.atlassian.jira.migration.avatar.MigratedAvatarRepository;
import com.atlassian.jira.migration.avatar.adapters.DBMigratedAvatarRepositoryKt;
import com.atlassian.jira.migration.avatar.adapters.MigratedAvatarEntity;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J&\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J*\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\rH\u0002J$\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00112\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001e0!H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/atlassian/jira/migration/avatar/adapters/DBMigratedAvatarRepository;", "Lcom/atlassian/jira/migration/avatar/MigratedAvatarRepository;", "ao", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;)V", "find", "Lcom/atlassian/jira/migration/avatar/adapters/MigratedAvatarEntity;", "serverAvatarId", "", "avatarSize", "Lcom/atlassian/jira/migration/avatar/Avatar$Size;", "Lcom/atlassian/jira/migration/avatar/MigrationAvatarSize;", "mediaClientId", "", "findAllMigratedAvatars", "Lkotlin/sequences/Sequence;", "findMigratedAvatar", "Lcom/atlassian/jira/migration/avatar/Avatar$MigratedInfo;", "recordMigration", "avatarWithInfo", "Lcom/atlassian/jira/migration/avatar/Avatar$Info;", "mediaUploadInfo", "Lcom/atlassian/jira/migration/avatar/MediaUploadInfo;", "migrated", "", "updateFrom", "dst", "fileMediaId", "uploadId", "updateMigrationStatus", "", "migratedInfo", "updatedHandler", "Lkotlin/Function1;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nDBMigratedAvatarRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DBMigratedAvatarRepository.kt\ncom/atlassian/jira/migration/avatar/adapters/DBMigratedAvatarRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n1#2:149\n*E\n"})
public final class DBMigratedAvatarRepository
implements MigratedAvatarRepository {
    @NotNull
    private final ActiveObjects ao;

    @Inject
    public DBMigratedAvatarRepository(@NotNull ActiveObjects ao) {
        Intrinsics.checkNotNullParameter((Object)ao, (String)"ao");
        this.ao = ao;
    }

    @Override
    @NotNull
    public Avatar.MigratedInfo recordMigration(@NotNull Avatar.Info avatarWithInfo, @NotNull MediaUploadInfo mediaUploadInfo, boolean migrated) {
        MigratedAvatarEntity entity;
        MigratedAvatarEntity migratedAvatarEntity;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)avatarWithInfo, (String)"avatarWithInfo");
                Intrinsics.checkNotNullParameter((Object)mediaUploadInfo, (String)"mediaUploadInfo");
                Avatar.Info $this$recordMigration_u24lambda_u240 = avatarWithInfo;
                boolean bl = false;
                MigratedAvatarEntity result2 = this.find($this$recordMigration_u24lambda_u240.getId(), $this$recordMigration_u24lambda_u240.getSize(), mediaUploadInfo.getMediaClientId());
                migratedAvatarEntity = result2;
                if (migratedAvatarEntity == null) break block2;
                MigratedAvatarEntity it = migratedAvatarEntity;
                boolean bl2 = false;
                MigratedAvatarEntity migratedAvatarEntity2 = this.updateFrom(it, mediaUploadInfo.getFileMediaId(), migrated, mediaUploadInfo.getUploadId());
                migratedAvatarEntity = migratedAvatarEntity2;
                if (migratedAvatarEntity2 != null) break block3;
            }
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"SERVER_AVATAR_ID", (Object)avatarWithInfo.getId()), TuplesKt.to((Object)"SIZE", (Object)avatarWithInfo.getSize().getParam()), TuplesKt.to((Object)"FILE_MEDIA_ID", (Object)mediaUploadInfo.getFileMediaId()), TuplesKt.to((Object)"MEDIA_CLIENT_ID", (Object)mediaUploadInfo.getMediaClientId()), TuplesKt.to((Object)"MIGRATED", (Object)migrated), TuplesKt.to((Object)"UPLOAD_ID", (Object)mediaUploadInfo.getUploadId())};
            migratedAvatarEntity = (MigratedAvatarEntity)this.ao.create(MigratedAvatarEntity.class, MapsKt.mapOf((Pair[])pairArray));
        }
        MigratedAvatarEntity p0 = entity = migratedAvatarEntity;
        boolean bl = false;
        return DBMigratedAvatarRepositoryKt.toMigratedAvatar(p0);
    }

    @Override
    public void updateMigrationStatus(@NotNull Avatar.MigratedInfo migratedInfo, @NotNull Function1<? super Avatar.MigratedInfo, Unit> updatedHandler) {
        Intrinsics.checkNotNullParameter((Object)migratedInfo, (String)"migratedInfo");
        Intrinsics.checkNotNullParameter(updatedHandler, (String)"updatedHandler");
        this.ao.executeInTransaction(() -> DBMigratedAvatarRepository.updateMigrationStatus$lambda$4(this, migratedInfo, updatedHandler));
    }

    @Override
    @Nullable
    public Avatar.MigratedInfo findMigratedAvatar(long serverAvatarId, @NotNull Avatar.Size avatarSize, @NotNull String mediaClientId) {
        Avatar.MigratedInfo migratedInfo;
        Intrinsics.checkNotNullParameter((Object)avatarSize, (String)"avatarSize");
        Intrinsics.checkNotNullParameter((Object)mediaClientId, (String)"mediaClientId");
        MigratedAvatarEntity migratedAvatarEntity = this.find(serverAvatarId, avatarSize, mediaClientId);
        if (migratedAvatarEntity != null) {
            MigratedAvatarEntity p0 = migratedAvatarEntity;
            boolean bl = false;
            migratedInfo = DBMigratedAvatarRepositoryKt.toMigratedAvatar(p0);
        } else {
            migratedInfo = null;
        }
        return migratedInfo;
    }

    @Override
    @NotNull
    public Sequence<MigratedAvatarEntity> findAllMigratedAvatars(@NotNull String mediaClientId) {
        Intrinsics.checkNotNullParameter((Object)mediaClientId, (String)"mediaClientId");
        Object[] objectArray = new Object[]{mediaClientId};
        RawEntity[] rawEntityArray = this.ao.find(MigratedAvatarEntity.class, Query.select().where("MEDIA_CLIENT_ID = ?", objectArray).distinct());
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return ArraysKt.asSequence((Object[])rawEntityArray);
    }

    private final MigratedAvatarEntity find(long serverAvatarId, Avatar.Size avatarSize, String mediaClientId) {
        Object[] objectArray = new Object[]{serverAvatarId, avatarSize.getParam(), mediaClientId};
        Object[] result2 = (MigratedAvatarEntity[])this.ao.find(MigratedAvatarEntity.class, Query.select().where("SERVER_AVATAR_ID = ? AND SIZE = ? AND MEDIA_CLIENT_ID = ?", objectArray).order("MIGRATED DESC, ID ASC").limit(1));
        Intrinsics.checkNotNull((Object)result2);
        return (MigratedAvatarEntity)ArraysKt.singleOrNull((Object[])result2);
    }

    private final MigratedAvatarEntity updateFrom(MigratedAvatarEntity dst, String fileMediaId, boolean migrated, String uploadId) {
        MigratedAvatarEntity migratedAvatarEntity;
        MigratedAvatarEntity $this$updateFrom_u24lambda_u246 = migratedAvatarEntity = dst;
        boolean bl = false;
        $this$updateFrom_u24lambda_u246.setFileMediaId(fileMediaId);
        $this$updateFrom_u24lambda_u246.setUploadId(uploadId);
        $this$updateFrom_u24lambda_u246.setMigrated(migrated);
        $this$updateFrom_u24lambda_u246.save();
        return migratedAvatarEntity;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit updateMigrationStatus$lambda$4(DBMigratedAvatarRepository this$0, Avatar.MigratedInfo $migratedInfo, Function1 $updatedHandler) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$migratedInfo, (String)"$migratedInfo");
            Intrinsics.checkNotNullParameter((Object)$updatedHandler, (String)"$updatedHandler");
            MigratedAvatarEntity entity = this$0.find($migratedInfo.getServerAvatarId(), $migratedInfo.getSize(), $migratedInfo.getMediaClientId());
            if (entity == null) break block1;
            MigratedAvatarEntity migratedAvatarEntity = (MigratedAvatarEntity)this$0.ao.get(MigratedAvatarEntity.class, (Object)entity.getID());
            if (migratedAvatarEntity != null) {
                void p0;
                MigratedAvatarEntity updated;
                MigratedAvatarEntity it = migratedAvatarEntity;
                boolean bl = false;
                MigratedAvatarEntity migratedAvatarEntity2 = updated = this$0.updateFrom(it, $migratedInfo.getFileMediaId(), $migratedInfo.getMigrated(), $migratedInfo.getUploadId());
                Function1 function1 = $updatedHandler;
                boolean bl2 = false;
                function1.invoke((Object)DBMigratedAvatarRepositoryKt.toMigratedAvatar((MigratedAvatarEntity)p0));
            }
        }
        return Unit.INSTANCE;
    }
}

