/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.avatar.adapters;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.migration.avatar.adapters.AvatarFinderInput;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u000b\u001a\u00020\u0006*\u0004\u0018\u00010\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/avatar/adapters/JiraSystemAvatarFinder;", "", "jiraHome", "Lcom/atlassian/jira/config/util/JiraHome;", "(Lcom/atlassian/jira/config/util/JiraHome;)V", "find", "Ljava/io/File;", "input", "Lcom/atlassian/jira/migration/avatar/adapters/AvatarFinderInput;", "getSystemFileUrl", "Ljava/net/URL;", "toFile", "defaultSupplier", "Lkotlin/Function0;", "Companion", "jira-migration-plugin"})
public final class JiraSystemAvatarFinder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JiraHome jiraHome;
    private static final Logger logger = LoggerFactory.getLogger(JiraSystemAvatarFinder.class);

    @Inject
    public JiraSystemAvatarFinder(@NotNull JiraHome jiraHome) {
        Intrinsics.checkNotNullParameter((Object)jiraHome, (String)"jiraHome");
        this.jiraHome = jiraHome;
    }

    @Nullable
    public final File find(@NotNull AvatarFinderInput input) {
        File file2;
        File file3;
        File file4;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        AvatarFinderInput $this$find_u24lambda_u242 = input;
        boolean bl = false;
        File it = file4 = this.toFile(this.getSystemFileUrl($this$find_u24lambda_u242), (Function0<? extends File>)((Function0)new Function0<File>(this, $this$find_u24lambda_u242){
            final /* synthetic */ JiraSystemAvatarFinder this$0;
            final /* synthetic */ AvatarFinderInput $this_run;
            {
                this.this$0 = $receiver;
                this.$this_run = $receiver2;
                super(0);
            }

            @NotNull
            public final File invoke() {
                return new File(JiraSystemAvatarFinder.access$getJiraHome$p(this.this$0).getDataDirectory(), this.$this_run.getFullFileName());
            }
        }));
        boolean bl2 = false;
        File file5 = file3 = it.exists() ? file4 : null;
        if (file3 != null) {
            it = file4 = file3;
            boolean bl3 = false;
            logger.info("System avatar file found: " + it.getAbsolutePath());
            file2 = file4;
        } else {
            file2 = null;
        }
        return file2;
    }

    private final URL getSystemFileUrl(AvatarFinderInput input) {
        AvatarFinderInput $this$getSystemFileUrl_u24lambda_u243 = input;
        boolean bl = false;
        return Avatar.Size.class.getResource("/avatars/" + $this$getSystemFileUrl_u24lambda_u243.getFilenameFlag() + $this$getSystemFileUrl_u24lambda_u243.getAvatar().getFileName());
    }

    private final File toFile(URL $this$toFile, Function0<? extends File> defaultSupplier) {
        if ($this$toFile == null) {
            return (File)defaultSupplier.invoke();
        }
        try {
            File file2 = ResourceUtils.getFile((URL)$this$toFile);
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getFile(...)");
            return file2;
        }
        catch (FileNotFoundException e) {
            logger.info("Unable to find a system avatar, will use default path for this avatar : " + ((File)defaultSupplier.invoke()).getPath());
            return (File)defaultSupplier.invoke();
        }
    }

    public static final /* synthetic */ JiraHome access$getJiraHome$p(JiraSystemAvatarFinder $this) {
        return $this.jiraHome;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/avatar/adapters/JiraSystemAvatarFinder$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

