/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.backgroundtask;

import com.atlassian.jira.migration.backgroundtask.BackgroundTask;
import com.atlassian.jira.migration.backgroundtask.TaskCleanupHelper;
import com.atlassian.jira.migration.backgroundtask.TaskUnitExecutor;
import com.atlassian.jira.migration.backgroundtask.analytics.BackgroundTaskEventDispatcher;
import com.atlassian.jira.migration.backgroundtask.analytics.BackgroundTaskEventParameter;
import com.atlassian.jira.migration.backgroundtask.api.BackgroundTaskData;
import com.atlassian.jira.migration.backgroundtask.repository.BackgroundTaskEntity;
import com.atlassian.jira.migration.backgroundtask.repository.BackgroundTaskRepository;
import com.atlassian.jira.migration.backgroundtask.service.BackgroundTaskStatus;
import com.atlassian.jira.migration.log.MigrationLogsService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B=\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000bH\u0002J\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\b\u0010\u001d\u001a\u00020\u0014H\u0016J\b\u0010\u001e\u001a\u00020\u0014H\u0002J\b\u0010\u001f\u001a\u00020\u0014H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/backgroundtask/BackgroundTaskImpl;", "Lcom/atlassian/jira/migration/backgroundtask/BackgroundTask;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "migrationLogsService", "Lcom/atlassian/jira/migration/log/MigrationLogsService;", "backgroundTaskRepository", "Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskRepository;", "backgroundTaskEventDispatcher", "Lcom/atlassian/jira/migration/backgroundtask/analytics/BackgroundTaskEventDispatcher;", "taskUnitExecutors", "", "Lcom/atlassian/jira/migration/backgroundtask/TaskUnitExecutor;", "taskCleanupHelper", "Lcom/atlassian/jira/migration/backgroundtask/TaskCleanupHelper;", "(Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/log/MigrationLogsService;Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskRepository;Lcom/atlassian/jira/migration/backgroundtask/analytics/BackgroundTaskEventDispatcher;Ljava/util/List;Lcom/atlassian/jira/migration/backgroundtask/TaskCleanupHelper;)V", "log", "Lorg/apache/log4j/Logger;", "kotlin.jvm.PlatformType", "cancelBackgroundTask", "Lcom/atlassian/jira/migration/backgroundtask/api/BackgroundTaskData;", "executePreProcessing", "", "taskGroupId", "", "projects", "Lcom/atlassian/jira/project/Project;", "exportErrorLogs", "Ljava/nio/file/Path;", "getBackgroundTaskStatus", "runTask", "startTask", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nBackgroundTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackgroundTask.kt\ncom/atlassian/jira/migration/backgroundtask/BackgroundTaskImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n1855#2,2:171\n*S KotlinDebug\n*F\n+ 1 BackgroundTask.kt\ncom/atlassian/jira/migration/backgroundtask/BackgroundTaskImpl\n*L\n116#1:171,2\n*E\n"})
public final class BackgroundTaskImpl
implements BackgroundTask {
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final MigrationLogsService migrationLogsService;
    @NotNull
    private final BackgroundTaskRepository backgroundTaskRepository;
    @NotNull
    private final BackgroundTaskEventDispatcher backgroundTaskEventDispatcher;
    @NotNull
    private final List<TaskUnitExecutor> taskUnitExecutors;
    @NotNull
    private final TaskCleanupHelper taskCleanupHelper;
    private final Logger log;

    @Inject
    public BackgroundTaskImpl(@NotNull ProjectManager projectManager, @NotNull MigrationLogsService migrationLogsService, @NotNull BackgroundTaskRepository backgroundTaskRepository, @NotNull BackgroundTaskEventDispatcher backgroundTaskEventDispatcher, @NotNull List<? extends TaskUnitExecutor> taskUnitExecutors, @NotNull TaskCleanupHelper taskCleanupHelper) {
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)migrationLogsService, (String)"migrationLogsService");
        Intrinsics.checkNotNullParameter((Object)backgroundTaskRepository, (String)"backgroundTaskRepository");
        Intrinsics.checkNotNullParameter((Object)backgroundTaskEventDispatcher, (String)"backgroundTaskEventDispatcher");
        Intrinsics.checkNotNullParameter(taskUnitExecutors, (String)"taskUnitExecutors");
        Intrinsics.checkNotNullParameter((Object)taskCleanupHelper, (String)"taskCleanupHelper");
        this.projectManager = projectManager;
        this.migrationLogsService = migrationLogsService;
        this.backgroundTaskRepository = backgroundTaskRepository;
        this.backgroundTaskEventDispatcher = backgroundTaskEventDispatcher;
        this.taskUnitExecutors = taskUnitExecutors;
        this.taskCleanupHelper = taskCleanupHelper;
        this.log = Logger.getLogger(BackgroundTaskImpl.class);
    }

    @Override
    @NotNull
    public BackgroundTaskData startTask() {
        BackgroundTaskData backgroundTaskData;
        BackgroundTaskEntity latestTask = this.backgroundTaskRepository.findLatest();
        if (latestTask == null) {
            backgroundTaskData = this.runTask();
        } else if (latestTask.getStatus().isRestartable()) {
            this.taskCleanupHelper.cleanupPreviousTasks();
            backgroundTaskData = this.runTask();
        } else {
            backgroundTaskData = new BackgroundTaskData(latestTask.getStatus(), latestTask.getProgress(), null, System.currentTimeMillis() - latestTask.getCreatedAt(), null, 20, null);
        }
        return backgroundTaskData;
    }

    @Override
    @NotNull
    public BackgroundTaskData getBackgroundTaskStatus() {
        BackgroundTaskData backgroundTaskData;
        BackgroundTaskEntity latestTask;
        BackgroundTaskEntity backgroundTaskEntity = latestTask = this.backgroundTaskRepository.findLatest();
        BackgroundTaskStatus backgroundTaskStatus = backgroundTaskEntity != null ? backgroundTaskEntity.getStatus() : null;
        switch (backgroundTaskStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[backgroundTaskStatus.ordinal()]) {
            case 1: 
            case 2: {
                BackgroundTaskStatus backgroundTaskStatus2 = latestTask.getStatus();
                String string = latestTask.getDescription();
                if (string == null) {
                    string = "";
                }
                backgroundTaskData = new BackgroundTaskData(backgroundTaskStatus2, 0, string, 0L, null, 26, null);
                break;
            }
            case 3: {
                backgroundTaskData = new BackgroundTaskData(latestTask.getStatus(), latestTask.getProgress(), null, System.currentTimeMillis() - latestTask.getCreatedAt(), null, 20, null);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                long startTime = latestTask.getCreatedAt();
                long endTime = latestTask.getUpdatedAt();
                BackgroundTaskStatus backgroundTaskStatus3 = latestTask.getStatus();
                int n = latestTask.getProgress();
                String string = latestTask.getDescription();
                if (string == null) {
                    string = "";
                }
                backgroundTaskData = new BackgroundTaskData(backgroundTaskStatus3, n, string, endTime - startTime, null, 16, null);
                break;
            }
            default: {
                backgroundTaskData = new BackgroundTaskData(BackgroundTaskStatus.NOT_STARTED, 0, null, 0L, null, 30, null);
            }
        }
        return backgroundTaskData;
    }

    @Override
    @Nullable
    public BackgroundTaskData cancelBackgroundTask() {
        BackgroundTaskData backgroundTaskData;
        BackgroundTaskEntity latestTask;
        this.log.info((Object)"Cancelling background preflight task.");
        BackgroundTaskEntity backgroundTaskEntity = latestTask = this.backgroundTaskRepository.findLatest();
        BackgroundTaskStatus backgroundTaskStatus = backgroundTaskEntity != null ? backgroundTaskEntity.getStatus() : null;
        if ((backgroundTaskStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[backgroundTaskStatus.ordinal()]) == 3) {
            this.taskCleanupHelper.performCancelActions(latestTask);
            BackgroundTaskStatus backgroundTaskStatus2 = BackgroundTaskStatus.CANCELED;
            int n = latestTask.getProgress();
            long l = System.currentTimeMillis() - latestTask.getCreatedAt();
            backgroundTaskData = new BackgroundTaskData(backgroundTaskStatus2, n, "Background preflight task was cancelled manually", l, null, 16, null);
        } else {
            backgroundTaskData = null;
        }
        return backgroundTaskData;
    }

    private final BackgroundTaskData runTask() {
        BackgroundTaskData backgroundTaskData;
        this.log.info((Object)"Starting background preflight task.");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String taskGroupId = string;
        List list = this.projectManager.getProjects();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getProjects(...)");
        List projects = list;
        this.executePreProcessing(taskGroupId, projects);
        long startTimeInMillisTask = System.currentTimeMillis();
        if (!((Collection)projects).isEmpty()) {
            Iterable $this$forEach$iv = this.taskUnitExecutors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TaskUnitExecutor it = (TaskUnitExecutor)element$iv;
                boolean bl = false;
                it.execute(taskGroupId);
            }
            BackgroundTaskRepository.updateTaskStatus$default(this.backgroundTaskRepository, taskGroupId, BackgroundTaskStatus.IN_PROGRESS, null, 4, null);
            backgroundTaskData = new BackgroundTaskData(BackgroundTaskStatus.IN_PROGRESS, 0, null, System.currentTimeMillis() - startTimeInMillisTask, null, 20, null);
        } else {
            this.taskCleanupHelper.unscheduleJobs();
            backgroundTaskData = new BackgroundTaskData(BackgroundTaskStatus.NOT_STARTED, 0, "No projects found in Jira server", 0L, null, 26, null);
        }
        return backgroundTaskData;
    }

    private final void executePreProcessing(String taskGroupId, List<? extends Project> projects) {
        this.taskCleanupHelper.restartJobs(taskGroupId);
        this.backgroundTaskEventDispatcher.sendBackgroundTaskEvent(new BackgroundTaskEventParameter("started", taskGroupId, System.currentTimeMillis(), System.currentTimeMillis(), 0L, false, 0, 0, 0, projects.size()));
        BackgroundTaskRepository.createTask$default(this.backgroundTaskRepository, taskGroupId, BackgroundTaskStatus.NOT_STARTED, 0, null, 8, null);
    }

    @Nullable
    public final Path exportErrorLogs() {
        return this.migrationLogsService.generateLogsForBackgroundTask("backgroundTaskExecId");
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BackgroundTaskStatus.values().length];
            try {
                nArray[BackgroundTaskStatus.NOT_STARTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackgroundTaskStatus.FAILED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackgroundTaskStatus.IN_PROGRESS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackgroundTaskStatus.COMPLETE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackgroundTaskStatus.INCOMPLETE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackgroundTaskStatus.CANCELED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

