/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.backgroundtask;

import com.atlassian.jira.migration.GroupedThreadFactory;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.preflight.utils.PreflightUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/backgroundtask/BackgroundThreadManager;", "", "()V", "bgThreadPool", "Ljava/util/concurrent/ExecutorService;", "createThreadPool", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "shutdownThreadPool", "", "shutdownThreadPoolNow", "jira-migration-plugin"})
public final class BackgroundThreadManager {
    @NotNull
    public static final BackgroundThreadManager INSTANCE = new BackgroundThreadManager();
    @Nullable
    private static ExecutorService bgThreadPool;

    private BackgroundThreadManager() {
    }

    @NotNull
    public final ExecutorService createThreadPool(@NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        if (bgThreadPool != null) {
            ExecutorService executorService = bgThreadPool;
            Intrinsics.checkNotNull((Object)executorService);
            if (!executorService.isShutdown()) {
                ExecutorService executorService2 = bgThreadPool;
                Intrinsics.checkNotNull((Object)executorService2);
                return executorService2;
            }
        }
        int numThreads = migrationFeatures.getEnableParallelizationInProjectDataPreprocessing() ? PreflightUtils.Companion.getParallelDryRunThreadPoolSize() : 1;
        ExecutorService executorService = bgThreadPool = Executors.newFixedThreadPool(numThreads, new GroupedThreadFactory("BackgroundTaskService"));
        Intrinsics.checkNotNull((Object)executorService);
        return executorService;
    }

    public final void shutdownThreadPool() {
        block0: {
            ExecutorService executorService = bgThreadPool;
            if (executorService == null) break block0;
            executorService.shutdown();
        }
    }

    public final void shutdownThreadPoolNow() {
        block0: {
            ExecutorService executorService = bgThreadPool;
            if (executorService == null) break block0;
            executorService.shutdownNow();
        }
    }
}

