/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.backgroundtask;

import com.atlassian.jira.migration.backgroundtask.BackgroundThreadManager;
import com.atlassian.jira.migration.backgroundtask.TaskExecutorUtilsKt;
import com.atlassian.jira.migration.backgroundtask.TaskProgressCalculator;
import com.atlassian.jira.migration.backgroundtask.TaskStatusCounts;
import com.atlassian.jira.migration.backgroundtask.TaskUnitExecutor;
import com.atlassian.jira.migration.backgroundtask.analytics.BackgroundTaskEventDispatcher;
import com.atlassian.jira.migration.backgroundtask.analytics.BackgroundTaskEventParameter;
import com.atlassian.jira.migration.backgroundtask.job.BackgroundTaskClusterMonitor;
import com.atlassian.jira.migration.backgroundtask.repository.BackgroundTaskEntity;
import com.atlassian.jira.migration.backgroundtask.repository.BackgroundTaskRepository;
import com.atlassian.jira.migration.backgroundtask.repository.BackgroundTaskUnitRepository;
import com.atlassian.jira.migration.backgroundtask.service.BackgroundTaskStatus;
import com.atlassian.jira.migration.backgroundtask.service.BackgroundTaskUnitStatus;
import com.atlassian.jira.migration.common.MigrationTaskMetadata;
import com.atlassian.jira.migration.export.ExportFacade;
import com.atlassian.jira.migration.export.PreprocessingOutcome;
import com.atlassian.jira.migration.export.framework.ExportMode;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.jiraservice.JiraExtensionsKt;
import com.atlassian.jira.migration.plan.MigrationType;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001BO\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J(\u0010!\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J$\u0010&\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010+\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0002J \u0010/\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u00101\u001a\u000202H\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/atlassian/jira/migration/backgroundtask/ProjectExportTaskUnitExecutor;", "Lcom/atlassian/jira/migration/backgroundtask/TaskUnitExecutor;", "backgroundTaskUnitRepository", "Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskUnitRepository;", "backgroundTaskRepository", "Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskRepository;", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "jiraAuthenticationContext", "Lcom/atlassian/jira/security/JiraAuthenticationContext;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "exportFacade", "Lcom/atlassian/jira/migration/export/ExportFacade;", "backgroundTaskEventDispatcher", "Lcom/atlassian/jira/migration/backgroundtask/analytics/BackgroundTaskEventDispatcher;", "backgroundTaskClusterMonitor", "Lcom/atlassian/jira/migration/backgroundtask/job/BackgroundTaskClusterMonitor;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskUnitRepository;Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskRepository;Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;Lcom/atlassian/jira/security/JiraAuthenticationContext;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/export/ExportFacade;Lcom/atlassian/jira/migration/backgroundtask/analytics/BackgroundTaskEventDispatcher;Lcom/atlassian/jira/migration/backgroundtask/job/BackgroundTaskClusterMonitor;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "log", "Lorg/apache/log4j/Logger;", "kotlin.jvm.PlatformType", "execute", "", "taskId", "", "executeTaskUnityPostProcessing", "project", "Lcom/atlassian/jira/project/Project;", "preprocessingOutcome", "Lcom/atlassian/jira/migration/export/PreprocessingOutcome;", "handleTaskUnitFailure", "startTimeInMillisForProject", "", "it", "", "runTaskUnits", "Ljava/util/concurrent/Future;", "loggedInUser", "Lcom/atlassian/jira/user/ApplicationUser;", "updateTaskProgressAndStatus", "updateTaskStatus", "totalIncompleteTasks", "", "totalFailedTasks", "updateTaskUnitStatus", "key", "status", "Lcom/atlassian/jira/migration/backgroundtask/service/BackgroundTaskUnitStatus;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nTaskUnitExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskUnitExecutor.kt\ncom/atlassian/jira/migration/backgroundtask/ProjectExportTaskUnitExecutor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n1549#2:201\n1620#2,3:202\n*S KotlinDebug\n*F\n+ 1 TaskUnitExecutor.kt\ncom/atlassian/jira/migration/backgroundtask/ProjectExportTaskUnitExecutor\n*L\n51#1:201\n51#1:202,3\n*E\n"})
public final class ProjectExportTaskUnitExecutor
implements TaskUnitExecutor {
    @NotNull
    private final BackgroundTaskUnitRepository backgroundTaskUnitRepository;
    @NotNull
    private final BackgroundTaskRepository backgroundTaskRepository;
    @NotNull
    private final JiraThreadLocalUtil jiraThreadLocalUtil;
    @NotNull
    private final JiraAuthenticationContext jiraAuthenticationContext;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final ExportFacade exportFacade;
    @NotNull
    private final BackgroundTaskEventDispatcher backgroundTaskEventDispatcher;
    @NotNull
    private final BackgroundTaskClusterMonitor backgroundTaskClusterMonitor;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    private final Logger log;

    @Inject
    public ProjectExportTaskUnitExecutor(@NotNull BackgroundTaskUnitRepository backgroundTaskUnitRepository, @NotNull BackgroundTaskRepository backgroundTaskRepository, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil, @NotNull JiraAuthenticationContext jiraAuthenticationContext, @NotNull ProjectManager projectManager, @NotNull ExportFacade exportFacade, @NotNull BackgroundTaskEventDispatcher backgroundTaskEventDispatcher, @NotNull BackgroundTaskClusterMonitor backgroundTaskClusterMonitor, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)backgroundTaskUnitRepository, (String)"backgroundTaskUnitRepository");
        Intrinsics.checkNotNullParameter((Object)backgroundTaskRepository, (String)"backgroundTaskRepository");
        Intrinsics.checkNotNullParameter((Object)jiraThreadLocalUtil, (String)"jiraThreadLocalUtil");
        Intrinsics.checkNotNullParameter((Object)jiraAuthenticationContext, (String)"jiraAuthenticationContext");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)exportFacade, (String)"exportFacade");
        Intrinsics.checkNotNullParameter((Object)backgroundTaskEventDispatcher, (String)"backgroundTaskEventDispatcher");
        Intrinsics.checkNotNullParameter((Object)backgroundTaskClusterMonitor, (String)"backgroundTaskClusterMonitor");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.backgroundTaskUnitRepository = backgroundTaskUnitRepository;
        this.backgroundTaskRepository = backgroundTaskRepository;
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectManager = projectManager;
        this.exportFacade = exportFacade;
        this.backgroundTaskEventDispatcher = backgroundTaskEventDispatcher;
        this.backgroundTaskClusterMonitor = backgroundTaskClusterMonitor;
        this.migrationFeatures = migrationFeatures;
        this.log = Logger.getLogger(ProjectExportTaskUnitExecutor.class);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(@NotNull String taskId2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)taskId2, (String)"taskId");
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        List list = this.projectManager.getProjects();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getProjects(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Project project = (Project)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
            this.updateTaskUnitStatus(string, taskId2, BackgroundTaskUnitStatus.NOT_STARTED);
            Intrinsics.checkNotNull((Object)it);
            Intrinsics.checkNotNull((Object)loggedInUser);
            collection.add(this.runTaskUnits((Project)it, taskId2, loggedInUser));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    private final void updateTaskUnitStatus(String key, String taskId2, BackgroundTaskUnitStatus status) {
        this.backgroundTaskUnitRepository.upsertTaskUnit(key, taskId2, this.backgroundTaskClusterMonitor.getNodeIdOrDefault(), status);
    }

    private final Future<?> runTaskUnits(Project project, String taskId2, ApplicationUser loggedInUser) {
        Future<?> future = BackgroundThreadManager.INSTANCE.createThreadPool(this.migrationFeatures).submit(() -> ProjectExportTaskUnitExecutor.runTaskUnits$lambda$3(this, project, taskId2, loggedInUser));
        Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
        return future;
    }

    private final void executeTaskUnityPostProcessing(Project project, PreprocessingOutcome preprocessingOutcome2, String taskId2) {
        if (!preprocessingOutcome2.getHasExportError()) {
            this.log.info((Object)("Background export for project " + project.getKey() + " was successful."));
            String string = project.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
            this.updateTaskUnitStatus(string, taskId2, BackgroundTaskUnitStatus.COMPLETE);
        } else {
            this.log.info((Object)("Background export for project " + project.getKey() + " found some errors. Please look at the export error logs for more details."));
            String string = project.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
            this.updateTaskUnitStatus(string, taskId2, BackgroundTaskUnitStatus.INCOMPLETE);
        }
        this.updateTaskProgressAndStatus(taskId2);
    }

    private final void handleTaskUnitFailure(Project project, long startTimeInMillisForProject, Throwable it, String taskId2) {
        this.log.error((Object)("Background export for project " + project.getKey() + " failed in " + (System.currentTimeMillis() - startTimeInMillisForProject) + '.'), it);
        String string = project.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        this.updateTaskUnitStatus(string, taskId2, BackgroundTaskUnitStatus.FAILED);
        this.updateTaskProgressAndStatus(taskId2);
    }

    private final void updateTaskProgressAndStatus(String taskId2) {
        block1: {
            TaskProgressCalculator taskProgressCalculator = new TaskProgressCalculator(this.backgroundTaskUnitRepository);
            TaskStatusCounts taskStatusCounts = taskProgressCalculator.calculateTaskStatusCounts();
            int currentProgress = taskProgressCalculator.calculateCurrentProgress(taskStatusCounts);
            this.backgroundTaskRepository.updateTaskProgress(taskId2, currentProgress);
            if (currentProgress != 100) break block1;
            this.updateTaskStatus(taskId2, taskStatusCounts.getIncompleteTasks(), taskStatusCounts.getFailedTasks());
            int totalTasks = this.backgroundTaskUnitRepository.countAll();
            this.backgroundTaskClusterMonitor.unscheduleJob();
            BackgroundTaskEntity backgroundTaskEntity = this.backgroundTaskRepository.findLatest();
            if (backgroundTaskEntity != null) {
                BackgroundTaskEntity it = backgroundTaskEntity;
                boolean bl = false;
                this.backgroundTaskEventDispatcher.sendBackgroundTaskEvent(new BackgroundTaskEventParameter("executed", taskId2, it.getCreatedAt(), System.currentTimeMillis(), System.currentTimeMillis() - it.getCreatedAt(), taskStatusCounts.getFailedTasks() == 0, taskStatusCounts.getCompletedTasks(), taskStatusCounts.getIncompleteTasks(), taskStatusCounts.getFailedTasks(), totalTasks));
            }
        }
    }

    private final void updateTaskStatus(String taskId2, int totalIncompleteTasks, int totalFailedTasks) {
        if (totalIncompleteTasks + totalFailedTasks == 0) {
            BackgroundTaskRepository.updateTaskStatus$default(this.backgroundTaskRepository, taskId2, BackgroundTaskStatus.COMPLETE, null, 4, null);
        } else {
            BackgroundTaskRepository.updateTaskStatus$default(this.backgroundTaskRepository, taskId2, BackgroundTaskStatus.INCOMPLETE, null, 4, null);
        }
    }

    private static final void runTaskUnits$lambda$3(ProjectExportTaskUnitExecutor this$0, Project $project, String $taskId, ApplicationUser $loggedInUser) {
        block2: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$taskId, (String)"$taskId");
            Intrinsics.checkNotNullParameter((Object)$loggedInUser, (String)"$loggedInUser");
            long startTimeInMillisForProject = System.currentTimeMillis();
            Object object2 = this$0;
            try {
                ProjectExportTaskUnitExecutor $this$runTaskUnits_u24lambda_u243_u24lambda_u241 = object2;
                boolean bl = false;
                String string = $project.getKey();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
                $this$runTaskUnits_u24lambda_u243_u24lambda_u241.updateTaskUnitStatus(string, $taskId, BackgroundTaskUnitStatus.IN_PROGRESS);
                $this$runTaskUnits_u24lambda_u243_u24lambda_u241.log.info((Object)("Exporting project " + $project.getKey() + " in background."));
                JiraThreadLocalUtil jiraThreadLocalUtil = $this$runTaskUnits_u24lambda_u243_u24lambda_u241.jiraThreadLocalUtil;
                Logger logger2 = $this$runTaskUnits_u24lambda_u243_u24lambda_u241.log;
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
                PreprocessingOutcome preprocessingOutcome2 = (PreprocessingOutcome)JiraExtensionsKt.wrap(jiraThreadLocalUtil, logger2, (Function0)new Function0<PreprocessingOutcome>($this$runTaskUnits_u24lambda_u243_u24lambda_u241, $loggedInUser, $project){
                    final /* synthetic */ ProjectExportTaskUnitExecutor $this_runCatching;
                    final /* synthetic */ ApplicationUser $loggedInUser;
                    final /* synthetic */ Project $project;
                    {
                        this.$this_runCatching = $receiver;
                        this.$loggedInUser = $loggedInUser;
                        this.$project = $project;
                        super(0);
                    }

                    @NotNull
                    public final PreprocessingOutcome invoke() {
                        ExportFacade exportFacade = ProjectExportTaskUnitExecutor.access$getExportFacade$p(this.$this_runCatching);
                        MigrationTaskMetadata migrationTaskMetadata2 = MigrationTaskMetadata.Companion.dummyMigrationMetadata$default(MigrationTaskMetadata.Companion, "backgroundTaskExecId", this.$loggedInUser, null, 4, null);
                        UsersGroupsMigrationOption usersGroupsMigrationOption = TaskExecutorUtilsKt.buildUsersGroupsMigrationOption();
                        ProjectDataMigrationMode projectDataMigrationMode = ProjectDataMigrationMode.ALL;
                        MigrationType migrationType = MigrationType.CLASSIC;
                        ExportMode exportMode = ExportMode.BACKGROUND_PREPROCESSING;
                        return ExportFacade.exportProjectPreprocessing$default(exportFacade, this.$project, migrationTaskMetadata2, usersGroupsMigrationOption, projectDataMigrationMode, migrationType, exportMode, true, null, 128, null);
                    }
                });
                $this$runTaskUnits_u24lambda_u243_u24lambda_u241.log.info((Object)("Background export for project " + $project.getKey() + " was done in: " + (System.currentTimeMillis() - startTimeInMillisForProject) + '.'));
                $this$runTaskUnits_u24lambda_u243_u24lambda_u241.executeTaskUnityPostProcessing($project, preprocessingOutcome2, $taskId);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object it = object = throwable;
            boolean bl = false;
            this$0.handleTaskUnitFailure($project, startTimeInMillisForProject, (Throwable)it, $taskId);
        }
    }

    public static final /* synthetic */ ExportFacade access$getExportFacade$p(ProjectExportTaskUnitExecutor $this) {
        return $this.exportFacade;
    }
}

