/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.backgroundtask;

import com.atlassian.jira.migration.backgroundtask.BackgroundThreadManager;
import com.atlassian.jira.migration.backgroundtask.analytics.BackgroundTaskEventDispatcher;
import com.atlassian.jira.migration.backgroundtask.analytics.BackgroundTaskEventParameter;
import com.atlassian.jira.migration.backgroundtask.job.BackgroundTaskClusterMonitor;
import com.atlassian.jira.migration.backgroundtask.job.BackgroundTaskInstrumentationJob;
import com.atlassian.jira.migration.backgroundtask.repository.BackgroundTaskEntity;
import com.atlassian.jira.migration.backgroundtask.repository.BackgroundTaskRepository;
import com.atlassian.jira.migration.backgroundtask.repository.BackgroundTaskUnitEntity;
import com.atlassian.jira.migration.backgroundtask.repository.BackgroundTaskUnitRepository;
import com.atlassian.jira.migration.backgroundtask.service.BackgroundTaskStatus;
import com.atlassian.jira.migration.backgroundtask.service.BackgroundTaskUnitStatus;
import com.atlassian.jira.migration.log.MigrationLogsService;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0010J\b\u0010\u001a\u001a\u00020\u0010H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/backgroundtask/TaskCleanupHelper;", "", "migrationLogsService", "Lcom/atlassian/jira/migration/log/MigrationLogsService;", "backgroundTaskRepository", "Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskRepository;", "backgroundTaskUnitRepository", "Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskUnitRepository;", "backgroundTaskInstrumentationJob", "Lcom/atlassian/jira/migration/backgroundtask/job/BackgroundTaskInstrumentationJob;", "backgroundTaskClusterMonitor", "Lcom/atlassian/jira/migration/backgroundtask/job/BackgroundTaskClusterMonitor;", "backgroundTaskEventDispatcher", "Lcom/atlassian/jira/migration/backgroundtask/analytics/BackgroundTaskEventDispatcher;", "(Lcom/atlassian/jira/migration/log/MigrationLogsService;Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskRepository;Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskUnitRepository;Lcom/atlassian/jira/migration/backgroundtask/job/BackgroundTaskInstrumentationJob;Lcom/atlassian/jira/migration/backgroundtask/job/BackgroundTaskClusterMonitor;Lcom/atlassian/jira/migration/backgroundtask/analytics/BackgroundTaskEventDispatcher;)V", "cancelPendingTaskUnits", "", "cleanupPreviousTasks", "performCancelActions", "latestTask", "Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskEntity;", "performCancelActionsOnRepository", "restartJobs", "taskGroupId", "", "unscheduleJobs", "unscheduleJobsAndShutdownExecutor", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nTaskCleanupHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskCleanupHelper.kt\ncom/atlassian/jira/migration/backgroundtask/TaskCleanupHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1855#2,2:111\n*S KotlinDebug\n*F\n+ 1 TaskCleanupHelper.kt\ncom/atlassian/jira/migration/backgroundtask/TaskCleanupHelper\n*L\n78#1:111,2\n*E\n"})
public final class TaskCleanupHelper {
    @NotNull
    private final MigrationLogsService migrationLogsService;
    @NotNull
    private final BackgroundTaskRepository backgroundTaskRepository;
    @NotNull
    private final BackgroundTaskUnitRepository backgroundTaskUnitRepository;
    @NotNull
    private final BackgroundTaskInstrumentationJob backgroundTaskInstrumentationJob;
    @NotNull
    private final BackgroundTaskClusterMonitor backgroundTaskClusterMonitor;
    @NotNull
    private final BackgroundTaskEventDispatcher backgroundTaskEventDispatcher;

    @Inject
    public TaskCleanupHelper(@NotNull MigrationLogsService migrationLogsService, @NotNull BackgroundTaskRepository backgroundTaskRepository, @NotNull BackgroundTaskUnitRepository backgroundTaskUnitRepository, @NotNull BackgroundTaskInstrumentationJob backgroundTaskInstrumentationJob, @NotNull BackgroundTaskClusterMonitor backgroundTaskClusterMonitor, @NotNull BackgroundTaskEventDispatcher backgroundTaskEventDispatcher) {
        Intrinsics.checkNotNullParameter((Object)migrationLogsService, (String)"migrationLogsService");
        Intrinsics.checkNotNullParameter((Object)backgroundTaskRepository, (String)"backgroundTaskRepository");
        Intrinsics.checkNotNullParameter((Object)backgroundTaskUnitRepository, (String)"backgroundTaskUnitRepository");
        Intrinsics.checkNotNullParameter((Object)backgroundTaskInstrumentationJob, (String)"backgroundTaskInstrumentationJob");
        Intrinsics.checkNotNullParameter((Object)backgroundTaskClusterMonitor, (String)"backgroundTaskClusterMonitor");
        Intrinsics.checkNotNullParameter((Object)backgroundTaskEventDispatcher, (String)"backgroundTaskEventDispatcher");
        this.migrationLogsService = migrationLogsService;
        this.backgroundTaskRepository = backgroundTaskRepository;
        this.backgroundTaskUnitRepository = backgroundTaskUnitRepository;
        this.backgroundTaskInstrumentationJob = backgroundTaskInstrumentationJob;
        this.backgroundTaskClusterMonitor = backgroundTaskClusterMonitor;
        this.backgroundTaskEventDispatcher = backgroundTaskEventDispatcher;
    }

    public final void cleanupPreviousTasks() {
        this.migrationLogsService.deleteExistingPreflightExecutionLogs("backgroundTaskExecId", "*-project-export.log");
        this.backgroundTaskRepository.deleteAllRecords();
        this.backgroundTaskUnitRepository.deleteAllRecords();
    }

    public final void performCancelActions(@NotNull BackgroundTaskEntity latestTask) {
        Intrinsics.checkNotNullParameter((Object)latestTask, (String)"latestTask");
        int totalProjects = this.backgroundTaskUnitRepository.countAll();
        int totalSuccessProjects = this.backgroundTaskUnitRepository.countByStatus(BackgroundTaskUnitStatus.COMPLETE);
        int totalIncompleteProjects = this.backgroundTaskUnitRepository.countByStatus(BackgroundTaskUnitStatus.INCOMPLETE);
        int totalFailedProjects = this.backgroundTaskUnitRepository.countByStatus(BackgroundTaskUnitStatus.FAILED);
        this.unscheduleJobsAndShutdownExecutor();
        this.performCancelActionsOnRepository(latestTask);
        this.backgroundTaskEventDispatcher.sendBackgroundTaskEvent(new BackgroundTaskEventParameter("cancelled", latestTask.getTaskId(), latestTask.getCreatedAt(), System.currentTimeMillis(), System.currentTimeMillis() - latestTask.getCreatedAt(), false, totalSuccessProjects, totalIncompleteProjects, totalFailedProjects, totalProjects));
    }

    private final void performCancelActionsOnRepository(BackgroundTaskEntity latestTask) {
        this.cancelPendingTaskUnits();
        this.backgroundTaskRepository.updateTaskStatus(latestTask.getTaskId(), BackgroundTaskStatus.CANCELED, "Background preflight task was cancelled manually");
    }

    private final void cancelPendingTaskUnits() {
        Object[] objectArray = new List[]{this.backgroundTaskUnitRepository.findAllByStatus(BackgroundTaskUnitStatus.IN_PROGRESS), this.backgroundTaskUnitRepository.findAllByStatus(BackgroundTaskUnitStatus.NOT_STARTED)};
        Iterable $this$forEach$iv = CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])objectArray));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BackgroundTaskUnitEntity it = (BackgroundTaskUnitEntity)element$iv;
            boolean bl = false;
            this.backgroundTaskUnitRepository.upsertTaskUnit(it.getTaskUnitId(), it.getTaskId(), this.backgroundTaskClusterMonitor.getNodeIdOrDefault(), BackgroundTaskUnitStatus.CANCELED);
        }
    }

    private final void unscheduleJobsAndShutdownExecutor() {
        this.unscheduleJobs();
        BackgroundThreadManager.INSTANCE.shutdownThreadPoolNow();
    }

    public final void unscheduleJobs() {
        this.backgroundTaskInstrumentationJob.unscheduleJob();
        this.backgroundTaskClusterMonitor.unscheduleJob();
    }

    public final void restartJobs(@NotNull String taskGroupId) {
        Intrinsics.checkNotNullParameter((Object)taskGroupId, (String)"taskGroupId");
        this.unscheduleJobs();
        this.backgroundTaskInstrumentationJob.scheduleJob(taskGroupId);
        BackgroundTaskClusterMonitor $this$restartJobs_u24lambda_u241 = this.backgroundTaskClusterMonitor;
        boolean bl = false;
        $this$restartJobs_u24lambda_u241.scheduleJob($this$restartJobs_u24lambda_u241.getNodeIdOrDefault());
    }
}

