/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.backgroundtask;

import com.atlassian.jira.migration.backgroundtask.TaskStatusCounts;
import com.atlassian.jira.migration.backgroundtask.repository.BackgroundTaskUnitRepository;
import com.atlassian.jira.migration.backgroundtask.service.BackgroundTaskUnitStatus;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/backgroundtask/TaskProgressCalculator;", "", "backgroundTaskUnitRepository", "Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskUnitRepository;", "(Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskUnitRepository;)V", "calculateCurrentProgress", "", "counts", "Lcom/atlassian/jira/migration/backgroundtask/TaskStatusCounts;", "calculateTaskStatusCounts", "jira-migration-plugin"})
public final class TaskProgressCalculator {
    @NotNull
    private final BackgroundTaskUnitRepository backgroundTaskUnitRepository;

    public TaskProgressCalculator(@NotNull BackgroundTaskUnitRepository backgroundTaskUnitRepository) {
        Intrinsics.checkNotNullParameter((Object)backgroundTaskUnitRepository, (String)"backgroundTaskUnitRepository");
        this.backgroundTaskUnitRepository = backgroundTaskUnitRepository;
    }

    @NotNull
    public final TaskStatusCounts calculateTaskStatusCounts() {
        return new TaskStatusCounts(this.backgroundTaskUnitRepository.countByStatus(BackgroundTaskUnitStatus.NOT_STARTED), this.backgroundTaskUnitRepository.countByStatus(BackgroundTaskUnitStatus.IN_PROGRESS), this.backgroundTaskUnitRepository.countByStatus(BackgroundTaskUnitStatus.COMPLETE), this.backgroundTaskUnitRepository.countByStatus(BackgroundTaskUnitStatus.FAILED), this.backgroundTaskUnitRepository.countByStatus(BackgroundTaskUnitStatus.CANCELED), this.backgroundTaskUnitRepository.countByStatus(BackgroundTaskUnitStatus.INCOMPLETE));
    }

    public final int calculateCurrentProgress(@NotNull TaskStatusCounts counts) {
        Intrinsics.checkNotNullParameter((Object)counts, (String)"counts");
        int totalTasks = counts.getNotStartedTasks() + counts.getRunningTasks() + counts.getCompletedTasks() + counts.getFailedTasks() + counts.getCancelledTasks() + counts.getIncompleteTasks();
        if (totalTasks == 0) {
            return 0;
        }
        int tasksWithFinishedStatus = counts.getCompletedTasks() + counts.getFailedTasks() + counts.getIncompleteTasks();
        int percentageFactor = 100;
        double progressPercentage = (double)tasksWithFinishedStatus / (double)totalTasks * (double)percentageFactor;
        return (int)progressPercentage;
    }
}

