/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.backgroundtask.analytics;

import com.atlassian.jira.migration.backgroundtask.analytics.BackgroundTaskEventParameter;
import com.atlassian.jira.migration.backgroundtask.repository.BackgroundTaskEntity;
import com.atlassian.jira.migration.backgroundtask.service.BackgroundTaskInstrumentationService;
import com.atlassian.jira.migration.events.BackgroundTaskCompletionEvent;
import com.atlassian.jira.migration.events.BackgroundTaskPostProcessingCompletionEvent;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.SystemLoadStatisticsGroup;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/backgroundtask/analytics/BackgroundTaskEventDispatcher;", "", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "backgroundTaskInstrumentationService", "Lcom/atlassian/jira/migration/backgroundtask/service/BackgroundTaskInstrumentationService;", "(Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/backgroundtask/service/BackgroundTaskInstrumentationService;)V", "sendBackgroundTaskEvent", "", "parameter", "Lcom/atlassian/jira/migration/backgroundtask/analytics/BackgroundTaskEventParameter;", "sendBackgroundTaskPostProcessingEvent", "backgroundTask", "Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskEntity;", "taskGroupId", "", "Companion", "jira-migration-plugin"})
public final class BackgroundTaskEventDispatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final BackgroundTaskInstrumentationService backgroundTaskInstrumentationService;
    private static final Logger log = Logger.getLogger(BackgroundTaskEventDispatcher.class);

    @Inject
    public BackgroundTaskEventDispatcher(@NotNull MigrationEventBus migrationEventBus, @NotNull BackgroundTaskInstrumentationService backgroundTaskInstrumentationService) {
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)backgroundTaskInstrumentationService, (String)"backgroundTaskInstrumentationService");
        this.migrationEventBus = migrationEventBus;
        this.backgroundTaskInstrumentationService = backgroundTaskInstrumentationService;
    }

    public final void sendBackgroundTaskEvent(@NotNull BackgroundTaskEventParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        log.info((Object)"Sending background task event .");
        SystemLoadStatisticsGroup systemLoadStatistics = this.backgroundTaskInstrumentationService.computeStatisticsFromCsvOnProcessing(parameter.getTaskGroupId());
        this.migrationEventBus.post(new BackgroundTaskCompletionEvent(parameter.getAction(), parameter.getTaskGroupId(), parameter.getStartInstant(), parameter.getEndInstant(), parameter.getTimeToComplete(), parameter.getSuccess(), systemLoadStatistics.getAvailableProcessors(), systemLoadStatistics.getTotalMemory(), systemLoadStatistics.getMaxMemory(), parameter.getNumberOfSuccessfulUnits(), parameter.getNumberOfIncompleteUnits(), parameter.getNumberOfFailedUnits(), parameter.getNumberOfTotalUnits(), systemLoadStatistics.getCpuLoadStatistics(), systemLoadStatistics.getUsedHeapMemoryStatistics(), systemLoadStatistics.getFreeHeapMemoryStatistics()));
    }

    public final void sendBackgroundTaskPostProcessingEvent(@NotNull BackgroundTaskEntity backgroundTask, @NotNull String taskGroupId) {
        Intrinsics.checkNotNullParameter((Object)backgroundTask, (String)"backgroundTask");
        Intrinsics.checkNotNullParameter((Object)taskGroupId, (String)"taskGroupId");
        log.info((Object)"Sending background task event .");
        SystemLoadStatisticsGroup systemLoadStatistics = this.backgroundTaskInstrumentationService.computeStatisticsFromCsvPostProcessing(taskGroupId);
        this.migrationEventBus.post(new BackgroundTaskPostProcessingCompletionEvent(taskGroupId, System.currentTimeMillis() - backgroundTask.getUpdatedAt(), systemLoadStatistics.getAvailableProcessors(), systemLoadStatistics.getTotalMemory(), systemLoadStatistics.getMaxMemory(), systemLoadStatistics.getCpuLoadStatistics(), systemLoadStatistics.getUsedHeapMemoryStatistics(), systemLoadStatistics.getFreeHeapMemoryStatistics()));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/backgroundtask/analytics/BackgroundTaskEventDispatcher$Companion;", "", "()V", "log", "Lorg/apache/log4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/apache/log4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

