/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.backgroundtask.job;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.migration.backgroundtask.job.BackgroundTaskInstrumentationJob;
import com.atlassian.jira.migration.backgroundtask.repository.BackgroundTaskEntity;
import com.atlassian.jira.migration.backgroundtask.repository.BackgroundTaskRepository;
import com.atlassian.jira.migration.backgroundtask.repository.BackgroundTaskUnitEntity;
import com.atlassian.jira.migration.backgroundtask.repository.BackgroundTaskUnitRepository;
import com.atlassian.jira.migration.backgroundtask.service.BackgroundTaskStatus;
import com.atlassian.jira.migration.backgroundtask.service.BackgroundTaskUnitStatus;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0007J\b\u0010\u0014\u001a\u00020\u0013H\u0007J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0011J\u0006\u0010\u001b\u001a\u00020\u0013R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/atlassian/jira/migration/backgroundtask/job/BackgroundTaskClusterMonitor;", "Lcom/atlassian/scheduler/JobRunner;", "clusterManager", "Lcom/atlassian/jira/cluster/ClusterManager;", "schedulerService", "Lcom/atlassian/scheduler/SchedulerService;", "backgroundTaskRepository", "Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskRepository;", "backgroundTaskUnitRepository", "Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskUnitRepository;", "backgroundTaskInstrumentationJob", "Lcom/atlassian/jira/migration/backgroundtask/job/BackgroundTaskInstrumentationJob;", "(Lcom/atlassian/jira/cluster/ClusterManager;Lcom/atlassian/scheduler/SchedulerService;Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskRepository;Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskUnitRepository;Lcom/atlassian/jira/migration/backgroundtask/job/BackgroundTaskInstrumentationJob;)V", "log", "Lorg/apache/log4j/Logger;", "kotlin.jvm.PlatformType", "getNodeIdOrDefault", "", "postConstruct", "", "preDestroy", "runJob", "Lcom/atlassian/scheduler/JobRunnerResponse;", "request", "Lcom/atlassian/scheduler/JobRunnerRequest;", "scheduleJob", "nodeId", "unscheduleJob", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nBackgroundTaskClusterMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackgroundTaskClusterMonitor.kt\ncom/atlassian/jira/migration/backgroundtask/job/BackgroundTaskClusterMonitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1549#2:136\n1620#2,3:137\n1855#2,2:140\n*S KotlinDebug\n*F\n+ 1 BackgroundTaskClusterMonitor.kt\ncom/atlassian/jira/migration/backgroundtask/job/BackgroundTaskClusterMonitor\n*L\n85#1:136\n85#1:137,3\n94#1:140,2\n*E\n"})
public final class BackgroundTaskClusterMonitor
implements JobRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClusterManager clusterManager;
    @NotNull
    private final SchedulerService schedulerService;
    @NotNull
    private final BackgroundTaskRepository backgroundTaskRepository;
    @NotNull
    private final BackgroundTaskUnitRepository backgroundTaskUnitRepository;
    @NotNull
    private final BackgroundTaskInstrumentationJob backgroundTaskInstrumentationJob;
    private final Logger log;
    @NotNull
    private static final JobRunnerKey JOB_RUNNER_KEY;
    @NotNull
    private static final JobId JOB_ID;
    @NotNull
    public static final String DEFAULT_NODE = "defaultNode";
    public static final long SCHEDULE_INTERVAL = 5L;
    @NotNull
    public static final String NODE_ID = "nodeId";

    @Inject
    public BackgroundTaskClusterMonitor(@NotNull ClusterManager clusterManager, @NotNull SchedulerService schedulerService, @NotNull BackgroundTaskRepository backgroundTaskRepository, @NotNull BackgroundTaskUnitRepository backgroundTaskUnitRepository, @NotNull BackgroundTaskInstrumentationJob backgroundTaskInstrumentationJob) {
        Intrinsics.checkNotNullParameter((Object)clusterManager, (String)"clusterManager");
        Intrinsics.checkNotNullParameter((Object)schedulerService, (String)"schedulerService");
        Intrinsics.checkNotNullParameter((Object)backgroundTaskRepository, (String)"backgroundTaskRepository");
        Intrinsics.checkNotNullParameter((Object)backgroundTaskUnitRepository, (String)"backgroundTaskUnitRepository");
        Intrinsics.checkNotNullParameter((Object)backgroundTaskInstrumentationJob, (String)"backgroundTaskInstrumentationJob");
        this.clusterManager = clusterManager;
        this.schedulerService = schedulerService;
        this.backgroundTaskRepository = backgroundTaskRepository;
        this.backgroundTaskUnitRepository = backgroundTaskUnitRepository;
        this.backgroundTaskInstrumentationJob = backgroundTaskInstrumentationJob;
        this.log = Logger.getLogger(BackgroundTaskClusterMonitor.class);
    }

    @PostConstruct
    public final void postConstruct() {
        if (this.clusterManager.isClustered()) {
            this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
            this.log.info((Object)("Successfully registered background task cluster monitor job " + JOB_RUNNER_KEY));
        }
    }

    @PreDestroy
    public final void preDestroy() {
        if (this.clusterManager.isClustered()) {
            this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
            this.log.info((Object)("Successfully unregistered background task cluster monitor job " + JOB_RUNNER_KEY));
        }
    }

    public final void scheduleJob(@NotNull String nodeId) {
        Intrinsics.checkNotNullParameter((Object)nodeId, (String)NODE_ID);
        if (this.clusterManager.isClustered()) {
            this.log.info((Object)"Scheduling background task cluster monitoring job");
            this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)TimeUnit.MINUTES.toMillis(5L), (Date)Date.from(Instant.now().plus(Duration.ofMinutes(5L))))).withParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)NODE_ID, (Object)nodeId))));
        }
    }

    public final void unscheduleJob() {
        this.log.info((Object)"Unscheduling background Task cluster monitoring job.");
        this.schedulerService.unscheduleJob(JOB_ID);
        this.log.info((Object)"Successfully unscheduled background Task cluster monitoring job.");
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest request) {
        JobRunnerResponse jobRunnerResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object v = request.getJobConfig().getParameters().get(NODE_ID);
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
        String nodeId = (String)v;
        try {
            List liveNodeIds;
            List list;
            Iterator $this$mapTo$iv$iv;
            Object $this$map$iv;
            Collection liveNodes;
            Collection collection = liveNodes = this.clusterManager.findLiveNodes();
            if (collection != null) {
                $this$map$iv = (Object[])collection;
                boolean $i$f$map = false;
                Object[] objectArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    Object item$iv$iv = iterator2.next();
                    Node node = (Node)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(it.getNodeId());
                }
                list = (List)destination$iv$iv;
            } else {
                list = liveNodeIds = null;
            }
            if (liveNodeIds == null || !liveNodeIds.contains(nodeId)) {
                BackgroundTaskEntity $this$forEach$iv;
                this.log.info((Object)("Node " + nodeId + " is not alive. We're cancelling current background task."));
                $this$map$iv = new List[]{this.backgroundTaskUnitRepository.findAllByStatus(BackgroundTaskUnitStatus.NOT_STARTED), this.backgroundTaskUnitRepository.findAllByStatus(BackgroundTaskUnitStatus.IN_PROGRESS)};
                $this$map$iv = CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])$this$map$iv));
                boolean $i$f$forEach = false;
                $this$mapTo$iv$iv = $this$forEach$iv.iterator();
                while ($this$mapTo$iv$iv.hasNext()) {
                    Object element$iv = $this$mapTo$iv$iv.next();
                    BackgroundTaskUnitEntity taskUnit = (BackgroundTaskUnitEntity)element$iv;
                    boolean bl = false;
                    this.backgroundTaskUnitRepository.upsertTaskUnit(taskUnit.getTaskUnitId(), taskUnit.getTaskId(), nodeId, BackgroundTaskUnitStatus.CANCELED);
                }
                $this$forEach$iv = this.backgroundTaskRepository.findByStatus(BackgroundTaskStatus.IN_PROGRESS);
                if ($this$forEach$iv != null) {
                    BackgroundTaskEntity it = $this$forEach$iv;
                    boolean bl = false;
                    this.backgroundTaskRepository.updateTaskStatus(it.getTaskId(), BackgroundTaskStatus.CANCELED, "Processing node " + nodeId + " not alive");
                }
                this.backgroundTaskInstrumentationJob.unscheduleJob();
                this.unscheduleJob();
            }
            jobRunnerResponse = JobRunnerResponse.success((String)request.getJobId().toString());
        }
        catch (Throwable t) {
            String errorMessage2 = "Failed to run job - jobId: " + request.getJobId() + ", but we'll try it again in a few minutes - " + t.getMessage();
            this.log.error((Object)errorMessage2, t);
            jobRunnerResponse = JobRunnerResponse.failed((String)errorMessage2);
        }
        return jobRunnerResponse;
    }

    @NotNull
    public final String getNodeIdOrDefault() {
        String string = this.clusterManager.getNodeId();
        if (string == null) {
            string = DEFAULT_NODE;
        }
        return string;
    }

    static {
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)"jira-migration-background-task-cluster-monitor-job-key");
        Intrinsics.checkNotNull((Object)jobRunnerKey);
        JOB_RUNNER_KEY = jobRunnerKey;
        JobId jobId = JobId.of((String)"jira-migration-background-task-cluster-monitor-job-id");
        Intrinsics.checkNotNull((Object)jobId);
        JOB_ID = jobId;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/backgroundtask/job/BackgroundTaskClusterMonitor$Companion;", "", "()V", "DEFAULT_NODE", "", "JOB_ID", "Lcom/atlassian/scheduler/config/JobId;", "getJOB_ID", "()Lcom/atlassian/scheduler/config/JobId;", "JOB_RUNNER_KEY", "Lcom/atlassian/scheduler/config/JobRunnerKey;", "getJOB_RUNNER_KEY", "()Lcom/atlassian/scheduler/config/JobRunnerKey;", "NODE_ID", "SCHEDULE_INTERVAL", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JobRunnerKey getJOB_RUNNER_KEY() {
            return JOB_RUNNER_KEY;
        }

        @NotNull
        public final JobId getJOB_ID() {
            return JOB_ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

