/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.backgroundtask.job;

import com.atlassian.jira.migration.backgroundtask.analytics.BackgroundTaskEventDispatcher;
import com.atlassian.jira.migration.backgroundtask.repository.BackgroundTaskEntity;
import com.atlassian.jira.migration.backgroundtask.repository.BackgroundTaskRepository;
import com.atlassian.jira.migration.backgroundtask.service.BackgroundTaskInstrumentationService;
import com.atlassian.jira.migration.backgroundtask.service.BackgroundTaskStatus;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\fH\u0007J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/backgroundtask/job/BackgroundTaskInstrumentationJob;", "Lcom/atlassian/scheduler/JobRunner;", "schedulerService", "Lcom/atlassian/scheduler/SchedulerService;", "backgroundTaskInstrumentationService", "Lcom/atlassian/jira/migration/backgroundtask/service/BackgroundTaskInstrumentationService;", "backgroundTaskRepository", "Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskRepository;", "backgroundTaskEventDispatcher", "Lcom/atlassian/jira/migration/backgroundtask/analytics/BackgroundTaskEventDispatcher;", "(Lcom/atlassian/scheduler/SchedulerService;Lcom/atlassian/jira/migration/backgroundtask/service/BackgroundTaskInstrumentationService;Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskRepository;Lcom/atlassian/jira/migration/backgroundtask/analytics/BackgroundTaskEventDispatcher;)V", "cleanup", "", "isBackgroundTaskInProgress", "", "isPostMetricsCollectionWindowOpen", "backgroundTask", "Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskEntity;", "postConstruct", "runJob", "Lcom/atlassian/scheduler/JobRunnerResponse;", "request", "Lcom/atlassian/scheduler/JobRunnerRequest;", "scheduleJob", "taskGroupId", "", "unscheduleJob", "Companion", "jira-migration-plugin"})
public final class BackgroundTaskInstrumentationJob
implements JobRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SchedulerService schedulerService;
    @NotNull
    private final BackgroundTaskInstrumentationService backgroundTaskInstrumentationService;
    @NotNull
    private final BackgroundTaskRepository backgroundTaskRepository;
    @NotNull
    private final BackgroundTaskEventDispatcher backgroundTaskEventDispatcher;
    private static final Logger log = Logger.getLogger(BackgroundTaskInstrumentationJob.class);
    @NotNull
    private static final JobRunnerKey JOB_RUNNER_KEY;
    @NotNull
    private static final JobId JOB_ID;
    public static final long SCHEDULER_INTERVAL_IN_MINUTES = 5L;
    @NotNull
    public static final String TASK_GROUP_ID = "taskGroupId";
    public static final long HOURS_FOR_POST_PROCESSING_COLLECTION_WINDOW = 24L;

    @Inject
    public BackgroundTaskInstrumentationJob(@NotNull SchedulerService schedulerService, @NotNull BackgroundTaskInstrumentationService backgroundTaskInstrumentationService, @NotNull BackgroundTaskRepository backgroundTaskRepository, @NotNull BackgroundTaskEventDispatcher backgroundTaskEventDispatcher) {
        Intrinsics.checkNotNullParameter((Object)schedulerService, (String)"schedulerService");
        Intrinsics.checkNotNullParameter((Object)backgroundTaskInstrumentationService, (String)"backgroundTaskInstrumentationService");
        Intrinsics.checkNotNullParameter((Object)backgroundTaskRepository, (String)"backgroundTaskRepository");
        Intrinsics.checkNotNullParameter((Object)backgroundTaskEventDispatcher, (String)"backgroundTaskEventDispatcher");
        this.schedulerService = schedulerService;
        this.backgroundTaskInstrumentationService = backgroundTaskInstrumentationService;
        this.backgroundTaskRepository = backgroundTaskRepository;
        this.backgroundTaskEventDispatcher = backgroundTaskEventDispatcher;
    }

    @PostConstruct
    public final void postConstruct() {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        log.info((Object)("Successfully registered background task instrumentation job {}. " + JOB_RUNNER_KEY));
    }

    @PreDestroy
    public final void cleanup() {
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
        log.info((Object)("Successfully unregistered background task instrumentation job  " + JOB_RUNNER_KEY));
    }

    public final void scheduleJob(@NotNull String taskGroupId) {
        Intrinsics.checkNotNullParameter((Object)taskGroupId, (String)TASK_GROUP_ID);
        log.info((Object)"Scheduling BG Task instrumentation job.");
        this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)TimeUnit.MINUTES.toMillis(5L), (Date)Date.from(Instant.now().plus(Duration.ofMinutes(5L))))).withParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)TASK_GROUP_ID, (Object)taskGroupId))));
        log.info((Object)"Successfully scheduled BG Task instrumentation job.");
    }

    public final void unscheduleJob() {
        log.info((Object)"Unscheduling BG Task instrumentation job.");
        this.schedulerService.unscheduleJob(JOB_ID);
        log.info((Object)"Successfully unscheduled BG Task instrumentation job.");
    }

    @Nullable
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest request) {
        JobRunnerResponse jobRunnerResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            log.info((Object)("Running job - jobId: " + request.getJobId()));
            BackgroundTaskEntity backgroundTask = this.backgroundTaskRepository.findLatest();
            Object v = request.getJobConfig().getParameters().get(TASK_GROUP_ID);
            Intrinsics.checkNotNull(v);
            String taskGroupId = (String)v;
            if (backgroundTask == null) {
                log.info((Object)"Ignoring job: BG Task instrumentation job should only run when there are BG tasks created.");
                this.unscheduleJob();
            } else if (this.isBackgroundTaskInProgress()) {
                log.info((Object)"Collecting ongoing BG Task metrics.");
                this.backgroundTaskInstrumentationService.collectAndWriteSystemMetricsToCsvOnProcessing(taskGroupId);
            } else if (this.isPostMetricsCollectionWindowOpen(backgroundTask)) {
                log.info((Object)"Collecting post BG Task metrics.");
                this.backgroundTaskInstrumentationService.collectAndWriteSystemMetricsToCsvPostProcessing(taskGroupId);
            } else {
                log.info((Object)"Post processing instrumentation window closed, saving analytic event.");
                this.backgroundTaskEventDispatcher.sendBackgroundTaskPostProcessingEvent(backgroundTask, taskGroupId);
                this.unscheduleJob();
            }
            jobRunnerResponse = JobRunnerResponse.success((String)request.getJobId().toString());
        }
        catch (Throwable e) {
            String errorMessage2 = "Failed to run job - jobId: " + request.getJobId() + " - " + e.getMessage();
            log.error((Object)errorMessage2, e);
            this.unscheduleJob();
            jobRunnerResponse = JobRunnerResponse.failed((String)errorMessage2);
        }
        return jobRunnerResponse;
    }

    private final boolean isPostMetricsCollectionWindowOpen(BackgroundTaskEntity backgroundTask) {
        return backgroundTask.getUpdatedAt() > System.currentTimeMillis() - TimeUnit.HOURS.toMillis(24L);
    }

    private final boolean isBackgroundTaskInProgress() {
        BackgroundTaskEntity backgroundTaskEntity = this.backgroundTaskRepository.findLatest();
        return (backgroundTaskEntity != null ? backgroundTaskEntity.getStatus() : null) == BackgroundTaskStatus.IN_PROGRESS;
    }

    static {
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)"jira-migration-background-task-instrumentation-job-key");
        Intrinsics.checkNotNull((Object)jobRunnerKey);
        JOB_RUNNER_KEY = jobRunnerKey;
        JobId jobId = JobId.of((String)"jira-migration-background-task-instrumentation-job-id");
        Intrinsics.checkNotNull((Object)jobId);
        JOB_ID = jobId;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/backgroundtask/job/BackgroundTaskInstrumentationJob$Companion;", "", "()V", "HOURS_FOR_POST_PROCESSING_COLLECTION_WINDOW", "", "JOB_ID", "Lcom/atlassian/scheduler/config/JobId;", "getJOB_ID", "()Lcom/atlassian/scheduler/config/JobId;", "JOB_RUNNER_KEY", "Lcom/atlassian/scheduler/config/JobRunnerKey;", "getJOB_RUNNER_KEY", "()Lcom/atlassian/scheduler/config/JobRunnerKey;", "SCHEDULER_INTERVAL_IN_MINUTES", "TASK_GROUP_ID", "", "log", "Lorg/apache/log4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/apache/log4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLog() {
            return log;
        }

        @NotNull
        public final JobRunnerKey getJOB_RUNNER_KEY() {
            return JOB_RUNNER_KEY;
        }

        @NotNull
        public final JobId getJOB_ID() {
            return JOB_ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

