/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.backgroundtask.repository;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.migration.backgroundtask.repository.BackgroundTaskEntity;
import com.atlassian.jira.migration.backgroundtask.service.BackgroundTaskStatus;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\bJ\u0006\u0010\u000e\u001a\u00020\fJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010J\u0016\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskRepository;", "", "ao", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;)V", "createTask", "", "taskId", "", "status", "Lcom/atlassian/jira/migration/backgroundtask/service/BackgroundTaskStatus;", "progress", "", "description", "deleteAllRecords", "findByStatus", "Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskEntity;", "findLatest", "updateTaskProgress", "updateTaskStatus", "jira-migration-plugin"})
public final class BackgroundTaskRepository {
    @NotNull
    private final ActiveObjects ao;

    @Inject
    public BackgroundTaskRepository(@NotNull ActiveObjects ao) {
        Intrinsics.checkNotNullParameter((Object)ao, (String)"ao");
        this.ao = ao;
    }

    public final void createTask(@NotNull String taskId2, @NotNull BackgroundTaskStatus status, int progress, @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)taskId2, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"TASK_ID", (Object)taskId2), TuplesKt.to((Object)"STATUS", (Object)((Object)status)), TuplesKt.to((Object)"PROGRESS", (Object)progress), TuplesKt.to((Object)"DESCRIPTION", (Object)description), TuplesKt.to((Object)"CREATED_AT", (Object)System.currentTimeMillis()), TuplesKt.to((Object)"UPDATED_AT", (Object)System.currentTimeMillis())};
        this.ao.create(BackgroundTaskEntity.class, MapsKt.mapOf((Pair[])pairArray));
    }

    public static /* synthetic */ void createTask$default(BackgroundTaskRepository backgroundTaskRepository, String string, BackgroundTaskStatus backgroundTaskStatus, int n, String string2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            string2 = null;
        }
        backgroundTaskRepository.createTask(string, backgroundTaskStatus, n, string2);
    }

    public final void updateTaskProgress(@NotNull String taskId2, int progress) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)taskId2, (String)"taskId");
            Object[] objectArray = new Object[]{taskId2};
            RawEntity[] rawEntityArray = this.ao.find(BackgroundTaskEntity.class, Query.select().where("TASK_ID = ?", objectArray));
            Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
            BackgroundTaskEntity backgroundTaskEntity = (BackgroundTaskEntity)ArraysKt.firstOrNull((Object[])rawEntityArray);
            if (backgroundTaskEntity == null) break block0;
            BackgroundTaskEntity it = backgroundTaskEntity;
            boolean bl = false;
            it.setProgress(progress);
            it.setUpdatedAt(System.currentTimeMillis());
            it.save();
        }
    }

    public final void updateTaskStatus(@NotNull String taskId2, @NotNull BackgroundTaskStatus status, @Nullable String description) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)taskId2, (String)"taskId");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            Object[] objectArray = new Object[]{taskId2};
            RawEntity[] rawEntityArray = this.ao.find(BackgroundTaskEntity.class, Query.select().where("TASK_ID = ?", objectArray));
            Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
            BackgroundTaskEntity backgroundTaskEntity = (BackgroundTaskEntity)ArraysKt.firstOrNull((Object[])rawEntityArray);
            if (backgroundTaskEntity == null) break block1;
            BackgroundTaskEntity it = backgroundTaskEntity;
            boolean bl = false;
            it.setStatus(status);
            String string = description;
            if (string == null) {
                string = it.getDescription();
            }
            it.setDescription(string);
            it.save();
        }
    }

    public static /* synthetic */ void updateTaskStatus$default(BackgroundTaskRepository backgroundTaskRepository, String string, BackgroundTaskStatus backgroundTaskStatus, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        backgroundTaskRepository.updateTaskStatus(string, backgroundTaskStatus, string2);
    }

    public final int deleteAllRecords() {
        return this.ao.deleteWithSQL(BackgroundTaskEntity.class, null, new Object[0]);
    }

    @Nullable
    public final BackgroundTaskEntity findByStatus(@NotNull BackgroundTaskStatus status) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Object[] objectArray = new Object[]{status};
        RawEntity[] rawEntityArray = this.ao.find(BackgroundTaskEntity.class, Query.select().where("STATUS = ?", objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return (BackgroundTaskEntity)ArraysKt.firstOrNull((Object[])rawEntityArray);
    }

    @Nullable
    public final BackgroundTaskEntity findLatest() {
        RawEntity[] rawEntityArray = this.ao.find(BackgroundTaskEntity.class, Query.select().order("UPDATED_AT DESC"));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return (BackgroundTaskEntity)ArraysKt.firstOrNull((Object[])rawEntityArray);
    }
}

