/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.backgroundtask.repository;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.migration.backgroundtask.repository.BackgroundTaskUnitEntity;
import com.atlassian.jira.migration.backgroundtask.service.BackgroundTaskUnitStatus;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0006\u0010\u0010\u001a\u00020\u0006J\u0014\u0010\u0011\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u000b0\u000b0\u0012J\u001c\u0010\u0014\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u000b0\u000b0\u00122\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskUnitRepository;", "", "ao", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;)V", "countAll", "", "countByStatus", "status", "Lcom/atlassian/jira/migration/backgroundtask/service/BackgroundTaskUnitStatus;", "createTaskUnit", "Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskUnitEntity;", "taskUnitId", "", "taskId", "nodeId", "deleteAllRecords", "findAll", "", "kotlin.jvm.PlatformType", "findAllByStatus", "findTaskUnit", "upsertTaskUnit", "", "jira-migration-plugin"})
public final class BackgroundTaskUnitRepository {
    @NotNull
    private final ActiveObjects ao;

    @Inject
    public BackgroundTaskUnitRepository(@NotNull ActiveObjects ao) {
        Intrinsics.checkNotNullParameter((Object)ao, (String)"ao");
        this.ao = ao;
    }

    @NotNull
    public final List<BackgroundTaskUnitEntity> findAll() {
        RawEntity[] rawEntityArray = this.ao.find(BackgroundTaskUnitEntity.class, Query.select());
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return ArraysKt.asList((Object[])rawEntityArray);
    }

    public final int countAll() {
        RawEntity[] rawEntityArray = this.ao.find(BackgroundTaskUnitEntity.class, Query.select());
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return ((Object[])rawEntityArray).length;
    }

    @NotNull
    public final List<BackgroundTaskUnitEntity> findAllByStatus(@NotNull BackgroundTaskUnitStatus status) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Object[] objectArray = new Object[]{status};
        RawEntity[] rawEntityArray = this.ao.find(BackgroundTaskUnitEntity.class, Query.select().where("STATUS = ?", objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return ArraysKt.asList((Object[])rawEntityArray);
    }

    public final int deleteAllRecords() {
        return this.ao.deleteWithSQL(BackgroundTaskUnitEntity.class, null, new Object[0]);
    }

    public final void upsertTaskUnit(@NotNull String taskUnitId, @NotNull String taskId2, @NotNull String nodeId, @NotNull BackgroundTaskUnitStatus status) {
        Intrinsics.checkNotNullParameter((Object)taskUnitId, (String)"taskUnitId");
        Intrinsics.checkNotNullParameter((Object)taskId2, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)nodeId, (String)"nodeId");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        BackgroundTaskUnitEntity backgroundTaskUnitEntity = this.findTaskUnit(taskUnitId);
        if (backgroundTaskUnitEntity != null) {
            BackgroundTaskUnitEntity it = backgroundTaskUnitEntity;
            boolean bl = false;
            it.setStatus(status);
            it.setUpdatedAt(System.currentTimeMillis());
            it.save();
        } else {
            this.createTaskUnit(taskUnitId, taskId2, nodeId, status);
        }
    }

    private final BackgroundTaskUnitEntity createTaskUnit(String taskUnitId, String taskId2, String nodeId, BackgroundTaskUnitStatus status) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"CREATED_AT", (Object)System.currentTimeMillis()), TuplesKt.to((Object)"UPDATED_AT", (Object)System.currentTimeMillis()), TuplesKt.to((Object)"TASK_UNIT_ID", (Object)taskUnitId), TuplesKt.to((Object)"TASK_ID", (Object)taskId2), TuplesKt.to((Object)"NODE_ID", (Object)nodeId), TuplesKt.to((Object)"STATUS", (Object)((Object)status))};
        RawEntity rawEntity = this.ao.create(BackgroundTaskUnitEntity.class, MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntity, (String)"create(...)");
        return (BackgroundTaskUnitEntity)rawEntity;
    }

    private final BackgroundTaskUnitEntity findTaskUnit(String taskUnitId) {
        Object[] objectArray = new Object[]{taskUnitId};
        RawEntity[] rawEntityArray = this.ao.find(BackgroundTaskUnitEntity.class, Query.select().where("TASK_UNIT_ID = ?", objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return (BackgroundTaskUnitEntity)ArraysKt.firstOrNull((Object[])rawEntityArray);
    }

    public final int countByStatus(@NotNull BackgroundTaskUnitStatus status) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Object[] objectArray = new Object[]{status};
        RawEntity[] rawEntityArray = this.ao.find(BackgroundTaskUnitEntity.class, Query.select().where("STATUS = ?", objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return ((Object[])rawEntityArray).length;
    }
}

