/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.backgroundtask.service;

import com.atlassian.jira.migration.backgroundtask.service.SystemMetrics;
import com.atlassian.jira.migration.backgroundtask.service.SystemMetricsFileRecord;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.events.SystemLoadStatistics;
import com.atlassian.jira.migration.events.SystemLoadStatisticsGroup;
import com.atlassian.jira.migration.serverdataextractors.CpuUsageCalculator;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.supercsv.io.CsvBeanReader;
import org.supercsv.io.CsvBeanWriter;
import org.supercsv.prefs.CsvPreference;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 +2\u00020\u0001:\u0001+B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J2\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0002J-\u0010\u000f\u001a\u0002H\u0010\"\b\b\u0000\u0010\u0010*\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\n2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0014J<\u0010\u0015\u001a\u00020\u0016\"\u0004\b\u0000\u0010\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\n2\u001e\u0010\u0017\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00110\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u001fH\u0002J\u000e\u0010%\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010&\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010'\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u001fH\u0002J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u001fH\u0002J\u0010\u0010*\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/atlassian/jira/migration/backgroundtask/service/BackgroundTaskInstrumentationService;", "", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "cpuUsageCalculator", "Lcom/atlassian/jira/migration/serverdataextractors/CpuUsageCalculator;", "(Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/serverdataextractors/CpuUsageCalculator;)V", "buildSystemLoadStaticsGroup", "Lcom/atlassian/jira/migration/events/SystemLoadStatisticsGroup;", "sortedCpuLoadValues", "", "", "sortedUsedMemoryValues", "", "sortedFreeMemoryValues", "calculatePercentile", "T", "", "values", "percentile", "(Ljava/util/List;D)Ljava/lang/Number;", "calculateStatistics", "Lcom/atlassian/jira/migration/events/SystemLoadStatistics;", "calculatePercentileCallback", "Lkotlin/Function2;", "collectAndWriteSystemMetricsToCsv", "", "filePath", "Ljava/nio/file/Path;", "collectAndWriteSystemMetricsToCsvOnProcessing", "taskGroupId", "", "collectAndWriteSystemMetricsToCsvPostProcessing", "collectSystemMetrics", "Lcom/atlassian/jira/migration/backgroundtask/service/SystemMetrics;", "computeStatisticsFromCsv", "csvFileName", "computeStatisticsFromCsvOnProcessing", "computeStatisticsFromCsvPostProcessing", "getMetricsCsvFilePath", "prepareAndReadCsv", "Lcom/atlassian/jira/migration/backgroundtask/service/SystemMetricsFileRecord;", "prepareFileForWriting", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nBackgroundTaskInstrumentationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackgroundTaskInstrumentationService.kt\ncom/atlassian/jira/migration/backgroundtask/service/BackgroundTaskInstrumentationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n1549#2:213\n1620#2,3:214\n1549#2:217\n1620#2,3:218\n1549#2:221\n1620#2,3:222\n1549#2:226\n1620#2,3:227\n800#2,11:230\n800#2,11:241\n1#3:225\n*S KotlinDebug\n*F\n+ 1 BackgroundTaskInstrumentationService.kt\ncom/atlassian/jira/migration/backgroundtask/service/BackgroundTaskInstrumentationService\n*L\n98#1:213\n98#1:214,3\n99#1:217\n99#1:218,3\n100#1:221\n100#1:222,3\n163#1:226\n163#1:227,3\n166#1:230,11\n167#1:241,11\n*E\n"})
public final class BackgroundTaskInstrumentationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final CpuUsageCalculator cpuUsageCalculator;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final String[] CSV_HEADER;
    @NotNull
    private static final DateTimeFormatter DATE_TIME_FORMATTER;
    @NotNull
    private static final List<Double> PERCENTILES_METRICS;
    @NotNull
    public static final String STATISTICS_FILE_DURING = "statistics-during-processing.csv";
    @NotNull
    public static final String STATISTICS_FILE_POST = "statistics-post-processing.csv";
    public static final int ZERO = 0;
    public static final int ONE = 1;
    public static final int TWO = 2;
    public static final int THREE = 3;
    public static final double HUNDRED = 100.0;

    @Inject
    public BackgroundTaskInstrumentationService(@NotNull LocalFileDataOutput localFileDataOutput, @NotNull CpuUsageCalculator cpuUsageCalculator) {
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)cpuUsageCalculator, (String)"cpuUsageCalculator");
        this.localFileDataOutput = localFileDataOutput;
        this.cpuUsageCalculator = cpuUsageCalculator;
    }

    public final void collectAndWriteSystemMetricsToCsvOnProcessing(@NotNull String taskGroupId) {
        Intrinsics.checkNotNullParameter((Object)taskGroupId, (String)"taskGroupId");
        this.collectAndWriteSystemMetricsToCsv(this.getMetricsCsvFilePath(taskGroupId, STATISTICS_FILE_DURING));
    }

    public final void collectAndWriteSystemMetricsToCsvPostProcessing(@NotNull String taskGroupId) {
        Intrinsics.checkNotNullParameter((Object)taskGroupId, (String)"taskGroupId");
        this.collectAndWriteSystemMetricsToCsv(this.getMetricsCsvFilePath(taskGroupId, STATISTICS_FILE_POST));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void collectAndWriteSystemMetricsToCsv(Path filePath) {
        Object $this$collectAndWriteSystemMetricsToCsv_u24lambda_u243;
        Object object = this;
        try {
            $this$collectAndWriteSystemMetricsToCsv_u24lambda_u243 = object;
            boolean bl = false;
            super.prepareFileForWriting(filePath);
            Object it = super.collectSystemMetrics();
            boolean bl2 = false;
            SystemMetricsFileRecord systemMetrics = new SystemMetricsFileRecord(((SystemMetrics)it).getTimestamp(), String.valueOf(((SystemMetrics)it).getAvgSystemCpuLoad()), String.valueOf(((SystemMetrics)it).getUsedHeapMemory()), String.valueOf(((SystemMetrics)it).getFreeHeapMemory()));
            boolean appendHeader = Files.size(filePath) == 0L;
            it = new FileOutputStream(filePath.toFile(), true);
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Object object2 = charset;
            Writer writer = new OutputStreamWriter((OutputStream)it, (Charset)object2);
            int n = 8192;
            it = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
            object2 = null;
            try {
                BufferedWriter writer2 = (BufferedWriter)it;
                boolean bl3 = false;
                Closeable closeable = (Closeable)new CsvBeanWriter((Writer)writer2, CsvPreference.STANDARD_PREFERENCE);
                Throwable throwable = null;
                try {
                    String[] stringArray;
                    CsvBeanWriter it2 = (CsvBeanWriter)closeable;
                    boolean bl4 = false;
                    if (appendHeader) {
                        stringArray = CSV_HEADER;
                        it2.writeHeader(Arrays.copyOf(stringArray, stringArray.length));
                    }
                    stringArray = CSV_HEADER;
                    it2.write((Object)systemMetrics, Arrays.copyOf(stringArray, stringArray.length));
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                writer = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)it, (Throwable)object2);
            }
            $this$collectAndWriteSystemMetricsToCsv_u24lambda_u243 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$collectAndWriteSystemMetricsToCsv_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$collectAndWriteSystemMetricsToCsv_u24lambda_u243;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Object it = $this$collectAndWriteSystemMetricsToCsv_u24lambda_u243 = throwable;
            boolean bl = false;
            log.error((Object)"Failed to write to csv file.", (Throwable)it);
        }
        if (Result.isSuccess-impl((Object)object)) {
            Unit it = (Unit)object;
            boolean bl = false;
            log.info((Object)"Successfully wrote to csv file.");
        }
    }

    private final void prepareFileForWriting(Path filePath) {
        Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        if (!Files.exists(filePath, new LinkOption[0])) {
            Files.createFile(filePath, new FileAttribute[0]);
        }
    }

    private final SystemMetrics collectSystemMetrics() {
        double avgSystemCpuLoad = this.cpuUsageCalculator.calculateSystemCpuLoadAverage();
        long freeHeapMemory = Runtime.getRuntime().freeMemory();
        long usedHeapMemory = Runtime.getRuntime().totalMemory() - freeHeapMemory;
        String string = DATE_TIME_FORMATTER.format(LocalDateTime.now());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return new SystemMetrics(string, avgSystemCpuLoad, usedHeapMemory, freeHeapMemory);
    }

    private final Path getMetricsCsvFilePath(String taskGroupId, String csvFileName) {
        Path path = this.localFileDataOutput.backgroundTaskMetricsDirectory(taskGroupId).resolve(csvFileName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final SystemLoadStatisticsGroup computeStatisticsFromCsvOnProcessing(@NotNull String taskGroupId) {
        Intrinsics.checkNotNullParameter((Object)taskGroupId, (String)"taskGroupId");
        return this.computeStatisticsFromCsv(taskGroupId, STATISTICS_FILE_DURING);
    }

    @NotNull
    public final SystemLoadStatisticsGroup computeStatisticsFromCsvPostProcessing(@NotNull String taskGroupId) {
        Intrinsics.checkNotNullParameter((Object)taskGroupId, (String)"taskGroupId");
        return this.computeStatisticsFromCsv(taskGroupId, STATISTICS_FILE_POST);
    }

    /*
     * WARNING - void declaration
     */
    private final SystemLoadStatisticsGroup computeStatisticsFromCsv(String taskGroupId, String csvFileName) {
        Object object = this;
        try {
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            Collection collection;
            void $this$mapTo$iv$iv3;
            BackgroundTaskInstrumentationService $this$computeStatisticsFromCsv_u24lambda_u249 = object;
            boolean bl = false;
            List<SystemMetricsFileRecord> metricsList = $this$computeStatisticsFromCsv_u24lambda_u249.prepareAndReadCsv(taskGroupId, csvFileName);
            Iterable $this$map$iv = metricsList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                SystemMetricsFileRecord systemMetricsFileRecord = (SystemMetricsFileRecord)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(Double.parseDouble(it.getAvgSystemCpuLoad()));
            }
            List sortedCpuLoadValues = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
            Iterable $this$map$iv2 = metricsList;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                SystemMetricsFileRecord bl2 = (SystemMetricsFileRecord)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(Long.parseLong(it.getUsedHeapMemory()));
            }
            List sortedUsedMemoryValues = CollectionsKt.sorted((Iterable)((List)destination$iv$iv2));
            Iterable $this$map$iv3 = metricsList;
            boolean $i$f$map3 = false;
            destination$iv$iv2 = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SystemMetricsFileRecord bl3 = (SystemMetricsFileRecord)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl4 = false;
                collection.add(Long.parseLong(it.getFreeHeapMemory()));
            }
            List sortedFreeMemoryValues = CollectionsKt.sorted((Iterable)((List)destination$iv$iv3));
            return $this$computeStatisticsFromCsv_u24lambda_u249.buildSystemLoadStaticsGroup(sortedCpuLoadValues, sortedUsedMemoryValues, sortedFreeMemoryValues);
        }
        catch (Throwable bl) {
            Object object2;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                object2 = throwable;
                Throwable it = object2;
                boolean bl5 = false;
                log.error((Object)("Failed to compute statistics from " + csvFileName + " file."), it);
            }
            object2 = new SystemLoadStatisticsGroup(new SystemLoadStatistics(null, null, null, null, null, 31, null), new SystemLoadStatistics(null, null, null, null, null, 31, null), new SystemLoadStatistics(null, null, null, null, null, 31, null), 0, 0L, 0L);
            return (SystemLoadStatisticsGroup)(Result.isFailure-impl((Object)object) ? object2 : object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<SystemMetricsFileRecord> prepareAndReadCsv(String taskGroupId, String csvFileName) {
        List metricsList = new ArrayList();
        Path csvFilePath = this.getMetricsCsvFilePath(taskGroupId, csvFileName);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(csvFilePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            this.collectAndWriteSystemMetricsToCsv(csvFilePath);
        }
        Closeable closeable = (Closeable)new CsvBeanReader((Reader)new FileReader(csvFilePath.toFile()), CsvPreference.STANDARD_PREFERENCE);
        Throwable throwable = null;
        try {
            CsvBeanReader reader = (CsvBeanReader)closeable;
            boolean bl = false;
            reader.getHeader(true);
            SystemMetricsFileRecord metrics = null;
            while (true) {
                SystemMetricsFileRecord it;
                Object object = CSV_HEADER;
                object = reader.read(SystemMetricsFileRecord.class, Arrays.copyOf(object, ((String[])object).length));
                SystemMetricsFileRecord it2 = (SystemMetricsFileRecord)object;
                boolean bl2 = false;
                metrics = it2;
                if (object == null) break;
                if (metrics == null) continue;
                boolean bl3 = false;
                metricsList.add(it);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return metricsList;
    }

    private final SystemLoadStatisticsGroup buildSystemLoadStaticsGroup(List<Double> sortedCpuLoadValues, List<Long> sortedUsedMemoryValues, List<Long> sortedFreeMemoryValues) {
        SystemLoadStatistics cpuLoadStatistics2 = this.calculateStatistics(sortedCpuLoadValues, (Function2)new Function2<List<? extends Double>, Double, Number>(this){
            final /* synthetic */ BackgroundTaskInstrumentationService this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Number invoke(@NotNull List<Double> values, double percentile) {
                Intrinsics.checkNotNullParameter(values, (String)"values");
                return BackgroundTaskInstrumentationService.access$calculatePercentile(this.this$0, values, percentile);
            }
        });
        SystemLoadStatistics usedMemoryStatistics2 = this.calculateStatistics(sortedUsedMemoryValues, (Function2)new Function2<List<? extends Long>, Double, Number>(this){
            final /* synthetic */ BackgroundTaskInstrumentationService this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Number invoke(@NotNull List<Long> values, double percentile) {
                Intrinsics.checkNotNullParameter(values, (String)"values");
                return BackgroundTaskInstrumentationService.access$calculatePercentile(this.this$0, values, percentile);
            }
        });
        SystemLoadStatistics freeMemoryStatistics2 = this.calculateStatistics(sortedFreeMemoryValues, (Function2)new Function2<List<? extends Long>, Double, Number>(this){
            final /* synthetic */ BackgroundTaskInstrumentationService this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Number invoke(@NotNull List<Long> values, double percentile) {
                Intrinsics.checkNotNullParameter(values, (String)"values");
                return BackgroundTaskInstrumentationService.access$calculatePercentile(this.this$0, values, percentile);
            }
        });
        return new SystemLoadStatisticsGroup(cpuLoadStatistics2, usedMemoryStatistics2, freeMemoryStatistics2, Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().totalMemory(), Runtime.getRuntime().maxMemory());
    }

    /*
     * WARNING - void declaration
     */
    private final <T> SystemLoadStatistics calculateStatistics(List<? extends T> values, Function2<? super List<? extends T>, ? super Double, ? extends Number> calculatePercentileCallback) {
        String string;
        String string2;
        String string3;
        String string4;
        String average;
        String string5;
        Collection destination$iv$iv;
        Iterable $this$filterIsInstance$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = PERCENTILES_METRICS;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            double d = ((Number)item$iv$iv).doubleValue();
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(((Number)calculatePercentileCallback.invoke(values, (Object)((double)it))).toString());
        }
        List stats = (List)destination$iv$iv2;
        Object object = CollectionsKt.first(values);
        if (object instanceof Double) {
            void $this$filterIsInstanceTo$iv$iv;
            $this$filterIsInstance$iv = values;
            boolean $i$f$filterIsInstance = false;
            Iterable $i$f$mapTo2 = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Double)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            string5 = String.valueOf(CollectionsKt.averageOfDouble((Iterable)((List)destination$iv$iv)));
        } else if (object instanceof Long) {
            $this$filterIsInstance$iv = values;
            boolean $i$f$filterIsInstance = false;
            Iterable $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Long)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            string5 = String.valueOf((long)CollectionsKt.averageOfLong((Iterable)((List)destination$iv$iv)));
        } else {
            string5 = average = "";
        }
        if ((string4 = (String)CollectionsKt.getOrNull((List)stats, (int)0)) == null) {
            string4 = "";
        }
        if ((string3 = (String)CollectionsKt.getOrNull((List)stats, (int)1)) == null) {
            string3 = "";
        }
        if ((string2 = (String)CollectionsKt.getOrNull((List)stats, (int)2)) == null) {
            string2 = "";
        }
        if ((string = (String)CollectionsKt.getOrNull((List)stats, (int)3)) == null) {
            string = "";
        }
        return new SystemLoadStatistics(string4, string3, string2, string, average);
    }

    private final <T extends Number> T calculatePercentile(List<? extends T> values, double percentile) {
        int index = (int)Math.ceil(percentile / 100.0 * (double)values.size());
        return (T)((Number)values.get(index - 1));
    }

    public static final /* synthetic */ Number access$calculatePercentile(BackgroundTaskInstrumentationService $this, List values, double percentile) {
        return $this.calculatePercentile(values, percentile);
    }

    static {
        Logger logger2 = Logger.getLogger(BackgroundTaskInstrumentationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
        Object[] objectArray = new String[]{"timestamp", "avgSystemCpuLoad", "usedHeapMemory", "freeHeapMemory"};
        CSV_HEADER = objectArray;
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd hh-mm-ss");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(...)");
        DATE_TIME_FORMATTER = dateTimeFormatter;
        objectArray = new Double[]{99.0, 90.0, 75.0, 50.0};
        PERCENTILES_METRICS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/jira/migration/backgroundtask/service/BackgroundTaskInstrumentationService$Companion;", "", "()V", "CSV_HEADER", "", "", "getCSV_HEADER", "()[Ljava/lang/String;", "[Ljava/lang/String;", "DATE_TIME_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "getDATE_TIME_FORMATTER", "()Ljava/time/format/DateTimeFormatter;", "HUNDRED", "", "ONE", "", "PERCENTILES_METRICS", "", "getPERCENTILES_METRICS", "()Ljava/util/List;", "STATISTICS_FILE_DURING", "STATISTICS_FILE_POST", "THREE", "TWO", "ZERO", "log", "Lorg/apache/log4j/Logger;", "getLog", "()Lorg/apache/log4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        @NotNull
        public final String[] getCSV_HEADER() {
            return CSV_HEADER;
        }

        @NotNull
        public final DateTimeFormatter getDATE_TIME_FORMATTER() {
            return DATE_TIME_FORMATTER;
        }

        @NotNull
        public final List<Double> getPERCENTILES_METRICS() {
            return PERCENTILES_METRICS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

