/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.backgroundtask.service;

import com.atlassian.jira.migration.backgroundtask.BackgroundTaskImpl;
import com.atlassian.jira.migration.backgroundtask.BackgroundThreadManager;
import com.atlassian.jira.migration.backgroundtask.api.BackgroundTaskData;
import com.atlassian.jira.migration.backgroundtask.service.BackgroundTaskStatus;
import com.atlassian.jira.migration.features.MigrationFeatures;
import java.nio.file.Path;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0006\u0010\u000e\u001a\u00020\u000bJ\b\u0010\u000f\u001a\u00020\u0010H\u0007J\u0006\u0010\u0011\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/jira/migration/backgroundtask/service/BackgroundTaskService;", "", "backgroundTask", "Lcom/atlassian/jira/migration/backgroundtask/BackgroundTaskImpl;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/backgroundtask/BackgroundTaskImpl;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cancelTask", "Lcom/atlassian/jira/migration/backgroundtask/api/BackgroundTaskData;", "exportErrorLogs", "Ljava/nio/file/Path;", "getTaskStatus", "preDestroy", "", "startTask", "jira-migration-plugin"})
public final class BackgroundTaskService {
    @NotNull
    private final BackgroundTaskImpl backgroundTask;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    private final Logger log;

    @Inject
    public BackgroundTaskService(@NotNull BackgroundTaskImpl backgroundTask, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)backgroundTask, (String)"backgroundTask");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.backgroundTask = backgroundTask;
        this.migrationFeatures = migrationFeatures;
        this.log = LoggerFactory.getLogger(BackgroundTaskService.class);
    }

    @PreDestroy
    public final void preDestroy() {
        BackgroundThreadManager.INSTANCE.shutdownThreadPool();
        this.backgroundTask.cancelBackgroundTask();
    }

    @NotNull
    public final BackgroundTaskData startTask() {
        Object object;
        Object $this$startTask_u24lambda_u240;
        if (!this.migrationFeatures.getEnableProjectDataPreprocessing()) {
            this.log.info("Preprocessing feature flag is not enabled for your tenant. Please contact the support team.");
            return new BackgroundTaskData(BackgroundTaskStatus.NOT_STARTED, 0, "Preprocessing feature flag is not enabled for your tenant. Please contact the support team.", 0L, null, 26, null);
        }
        Object object2 = this;
        try {
            $this$startTask_u24lambda_u240 = object2;
            boolean bl = false;
            $this$startTask_u24lambda_u240 = Result.constructor-impl((Object)((BackgroundTaskService)$this$startTask_u24lambda_u240).backgroundTask.startTask());
        }
        catch (Throwable bl) {
            $this$startTask_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$startTask_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            String string = it.getMessage();
            if (string == null) {
                string = "";
            }
            object = new BackgroundTaskData(BackgroundTaskStatus.FAILED, 0, string, 0L, null, 26, null);
        }
        return (BackgroundTaskData)object;
    }

    @Nullable
    public final BackgroundTaskData cancelTask() {
        return this.backgroundTask.cancelBackgroundTask();
    }

    @NotNull
    public final BackgroundTaskData getTaskStatus() {
        return this.backgroundTask.getBackgroundTaskStatus();
    }

    @Nullable
    public final Path exportErrorLogs() {
        return this.backgroundTask.exportErrorLogs();
    }
}

