/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.cloud;

import com.atlassian.cmpt.analytics.AnalyticsSubProduct;
import com.atlassian.cmpt.domain.Product;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.migrationservice.TcsProductInfo;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nJ\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u0010\u001a\u00020\nH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/cloud/CloudProductManager;", "", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "cloudProductToProjectType", "", "Lcom/atlassian/cmpt/domain/Product;", "", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "projectTypeToSubProduct", "Lcom/atlassian/cmpt/analytics/AnalyticsSubProduct;", "getSubProductByProjectTypeForCloud", "cloudId", "projectType", "getSupportedProjectTypeInCloud", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCloudProductManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudProductManager.kt\ncom/atlassian/jira/migration/cloud/CloudProductManager\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n58#2:65\n51#2:66\n1603#3,9:67\n1855#3:76\n1856#3:78\n1612#3:79\n1#4:77\n*S KotlinDebug\n*F\n+ 1 CloudProductManager.kt\ncom/atlassian/jira/migration/cloud/CloudProductManager\n*L\n55#1:65\n55#1:66\n56#1:67,9\n56#1:76\n56#1:78\n56#1:79\n56#1:77\n*E\n"})
public final class CloudProductManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private final Map<String, AnalyticsSubProduct> projectTypeToSubProduct;
    @NotNull
    private final Map<Product, String> cloudProductToProjectType;
    @NotNull
    private static final Set<String> directMappingTypeKeys;

    @Inject
    public CloudProductManager(@NotNull CloudSiteRepository cloudSiteRepository, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.cloudSiteRepository = cloudSiteRepository;
        this.mapper = objectMapperFactory.createObjectMapper();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"business", (Object)AnalyticsSubProduct.CORE), TuplesKt.to((Object)"software", (Object)AnalyticsSubProduct.SOFTWARE), TuplesKt.to((Object)"service_desk", (Object)AnalyticsSubProduct.SERVICE_DESK)};
        this.projectTypeToSubProduct = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)Product.JIRA_CORE, (Object)"business"), TuplesKt.to((Object)Product.JIRA_SOFTWARE, (Object)"software"), TuplesKt.to((Object)Product.JIRA_SERVICEDESK, (Object)"service_desk")};
        this.cloudProductToProjectType = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final AnalyticsSubProduct getSubProductByProjectTypeForCloud(@NotNull String cloudId2, @NotNull String projectType) {
        AnalyticsSubProduct analyticsSubProduct;
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)projectType, (String)"projectType");
        if (directMappingTypeKeys.contains(projectType) || Intrinsics.areEqual((Object)projectType, (Object)"business") && this.getSupportedProjectTypeInCloud(cloudId2).contains(projectType)) {
            analyticsSubProduct = this.projectTypeToSubProduct.get(projectType);
            if (analyticsSubProduct == null) {
                throw new IllegalStateException("ProjectType to analytics sub-product mapping missing".toString());
            }
        } else {
            analyticsSubProduct = AnalyticsSubProduct.PLATFORM;
        }
        return analyticsSubProduct;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getSupportedProjectTypeInCloud(String cloudId2) {
        Object object;
        block6: {
            block5: {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                CloudSite cloudSite2 = this.cloudSiteRepository.getSite(cloudId2);
                if (cloudSite2 == null) {
                    throw new IllegalStateException(("CloudSite id=" + cloudId2 + " not found").toString());
                }
                CloudSite cloudSite3 = cloudSite2;
                object = cloudSite3.getProductsJson();
                if (object == null) break block5;
                String content = object;
                boolean bl = false;
                Object $this$readValue$iv = this.mapper;
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef22 = false;
                $this$readValue$iv = (Iterable)$this$readValue$iv.readValue(content, (TypeReference)new TypeReference<List<? extends TcsProductInfo>>(){});
                boolean $i$f$mapNotNull = false;
                void $i$f$jacksonTypeRef22 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    TcsProductInfo it = (TcsProductInfo)element$iv$iv;
                    boolean bl3 = false;
                    if (this.cloudProductToProjectType.get(it.getProductKey()) == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                object = set;
                if (set != null) break block6;
            }
            object = SetsKt.emptySet();
        }
        return object;
    }

    static {
        Object[] objectArray = new String[]{"software", "service_desk"};
        directMappingTypeKeys = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/cloud/CloudProductManager$Companion;", "", "()V", "directMappingTypeKeys", "", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

