/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.cloud;

import com.atlassian.analytics.api.services.AnalyticsConfigService;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.cmpt.domain.Edition;
import com.atlassian.jira.migration.MigrationServicesConfiguration;
import com.atlassian.jira.migration.analytics.AnalyticsEventService;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteDto;
import com.atlassian.jira.migration.cloud.CloudSiteDtoKt;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.cloud.CloudType;
import com.atlassian.jira.migration.cloud.NonceService;
import com.atlassian.jira.migration.cloud.SaveTokenRequest;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.common.StringExtensionsKt;
import com.atlassian.jira.migration.containerToken.ContainerTokenService;
import com.atlassian.jira.migration.infrastructure.rest.ResponseUtils;
import com.atlassian.jira.migration.legal.LegalService;
import com.atlassian.jira.migration.migrationservice.TcsProductInfo;
import com.atlassian.jira.migration.publicapi.model.SaveTokenResponse;
import com.atlassian.jira.migration.sen.JiraSenInfo;
import com.atlassian.jira.migration.sen.SENSupplier;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.spi.container.ResourceFilters;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.codehaus.jackson.annotate.JsonCreator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="cloud")
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 52\u00020\u0001:\u0003567BW\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u001a\u0010\u001e\u001a\u00020\u00182\b\b\u0001\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u001a\u0010#\u001a\u00020$2\b\b\u0001\u0010\u001f\u001a\u00020 2\u0006\u0010%\u001a\u00020\"H\u0007J\u001a\u0010&\u001a\u00020$2\b\b\u0001\u0010\u001f\u001a\u00020 2\u0006\u0010'\u001a\u00020\"H\u0007J\b\u0010(\u001a\u00020$H\u0007J\b\u0010)\u001a\u00020$H\u0007J\u0010\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020,H\u0007J\u001c\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\n\b\u0002\u00101\u001a\u0004\u0018\u000102H\u0002J\u001a\u00103\u001a\u0002042\b\b\u0001\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/atlassian/jira/migration/cloud/CloudResource;", "", "applicationProperties", "Lcom/atlassian/sal/api/ApplicationProperties;", "cfg", "Lcom/atlassian/jira/migration/MigrationServicesConfiguration;", "nonceService", "Lcom/atlassian/jira/migration/cloud/NonceService;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "analyticsConfigService", "Lcom/atlassian/analytics/api/services/AnalyticsConfigService;", "legalService", "Lcom/atlassian/jira/migration/legal/LegalService;", "senSupplier", "Lcom/atlassian/jira/migration/sen/SENSupplier;", "containerTokenService", "Lcom/atlassian/jira/migration/containerToken/ContainerTokenService;", "analyticsEventService", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/sal/api/ApplicationProperties;Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/cloud/NonceService;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/analytics/api/services/AnalyticsConfigService;Lcom/atlassian/jira/migration/legal/LegalService;Lcom/atlassian/jira/migration/sen/SENSupplier;Lcom/atlassian/jira/migration/containerToken/ContainerTokenService;Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "baseURI", "Ljava/net/URI;", "getBaseURI", "()Ljava/net/URI;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "migrationGatewayURI", "buildContinueUrl", "request", "Ljavax/servlet/http/HttpServletRequest;", "cloudDto", "Lcom/atlassian/jira/migration/cloud/CloudResource$ReturnUrlRequest;", "generateCloudSiteSetupUrl", "Ljavax/ws/rs/core/Response;", "cloudSiteSetupDto", "generateEctlRedirectUrl", "cloudEctlRedirectDto", "listSites", "listTokens", "saveToken", "saveTokenRequest", "Lcom/atlassian/jira/migration/cloud/SaveTokenRequest;", "sendSaveTokenEvent", "", "cloudUrl", "", "ex", "", "setupUrlBuilder", "Ljavax/ws/rs/core/UriBuilder;", "Companion", "RedirectToConfig", "ReturnUrlRequest", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCloudResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudResource.kt\ncom/atlassian/jira/migration/cloud/CloudResource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,314:1\n1549#2:315\n1620#2,2:316\n1549#2:319\n1620#2,3:320\n1622#2:323\n1549#2:324\n1620#2,3:325\n51#3:318\n*S KotlinDebug\n*F\n+ 1 CloudResource.kt\ncom/atlassian/jira/migration/cloud/CloudResource\n*L\n127#1:315\n127#1:316,2\n134#1:319\n134#1:320,3\n127#1:323\n182#1:324\n182#1:325,3\n133#1:318\n*E\n"})
public final class CloudResource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationProperties applicationProperties;
    @NotNull
    private final MigrationServicesConfiguration cfg;
    @NotNull
    private final NonceService nonceService;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final AnalyticsConfigService analyticsConfigService;
    @NotNull
    private final LegalService legalService;
    @NotNull
    private final SENSupplier senSupplier;
    @NotNull
    private final ContainerTokenService containerTokenService;
    @NotNull
    private final AnalyticsEventService analyticsEventService;
    @NotNull
    private URI migrationGatewayURI;
    @NotNull
    private final ObjectMapper mapper;
    private static final Logger log = LoggerFactory.getLogger(CloudResource.class);
    @NotNull
    private static final String MIGRATION_CLOUD_SAVE_ACTION = "migration-cloud-save-action.jspa";

    @Inject
    public CloudResource(@NotNull ApplicationProperties applicationProperties, @NotNull MigrationServicesConfiguration cfg, @NotNull NonceService nonceService, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull AnalyticsConfigService analyticsConfigService, @NotNull LegalService legalService, @NotNull SENSupplier senSupplier, @NotNull ContainerTokenService containerTokenService, @NotNull AnalyticsEventService analyticsEventService, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)applicationProperties, (String)"applicationProperties");
        Intrinsics.checkNotNullParameter((Object)cfg, (String)"cfg");
        Intrinsics.checkNotNullParameter((Object)nonceService, (String)"nonceService");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)analyticsConfigService, (String)"analyticsConfigService");
        Intrinsics.checkNotNullParameter((Object)legalService, (String)"legalService");
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        Intrinsics.checkNotNullParameter((Object)containerTokenService, (String)"containerTokenService");
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.applicationProperties = applicationProperties;
        this.cfg = cfg;
        this.nonceService = nonceService;
        this.cloudSiteRepository = cloudSiteRepository;
        this.analyticsConfigService = analyticsConfigService;
        this.legalService = legalService;
        this.senSupplier = senSupplier;
        this.containerTokenService = containerTokenService;
        this.analyticsEventService = analyticsEventService;
        this.mapper = objectMapperFactory.createObjectMapper();
        this.migrationGatewayURI = this.cfg.getMigrationGatewayBaseURI();
        log.debug("Using Migration gateway base URI: {}", (Object)this.migrationGatewayURI);
    }

    private final URI getBaseURI() {
        URI uRI = URI.create(this.applicationProperties.getBaseUrl(UrlMode.CANONICAL));
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
        return uRI;
    }

    @POST
    @Path(value="/generate-setup-url")
    @NotNull
    public final Response generateCloudSiteSetupUrl(@Context @NotNull HttpServletRequest request, @NotNull ReturnUrlRequest cloudSiteSetupDto) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)cloudSiteSetupDto, (String)"cloudSiteSetupDto");
        this.migrationGatewayURI = this.cfg.getMigrationGatewayBaseURI();
        UriBuilder builder = this.setupUrlBuilder(request, cloudSiteSetupDto);
        String sen = this.senSupplier.getFirstSen();
        Object[] objectArray = (Object[])sen;
        if (!(objectArray == null || objectArray.length() == 0) && (this.legalService.isLegalOptIn() || this.analyticsConfigService.canCollectAnalytics())) {
            objectArray = new Object[]{this.senSupplier.getFirstSen()};
            builder.queryParam("sen", objectArray);
        }
        Response response2 = Response.ok((Object)builder.build(new Object[0]).toASCIIString()).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @POST
    @Path(value="/generate-ectl-redirect-url")
    @NotNull
    public final Response generateEctlRedirectUrl(@Context @NotNull HttpServletRequest request, @NotNull ReturnUrlRequest cloudEctlRedirectDto) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)cloudEctlRedirectDto, (String)"cloudEctlRedirectDto");
        UriBuilder builder = this.setupUrlBuilder(request, cloudEctlRedirectDto);
        JiraSenInfo sens = this.senSupplier.getSens();
        if (StringExtensionsKt.isNotNullOrBlank(sens.getJiraSoftwareSen())) {
            Object[] objectArray = new Object[]{sens.getJiraSoftwareSen()};
            builder.queryParam("sen", objectArray);
            objectArray = new Object[]{"jira-software"};
            builder.queryParam("ectl_redirect", objectArray);
        } else if (StringExtensionsKt.isNotNullOrBlank(sens.getJiraServicedeskSen())) {
            Object[] objectArray = new Object[]{sens.getJiraServicedeskSen()};
            builder.queryParam("sen", objectArray);
            objectArray = new Object[]{"jira-service-desk"};
            builder.queryParam("ectl_redirect", objectArray);
        } else if (StringExtensionsKt.isNotNullOrBlank(sens.getJiraCoreSen())) {
            Object[] objectArray = new Object[]{sens.getJiraCoreSen()};
            builder.queryParam("sen", objectArray);
            objectArray = new Object[]{"jira-core"};
            builder.queryParam("ectl_redirect", objectArray);
        } else {
            throw new IllegalArgumentException("Neither JSW, JSD, nor Jira Core SEN was found");
        }
        Response response2 = Response.ok((Object)builder.build(new Object[0]).toASCIIString()).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="/sites")
    @NotNull
    public final Response listSites() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.cloudSiteRepository.findAll();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            List list;
            void cloudSite2;
            CloudSite cloudSite3 = (CloudSite)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = cloudSite2.getCloudId();
            String string2 = cloudSite2.getCloudUrl().toString();
            String string3 = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            Edition edition = cloudSite2.getCloudEdition();
            if (cloudSite2.getProductsJson() != null) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                void json;
                Edition edition2 = edition;
                String string4 = string3;
                String string5 = string;
                boolean bl2 = false;
                boolean $i$f$jacksonTypeRef = false;
                Object object = this.mapper.readValue((String)json, (TypeReference)new TypeReference<List<? extends TcsProductInfo>>(){});
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
                Iterable iterable2 = (Iterable)object;
                boolean $i$f$map2 = false;
                void var17_17 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    TcsProductInfo tcsProductInfo = (TcsProductInfo)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl3 = false;
                    collection2.add(CloudSiteDtoKt.toCloudProductInfo((TcsProductInfo)it));
                }
                List list2 = (List)destination$iv$iv2;
                string = string5;
                string3 = string4;
                edition = edition2;
                list = list2;
            } else {
                list = null;
            }
            CloudType cloudType = cloudSite2.getCloudType();
            List list3 = list;
            Edition edition3 = edition;
            String string6 = string3;
            String string7 = string;
            collection.add(new CloudSiteDto(string7, string6, edition3, list3, cloudType));
        }
        Response response2 = Response.ok((Object)((List)destination$iv$iv)).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @POST
    @Path(value="save/token")
    @Operation(description="Saves token to database", responses={@ApiResponse(description="OK", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(description="Invalid data provided", responseCode="400")})
    @NotNull
    public final Response saveToken(@NotNull SaveTokenRequest saveTokenRequest) {
        Object object;
        Object $this$saveToken_u24lambda_u243;
        Intrinsics.checkNotNullParameter((Object)saveTokenRequest, (String)"saveTokenRequest");
        Object object2 = this;
        try {
            $this$saveToken_u24lambda_u243 = object2;
            boolean bl = false;
            ((CloudResource)$this$saveToken_u24lambda_u243).containerTokenService.createAndSaveToken(saveTokenRequest.getToken(), saveTokenRequest.getCloudUrl());
            CloudResource.sendSaveTokenEvent$default((CloudResource)$this$saveToken_u24lambda_u243, saveTokenRequest.getCloudUrl(), null, 2, null);
            $this$saveToken_u24lambda_u243 = Result.constructor-impl((Object)ResponseUtils.INSTANCE.ok(((CloudResource)$this$saveToken_u24lambda_u243).mapper.writeValueAsString((Object)new SaveTokenResponse(saveTokenRequest.getCloudUrl(), "Token saved successfully."))));
        }
        catch (Throwable bl) {
            $this$saveToken_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$saveToken_u24lambda_u243;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable ex = throwable;
            boolean bl = false;
            log.error("Exception in saving token", ex);
            this.sendSaveTokenEvent(saveTokenRequest.getCloudUrl(), ex);
            object = ResponseUtils.INSTANCE.internalServerError("Exception in saving token.");
        }
        return (Response)object;
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="/tokens")
    @NotNull
    public final Response listTokens() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.cloudSiteRepository.findAll();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void cloudSite2;
            CloudSite cloudSite3 = (CloudSite)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair[] pairArray = new Pair[2];
            String string = cloudSite2.getCloudId();
            String string2 = cloudSite2.getCloudUrl().toASCIIString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toASCIIString(...)");
            pairArray[0] = TuplesKt.to((Object)"site", (Object)new CloudSiteDto(string, string2, cloudSite2.getCloudEdition(), null, cloudSite2.getCloudType(), 8, null));
            pairArray[1] = TuplesKt.to((Object)"token", (Object)cloudSite2.getContainerToken());
            collection.add(MapsKt.mapOf((Pair[])pairArray));
        }
        Response response2 = Response.ok((Object)((List)destination$iv$iv)).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    private final UriBuilder setupUrlBuilder(@Context HttpServletRequest request, ReturnUrlRequest cloudDto) {
        Object[] objectArray = new Object[]{cloudDto.getReturnUrl()};
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.migrationGatewayURI).path("setup").queryParam("back", objectArray);
        objectArray = new Object[]{this.buildContinueUrl(request, cloudDto)};
        UriBuilder uriBuilder2 = uriBuilder.queryParam("continue", objectArray);
        objectArray = new Object[]{"jira"};
        UriBuilder uriBuilder3 = uriBuilder2.queryParam("product", objectArray);
        objectArray = new Object[]{"S2C_MIGRATION"};
        UriBuilder uriBuilder4 = uriBuilder3.queryParam("migrationType", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)uriBuilder4, (String)"queryParam(...)");
        return uriBuilder4;
    }

    private final URI buildContinueUrl(@Context HttpServletRequest request, ReturnUrlRequest cloudDto) {
        URI uRI;
        if (WhenMappings.$EnumSwitchMapping$0[cloudDto.getRedirectTo().ordinal()] == 1) {
            UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.getBaseURI()).path(MIGRATION_CLOUD_SAVE_ACTION);
            Object[] objectArray = new Object[1];
            HttpSession httpSession = request.getSession();
            Intrinsics.checkNotNullExpressionValue((Object)httpSession, (String)"getSession(...)");
            objectArray[0] = this.nonceService.generateAndSaveNonce(httpSession);
            UriBuilder uriBuilder2 = uriBuilder.queryParam("nonce", objectArray);
            objectArray = new Object[]{cloudDto.getRedirectTo().getValue()};
            UriBuilder uriBuilder3 = uriBuilder2.queryParam("redirectTo", objectArray);
            objectArray = new Object[]{cloudDto.getPlanId()};
            UriBuilder uriBuilder4 = uriBuilder3.queryParam("planId", objectArray);
            objectArray = new Object[]{cloudDto.getExecutionId()};
            UriBuilder uriBuilder5 = uriBuilder4.queryParam("executionId", objectArray);
            objectArray = new Object[]{cloudDto.getJcmaRedirectTo()};
            UriBuilder uriBuilder6 = uriBuilder5.queryParam("jcmaRedirectTo", objectArray);
            objectArray = new Object[1];
            String string = cloudDto.getCloudType();
            if (string == null) {
                string = "STANDARD";
            }
            objectArray[0] = string;
            URI uRI2 = uriBuilder6.queryParam("cloudType", objectArray).build(new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"build(...)");
            uRI = uRI2;
        } else {
            UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.getBaseURI()).path(MIGRATION_CLOUD_SAVE_ACTION);
            Object[] objectArray = new Object[1];
            HttpSession httpSession = request.getSession();
            Intrinsics.checkNotNullExpressionValue((Object)httpSession, (String)"getSession(...)");
            objectArray[0] = this.nonceService.generateAndSaveNonce(httpSession);
            UriBuilder uriBuilder7 = uriBuilder.queryParam("nonce", objectArray);
            objectArray = new Object[]{cloudDto.getRedirectTo().getValue()};
            UriBuilder uriBuilder8 = uriBuilder7.queryParam("redirectTo", objectArray);
            objectArray = new Object[1];
            String string = cloudDto.getCloudType();
            if (string == null) {
                string = "STANDARD";
            }
            objectArray[0] = string;
            URI uRI3 = uriBuilder8.queryParam("cloudType", objectArray).build(new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)uRI3, (String)"build(...)");
            uRI = uRI3;
        }
        return uRI;
    }

    private final void sendSaveTokenEvent(String cloudUrl, Throwable ex) {
        GenericOperationalEvent.Builder builder = (GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(Instant.now().toEpochMilli()).actionSubject("containerToken")).action("save")).addAttribute("cloudUrl", (Object)cloudUrl);
        Object object = ex;
        if (object == null || (object = ((Throwable)object).getMessage()) == null) {
            object = "Token saved successfully.";
        }
        EventDto.Builder builder2 = builder.addAttribute("message", object);
        GenericOperationalEvent.Builder it = (GenericOperationalEvent.Builder)builder2;
        boolean bl = false;
        Throwable throwable = ex;
        if (throwable != null) {
            Throwable exception = throwable;
            boolean bl2 = false;
            it.addAttribute("stackTrace", (Object)exception.getStackTrace());
        }
        GenericOperationalEvent event = ((GenericOperationalEvent.Builder)builder2).build();
        Intrinsics.checkNotNull((Object)event);
        AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)event, null, 2, null);
    }

    static /* synthetic */ void sendSaveTokenEvent$default(CloudResource cloudResource, String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        cloudResource.sendSaveTokenEvent(string, throwable);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/cloud/CloudResource$Companion;", "", "()V", "MIGRATION_CLOUD_SAVE_ACTION", "", "getMIGRATION_CLOUD_SAVE_ACTION$annotations", "getMIGRATION_CLOUD_SAVE_ACTION", "()Ljava/lang/String;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getMIGRATION_CLOUD_SAVE_ACTION() {
            return MIGRATION_CLOUD_SAVE_ACTION;
        }

        @VisibleForTesting
        public static /* synthetic */ void getMIGRATION_CLOUD_SAVE_ACTION$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0014\b\u0086\u0081\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0016B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/cloud/CloudResource$RedirectToConfig;", "", "value", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "PLAN_CONFIGURATION", "APP_ASSESSMENT", "PRE_MIGRATION_CHECKS", "SAVED_PLAN_PRE_MIGRATION_CHECKS", "USER_ASSESSMENT", "USER_ASSESSMENT_RESULTS", "USER_ASSESSMENT_FIX_INVALID_EMAILS", "USER_ASSESSMENT_FIX_DUPLICATED_EMAILS", "USER_ASSESSMENT_REVIEW_CHANGES", "USER_ASSESSMENT_CUSTOMIZE_USERS", "USER_ASSESSMENT_REVIEW", "USER_ASSESSMENT_SUMMARY", "CHOOSE_DOMAINS", "USER_MIGRATION_CONNECT_TO_CLOUD", "USER_CONNECT_CLOUD_TO_SERVER", "Companion", "jira-migration-plugin"})
    @SourceDebugExtension(value={"SMAP\nCloudResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudResource.kt\ncom/atlassian/jira/migration/cloud/CloudResource$RedirectToConfig\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,314:1\n8541#2,2:315\n8801#2,4:317\n*S KotlinDebug\n*F\n+ 1 CloudResource.kt\ncom/atlassian/jira/migration/cloud/CloudResource$RedirectToConfig\n*L\n287#1:315,2\n287#1:317,4\n*E\n"})
    public static final class RedirectToConfig
    extends Enum<RedirectToConfig> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String value;
        @NotNull
        private static final Map<String, RedirectToConfig> stringLookupMap;
        public static final /* enum */ RedirectToConfig PLAN_CONFIGURATION;
        public static final /* enum */ RedirectToConfig APP_ASSESSMENT;
        public static final /* enum */ RedirectToConfig PRE_MIGRATION_CHECKS;
        public static final /* enum */ RedirectToConfig SAVED_PLAN_PRE_MIGRATION_CHECKS;
        public static final /* enum */ RedirectToConfig USER_ASSESSMENT;
        public static final /* enum */ RedirectToConfig USER_ASSESSMENT_RESULTS;
        public static final /* enum */ RedirectToConfig USER_ASSESSMENT_FIX_INVALID_EMAILS;
        public static final /* enum */ RedirectToConfig USER_ASSESSMENT_FIX_DUPLICATED_EMAILS;
        public static final /* enum */ RedirectToConfig USER_ASSESSMENT_REVIEW_CHANGES;
        public static final /* enum */ RedirectToConfig USER_ASSESSMENT_CUSTOMIZE_USERS;
        public static final /* enum */ RedirectToConfig USER_ASSESSMENT_REVIEW;
        public static final /* enum */ RedirectToConfig USER_ASSESSMENT_SUMMARY;
        public static final /* enum */ RedirectToConfig CHOOSE_DOMAINS;
        public static final /* enum */ RedirectToConfig USER_MIGRATION_CONNECT_TO_CLOUD;
        public static final /* enum */ RedirectToConfig USER_CONNECT_CLOUD_TO_SERVER;
        private static final /* synthetic */ RedirectToConfig[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private RedirectToConfig(String value) {
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public static RedirectToConfig[] values() {
            return (RedirectToConfig[])$VALUES.clone();
        }

        public static RedirectToConfig valueOf(String value) {
            return Enum.valueOf(RedirectToConfig.class, value);
        }

        @NotNull
        public static EnumEntries<RedirectToConfig> getEntries() {
            return $ENTRIES;
        }

        @JvmStatic
        @JsonCreator
        @com.fasterxml.jackson.annotation.JsonCreator
        @NotNull
        public static final RedirectToConfig fromString(@NotNull String redirectTo) {
            return Companion.fromString(redirectTo);
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$associateByTo$iv$iv;
            PLAN_CONFIGURATION = new RedirectToConfig("planConfiguration");
            APP_ASSESSMENT = new RedirectToConfig("appAssessment");
            PRE_MIGRATION_CHECKS = new RedirectToConfig("preMigrationChecks");
            SAVED_PLAN_PRE_MIGRATION_CHECKS = new RedirectToConfig("savedPlanPreMigrationChecks");
            USER_ASSESSMENT = new RedirectToConfig("userAssessment");
            USER_ASSESSMENT_RESULTS = new RedirectToConfig("userAssessmentResults");
            USER_ASSESSMENT_FIX_INVALID_EMAILS = new RedirectToConfig("userAssessmentFixInvalidEmails");
            USER_ASSESSMENT_FIX_DUPLICATED_EMAILS = new RedirectToConfig("userAssessmentFixDuplicatedEmails");
            USER_ASSESSMENT_REVIEW_CHANGES = new RedirectToConfig("userAssessmentReviewChanges");
            USER_ASSESSMENT_CUSTOMIZE_USERS = new RedirectToConfig("userAssessmentCustomizeUsers");
            USER_ASSESSMENT_REVIEW = new RedirectToConfig("userAssessmentReview");
            USER_ASSESSMENT_SUMMARY = new RedirectToConfig("userAssessmentSummary");
            CHOOSE_DOMAINS = new RedirectToConfig("chooseDomains");
            USER_MIGRATION_CONNECT_TO_CLOUD = new RedirectToConfig("userMigrationConnectToCloud");
            USER_CONNECT_CLOUD_TO_SERVER = new RedirectToConfig("connectCloudToServer");
            $VALUES = redirectToConfigArray = new RedirectToConfig[]{RedirectToConfig.PLAN_CONFIGURATION, RedirectToConfig.APP_ASSESSMENT, RedirectToConfig.PRE_MIGRATION_CHECKS, RedirectToConfig.SAVED_PLAN_PRE_MIGRATION_CHECKS, RedirectToConfig.USER_ASSESSMENT, RedirectToConfig.USER_ASSESSMENT_RESULTS, RedirectToConfig.USER_ASSESSMENT_FIX_INVALID_EMAILS, RedirectToConfig.USER_ASSESSMENT_FIX_DUPLICATED_EMAILS, RedirectToConfig.USER_ASSESSMENT_REVIEW_CHANGES, RedirectToConfig.USER_ASSESSMENT_CUSTOMIZE_USERS, RedirectToConfig.USER_ASSESSMENT_REVIEW, RedirectToConfig.USER_ASSESSMENT_SUMMARY, RedirectToConfig.CHOOSE_DOMAINS, RedirectToConfig.USER_MIGRATION_CONNECT_TO_CLOUD, RedirectToConfig.USER_CONNECT_CLOUD_TO_SERVER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            RedirectToConfig[] $this$associateBy$iv = RedirectToConfig.values();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
            RedirectToConfig[] redirectToConfigArray = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            int n = ((void)$this$associateByTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void p0;
                void element$iv$iv;
                void var9_9 = element$iv$iv = $this$associateByTo$iv$iv[i];
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(p0.value, element$iv$iv);
            }
            stringLookupMap = destination$iv$iv;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0007R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/cloud/CloudResource$RedirectToConfig$Companion;", "", "()V", "stringLookupMap", "", "", "Lcom/atlassian/jira/migration/cloud/CloudResource$RedirectToConfig;", "fromString", "redirectTo", "jira-migration-plugin"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @JsonCreator
            @com.fasterxml.jackson.annotation.JsonCreator
            @NotNull
            public final RedirectToConfig fromString(@NotNull String redirectTo) {
                Intrinsics.checkNotNullParameter((Object)redirectTo, (String)"redirectTo");
                RedirectToConfig redirectToConfig = (RedirectToConfig)((Object)stringLookupMap.get(redirectTo));
                if (redirectToConfig == null) {
                    throw new IllegalArgumentException("Unsupported redirect value : " + redirectTo);
                }
                return redirectToConfig;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BK\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003JM\u0010\u001b\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00052\n\b\u0003\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0003\u0010\b\u001a\u0004\u0018\u00010\u00072\n\b\u0003\u0010\t\u001a\u0004\u0018\u00010\u00072\n\b\u0003\u0010\n\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0007H\u00d6\u0001R\u0018\u0010\n\u001a\u0004\u0018\u00010\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0018\u0010\b\u001a\u0004\u0018\u00010\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0018\u0010\t\u001a\u0004\u0018\u00010\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/atlassian/jira/migration/cloud/CloudResource$ReturnUrlRequest;", "", "returnUrl", "Ljava/net/URI;", "redirectTo", "Lcom/atlassian/jira/migration/cloud/CloudResource$RedirectToConfig;", "planId", "", "executionId", "jcmaRedirectTo", "cloudType", "(Ljava/net/URI;Lcom/atlassian/jira/migration/cloud/CloudResource$RedirectToConfig;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCloudType", "()Ljava/lang/String;", "getExecutionId", "getJcmaRedirectTo", "getPlanId", "getRedirectTo", "()Lcom/atlassian/jira/migration/cloud/CloudResource$RedirectToConfig;", "getReturnUrl", "()Ljava/net/URI;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    public static final class ReturnUrlRequest {
        @org.codehaus.jackson.annotate.JsonProperty
        @JsonProperty
        @NotNull
        private final URI returnUrl;
        @org.codehaus.jackson.annotate.JsonProperty
        @JsonProperty
        @NotNull
        private final RedirectToConfig redirectTo;
        @org.codehaus.jackson.annotate.JsonProperty
        @JsonProperty
        @Nullable
        private final String planId;
        @org.codehaus.jackson.annotate.JsonProperty
        @JsonProperty
        @Nullable
        private final String executionId;
        @org.codehaus.jackson.annotate.JsonProperty
        @JsonProperty
        @Nullable
        private final String jcmaRedirectTo;
        @org.codehaus.jackson.annotate.JsonProperty
        @JsonProperty
        @Nullable
        private final String cloudType;

        @JsonCreator
        @com.fasterxml.jackson.annotation.JsonCreator
        public ReturnUrlRequest(@org.codehaus.jackson.annotate.JsonProperty(value="returnUrl") @JsonProperty(value="returnUrl") @NotNull URI returnUrl, @org.codehaus.jackson.annotate.JsonProperty(value="redirectTo") @JsonProperty(value="redirectTo") @NotNull RedirectToConfig redirectTo, @org.codehaus.jackson.annotate.JsonProperty(value="planId") @JsonProperty(value="planId") @Nullable String planId, @org.codehaus.jackson.annotate.JsonProperty(value="executionId") @JsonProperty(value="executionId") @Nullable String executionId, @org.codehaus.jackson.annotate.JsonProperty(value="jcmaRedirectTo") @JsonProperty(value="jcmaRedirectTo") @Nullable String jcmaRedirectTo, @org.codehaus.jackson.annotate.JsonProperty(value="cloudType") @JsonProperty(value="cloudType") @Nullable String cloudType) {
            Intrinsics.checkNotNullParameter((Object)returnUrl, (String)"returnUrl");
            Intrinsics.checkNotNullParameter((Object)((Object)redirectTo), (String)"redirectTo");
            this.returnUrl = returnUrl;
            this.redirectTo = redirectTo;
            this.planId = planId;
            this.executionId = executionId;
            this.jcmaRedirectTo = jcmaRedirectTo;
            this.cloudType = cloudType;
        }

        @NotNull
        public final URI getReturnUrl() {
            return this.returnUrl;
        }

        @NotNull
        public final RedirectToConfig getRedirectTo() {
            return this.redirectTo;
        }

        @Nullable
        public final String getPlanId() {
            return this.planId;
        }

        @Nullable
        public final String getExecutionId() {
            return this.executionId;
        }

        @Nullable
        public final String getJcmaRedirectTo() {
            return this.jcmaRedirectTo;
        }

        @Nullable
        public final String getCloudType() {
            return this.cloudType;
        }

        @NotNull
        public final URI component1() {
            return this.returnUrl;
        }

        @NotNull
        public final RedirectToConfig component2() {
            return this.redirectTo;
        }

        @Nullable
        public final String component3() {
            return this.planId;
        }

        @Nullable
        public final String component4() {
            return this.executionId;
        }

        @Nullable
        public final String component5() {
            return this.jcmaRedirectTo;
        }

        @Nullable
        public final String component6() {
            return this.cloudType;
        }

        @NotNull
        public final ReturnUrlRequest copy(@org.codehaus.jackson.annotate.JsonProperty(value="returnUrl") @JsonProperty(value="returnUrl") @NotNull URI returnUrl, @org.codehaus.jackson.annotate.JsonProperty(value="redirectTo") @JsonProperty(value="redirectTo") @NotNull RedirectToConfig redirectTo, @org.codehaus.jackson.annotate.JsonProperty(value="planId") @JsonProperty(value="planId") @Nullable String planId, @org.codehaus.jackson.annotate.JsonProperty(value="executionId") @JsonProperty(value="executionId") @Nullable String executionId, @org.codehaus.jackson.annotate.JsonProperty(value="jcmaRedirectTo") @JsonProperty(value="jcmaRedirectTo") @Nullable String jcmaRedirectTo, @org.codehaus.jackson.annotate.JsonProperty(value="cloudType") @JsonProperty(value="cloudType") @Nullable String cloudType) {
            Intrinsics.checkNotNullParameter((Object)returnUrl, (String)"returnUrl");
            Intrinsics.checkNotNullParameter((Object)((Object)redirectTo), (String)"redirectTo");
            return new ReturnUrlRequest(returnUrl, redirectTo, planId, executionId, jcmaRedirectTo, cloudType);
        }

        public static /* synthetic */ ReturnUrlRequest copy$default(ReturnUrlRequest returnUrlRequest, URI uRI, RedirectToConfig redirectToConfig, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                uRI = returnUrlRequest.returnUrl;
            }
            if ((n & 2) != 0) {
                redirectToConfig = returnUrlRequest.redirectTo;
            }
            if ((n & 4) != 0) {
                string = returnUrlRequest.planId;
            }
            if ((n & 8) != 0) {
                string2 = returnUrlRequest.executionId;
            }
            if ((n & 0x10) != 0) {
                string3 = returnUrlRequest.jcmaRedirectTo;
            }
            if ((n & 0x20) != 0) {
                string4 = returnUrlRequest.cloudType;
            }
            return returnUrlRequest.copy(uRI, redirectToConfig, string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "ReturnUrlRequest(returnUrl=" + this.returnUrl + ", redirectTo=" + (Object)((Object)this.redirectTo) + ", planId=" + this.planId + ", executionId=" + this.executionId + ", jcmaRedirectTo=" + this.jcmaRedirectTo + ", cloudType=" + this.cloudType + ')';
        }

        public int hashCode() {
            int result2 = this.returnUrl.hashCode();
            result2 = result2 * 31 + this.redirectTo.hashCode();
            result2 = result2 * 31 + (this.planId == null ? 0 : this.planId.hashCode());
            result2 = result2 * 31 + (this.executionId == null ? 0 : this.executionId.hashCode());
            result2 = result2 * 31 + (this.jcmaRedirectTo == null ? 0 : this.jcmaRedirectTo.hashCode());
            result2 = result2 * 31 + (this.cloudType == null ? 0 : this.cloudType.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReturnUrlRequest)) {
                return false;
            }
            ReturnUrlRequest returnUrlRequest = (ReturnUrlRequest)other;
            if (!Intrinsics.areEqual((Object)this.returnUrl, (Object)returnUrlRequest.returnUrl)) {
                return false;
            }
            if (this.redirectTo != returnUrlRequest.redirectTo) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.planId, (Object)returnUrlRequest.planId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.executionId, (Object)returnUrlRequest.executionId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.jcmaRedirectTo, (Object)returnUrlRequest.jcmaRedirectTo)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.cloudType, (Object)returnUrlRequest.cloudType);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RedirectToConfig.values().length];
            try {
                nArray[RedirectToConfig.SAVED_PLAN_PRE_MIGRATION_CHECKS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

