/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.cloud;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.cmpt.domain.Edition;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudType;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.crypto.EncryptionService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.migrationservice.TcsProductInfo;
import com.atlassian.jira.migration.shadow.db.ShadowCloudSiteRepository;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\t\b\u0007\u0018\u0000 +2\u00020\u0001:\u0001+B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJB\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u00192\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u0019H\u0002J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010 \u001a\u00020!J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100#J\b\u0010$\u001a\u0004\u0018\u00010\u0010J\u0010\u0010%\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010&\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u0012J\u0012\u0010'\u001a\u0004\u0018\u00010\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0012J@\u0010(\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJB\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "", "ao", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "encryptionService", "Lcom/atlassian/jira/migration/crypto/EncryptionService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "shadowCloudSiteRepository", "Lcom/atlassian/jira/migration/shadow/db/ShadowCloudSiteRepository;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Lcom/atlassian/jira/migration/crypto/EncryptionService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/shadow/db/ShadowCloudSiteRepository;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "createCloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "cloudId", "", "cloudUrl", "Ljava/net/URI;", "containerToken", "cloudEdition", "Lcom/atlassian/cmpt/domain/Edition;", "products", "", "Lcom/atlassian/jira/migration/migrationservice/TcsProductInfo;", "cloudType", "Lcom/atlassian/jira/migration/cloud/CloudType;", "decryptAllContainerTokens", "cloudSites", "deleteSite", "encryptAllContainerTokens", "", "findAll", "", "getRecentlyUpdatedCloudSite", "getSite", "getSiteByCloudUrl", "getSiteByContainerToken", "saveOrUpdate", "updateCloudSite", "existingSite", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCloudSiteRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudSiteRepository.kt\ncom/atlassian/jira/migration/cloud/CloudSiteRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1#2:139\n288#3,2:140\n1855#3,2:142\n3433#3,7:144\n819#3:151\n847#3,2:152\n1855#3,2:154\n*S KotlinDebug\n*F\n+ 1 CloudSiteRepository.kt\ncom/atlassian/jira/migration/cloud/CloudSiteRepository\n*L\n49#1:140,2\n60#1:142,2\n63#1:144,7\n79#1:151\n79#1:152,2\n123#1:154,2\n*E\n"})
public final class CloudSiteRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ActiveObjects ao;
    @NotNull
    private final EncryptionService encryptionService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final ShadowCloudSiteRepository shadowCloudSiteRepository;
    @NotNull
    private final ObjectMapper mapper;
    private static final Logger log = LoggerFactory.getLogger(CloudSiteRepository.class);
    @NotNull
    private static final String UPDATED_TIMESTAMP = "UPDATED_TIMESTAMP";

    @Inject
    public CloudSiteRepository(@NotNull ActiveObjects ao, @NotNull ObjectMapperFactory objectMapperFactory, @NotNull EncryptionService encryptionService, @NotNull MigrationFeatures migrationFeatures, @NotNull ShadowCloudSiteRepository shadowCloudSiteRepository) {
        Intrinsics.checkNotNullParameter((Object)ao, (String)"ao");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        Intrinsics.checkNotNullParameter((Object)encryptionService, (String)"encryptionService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)shadowCloudSiteRepository, (String)"shadowCloudSiteRepository");
        this.ao = ao;
        this.encryptionService = encryptionService;
        this.migrationFeatures = migrationFeatures;
        this.shadowCloudSiteRepository = shadowCloudSiteRepository;
        this.mapper = objectMapperFactory.createObjectMapper();
    }

    @Nullable
    public final CloudSite getSite(@NotNull String cloudId2) {
        CloudSite cloudSite2;
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Object[] objectArray = new Object[]{cloudId2};
        RawEntity[] rawEntityArray = this.ao.find(CloudSite.class, Query.select().where("CLOUD_ID = ?", objectArray).limit(1));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        CloudSite cloudSite3 = (CloudSite)ArraysKt.firstOrNull((Object[])rawEntityArray);
        if (cloudSite3 != null) {
            CloudSite cloudSite4;
            CloudSite $this$getSite_u24lambda_u240 = cloudSite4 = cloudSite3;
            boolean bl = false;
            $this$getSite_u24lambda_u240.setContainerToken(this.encryptionService.decrypt($this$getSite_u24lambda_u240.getContainerToken()));
            cloudSite2 = cloudSite4;
        } else {
            cloudSite2 = null;
        }
        return cloudSite2;
    }

    @Nullable
    public final CloudSite deleteSite(@NotNull String cloudId2) {
        CloudSite cloudSite2;
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Object[] objectArray = new Object[]{cloudId2};
        RawEntity[] rawEntityArray = this.ao.find(CloudSite.class, Query.select().where("CLOUD_ID = ?", objectArray).limit(1));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        CloudSite cloudSite3 = (CloudSite)ArraysKt.firstOrNull((Object[])rawEntityArray);
        if (cloudSite3 != null) {
            CloudSite cloudSite4;
            CloudSite it = cloudSite4 = cloudSite3;
            boolean bl = false;
            RawEntity[] rawEntityArray2 = new RawEntity[]{it};
            this.ao.delete(rawEntityArray2);
            cloudSite2 = cloudSite4;
        } else {
            cloudSite2 = null;
        }
        return cloudSite2;
    }

    @Nullable
    public final CloudSite getSiteByCloudUrl(@NotNull String cloudUrl) {
        CloudSite cloudSite2;
        Intrinsics.checkNotNullParameter((Object)cloudUrl, (String)"cloudUrl");
        Object[] objectArray = new Object[]{cloudUrl};
        RawEntity[] rawEntityArray = this.ao.find(CloudSite.class, Query.select().where("CLOUD_URL = ?", objectArray).limit(1));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        CloudSite cloudSite3 = (CloudSite)ArraysKt.firstOrNull((Object[])rawEntityArray);
        if (cloudSite3 != null) {
            CloudSite cloudSite4;
            CloudSite $this$getSiteByCloudUrl_u24lambda_u242 = cloudSite4 = cloudSite3;
            boolean bl = false;
            $this$getSiteByCloudUrl_u24lambda_u242.setContainerToken(this.encryptionService.decrypt($this$getSiteByCloudUrl_u24lambda_u242.getContainerToken()));
            cloudSite2 = cloudSite4;
        } else {
            cloudSite2 = null;
        }
        return cloudSite2;
    }

    @Nullable
    public final CloudSite getRecentlyUpdatedCloudSite() {
        CloudSite cloudSite2;
        RawEntity[] rawEntityArray = this.ao.find(CloudSite.class, Query.select().order("UPDATED_TIMESTAMP DESC").limit(1));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        CloudSite cloudSite3 = (CloudSite)ArraysKt.firstOrNull((Object[])rawEntityArray);
        if (cloudSite3 != null) {
            CloudSite cloudSite4;
            CloudSite $this$getRecentlyUpdatedCloudSite_u24lambda_u243 = cloudSite4 = cloudSite3;
            boolean bl = false;
            $this$getRecentlyUpdatedCloudSite_u24lambda_u243.setContainerToken(this.encryptionService.decrypt($this$getRecentlyUpdatedCloudSite_u24lambda_u243.getContainerToken()));
            cloudSite2 = cloudSite4;
        } else {
            cloudSite2 = null;
        }
        return cloudSite2;
    }

    @Nullable
    public final CloudSite getSiteByContainerToken(@Nullable String containerToken) {
        if (this.migrationFeatures.getEnableTokenEncryption()) {
            Object v1;
            block2: {
                RawEntity[] rawEntityArray = this.ao.find(CloudSite.class);
                Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
                List<CloudSite> cloudSites = this.decryptAllContainerTokens(ArraysKt.toList((Object[])rawEntityArray));
                Iterable $this$firstOrNull$iv = cloudSites;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    CloudSite it = (CloudSite)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getContainerToken(), (Object)containerToken)) continue;
                    v1 = element$iv;
                    break block2;
                }
                v1 = null;
            }
            return v1;
        }
        Object[] objectArray = new Object[]{containerToken};
        RawEntity[] rawEntityArray = this.ao.find(CloudSite.class, Query.select().where("CONTAINER_TOKEN = ?", objectArray).limit(1));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return (CloudSite)ArraysKt.firstOrNull((Object[])rawEntityArray);
    }

    /*
     * WARNING - void declaration
     */
    private final List<CloudSite> decryptAllContainerTokens(List<? extends CloudSite> cloudSites) {
        List containerTokenList = new ArrayList();
        Iterable $this$forEach$iv = cloudSites;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CloudSite it = (CloudSite)element$iv;
            boolean bl = false;
            containerTokenList.add(it.getContainerToken());
        }
        Collection<String> decryptedContainerTokenList = this.encryptionService.decryptAll(containerTokenList);
        Iterable $this$zip$iv = cloudSites;
        boolean $i$f$zip = false;
        Iterator first$iv = $this$zip$iv.iterator();
        Iterator second$iv = ((Iterable)decryptedContainerTokenList).iterator();
        ArrayList<Unit> list$iv = new ArrayList<Unit>(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)$this$zip$iv, (int)10), CollectionsKt.collectionSizeOrDefault((Iterable)decryptedContainerTokenList, (int)10)));
        while (first$iv.hasNext() && second$iv.hasNext()) {
            void b;
            void a;
            String string = (String)second$iv.next();
            CloudSite cloudSite2 = (CloudSite)first$iv.next();
            ArrayList<Unit> arrayList = list$iv;
            boolean bl = false;
            a.setContainerToken((String)b);
            arrayList.add(Unit.INSTANCE);
        }
        return cloudSites;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CloudSite saveOrUpdate(@NotNull String cloudId2, @NotNull URI cloudUrl, @NotNull String containerToken, @Nullable String cloudEdition, @NotNull List<TcsProductInfo> products, @Nullable CloudType cloudType) {
        CloudSite cloudSite2;
        Edition edition;
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)cloudUrl, (String)"cloudUrl");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter(products, (String)"products");
        CloudSite cloudSite3 = this.getSite(cloudId2);
        if (cloudSite3 != null) {
            CloudSite cloudSite4;
            Edition edition2;
            CloudSite cloudSite5 = cloudSite3;
            boolean bl = false;
            log.info("Site already exists. Will update.");
            CloudSiteRepository cloudSiteRepository = this;
            CloudSite cloudSite6 = cloudSite5;
            URI uRI = cloudUrl;
            String string = containerToken;
            String string2 = cloudEdition;
            if (string2 != null) {
                void it;
                String string3 = string2;
                String string4 = string;
                URI uRI2 = uRI;
                CloudSite cloudSite7 = cloudSite6;
                CloudSiteRepository cloudSiteRepository2 = cloudSiteRepository;
                boolean bl2 = false;
                Edition edition3 = Edition.getByKey((String)it);
                cloudSiteRepository = cloudSiteRepository2;
                cloudSite6 = cloudSite7;
                uRI = uRI2;
                string = string4;
                edition2 = edition3;
            } else {
                edition2 = null;
            }
            CloudSite $this$saveOrUpdate_u24lambda_u249_u24lambda_u248 = cloudSite4 = cloudSiteRepository.updateCloudSite(cloudSite6, uRI, string, edition2, products, cloudType);
            boolean bl3 = false;
            $this$saveOrUpdate_u24lambda_u249_u24lambda_u248.setContainerToken(containerToken);
            return cloudSite4;
        }
        log.info("Site does not exist. Will create.");
        CloudSiteRepository cloudSiteRepository = this;
        String string = cloudId2;
        URI uRI = cloudUrl;
        String string5 = containerToken;
        String string6 = cloudEdition;
        if (string6 != null) {
            void it;
            String string7 = string6;
            String string8 = string5;
            URI uRI3 = uRI;
            String string9 = string;
            CloudSiteRepository cloudSiteRepository3 = cloudSiteRepository;
            boolean bl = false;
            Edition edition4 = Edition.getByKey((String)it);
            cloudSiteRepository = cloudSiteRepository3;
            string = string9;
            uRI = uRI3;
            string5 = string8;
            edition = edition4;
        } else {
            edition = null;
        }
        CloudSite $this$saveOrUpdate_u24lambda_u2411 = cloudSite2 = cloudSiteRepository.createCloudSite(string, uRI, string5, edition, products, cloudType);
        boolean bl = false;
        $this$saveOrUpdate_u24lambda_u2411.setContainerToken(containerToken);
        return cloudSite2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<CloudSite> findAll() {
        void $this$filterNotTo$iv$iv;
        RawEntity[] rawEntityArray = this.ao.find(CloudSite.class);
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        Iterable $this$filterNot$iv = ArraysKt.toList((Object[])rawEntityArray);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            CloudSite it = (CloudSite)element$iv$iv;
            boolean bl = false;
            if (this.shadowCloudSiteRepository.isShadowCloud(it.getCloudId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List cloudSites = (List)destination$iv$iv;
        return this.migrationFeatures.getEnableTokenEncryption() ? (Collection)this.decryptAllContainerTokens(cloudSites) : (Collection)cloudSites;
    }

    private final CloudSite createCloudSite(String cloudId2, URI cloudUrl, String containerToken, Edition cloudEdition, List<TcsProductInfo> products, CloudType cloudType) {
        RawEntity rawEntity = this.ao.create(CloudSite.class, MapsKt.mapOf((Pair)TuplesKt.to((Object)"CLOUD_ID", (Object)cloudId2)));
        CloudSite $this$createCloudSite_u24lambda_u2413 = (CloudSite)rawEntity;
        boolean bl = false;
        $this$createCloudSite_u24lambda_u2413.setCloudUrl(cloudUrl);
        $this$createCloudSite_u24lambda_u2413.setContainerToken(this.encryptionService.encrypt(containerToken));
        $this$createCloudSite_u24lambda_u2413.setCloudEdition(cloudEdition);
        $this$createCloudSite_u24lambda_u2413.setProductsJson(this.mapper.writeValueAsString(products));
        CloudType cloudType2 = cloudType;
        if (cloudType2 == null) {
            cloudType2 = CloudType.STANDARD;
        }
        $this$createCloudSite_u24lambda_u2413.setCloudType(cloudType2);
        $this$createCloudSite_u24lambda_u2413.setUpdatedTimestamp(System.currentTimeMillis());
        $this$createCloudSite_u24lambda_u2413.save();
        CloudSite it = (CloudSite)rawEntity;
        boolean bl2 = false;
        log.debug("Successfully created CloudSite with cloudId " + cloudId2);
        RawEntity rawEntity2 = rawEntity;
        Intrinsics.checkNotNullExpressionValue((Object)rawEntity2, (String)"also(...)");
        return (CloudSite)rawEntity2;
    }

    private final CloudSite updateCloudSite(CloudSite existingSite, URI cloudUrl, String containerToken, Edition cloudEdition, List<TcsProductInfo> products, CloudType cloudType) {
        existingSite.setContainerToken(this.encryptionService.encrypt(containerToken));
        existingSite.setCloudUrl(cloudUrl);
        existingSite.setCloudEdition(cloudEdition);
        existingSite.setProductsJson(this.mapper.writeValueAsString(products));
        CloudType cloudType2 = cloudType;
        if (cloudType2 == null) {
            cloudType2 = CloudType.STANDARD;
        }
        existingSite.setCloudType(cloudType2);
        existingSite.setUpdatedTimestamp(System.currentTimeMillis());
        existingSite.save();
        log.debug("CloudSite with cloudId {} was updated successfully.", (Object)existingSite.getCloudId());
        return existingSite;
    }

    public final void encryptAllContainerTokens() {
        if (this.migrationFeatures.getEnableTokenEncryption()) {
            log.info("Encrypting saved container tokens on startup");
            try {
                this.ao.executeInTransaction(() -> CloudSiteRepository.encryptAllContainerTokens$lambda$16(this));
            }
            catch (Exception e) {
                log.warn("Ignoring error occurred while encrypting stored container tokens. " + e);
            }
        }
    }

    private static final Unit encryptAllContainerTokens$lambda$16(CloudSiteRepository this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        RawEntity[] rawEntityArray = this$0.ao.find(CloudSite.class);
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        Iterable $this$forEach$iv = ArraysKt.toList((Object[])rawEntityArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CloudSite it = (CloudSite)element$iv;
            boolean bl = false;
            it.setContainerToken(this$0.encryptionService.encrypt(it.getContainerToken()));
            it.save();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/cloud/CloudSiteRepository$Companion;", "", "()V", "UPDATED_TIMESTAMP", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

