/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.cloud;

import com.google.common.annotations.VisibleForTesting;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.inject.Named;
import javax.servlet.http.HttpSession;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0015\b\u0007\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/cloud/NonceService;", "", "()V", "nanoTimeSupplier", "Ljava/util/function/Supplier;", "", "(Ljava/util/function/Supplier;)V", "generateAndSaveNonce", "", "httpSession", "Ljavax/servlet/http/HttpSession;", "validateAndDeleteNonce", "", "nonce", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nNonceService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonceService.kt\ncom/atlassian/jira/migration/cloud/NonceService\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,60:1\n1313#2,2:61\n*S KotlinDebug\n*F\n+ 1 NonceService.kt\ncom/atlassian/jira/migration/cloud/NonceService\n*L\n44#1:61,2\n*E\n"})
public final class NonceService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Supplier<Long> nanoTimeSupplier;
    @NotNull
    private static final String NONCE_ATTRIBUTE = "jira.migration.nonce";
    @NotNull
    private static final String NONCE_CREATE_TIME_ATTRIBUTE = "jira.migration.nonce.createtime";
    private static final long TTL_NS = TimeUnit.MINUTES.toNanos(30L);

    @VisibleForTesting
    public NonceService(@NotNull Supplier<Long> nanoTimeSupplier) {
        Intrinsics.checkNotNullParameter(nanoTimeSupplier, (String)"nanoTimeSupplier");
        this.nanoTimeSupplier = nanoTimeSupplier;
    }

    public NonceService() {
        this(NonceService::_init_$lambda$0);
    }

    @NotNull
    public final String generateAndSaveNonce(@NotNull HttpSession httpSession) {
        Intrinsics.checkNotNullParameter((Object)httpSession, (String)"httpSession");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String nonce = string;
        httpSession.setAttribute(NONCE_ATTRIBUTE, (Object)nonce);
        httpSession.setAttribute(NONCE_CREATE_TIME_ATTRIBUTE, (Object)this.nanoTimeSupplier.get());
        return nonce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean validateAndDeleteNonce(@NotNull HttpSession httpSession, @NotNull String nonce) {
        void $this$forEach$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)httpSession, (String)"httpSession");
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        try {
            boolean bl2;
            Long nonceCreationTime;
            Object savedNonce = httpSession.getAttribute(NONCE_ATTRIBUTE);
            boolean nonceIsValid = Intrinsics.areEqual((Object)savedNonce, (Object)nonce);
            Object object = httpSession.getAttribute(NONCE_CREATE_TIME_ATTRIBUTE);
            Long l = nonceCreationTime = object instanceof Long ? (Long)object : null;
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl3 = false;
                Long l2 = this.nanoTimeSupplier.get();
                Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"get(...)");
                bl2 = it + TTL_NS > ((Number)l2).longValue();
            } else {
                bl2 = false;
            }
            boolean nonceStillValid = bl2;
            bl = nonceIsValid && nonceStillValid;
        }
        catch (Throwable throwable) {
            void $this$forEach$iv2;
            String[] $i$f$forEach = new String[]{NONCE_ATTRIBUTE, NONCE_CREATE_TIME_ATTRIBUTE};
            $i$f$forEach = SequencesKt.sequenceOf((Object[])$i$f$forEach);
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String it = (String)element$iv;
                boolean bl4 = false;
                httpSession.removeAttribute(it);
            }
            throw throwable;
        }
        String[] nonceIsValid = new String[]{NONCE_ATTRIBUTE, NONCE_CREATE_TIME_ATTRIBUTE};
        nonceIsValid = SequencesKt.sequenceOf((Object[])nonceIsValid);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl5 = false;
            httpSession.removeAttribute(it);
        }
        return bl;
    }

    private static final Long _init_$lambda$0() {
        return System.nanoTime();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u0007R\u001c\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/cloud/NonceService$Companion;", "", "()V", "NONCE_ATTRIBUTE", "", "getNONCE_ATTRIBUTE$annotations", "getNONCE_ATTRIBUTE", "()Ljava/lang/String;", "NONCE_CREATE_TIME_ATTRIBUTE", "getNONCE_CREATE_TIME_ATTRIBUTE$annotations", "getNONCE_CREATE_TIME_ATTRIBUTE", "TTL_NS", "", "getTTL_NS$annotations", "getTTL_NS", "()J", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getNONCE_ATTRIBUTE() {
            return NONCE_ATTRIBUTE;
        }

        @VisibleForTesting
        public static /* synthetic */ void getNONCE_ATTRIBUTE$annotations() {
        }

        @NotNull
        public final String getNONCE_CREATE_TIME_ATTRIBUTE() {
            return NONCE_CREATE_TIME_ATTRIBUTE;
        }

        @VisibleForTesting
        public static /* synthetic */ void getNONCE_CREATE_TIME_ATTRIBUTE$annotations() {
        }

        public final long getTTL_NS() {
            return TTL_NS;
        }

        @VisibleForTesting
        public static /* synthetic */ void getTTL_NS$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

