/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.cloud.action;

import com.atlassian.jira.migration.api.metadataaggregator.MetadataAggregatorService;
import com.atlassian.jira.migration.cloud.CloudResource;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.cloud.CloudType;
import com.atlassian.jira.migration.cloud.NonceService;
import com.atlassian.jira.migration.cloud.domain.CloudError;
import com.atlassian.jira.migration.cloud.domain.RedirectAttributes;
import com.atlassian.jira.migration.containerToken.ContainerTokenService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.legal.LegalService;
import com.atlassian.jira.migration.migrationservice.MigrationServiceClient;
import com.atlassian.jira.migration.prc.PollingService;
import com.atlassian.jira.migration.publicapi.model.SaveTokenRequest;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSudoRequired
public class SaveCloudSiteAction
extends JiraWebActionSupport {
    private static final Logger log = LoggerFactory.getLogger(SaveCloudSiteAction.class);
    private static final String REDIRECT_TO_PLAN_CONFIG = "/plan-configuration";
    private static final String REDIRECT_TO_APP_ASSESSMENT = "/apps/connect-to-cloud";
    private static final String REDIRECT_TO_PRE_MIGRATION_CHECKS = "/pre-migration-checks";
    private static final String REDIRECT_TO_SAVED_PLAN_PRE_MIGRATION_CHECKS = "/saved-plan-pre-migration-checks";
    private static final String REDIRECT_TO_USER_ASSESSMENT = "/email-validation/connect";
    private static final String REDIRECT_TO_USER_ASSESSMENT_RESULTS = "/email-validation/results";
    private static final String REDIRECT_TO_USER_ASSESSMENT_FIX_INVALID_EMAILS = "/email-validation/fix-invalid-emails";
    private static final String REDIRECT_TO_USER_ASSESSMENT_FIX_DUPLICATED_EMAILS = "/email-validation/fix-duplicated-emails";
    private static final String REDIRECT_TO_USER_ASSESSMENT_REVIEW_CHANGES = "/email-validation/review-changes";
    private static final String REDIRECT_TO_USER_ASSESSMENT_CUSTOMIZE_USERS = "/email-validation/customize-users";
    private static final String REDIRECT_TO_USER_ASSESSMENT_REVIEW = "/email-validation/review";
    private static final String REDIRECT_TO_USER_ASSESSMENT_SUMMARY = "/email-validation/summary";
    private static final String REDIRECT_TO_CHOOSE_DOMAINS_CONNECT = "/domains/connect";
    private static final String REDIRECT_TO_USER_MIGRATION_CONNECT_TO_CLOUD = "/frontloading/connect-to-cloud";
    private static final String REDIRECT_TO_USER_CONNECT_CLOUD_TO_SERVER = "connect-cloud-to-server";
    private static final String REDIRECT_BASE_PATH = "/secure/migration-app-action.jspa";
    private final transient NonceService nonceService;
    private final transient CloudSiteRepository cloudSiteRepository;
    private final transient LegalService legalService;
    private final transient MigrationServiceClient migrationServiceClient;
    private final transient MigrationFeatures migrationFeatures;
    private final transient PollingService pollingService;
    private final transient ContainerTokenService containerTokenService;
    private final transient MetadataAggregatorService metadataAggregatorService;

    public SaveCloudSiteAction(NonceService nonceService, CloudSiteRepository cloudSiteRepository, LegalService legalService, MigrationServiceClient migrationServiceClient, MigrationFeatures migrationFeatures, MetadataAggregatorService metadataAggregatorService, PollingService pollingService, ContainerTokenService containerTokenService) {
        this.nonceService = nonceService;
        this.cloudSiteRepository = cloudSiteRepository;
        this.legalService = legalService;
        this.migrationServiceClient = migrationServiceClient;
        this.migrationFeatures = migrationFeatures;
        this.metadataAggregatorService = metadataAggregatorService;
        this.pollingService = pollingService;
        this.containerTokenService = containerTokenService;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doExecute() {
        String redirectTo = this.getParameter(RedirectAttributes.REDIRECT_TO.getAttribute()).get();
        if (!this.isNonceValid()) {
            log.debug("Nonce is missing or invalid.");
            return this.redirectWithError(CloudError.SAVE_CLOUD_NONCE_ERROR, redirectTo);
        }
        Optional<String> cloudUrl = this.getParameter(RedirectAttributes.CLOUD_URL.getAttribute());
        Optional<String> containerToken = this.getParameter(RedirectAttributes.CONTAINER_TOKEN.getAttribute());
        Optional<String> cloudId2 = this.getParameter(RedirectAttributes.CLOUD_ID.getAttribute());
        Optional<String> cloudEdition = this.getParameter(RedirectAttributes.CLOUD_EDITION.getAttribute());
        Optional<String> cloudType = this.getParameter(RedirectAttributes.CLOUD_TYPE.getAttribute());
        Optional<String> cloudOrigin = this.getParameter(RedirectAttributes.CLOUD_ORIGIN.getAttribute());
        Optional<String> planId = this.getParameter(RedirectAttributes.PLAN_ID.getAttribute());
        Optional<String> executionId = this.getParameter(RedirectAttributes.EXECUTION_ID.getAttribute());
        Optional<String> jcmaRedirectTo = this.getParameter(RedirectAttributes.JCMA_REDIRECT_TO.getAttribute());
        if (cloudId2.isPresent() && containerToken.isPresent() && cloudUrl.isPresent()) {
            SaveTokenRequest saveTokenRequest = new SaveTokenRequest(cloudUrl.get(), cloudId2.get(), cloudEdition.orElse(null), cloudType.orElse(null), containerToken.get(), null, cloudOrigin.orElse(null));
            boolean redirectWithError = this.containerTokenService.saveToken(saveTokenRequest);
            if (redirectWithError) {
                if (this.migrationFeatures.isCloudFirstMigrationEnabled() && cloudOrigin.isPresent()) {
                    return this.redirectWithError(CloudError.CLOUD_CONNECT_ERROR, redirectTo, cloudOrigin.get());
                }
                return this.redirectWithError(CloudError.CLOUD_CONNECT_ERROR, redirectTo);
            }
            return cloudOrigin.isPresent() ? this.externalRedirect(cloudOrigin.get()) : this.redirectWithCloudSite(cloudId2.get(), cloudUrl.get(), redirectTo, planId, executionId, jcmaRedirectTo, cloudType);
        }
        log.error("A required parameter is not found to save cloud site");
        return this.redirectWithError(CloudError.SAVE_CLOUD_AUTH_ERROR, redirectTo);
    }

    private boolean isNonceValid() {
        return this.getParameter(RedirectAttributes.NONCE.getAttribute()).map(nonce -> this.nonceService.validateAndDeleteNonce(this.getHttpSession(), (String)nonce)).orElse(false);
    }

    private Optional<String> getParameter(String key) {
        String parameter = this.getHttpRequest().getParameter(key);
        if (StringUtils.isNotBlank((CharSequence)parameter)) {
            return Optional.of(parameter);
        }
        log.debug("Parameter {} is missing", (Object)key);
        return Optional.empty();
    }

    private String getRedirectFragment(String redirectTo) {
        switch (CloudResource.RedirectToConfig.fromString(redirectTo)) {
            case PLAN_CONFIGURATION: {
                return REDIRECT_TO_PLAN_CONFIG;
            }
            case APP_ASSESSMENT: {
                return REDIRECT_TO_APP_ASSESSMENT;
            }
            case PRE_MIGRATION_CHECKS: {
                return REDIRECT_TO_PRE_MIGRATION_CHECKS;
            }
            case SAVED_PLAN_PRE_MIGRATION_CHECKS: {
                return REDIRECT_TO_SAVED_PLAN_PRE_MIGRATION_CHECKS;
            }
            case USER_ASSESSMENT: {
                return REDIRECT_TO_USER_ASSESSMENT;
            }
            case USER_ASSESSMENT_RESULTS: {
                return REDIRECT_TO_USER_ASSESSMENT_RESULTS;
            }
            case USER_ASSESSMENT_FIX_INVALID_EMAILS: {
                return REDIRECT_TO_USER_ASSESSMENT_FIX_INVALID_EMAILS;
            }
            case USER_ASSESSMENT_FIX_DUPLICATED_EMAILS: {
                return REDIRECT_TO_USER_ASSESSMENT_FIX_DUPLICATED_EMAILS;
            }
            case USER_MIGRATION_CONNECT_TO_CLOUD: {
                return REDIRECT_TO_USER_MIGRATION_CONNECT_TO_CLOUD;
            }
            case USER_ASSESSMENT_REVIEW_CHANGES: {
                return REDIRECT_TO_USER_ASSESSMENT_REVIEW_CHANGES;
            }
            case USER_ASSESSMENT_CUSTOMIZE_USERS: {
                return REDIRECT_TO_USER_ASSESSMENT_CUSTOMIZE_USERS;
            }
            case USER_ASSESSMENT_REVIEW: {
                return REDIRECT_TO_USER_ASSESSMENT_REVIEW;
            }
            case USER_ASSESSMENT_SUMMARY: {
                return REDIRECT_TO_USER_ASSESSMENT_SUMMARY;
            }
            case CHOOSE_DOMAINS: {
                return REDIRECT_TO_CHOOSE_DOMAINS_CONNECT;
            }
            case USER_CONNECT_CLOUD_TO_SERVER: {
                return REDIRECT_TO_USER_CONNECT_CLOUD_TO_SERVER;
            }
        }
        throw new IllegalArgumentException("Unsupported redirectTo value : " + redirectTo);
    }

    private String redirectWithError(CloudError errorMessage2, String redirectTo) {
        String uriFragment = UriBuilder.fromUri((String)this.getRedirectFragment(redirectTo)).queryParam(RedirectAttributes.ERROR_CODE.getAttribute(), new Object[]{this.urlEncode(errorMessage2.name())}).build(new Object[0]).toString();
        String uriString = UriBuilder.fromUri((String)REDIRECT_BASE_PATH).fragment(uriFragment).build(new Object[0]).toString();
        return this.redirect(uriString);
    }

    private String redirectWithError(CloudError errorMessage2, String redirectTo, String cloudOrigin) {
        String uriFragment = UriBuilder.fromUri((String)this.getRedirectFragment(redirectTo)).queryParam(RedirectAttributes.ERROR_CODE.getAttribute(), new Object[]{this.urlEncode(errorMessage2.name())}).queryParam(RedirectAttributes.CLOUD_ORIGIN.getAttribute(), new Object[]{cloudOrigin}).build(new Object[0]).toString();
        String uriString = UriBuilder.fromUri((String)REDIRECT_BASE_PATH).fragment(uriFragment).build(new Object[0]).toString();
        return this.redirect(uriString);
    }

    private String redirectWithCloudSite(String cloudId2, String cloudUrl, String redirectTo, Optional<String> planId, Optional<String> executionId, Optional<String> jcmaRedirectTo, Optional<String> cloudType) {
        String redirectFragment = this.buildRedirectFragment(cloudId2, cloudUrl, redirectTo, planId, executionId, jcmaRedirectTo, cloudType);
        return this.redirect(UriBuilder.fromUri((String)REDIRECT_BASE_PATH).fragment(redirectFragment).build(new Object[0]).toString());
    }

    private String buildRedirectFragment(String cloudId2, String cloudUrl, String redirectTo, Optional<String> planId, Optional<String> executionId, Optional<String> jcmaRedirectTo, Optional<String> cloudType) {
        String redirectBaseUrl = this.getRedirectFragment(redirectTo);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)redirectBaseUrl);
        switch (CloudResource.RedirectToConfig.fromString(redirectTo)) {
            case SAVED_PLAN_PRE_MIGRATION_CHECKS: {
                this.addMigErrorParamsIfPresent(uriBuilder, planId, executionId, jcmaRedirectTo);
            }
        }
        uriBuilder.queryParam(RedirectAttributes.CLOUD_ID.getAttribute(), new Object[]{cloudId2}).queryParam(RedirectAttributes.CLOUD_URL.getAttribute(), new Object[]{cloudUrl}).queryParam(RedirectAttributes.CLOUD_TYPE.getAttribute(), new Object[]{cloudType.orElse(CloudType.STANDARD.name())});
        return uriBuilder.build(new Object[0]).toString();
    }

    @VisibleForTesting
    protected String redirect(String url) {
        this.setReturnUrl(url);
        return this.getRedirect(this.getReturnUrl(), true);
    }

    @VisibleForTesting
    protected String externalRedirect(String url) {
        return this.forceRedirect(url);
    }

    private void addMigErrorParamsIfPresent(UriBuilder uriBuilder, Optional<String> planId, Optional<String> executionId, Optional<String> jcmaRedirectTo) {
        if (planId.isPresent() && executionId.isPresent() && jcmaRedirectTo.isPresent()) {
            uriBuilder.queryParam(RedirectAttributes.PLAN_ID.getAttribute(), new Object[]{planId.get()}).queryParam(RedirectAttributes.EXECUTION_ID.getAttribute(), new Object[]{executionId.get()}).queryParam(RedirectAttributes.JCMA_REDIRECT_TO.getAttribute(), new Object[]{jcmaRedirectTo.get()});
        }
    }
}

