/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.common;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.user.ApplicationUser;
import javax.ws.rs.core.UriBuilder;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0016\b\u0002\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\bH\u0002J\f\u0010\u001e\u001a\u00020\u001c*\u00020\u001fH\u0002J\f\u0010\u001e\u001a\u00020\u001c*\u00020 H\u0002J\f\u0010!\u001a\u00020\u001c*\u00020\u001fH\u0002J\f\u0010!\u001a\u00020\u001c*\u00020 H\u0002J\n\u0010\"\u001a\u00020\u001c*\u00020\u001fJ\n\u0010\"\u001a\u00020\u001c*\u00020 R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/atlassian/jira/migration/common/Constants;", "", "()V", "CHUNK_SIZE_100", "", "CHUNK_SIZE_1000", "DIVISOR_FACTOR_10", "EMPTY_STRING", "", "JIRA_ANONYMOUS_USER_EMAIL_SUFFIX", "JIRA_ANONYMOUS_USER_KEY_PREFIX", "JIRA_ANONYMOUS_USER_NAME_PREFIX", "JIRA_BUSINESS_KEY", "JIRA_CLOUD_FORMER_USER_DISPLAY_NAME", "JIRA_CONNECT_USER_EMAIL_SUFFIX", "JIRA_CORE_PRODUCT_NAME", "JIRA_OPS_KEY", "JIRA_SERVICE_DESK_KEY", "JIRA_SERVICE_DESK_PRODUCT_NAME", "JIRA_SOFTWARE_KEY", "JIRA_SOFTWARE_PLUGIN_KEY", "JIRA_SOFTWARE_PRODUCT_NAME", "PLUGIN_KEY", "buildPageUrl", "suffix", "queryParam", "Lkotlin/Pair;", "isBlacklistedEmail", "", "emailAddress", "isAnonymous", "Lcom/atlassian/crowd/embedded/api/User;", "Lcom/atlassian/jira/user/ApplicationUser;", "isCloudFormerUser", "shouldNotMigrate", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nConstants.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Constants.kt\ncom/atlassian/jira/migration/common/Constants\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public final class Constants {
    @NotNull
    public static final Constants INSTANCE = new Constants();
    @NotNull
    public static final String JIRA_ANONYMOUS_USER_KEY_PREFIX = "JIRAUSER";
    @NotNull
    public static final String JIRA_ANONYMOUS_USER_NAME_PREFIX = "jirauser";
    @NotNull
    public static final String JIRA_ANONYMOUS_USER_EMAIL_SUFFIX = "@jira.invalid";
    @NotNull
    public static final String JIRA_CLOUD_FORMER_USER_DISPLAY_NAME = "Former user";
    @NotNull
    public static final String JIRA_CONNECT_USER_EMAIL_SUFFIX = "@connect.atlassian.com";
    @NotNull
    public static final String JIRA_SOFTWARE_KEY = "software";
    @NotNull
    public static final String JIRA_BUSINESS_KEY = "business";
    @NotNull
    public static final String JIRA_SERVICE_DESK_KEY = "service_desk";
    @NotNull
    public static final String JIRA_OPS_KEY = "ops";
    @NotNull
    public static final String EMPTY_STRING = "";
    @NotNull
    public static final String PLUGIN_KEY = "com.atlassian.jira.migration.jira-migration-plugin";
    @NotNull
    public static final String JIRA_SOFTWARE_PLUGIN_KEY = "com.pyxis.greenhopper.jira";
    @NotNull
    public static final String JIRA_SOFTWARE_PRODUCT_NAME = "jira-software.ondemand";
    @NotNull
    public static final String JIRA_CORE_PRODUCT_NAME = "jira-core.ondemand";
    @NotNull
    public static final String JIRA_SERVICE_DESK_PRODUCT_NAME = "jira-servicedesk.ondemand";
    public static final int CHUNK_SIZE_1000 = 1000;
    public static final int CHUNK_SIZE_100 = 100;
    public static final int DIVISOR_FACTOR_10 = 10;

    private Constants() {
    }

    public final boolean shouldNotMigrate(@NotNull User $this$shouldNotMigrate) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotMigrate, (String)"<this>");
        String string = $this$shouldNotMigrate.getEmailAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEmailAddress(...)");
        return this.isBlacklistedEmail(string) || this.isAnonymous($this$shouldNotMigrate) || this.isCloudFormerUser($this$shouldNotMigrate);
    }

    public final boolean shouldNotMigrate(@NotNull ApplicationUser $this$shouldNotMigrate) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotMigrate, (String)"<this>");
        String string = $this$shouldNotMigrate.getEmailAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEmailAddress(...)");
        return this.isBlacklistedEmail(string) || this.isAnonymous($this$shouldNotMigrate) || this.isCloudFormerUser($this$shouldNotMigrate);
    }

    @NotNull
    public final String buildPageUrl(@NotNull String suffix, @Nullable Pair<String, String> queryParam) {
        UriBuilder uriBuilder;
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        ApplicationProperties properties = ComponentAccessor.getApplicationProperties();
        String baseUrl = properties.getString("jira.baseurl");
        UriBuilder $this$buildPageUrl_u24lambda_u241 = uriBuilder = UriBuilder.fromUri((String)baseUrl).path(suffix);
        boolean bl = false;
        Pair<String, String> pair = queryParam;
        if (pair != null) {
            Pair<String, String> it = pair;
            boolean bl2 = false;
            Object[] objectArray = new Object[]{it.getSecond()};
            $this$buildPageUrl_u24lambda_u241.queryParam((String)it.getFirst(), objectArray);
        }
        String string = uriBuilder.build(new Object[0]).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String buildPageUrl$default(Constants constants, String string, Pair pair, int n, Object object) {
        if ((n & 2) != 0) {
            pair = null;
        }
        return constants.buildPageUrl(string, (Pair<String, String>)pair);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAnonymous(User $this$isAnonymous) {
        String string = $this$isAnonymous.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.startsWith$default((String)string, (String)JIRA_ANONYMOUS_USER_NAME_PREFIX, (boolean)false, (int)2, null)) return false;
        String string2 = $this$isAnonymous.getEmailAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getEmailAddress(...)");
        if (!StringsKt.endsWith((String)string2, (String)JIRA_ANONYMOUS_USER_EMAIL_SUFFIX, (boolean)true)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCloudFormerUser(User $this$isCloudFormerUser) {
        if ($this$isCloudFormerUser.isActive()) return false;
        String string = $this$isCloudFormerUser.getEmailAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEmailAddress(...)");
        if (((CharSequence)string).length() != 0) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual((Object)$this$isCloudFormerUser.getDisplayName(), (Object)JIRA_CLOUD_FORMER_USER_DISPLAY_NAME)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAnonymous(ApplicationUser $this$isAnonymous) {
        String string = $this$isAnonymous.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        if (!StringsKt.startsWith$default((String)string, (String)JIRA_ANONYMOUS_USER_KEY_PREFIX, (boolean)false, (int)2, null)) return false;
        String string2 = $this$isAnonymous.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        if (!StringsKt.startsWith$default((String)string2, (String)JIRA_ANONYMOUS_USER_NAME_PREFIX, (boolean)false, (int)2, null)) return false;
        String string3 = $this$isAnonymous.getEmailAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getEmailAddress(...)");
        if (!StringsKt.endsWith((String)string3, (String)JIRA_ANONYMOUS_USER_EMAIL_SUFFIX, (boolean)true)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCloudFormerUser(ApplicationUser $this$isCloudFormerUser) {
        if ($this$isCloudFormerUser.isActive()) return false;
        String string = $this$isCloudFormerUser.getEmailAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEmailAddress(...)");
        if (((CharSequence)string).length() != 0) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual((Object)$this$isCloudFormerUser.getDisplayName(), (Object)JIRA_CLOUD_FORMER_USER_DISPLAY_NAME)) return false;
        return true;
    }

    private final boolean isBlacklistedEmail(String emailAddress) {
        return StringsKt.endsWith((String)emailAddress, (String)JIRA_CONNECT_USER_EMAIL_SUFFIX, (boolean)true);
    }
}

