/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.common;

import com.atlassian.cmpt.validation.IdentityAcceptedEmailValidator;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010\f\u001a\u00020\u0003J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/common/DomainId;", "", "domain", "", "(Ljava/lang/String;)V", "getDomain", "()Ljava/lang/String;", "standardizedDomain", "getStandardizedDomain", "equals", "", "other", "generateRandomEmail", "hashCode", "", "toString", "Companion", "jira-migration-plugin"})
public final class DomainId {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String domain;
    @NotNull
    private final String standardizedDomain;

    public DomainId(@NotNull String domain) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        this.domain = domain;
        String string = IdentityAcceptedEmailValidator.cleanse((String)this.domain);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cleanse(...)");
        String string2 = string;
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        this.standardizedDomain = string3;
    }

    @NotNull
    public final String getDomain() {
        return this.domain;
    }

    @NotNull
    public final String getStandardizedDomain() {
        return this.standardizedDomain;
    }

    @NotNull
    public final String generateRandomEmail() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String id = StringsKt.replace$default((String)string, (String)"-", (String)"", (boolean)false, (int)4, null);
        String formattedDomain = StringsKt.startsWith$default((String)this.standardizedDomain, (String)"@", (boolean)false, (int)2, null) ? this.standardizedDomain : '@' + this.standardizedDomain;
        return id + formattedDomain;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.common.DomainId");
        DomainId cfr_ignored_0 = (DomainId)other;
        return Intrinsics.areEqual((Object)this.standardizedDomain, (Object)((DomainId)other).standardizedDomain);
    }

    public int hashCode() {
        return this.standardizedDomain.hashCode();
    }

    @NotNull
    public String toString() {
        return "DomainId(domain='" + this.domain + "', standardizedDomain='" + this.standardizedDomain + "')";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/common/DomainId$Companion;", "", "()V", "fromEmail", "Lcom/atlassian/jira/migration/common/DomainId;", "email", "", "jira-migration-plugin"})
    @SourceDebugExtension(value={"SMAP\nDomainId.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DomainId.kt\ncom/atlassian/jira/migration/common/DomainId$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n1#2:47\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final DomainId fromEmail(@NotNull String email) {
            String string;
            String string2;
            Intrinsics.checkNotNullParameter((Object)email, (String)"email");
            String it = string2 = email;
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)it)) return null;
            boolean bl2 = true;
            if (!bl2) return null;
            String string3 = string2;
            String string4 = string3;
            if (string3 == null) return null;
            String string5 = StringsKt.substringAfterLast((String)string4, (String)"@", (String)"");
            string4 = string5;
            if (string5 == null) return null;
            String it2 = string = string4;
            boolean bl3 = false;
            if (StringsKt.isBlank((CharSequence)it2)) return null;
            boolean bl4 = true;
            if (!bl4) return null;
            String string6 = string;
            string4 = string6;
            if (string6 == null) return null;
            it2 = string4;
            boolean bl5 = false;
            DomainId domainId = new DomainId(it2);
            return domainId;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

