/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.common;

import com.atlassian.jira.migration.common.Hasher;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/common/Hasher;", "", "()V", "bytesToHex", "", "hash", "", "valueToHash", "Companion", "jira-migration-plugin"})
public final class Hasher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String HASHING_ALGORITHM = "SHA-256";

    @NotNull
    public final String hash(@NotNull String valueToHash) {
        Intrinsics.checkNotNullParameter((Object)valueToHash, (String)"valueToHash");
        MessageDigest md = MessageDigest.getInstance(HASHING_ALGORITHM);
        String string = valueToHash;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        md.update(byArray);
        byte[] byArray2 = md.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"digest(...)");
        return this.bytesToHex(byArray2);
    }

    private final String bytesToHex(byte[] hash) {
        return ArraysKt.joinToString$default((byte[])hash, (CharSequence)"", null, null, (int)0, null, (Function1)bytesToHex.1.INSTANCE, (int)30, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/common/Hasher$Companion;", "", "()V", "HASHING_ALGORITHM", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

