/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.common;

import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FileAlreadyExistsException;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b!\b\u0007\u0018\u0000 ;2\u00020\u0001:\u0001;B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0016\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000bJ(\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\b2\u0018\b\u0002\u0010\u0013\u001a\u0012\u0012\b\u0012\u00060\u0015j\u0002`\u0016\u0012\u0004\u0012\u00020\u00060\u0014J\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\bJ(\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\b\u0002\u0010\u0013\u001a\u0012\u0012\b\u0012\u00060\u0015j\u0002`\u0016\u0012\u0004\u0012\u00020\u00060\u0014J(\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\b2\u0018\b\u0002\u0010\u0013\u001a\u0012\u0012\b\u0012\u00060\u0015j\u0002`\u0016\u0012\u0004\u0012\u00020\u00060\u0014J\u000e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u000bJ\u0006\u0010\u001e\u001a\u00020\bJ\u001a\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\b2\b\b\u0002\u0010!\u001a\u00020\u000bH\u0002J\u000e\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u000bJ\u000e\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u000bJ\u0006\u0010&\u001a\u00020\bJ\u000e\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u000bJ\u0006\u0010)\u001a\u00020\bJ\u000e\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\u000bJ\u000e\u0010,\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u000bJ\u000e\u0010-\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u000bJ\u000e\u0010.\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u000bJ\u000e\u0010/\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u000bJ\u0016\u00100\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000bJ \u00101\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u000b2\b\b\u0002\u0010!\u001a\u00020\u000bJ\u000e\u00103\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u000bJ\u000e\u00104\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u000bJ\u001a\u00105\u001a\u0004\u0018\u00010\u001b2\u0006\u0010 \u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u0010\u00106\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\u000bJ\u0006\u00107\u001a\u00020\bJ\u0006\u00108\u001a\u00020\bJ\u0006\u00109\u001a\u00020\bJ\b\u0010:\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "Lcom/atlassian/migration/udc/file/LocalFileDataOutput;", "jiraHome", "Lcom/atlassian/jira/config/util/JiraHome;", "(Lcom/atlassian/jira/config/util/JiraHome;)V", "addFilesToExistingZip", "", "existingZip", "Ljava/nio/file/Path;", "filesToAdd", "", "", "atomicMove", "source", "destination", "backgroundTaskMetricsDirectory", "taskGroupId", "cleanHandlingExceptions", "filePath", "errorHandler", "Lkotlin/Function1;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "deleteDirectoryIfExists", "directory", "deleteHandlingExceptions", "file", "Ljava/io/File;", "downloadFileForRecon", "fileName", "exportDirectory", "getFile", "dir", "uniquify", "idMappingResultsDirectory", "migrationScopeId", "legacyMigrationLogDirectory", "migrationId", "localLogDirectory", "migrationCheckDirectory", "executionId", "migrationDomainsDirectory", "migrationDryRunReportDirectory", "dryRunMigrationId", "migrationLogDirectory", "migrationPostReportDirectory", "migrationPreReportDirectory", "migrationScopeLogDirectory", "outputFileForAppEntities", "outputFileForProjectData", "projectKey", "outputFileForRecon", "preFlightExecutionLogDirectory", "readFile", "readFileForRecon", "reconDuplicateEntitiesDirectory", "temporaryFilesDirectory", "umsInvalidEmailResponseDirectory", "userMappingDirectory", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nLocalFileDataOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalFileDataOutput.kt\ncom/atlassian/jira/migration/common/LocalFileDataOutput\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,331:1\n1#2:332\n215#3,2:333\n*S KotlinDebug\n*F\n+ 1 LocalFileDataOutput.kt\ncom/atlassian/jira/migration/common/LocalFileDataOutput\n*L\n286#1:333,2\n*E\n"})
public final class LocalFileDataOutput
extends com.atlassian.migration.udc.file.LocalFileDataOutput {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JiraHome jiraHome;
    @NotNull
    public static final String LOG_DIR = "log";
    @NotNull
    public static final String REPORT_DIR = "reports";
    @NotNull
    public static final String ID_MAPPINGS_DIR = "id-mappings";
    @NotNull
    public static final String TEMP = "temp";
    @NotNull
    public static final String PRE_DIR = "pre";
    @NotNull
    public static final String POST_DIR = "post";
    @NotNull
    public static final String DRY_RUN = "dry-run";
    @NotNull
    public static final String EXPORT_DIR = "export";
    @NotNull
    public static final String MIG_TO_CLOUD_DIR = "migration-to-cloud";
    @NotNull
    public static final String DOMAINS_DIR = "domains";
    @NotNull
    public static final String MIG_SCOPE_TO_CLOUD_DIR = "migration-scope-to-cloud";
    @NotNull
    public static final String CHECKS_DIR = "checks";
    @NotNull
    public static final String UMS = "ums";
    @NotNull
    public static final String USER_MAPPING_DIR = "user-mapping";
    @NotNull
    public static final String CONFIG_ALIGNMENT = "config-alignment";
    @NotNull
    public static final String PROJECTS_DIR = "projects";
    @NotNull
    public static final String APP_ENTITIES_DIR = "app_entities";
    @NotNull
    public static final String BACKGROUND_TASK_DIR = "background-task";
    @NotNull
    public static final String METRICS_DIR = "metrics";
    @NotNull
    public static final String RECON_DIR = "recon";

    @Inject
    public LocalFileDataOutput(@NotNull JiraHome jiraHome) {
        Intrinsics.checkNotNullParameter((Object)jiraHome, (String)"jiraHome");
        this.jiraHome = jiraHome;
    }

    @NotNull
    public final File outputFileForProjectData(@NotNull String migrationId, @NotNull String projectKey, @NotNull String uniquify) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter((Object)uniquify, (String)"uniquify");
        String[] stringArray = new String[]{EXPORT_DIR, MIG_TO_CLOUD_DIR, migrationId, PROJECTS_DIR};
        Path dir = Paths.get(this.jiraHome.getHome().getAbsolutePath(), stringArray);
        Intrinsics.checkNotNull((Object)dir);
        return this.getFile(dir, projectKey + '-' + uniquify + ".json");
    }

    public static /* synthetic */ File outputFileForProjectData$default(LocalFileDataOutput localFileDataOutput, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = String.valueOf(System.currentTimeMillis());
        }
        return localFileDataOutput.outputFileForProjectData(string, string2, string3);
    }

    @NotNull
    public final File outputFileForAppEntities(@NotNull String migrationId, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String[] stringArray = new String[]{EXPORT_DIR, MIG_TO_CLOUD_DIR, migrationId, APP_ENTITIES_DIR};
        Path dir = Paths.get(this.jiraHome.getHome().getAbsolutePath(), stringArray);
        Intrinsics.checkNotNull((Object)dir);
        return this.getFile(dir, fileName);
    }

    @NotNull
    public final File downloadFileForRecon(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String[] stringArray = new String[]{EXPORT_DIR, MIG_TO_CLOUD_DIR, RECON_DIR};
        Path dir = Paths.get(this.jiraHome.getHome().getAbsolutePath(), stringArray);
        Path filePath = dir.resolve(fileName).normalize();
        if (Files.notExists(filePath, new LinkOption[0])) {
            throw new IllegalArgumentException("File not found");
        }
        File file2 = filePath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        return file2;
    }

    @NotNull
    public final File outputFileForRecon(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String[] stringArray = new String[]{EXPORT_DIR, MIG_TO_CLOUD_DIR, RECON_DIR};
        Path dir = Paths.get(this.jiraHome.getHome().getAbsolutePath(), stringArray);
        Intrinsics.checkNotNull((Object)dir);
        return this.getFile(dir, fileName);
    }

    private final File getFile(Path dir, String uniquify) {
        try {
            Path it = Files.createDirectories(dir, new FileAttribute[0]);
            boolean bl = false;
            Comparable<Path> comparable = dir.resolve(uniquify);
            it = comparable;
            boolean bl2 = false;
            Files.deleteIfExists(it);
            it = comparable;
            boolean bl3 = false;
            Comparable<Path> $this$getFile_u24lambda_u243 = comparable = Files.createFile(it, new FileAttribute[0]).toFile();
            boolean bl4 = false;
            ((File)$this$getFile_u24lambda_u243).deleteOnExit();
            Comparable<Path> comparable2 = comparable;
            Intrinsics.checkNotNullExpressionValue(comparable2, (String)"apply(...)");
            return comparable2;
        }
        catch (Exception ex) {
            throw new Exception("Error while creating output file for project data: " + ex);
        }
    }

    static /* synthetic */ File getFile$default(LocalFileDataOutput localFileDataOutput, Path path, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = System.currentTimeMillis() + ".json";
        }
        return localFileDataOutput.getFile(path, string);
    }

    @Nullable
    public final File readFileForRecon(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String[] stringArray = new String[]{EXPORT_DIR, MIG_TO_CLOUD_DIR, RECON_DIR};
        Path dir = Paths.get(this.jiraHome.getHome().getAbsolutePath(), stringArray);
        Intrinsics.checkNotNull((Object)dir);
        return this.readFile(dir, fileName);
    }

    private final File readFile(Path dir, String fileName) {
        String[] stringArray = new String[]{fileName};
        Path path = Paths.get(((Object)dir).toString(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path filePath = path;
        return Files.exists(filePath, new LinkOption[0]) ? filePath.toFile() : null;
    }

    @NotNull
    public final Path localLogDirectory() {
        String[] stringArray = new String[]{LOG_DIR};
        Path path = Paths.get(this.jiraHome.getLocalHomePath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public final Path migrationLogDirectory(@NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        String[] stringArray = new String[]{EXPORT_DIR, MIG_TO_CLOUD_DIR, migrationId, LOG_DIR};
        Path path = Paths.get(this.jiraHome.getHome().getAbsolutePath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public final Path migrationScopeLogDirectory(@NotNull String migrationScopeId2) {
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        String[] stringArray = new String[]{EXPORT_DIR, MIG_TO_CLOUD_DIR, migrationScopeId2, LOG_DIR};
        Path path = Paths.get(this.jiraHome.getHome().getAbsolutePath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public final Path legacyMigrationLogDirectory(@NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        String[] stringArray = new String[]{LOG_DIR, MIG_TO_CLOUD_DIR, migrationId};
        Path path = Paths.get(this.jiraHome.getHome().getAbsolutePath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public final Path preFlightExecutionLogDirectory(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        String[] stringArray = new String[]{EXPORT_DIR, MIG_TO_CLOUD_DIR, executionId, LOG_DIR, EXPORT_DIR};
        Path path = Paths.get(this.jiraHome.getHome().getAbsolutePath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public final Path exportDirectory() {
        String[] stringArray = new String[]{EXPORT_DIR};
        Path path = Paths.get(this.jiraHome.getHome().getAbsolutePath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public final Path umsInvalidEmailResponseDirectory() {
        String[] stringArray = new String[]{EXPORT_DIR, MIG_TO_CLOUD_DIR, CHECKS_DIR, UMS};
        Path path = Paths.get(this.jiraHome.getHome().getAbsolutePath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public final Path migrationCheckDirectory(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        String[] stringArray = new String[]{EXPORT_DIR, MIG_TO_CLOUD_DIR, CHECKS_DIR, executionId};
        Path path = Paths.get(this.jiraHome.getHome().getAbsolutePath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public final Path migrationDomainsDirectory() {
        String[] stringArray = new String[]{EXPORT_DIR, MIG_TO_CLOUD_DIR, DOMAINS_DIR};
        Path path = Paths.get(this.jiraHome.getHome().getAbsolutePath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public final Path reconDuplicateEntitiesDirectory() {
        String[] stringArray = new String[]{EXPORT_DIR, MIG_TO_CLOUD_DIR, RECON_DIR};
        Path path = Paths.get(this.jiraHome.getHome().getAbsolutePath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public final Path migrationPreReportDirectory(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        String[] stringArray = new String[]{REPORT_DIR, PRE_DIR, MIG_SCOPE_TO_CLOUD_DIR, executionId};
        Path path = Paths.get(this.jiraHome.getHome().getAbsolutePath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public final Path idMappingResultsDirectory(@NotNull String migrationScopeId2) {
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        String[] stringArray = new String[]{ID_MAPPINGS_DIR, migrationScopeId2};
        Path path = Paths.get(this.jiraHome.getHome().getAbsolutePath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public final Path temporaryFilesDirectory() {
        String[] stringArray = new String[]{TEMP};
        Path path = Paths.get(this.jiraHome.getHome().getAbsolutePath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public final Path migrationDryRunReportDirectory(@NotNull String dryRunMigrationId) {
        Intrinsics.checkNotNullParameter((Object)dryRunMigrationId, (String)"dryRunMigrationId");
        String[] stringArray = new String[]{REPORT_DIR, DRY_RUN, MIG_TO_CLOUD_DIR, dryRunMigrationId};
        Path path = Paths.get(this.jiraHome.getHome().getAbsolutePath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public final Path migrationPostReportDirectory(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        String[] stringArray = new String[]{REPORT_DIR, POST_DIR, MIG_TO_CLOUD_DIR, executionId};
        Path path = Paths.get(this.jiraHome.getHome().getAbsolutePath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public Path userMappingDirectory() {
        String[] stringArray = new String[]{EXPORT_DIR, MIG_TO_CLOUD_DIR, USER_MAPPING_DIR};
        Path path = Paths.get(this.jiraHome.getHome().getAbsolutePath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public final Path backgroundTaskMetricsDirectory(@NotNull String taskGroupId) {
        Intrinsics.checkNotNullParameter((Object)taskGroupId, (String)"taskGroupId");
        String[] stringArray = new String[]{BACKGROUND_TASK_DIR, METRICS_DIR, taskGroupId};
        Path path = Paths.get(this.jiraHome.getHome().getAbsolutePath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteDirectoryIfExists(@NotNull Path directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        if (directory.toFile().exists()) {
            AutoCloseable autoCloseable = Files.walk(directory, new FileVisitOption[0]);
            Throwable throwable = null;
            try {
                Stream files = (Stream)autoCloseable;
                boolean bl = false;
                files.sorted(Comparator.reverseOrder()).map(arg_0 -> LocalFileDataOutput.deleteDirectoryIfExists$lambda$6$lambda$4(deleteDirectoryIfExists.1.1.INSTANCE, arg_0)).forEach(arg_0 -> LocalFileDataOutput.deleteDirectoryIfExists$lambda$6$lambda$5(deleteDirectoryIfExists.1.2.INSTANCE, arg_0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
    }

    public final void atomicMove(@NotNull Path source, @NotNull Path destination) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        try {
            try {
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
                Files.move(source, destination, copyOptionArray);
            }
            catch (AtomicMoveNotSupportedException fae) {
                Files.move(source, destination, new CopyOption[0]);
            }
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    public final void deleteHandlingExceptions(@NotNull File file2, @NotNull Function1<? super Exception, Unit> errorHandler) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(errorHandler, (String)"errorHandler");
        Path path = file2.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        this.deleteHandlingExceptions(path, errorHandler);
    }

    public static /* synthetic */ void deleteHandlingExceptions$default(LocalFileDataOutput localFileDataOutput, File file2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = deleteHandlingExceptions.1.INSTANCE;
        }
        localFileDataOutput.deleteHandlingExceptions(file2, (Function1<? super Exception, Unit>)function1);
    }

    public final void deleteHandlingExceptions(@NotNull Path filePath, @NotNull Function1<? super Exception, Unit> errorHandler) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter(errorHandler, (String)"errorHandler");
        try {
            Files.deleteIfExists(filePath);
        }
        catch (Exception exception) {
            errorHandler.invoke((Object)exception);
        }
    }

    public static /* synthetic */ void deleteHandlingExceptions$default(LocalFileDataOutput localFileDataOutput, Path path, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = deleteHandlingExceptions.2.INSTANCE;
        }
        localFileDataOutput.deleteHandlingExceptions(path, (Function1<? super Exception, Unit>)function1);
    }

    public final void cleanHandlingExceptions(@NotNull Path filePath, @NotNull Function1<? super Exception, Unit> errorHandler) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter(errorHandler, (String)"errorHandler");
        try {
            File f = new File(filePath.toUri());
            if (!f.exists()) {
                errorHandler.invoke((Object)new Exception("File by path [" + filePath.toUri().getPath() + "] not found!"));
                return;
            }
            FilesKt.writeText$default((File)f, (String)"", null, (int)2, null);
        }
        catch (Exception exception) {
            errorHandler.invoke((Object)exception);
        }
    }

    public static /* synthetic */ void cleanHandlingExceptions$default(LocalFileDataOutput localFileDataOutput, Path path, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = cleanHandlingExceptions.1.INSTANCE;
        }
        localFileDataOutput.cleanHandlingExceptions(path, (Function1<? super Exception, Unit>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addFilesToExistingZip(@NotNull Path existingZip, @NotNull Map<Path, String> filesToAdd) {
        Intrinsics.checkNotNullParameter((Object)existingZip, (String)"existingZip");
        Intrinsics.checkNotNullParameter(filesToAdd, (String)"filesToAdd");
        String tempFileName = ((Object)existingZip.toAbsolutePath()).toString() + ".tmp";
        try {
            String existingZipFileName = ((Object)existingZip.toAbsolutePath()).toString();
            Files.deleteIfExists(Paths.get(tempFileName, new String[0]));
            Closeable closeable = (Closeable)new ZipArchiveOutputStream(new File(tempFileName));
            Throwable throwable = null;
            try {
                Object object;
                ZipArchiveOutputStream newZip = (ZipArchiveOutputStream)closeable;
                boolean bl = false;
                newZip.setUseZip64(Zip64Mode.AsNeeded);
                File file2 = existingZip.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
                Object object2 = file2;
                object2 = (Closeable)new ZipArchiveInputStream((InputStream)new FileInputStream((File)object2));
                Throwable throwable2 = null;
                try {
                    ZipArchiveInputStream oldZip = (ZipArchiveInputStream)object2;
                    boolean bl2 = false;
                    ArchiveEntry nextEntry = null;
                    while (true) {
                        ArchiveEntry archiveEntry;
                        ArchiveEntry it = archiveEntry = oldZip.getNextEntry();
                        boolean bl3 = false;
                        nextEntry = it;
                        if (archiveEntry == null) break;
                        newZip.putArchiveEntry(nextEntry);
                        IOUtils.copy((InputStream)((InputStream)oldZip), (OutputStream)((OutputStream)newZip));
                        newZip.closeArchiveEntry();
                    }
                    object = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable2);
                }
                Map<Path, String> $this$forEach$iv = filesToAdd;
                boolean $i$f$forEach = false;
                object = $this$forEach$iv.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = (Map.Entry)object.next();
                    boolean bl4 = false;
                    Path path = (Path)entry.getKey();
                    String filename = (String)entry.getValue();
                    Path srcFile = path;
                    boolean bl5 = false;
                    ZipArchiveEntry entry2 = new ZipArchiveEntry(filename);
                    entry2.setSize(srcFile.toFile().length());
                    newZip.putArchiveEntry((ArchiveEntry)entry2);
                    Closeable closeable2 = new FileInputStream(srcFile.toFile());
                    Throwable throwable4 = null;
                    try {
                        FileInputStream fis = (FileInputStream)closeable2;
                        boolean bl6 = false;
                        long l = IOUtils.copy((InputStream)fis, (OutputStream)((OutputStream)newZip));
                    }
                    catch (Throwable throwable5) {
                        throwable4 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable4);
                    }
                    newZip.closeArchiveEntry();
                }
                newZip.finish();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Files.deleteIfExists(existingZip);
            Files.move(Paths.get(tempFileName, new String[0]), Paths.get(existingZipFileName, new String[0]), new CopyOption[0]);
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            Files.deleteIfExists(Paths.get(tempFileName, new String[0]));
        }
    }

    private static final File deleteDirectoryIfExists$lambda$6$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (File)$tmp0.invoke(p0);
    }

    private static final void deleteDirectoryIfExists$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0014\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/common/LocalFileDataOutput$Companion;", "", "()V", "APP_ENTITIES_DIR", "", "BACKGROUND_TASK_DIR", "CHECKS_DIR", "CONFIG_ALIGNMENT", "DOMAINS_DIR", "DRY_RUN", "EXPORT_DIR", "ID_MAPPINGS_DIR", "LOG_DIR", "METRICS_DIR", "MIG_SCOPE_TO_CLOUD_DIR", "MIG_TO_CLOUD_DIR", "POST_DIR", "PRE_DIR", "PROJECTS_DIR", "RECON_DIR", "REPORT_DIR", "TEMP", "UMS", "USER_MAPPING_DIR", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

