/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.common;

import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\b0\f\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/common/ObjectMapperService;", "", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "parse", "T", "inputStream", "Ljava/io/InputStream;", "returnType", "Ljava/lang/Class;", "(Ljava/io/InputStream;Ljava/lang/Class;)Ljava/lang/Object;", "jira-migration-plugin"})
public final class ObjectMapperService {
    @NotNull
    private final ObjectMapper objectMapper;

    @Inject
    public ObjectMapperService(@NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.objectMapper = objectMapperFactory.createObjectMapper();
    }

    public final <T> T parse(@NotNull InputStream inputStream, @NotNull Class<T> returnType) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter(returnType, (String)"returnType");
        return (T)this.objectMapper.readValue(inputStream, returnType);
    }
}

