/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.common;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u001e\n\u0002\b\n\u0018\u0000 \u000e*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\u000e\u000fB7\b\u0002\u0012\u001e\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\r\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0000H\u0002R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR&\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/common/PaginatedList;", "T", "", "fetchingFunc", "Lkotlin/Function2;", "", "", "curOffset", "limitPerPage", "(Lkotlin/jvm/functions/Function2;II)V", "fetched", "getFetched", "()Ljava/util/Collection;", "nextPage", "Companion", "PaginatedIterator", "jira-migration-plugin"})
public final class PaginatedList<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function2<Integer, Integer, Collection<T>> fetchingFunc;
    private final int curOffset;
    private final int limitPerPage;
    @NotNull
    private final Collection<T> fetched;

    private PaginatedList(Function2<? super Integer, ? super Integer, ? extends Collection<? extends T>> fetchingFunc, int curOffset, int limitPerPage) {
        this.fetchingFunc = fetchingFunc;
        this.curOffset = curOffset;
        this.limitPerPage = limitPerPage;
        this.fetched = (Collection)this.fetchingFunc.invoke((Object)this.curOffset, (Object)this.limitPerPage);
    }

    @NotNull
    public final Collection<T> getFetched() {
        return this.fetched;
    }

    private final PaginatedList<T> nextPage() {
        int fetchedSize = this.fetched.size();
        return fetchedSize < this.limitPerPage ? null : new PaginatedList<T>(this.fetchingFunc, this.curOffset + fetchedSize, this.limitPerPage);
    }

    public /* synthetic */ PaginatedList(Function2 fetchingFunc, int curOffset, int limitPerPage, DefaultConstructorMarker $constructor_marker) {
        this(fetchingFunc, curOffset, limitPerPage);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00050\u0004\"\u0004\b\u0001\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u001e\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u000b0\n\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/common/PaginatedList$Companion;", "", "()V", "fetchByPage", "", "Lcom/atlassian/jira/migration/common/PaginatedList;", "T", "limitPerPage", "", "fetchingFunc", "Lkotlin/Function2;", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> Iterator<PaginatedList<T>> fetchByPage(int limitPerPage, @NotNull Function2<? super Integer, ? super Integer, ? extends Collection<? extends T>> fetchingFunc) {
            Intrinsics.checkNotNullParameter(fetchingFunc, (String)"fetchingFunc");
            return new PaginatedIterator(new PaginatedList(fetchingFunc, 0, limitPerPage, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B\u0015\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0006\u001a\u00020\u0007H\u0096\u0002J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003H\u0096\u0002R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/common/PaginatedList$PaginatedIterator;", "T", "", "Lcom/atlassian/jira/migration/common/PaginatedList;", "nextPaginatedList", "(Lcom/atlassian/jira/migration/common/PaginatedList;)V", "hasNext", "", "next", "jira-migration-plugin"})
    public static final class PaginatedIterator<T>
    implements Iterator<PaginatedList<T>>,
    KMappedMarker {
        @Nullable
        private PaginatedList<T> nextPaginatedList;

        public PaginatedIterator(@Nullable PaginatedList<T> nextPaginatedList) {
            this.nextPaginatedList = nextPaginatedList;
        }

        @Override
        @NotNull
        public PaginatedList<T> next() {
            PaginatedList<T> paginatedList = this.nextPaginatedList;
            if (paginatedList == null) {
                throw new NoSuchElementException();
            }
            PaginatedList<T> curPaginatedList = paginatedList;
            this.nextPaginatedList = ((PaginatedList)curPaginatedList).nextPage();
            return curPaginatedList;
        }

        @Override
        public boolean hasNext() {
            return this.nextPaginatedList != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

