/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.common.liftandshift;

import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.common.liftandshift.UserMetadataRecord;
import com.atlassian.jira.migration.common.liftandshift.UsersMetadataExtractor;
import com.atlassian.jira.migration.email.FixAllEmailsResult;
import com.atlassian.jira.migration.email.UserEmailFixer;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUserGroupMigrationData;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUsersAndGroupsService;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JsmCustomerReader;
import com.atlassian.jira.migration.utility.JsmUtility;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.migration.udc.common.model.user.AccountType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015H\u0002J \u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015H\u0002J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/atlassian/jira/migration/common/liftandshift/UsersMetadataExtractor;", "", "jiraUsersAndGroupsService", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUsersAndGroupsService;", "userEmailFixer", "Lcom/atlassian/jira/migration/email/UserEmailFixer;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "jsmCustomerReader", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JsmCustomerReader;", "jsmUtility", "Lcom/atlassian/jira/migration/utility/JsmUtility;", "(Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUsersAndGroupsService;Lcom/atlassian/jira/migration/email/UserEmailFixer;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JsmCustomerReader;Lcom/atlassian/jira/migration/utility/JsmUtility;)V", "extract", "", "Lcom/atlassian/jira/migration/common/liftandshift/UserMetadataRecord;", "option", "Lcom/atlassian/jira/migration/plan/UsersGroupsMigrationOption;", "cloudId", "", "extractCustomers", "Lcom/atlassian/jira/migration/email/FixAllEmailsResult;", "migScopeId", "containerToken", "extractUsers", "getAccountTypeString", "accountType", "Lcom/atlassian/migration/udc/common/model/user/AccountType;", "getProcessedData", "usersInfo", "mapUserInfo", "userInfo", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUser;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nUsersMetadataExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsersMetadataExtractor.kt\ncom/atlassian/jira/migration/common/liftandshift/UsersMetadataExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1549#2:89\n1620#2,3:90\n1549#2:93\n1620#2,3:94\n*S KotlinDebug\n*F\n+ 1 UsersMetadataExtractor.kt\ncom/atlassian/jira/migration/common/liftandshift/UsersMetadataExtractor\n*L\n74#1:89\n74#1:90,3\n75#1:93\n75#1:94,3\n*E\n"})
public final class UsersMetadataExtractor {
    @NotNull
    private final JiraUsersAndGroupsService jiraUsersAndGroupsService;
    @NotNull
    private final UserEmailFixer userEmailFixer;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final MigrationScopeManager migrationScopeManager;
    @NotNull
    private final JsmCustomerReader jsmCustomerReader;
    @NotNull
    private final JsmUtility jsmUtility;

    @Inject
    public UsersMetadataExtractor(@NotNull JiraUsersAndGroupsService jiraUsersAndGroupsService, @NotNull UserEmailFixer userEmailFixer, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull MigrationScopeManager migrationScopeManager, @NotNull JsmCustomerReader jsmCustomerReader, @NotNull JsmUtility jsmUtility) {
        Intrinsics.checkNotNullParameter((Object)jiraUsersAndGroupsService, (String)"jiraUsersAndGroupsService");
        Intrinsics.checkNotNullParameter((Object)userEmailFixer, (String)"userEmailFixer");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)jsmCustomerReader, (String)"jsmCustomerReader");
        Intrinsics.checkNotNullParameter((Object)jsmUtility, (String)"jsmUtility");
        this.jiraUsersAndGroupsService = jiraUsersAndGroupsService;
        this.userEmailFixer = userEmailFixer;
        this.cloudSiteRepository = cloudSiteRepository;
        this.migrationScopeManager = migrationScopeManager;
        this.jsmCustomerReader = jsmCustomerReader;
        this.jsmUtility = jsmUtility;
    }

    @NotNull
    public final List<UserMetadataRecord> extract(@NotNull UsersGroupsMigrationOption option, @NotNull String cloudId2) {
        List list;
        CloudSite cloudSite2;
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        CloudSite cloudSite3 = cloudSite2 = this.cloudSiteRepository.getSite(cloudId2);
        String containerToken = String.valueOf(cloudSite3 != null ? cloudSite3.getContainerToken() : null);
        CloudSite cloudSite4 = cloudSite2;
        Intrinsics.checkNotNull((Object)cloudSite4);
        String migScopeId = this.migrationScopeManager.getMigrationScope(cloudSite4);
        FixAllEmailsResult users2 = this.extractUsers(option, migScopeId, containerToken);
        List processedUsersRecords = this.getProcessedData(users2, AccountType.USER);
        if (this.jsmUtility.isJsmInstalled()) {
            FixAllEmailsResult customers = this.extractCustomers(migScopeId, containerToken);
            list = CollectionsKt.plus((Collection)processedUsersRecords, (Iterable)this.getProcessedData(customers, AccountType.CUSTOMER));
        } else {
            list = processedUsersRecords;
        }
        return list;
    }

    private final FixAllEmailsResult extractUsers(UsersGroupsMigrationOption option, String migScopeId, String containerToken) {
        JiraUserGroupMigrationData userGroupMigrationData = JiraUsersAndGroupsService.usersAndGroupsMigrationData$default(this.jiraUsersAndGroupsService, option, null, null, 6, null);
        return UserEmailFixer.safelyFixAllEmailInMemory$default(this.userEmailFixer, userGroupMigrationData.getUsers(), AccountType.USER, migScopeId, UUID.randomUUID().toString(), containerToken, false, false, 96, null);
    }

    private final FixAllEmailsResult extractCustomers(String migScopeId, String containerToken) {
        Sequence<ApplicationUser> allCustomers2 = this.jsmCustomerReader.getAllJsdCustomersAsApplicationUser();
        Sequence asJiraUsers2 = SequencesKt.map(allCustomers2, (Function1)extractCustomers.asJiraUsers.1.INSTANCE);
        return UserEmailFixer.safelyFixAllEmailInMemory$default(this.userEmailFixer, SequencesKt.toList((Sequence)asJiraUsers2), AccountType.CUSTOMER, migScopeId, UUID.randomUUID().toString(), containerToken, false, false, 96, null);
    }

    private final List<UserMetadataRecord> getProcessedData(FixAllEmailsResult usersInfo, AccountType accountType) {
        JiraUser userInfo;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = usersInfo.getValid();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JiraUser jiraUser = (JiraUser)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.mapUserInfo(userInfo, accountType));
        }
        $this$map$iv = usersInfo.getNewMail();
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            userInfo = (JiraUser)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.mapUserInfo(userInfo, accountType));
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    private final UserMetadataRecord mapUserInfo(JiraUser userInfo, AccountType accountType) {
        return new UserMetadataRecord(userInfo.getUserKey(), userInfo.getUserName(), userInfo.getEmail(), this.getAccountTypeString(accountType));
    }

    private final String getAccountTypeString(AccountType accountType) {
        return accountType == AccountType.USER ? "ATLASSIAN" : "CUSTOMER";
    }
}

