/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.consent;

import com.atlassian.jira.migration.amsclient.DefaultAppMigrationServiceClient;
import com.atlassian.jira.migration.assessment.MarketplaceSharedConsentDto;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.cloud.CloudType;
import com.atlassian.jira.migration.sen.JiraSenInfo;
import com.atlassian.jira.migration.sen.SENSupplier;
import com.atlassian.jira.migration.setup.migrationsettings.MigrationSettingService;
import com.atlassian.jira.migration.setup.migrationsettings.MigrationSettings;
import com.atlassian.jira.migration.setup.migrationsettings.MigrationSettingsType;
import com.atlassian.migration.app.dto.ConsentRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0012J\b\u0010\u001b\u001a\u00020\fH\u0002J6\u0010\u001c\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d2!\u0010\u001e\u001a\u001d\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u0002H\u001d0\u001fH\u0002\u00a2\u0006\u0002\u0010$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/atlassian/jira/migration/consent/AppConsentService;", "", "appMigrationServiceClient", "Lcom/atlassian/jira/migration/amsclient/DefaultAppMigrationServiceClient;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "migrationSettingsService", "Lcom/atlassian/jira/migration/setup/migrationsettings/MigrationSettingService;", "senSupplier", "Lcom/atlassian/jira/migration/sen/SENSupplier;", "(Lcom/atlassian/jira/migration/amsclient/DefaultAppMigrationServiceClient;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/setup/migrationsettings/MigrationSettingService;Lcom/atlassian/jira/migration/sen/SENSupplier;)V", "isConsentedOnCloud", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "sens", "Ljava/util/SortedSet;", "", "sharedConsentKey", "getSharedConsentForMarketplacePartners", "Lcom/atlassian/jira/migration/assessment/MarketplaceSharedConsentDto;", "hasConsentOnCloud", "cloudSiteId", "sen", "saveSharedConsentForMarketplacePartners", "displayedText", "shouldCollectConsent", "withSomeStandardCloudIdThatWorks", "T", "function", "Lkotlin/Function1;", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "Lkotlin/ParameterName;", "name", "cloudSite", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppConsentService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppConsentService.kt\ncom/atlassian/jira/migration/consent/AppConsentService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n766#2:101\n857#2,2:102\n2624#2,3:105\n766#2:108\n857#2,2:109\n1855#2,2:111\n1#3:104\n*S KotlinDebug\n*F\n+ 1 AppConsentService.kt\ncom/atlassian/jira/migration/consent/AppConsentService\n*L\n35#1:101\n35#1:102,2\n69#1:105,3\n91#1:108\n91#1:109,2\n91#1:111,2\n*E\n"})
public final class AppConsentService {
    @NotNull
    private final DefaultAppMigrationServiceClient appMigrationServiceClient;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final MigrationSettingService migrationSettingsService;
    private final Logger log;
    private boolean isConsentedOnCloud;
    @NotNull
    private final String sharedConsentKey;
    @NotNull
    private final SortedSet<String> sens;

    /*
     * WARNING - void declaration
     */
    @Inject
    public AppConsentService(@NotNull DefaultAppMigrationServiceClient appMigrationServiceClient, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull MigrationSettingService migrationSettingsService, @NotNull SENSupplier senSupplier) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)appMigrationServiceClient, (String)"appMigrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)migrationSettingsService, (String)"migrationSettingsService");
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        this.appMigrationServiceClient = appMigrationServiceClient;
        this.cloudSiteRepository = cloudSiteRepository;
        this.migrationSettingsService = migrationSettingsService;
        this.log = LoggerFactory.getLogger(AppConsentService.class);
        this.sharedConsentKey = "allowAppMigrationsDataShare";
        JiraSenInfo jiraSenInfo = senSupplier.getSens();
        Object object = new String[]{jiraSenInfo.getJiraCoreSen(), jiraSenInfo.getJiraServicedeskSen(), jiraSenInfo.getJiraSoftwareSen()};
        object = CollectionsKt.listOfNotNull((Object[])object);
        AppConsentService appConsentService = this;
        boolean $i$f$filter = false;
        void var8_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        appConsentService.sens = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final MarketplaceSharedConsentDto getSharedConsentForMarketplacePartners() {
        return new MarketplaceSharedConsentDto(this.sharedConsentKey, this.shouldCollectConsent());
    }

    @NotNull
    public final MarketplaceSharedConsentDto saveSharedConsentForMarketplacePartners(@NotNull String displayedText) {
        Intrinsics.checkNotNullParameter((Object)displayedText, (String)"displayedText");
        if (!this.shouldCollectConsent()) {
            boolean bl = false;
            String string = "Consent should not be collected";
            throw new IllegalStateException(string.toString());
        }
        return (MarketplaceSharedConsentDto)this.withSomeStandardCloudIdThatWorks((Function1)new Function1<CloudSite, MarketplaceSharedConsentDto>(this, displayedText){
            final /* synthetic */ AppConsentService this$0;
            final /* synthetic */ String $displayedText;
            {
                this.this$0 = $receiver;
                this.$displayedText = $displayedText;
                super(1);
            }

            @NotNull
            public final MarketplaceSharedConsentDto invoke(@NotNull CloudSite it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AppConsentService.access$setConsentedOnCloud$p(this.this$0, AppConsentService.access$getAppMigrationServiceClient$p(this.this$0).saveConsent(it.getCloudId(), AppConsentService.access$getSharedConsentKey$p(this.this$0), new ConsentRequest(this.$displayedText, (List)new ArrayList<E>(AppConsentService.access$getSens$p(this.this$0)))).getConsented());
                return new MarketplaceSharedConsentDto(AppConsentService.access$getSharedConsentKey$p(this.this$0), false);
            }
        });
    }

    private final boolean shouldCollectConsent() {
        boolean bl;
        try {
            boolean bl2;
            block9: {
                if (this.isConsentedOnCloud) {
                    return false;
                }
                MigrationSettings cloudTypeSettings = this.migrationSettingsService.getSetting(MigrationSettingsType.CLOUD_TYPE.getValue());
                Map<CloudType, Boolean> map = cloudTypeSettings.getCloudTypes();
                if (map != null ? Intrinsics.areEqual((Object)map.get((Object)CloudType.FEDRAMP), (Object)true) : false) {
                    this.log.debug("Skipping consent collection in FedRAMP mode");
                    return false;
                }
                if (this.sens.isEmpty()) {
                    this.log.debug("Skipping consent collection as there is no SEN registered to the product");
                    return false;
                }
                Iterable $this$none$iv = this.cloudSiteRepository.findAll();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        CloudSite it = (CloudSite)element$iv;
                        boolean bl3 = false;
                        if (!(it.getCloudType() == CloudType.STANDARD)) continue;
                        bl2 = false;
                        break block9;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                this.log.debug("Skipping consent collection as there is no linked Standard CloudSite");
                return false;
            }
            bl = (Boolean)this.withSomeStandardCloudIdThatWorks((Function1)new Function1<CloudSite, Boolean>(this){
                final /* synthetic */ AppConsentService this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull CloudSite it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String string = it.getCloudId();
                    E e = AppConsentService.access$getSens$p(this.this$0).first();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"first(...)");
                    return !AppConsentService.access$hasConsentOnCloud(this.this$0, string, (String)e);
                }
            });
        }
        catch (Exception e) {
            this.log.warn("Failed to get consent for cloud site", (Throwable)e);
            bl = false;
        }
        return bl;
    }

    private final synchronized boolean hasConsentOnCloud(String cloudSiteId, String sen) {
        this.isConsentedOnCloud = this.appMigrationServiceClient.getConsent(cloudSiteId, this.sharedConsentKey, sen).getConsented();
        return this.isConsentedOnCloud;
    }

    /*
     * WARNING - void declaration
     */
    private final <T> T withSomeStandardCloudIdThatWorks(Function1<? super CloudSite, ? extends T> function) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.cloudSiteRepository.findAll();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CloudSite it = (CloudSite)element$iv$iv;
            boolean bl = false;
            if (!(it.getCloudType() == CloudType.STANDARD)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CloudSite it = (CloudSite)element$iv;
            boolean bl = false;
            try {
                return (T)function.invoke((Object)it);
            }
            catch (Exception e) {
                this.log.debug("Failed to interact with cloud site " + it.getCloudId(), (Throwable)e);
            }
        }
        throw new IllegalStateException("No working cloud site available".toString());
    }

    public static final /* synthetic */ void access$setConsentedOnCloud$p(AppConsentService $this, boolean bl) {
        $this.isConsentedOnCloud = bl;
    }

    public static final /* synthetic */ DefaultAppMigrationServiceClient access$getAppMigrationServiceClient$p(AppConsentService $this) {
        return $this.appMigrationServiceClient;
    }

    public static final /* synthetic */ String access$getSharedConsentKey$p(AppConsentService $this) {
        return $this.sharedConsentKey;
    }

    public static final /* synthetic */ SortedSet access$getSens$p(AppConsentService $this) {
        return $this.sens;
    }

    public static final /* synthetic */ boolean access$hasConsentOnCloud(AppConsentService $this, String cloudSiteId, String sen) {
        return $this.hasConsentOnCloud(cloudSiteId, sen);
    }
}

