/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.containerToken;

import com.atlassian.cmpt.domain.Product;
import com.atlassian.jira.migration.api.metadataaggregator.MetadataAggregatorService;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.cloud.CloudType;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.legal.LegalService;
import com.atlassian.jira.migration.metadataaggregator.apimodels.MetadataRefreshStatus;
import com.atlassian.jira.migration.migrationservice.MigrationServiceClient;
import com.atlassian.jira.migration.migrationservice.SiteDetailsRequest;
import com.atlassian.jira.migration.migrationservice.SiteDetailsResponse;
import com.atlassian.jira.migration.migrationservice.SiteDetailsWithCloudId;
import com.atlassian.jira.migration.migrationservice.TcsProductInfo;
import com.atlassian.jira.migration.prc.PollingService;
import com.atlassian.jira.migration.publicapi.client.MigrationClient;
import com.atlassian.jira.migration.publicapi.model.CreateContainerTokenRequest;
import com.atlassian.jira.migration.publicapi.model.CreateContainerTokenResponse;
import com.atlassian.jira.migration.publicapi.model.SaveTokenRequest;
import com.atlassian.migration.api.ProductFamily;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/containerToken/ContainerTokenService;", "", "migrationServiceClient", "Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "legalService", "Lcom/atlassian/jira/migration/legal/LegalService;", "pollingService", "Lcom/atlassian/jira/migration/prc/PollingService;", "metadataAggregatorService", "Lcom/atlassian/jira/migration/api/metadataaggregator/MetadataAggregatorService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "migrationClient", "Lcom/atlassian/jira/migration/publicapi/client/MigrationClient;", "(Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/legal/LegalService;Lcom/atlassian/jira/migration/prc/PollingService;Lcom/atlassian/jira/migration/api/metadataaggregator/MetadataAggregatorService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/publicapi/client/MigrationClient;)V", "createAndSaveToken", "", "authToken", "", "cloudUrl", "fetchProductDetails", "", "Lcom/atlassian/jira/migration/migrationservice/TcsProductInfo;", "containerToken", "cloudId", "saveToken", "", "saveTokenRequest", "Lcom/atlassian/jira/migration/publicapi/model/SaveTokenRequest;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nContainerTokenService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContainerTokenService.kt\ncom/atlassian/jira/migration/containerToken/ContainerTokenService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1360#2:110\n1446#2,5:111\n*S KotlinDebug\n*F\n+ 1 ContainerTokenService.kt\ncom/atlassian/jira/migration/containerToken/ContainerTokenService\n*L\n102#1:110\n102#1:111,5\n*E\n"})
public final class ContainerTokenService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationServiceClient migrationServiceClient;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final LegalService legalService;
    @NotNull
    private final PollingService pollingService;
    @NotNull
    private final MetadataAggregatorService metadataAggregatorService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final MigrationClient migrationClient;
    private static final Logger log = LoggerFactory.getLogger(ContainerTokenService.class);

    @Inject
    public ContainerTokenService(@NotNull MigrationServiceClient migrationServiceClient, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull LegalService legalService, @NotNull PollingService pollingService, @NotNull MetadataAggregatorService metadataAggregatorService, @NotNull MigrationFeatures migrationFeatures, @NotNull MigrationClient migrationClient) {
        Intrinsics.checkNotNullParameter((Object)migrationServiceClient, (String)"migrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)legalService, (String)"legalService");
        Intrinsics.checkNotNullParameter((Object)pollingService, (String)"pollingService");
        Intrinsics.checkNotNullParameter((Object)metadataAggregatorService, (String)"metadataAggregatorService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)migrationClient, (String)"migrationClient");
        this.migrationServiceClient = migrationServiceClient;
        this.cloudSiteRepository = cloudSiteRepository;
        this.legalService = legalService;
        this.pollingService = pollingService;
        this.metadataAggregatorService = metadataAggregatorService;
        this.migrationFeatures = migrationFeatures;
        this.migrationClient = migrationClient;
    }

    public final void createAndSaveToken(@NotNull String authToken, @NotNull String cloudUrl) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)cloudUrl, (String)"cloudUrl");
        CreateContainerTokenResponse createContainerTokenResponse = this.migrationClient.createContainerToken(new CreateContainerTokenRequest(ProductFamily.JIRA, new URI(cloudUrl)), authToken);
        String string = createContainerTokenResponse.getCloudUrl().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.saveToken(new SaveTokenRequest(string, createContainerTokenResponse.getCloudId(), createContainerTokenResponse.getCloudEdition(), null, createContainerTokenResponse.getToken(), createContainerTokenResponse.getProducts(), null));
    }

    public final boolean saveToken(@NotNull SaveTokenRequest saveTokenRequest) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)saveTokenRequest, (String)"saveTokenRequest");
            log.info("Saving container token for cloudUrl: " + saveTokenRequest.getCloudUrl());
            List<TcsProductInfo> list = saveTokenRequest.getProducts();
            if (list == null) {
                list = this.fetchProductDetails(saveTokenRequest.getToken(), saveTokenRequest.getCloudId());
            }
            List<TcsProductInfo> products = list;
            String string = saveTokenRequest.getCloudId();
            URI uRI = URI.create(saveTokenRequest.getCloudUrl());
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
            String string2 = saveTokenRequest.getToken();
            String string3 = saveTokenRequest.getCloudEdition();
            String string4 = saveTokenRequest.getCloudType();
            if (string4 == null) {
                string4 = "STANDARD";
            }
            this.cloudSiteRepository.saveOrUpdate(string, uRI, string2, string3, products, CloudType.valueOf(string4));
            if (saveTokenRequest.getCloudOrigin() != null && !this.migrationFeatures.isCloudFirstMigrationEnabled()) {
                return true;
            }
            if (this.migrationFeatures.isCloudFirstMigrationEnabled()) {
                try {
                    this.pollingService.startPollingUntilContainerTokenExpiry(saveTokenRequest.getCloudUrl());
                    MetadataRefreshStatus metadataRefreshStatus = this.metadataAggregatorService.createServerInstanceCloudSitePairInMMA(saveTokenRequest.getToken(), saveTokenRequest.getCloudId());
                    if (metadataRefreshStatus == MetadataRefreshStatus.FAILURE && saveTokenRequest.getCloudOrigin() != null) {
                        return true;
                    }
                }
                catch (Exception e) {
                    log.warn("could not create Server Instance cloud site pair in Migration Metadata Aggregator ", (Throwable)e);
                    if (saveTokenRequest.getCloudOrigin() == null) break block7;
                    return true;
                }
            }
        }
        this.legalService.rememberLegalOptIn();
        log.info("Container token for cloudUrl: " + saveTokenRequest.getCloudUrl() + " saved successfully");
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TcsProductInfo> fetchProductDetails(String containerToken, String cloudId2) {
        void $this$flatMapTo$iv$iv;
        Product[] productArray = new Product[]{Product.JIRA_CORE, Product.JIRA_SOFTWARE, Product.JIRA_SERVICEDESK};
        SiteDetailsResponse siteDetails = this.migrationServiceClient.fetchSiteDetails(containerToken, SiteDetailsRequest.Companion.requestDetailsFor(cloudId2, productArray));
        Iterable $this$flatMap$iv = siteDetails.getSites();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SiteDetailsWithCloudId it = (SiteDetailsWithCloudId)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getProducts();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/containerToken/ContainerTokenService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

