/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.containerToken;

import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.containerToken.ContainerTokenState;
import com.atlassian.jira.migration.migrationservice.ContainerTokenTTLService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bJ\b\u0010\n\u001a\u0004\u0018\u00010\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/containerToken/ContainerTokenValidator;", "", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "containerTokenTTLService", "Lcom/atlassian/jira/migration/migrationservice/ContainerTokenTTLService;", "(Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/migrationservice/ContainerTokenTTLService;)V", "getCloudIdsWithValidContainerToken", "", "", "getValidContainerToken", "cloudId", "isTokenValid", "", "containerToken", "validateContainerToken", "Lcom/atlassian/jira/migration/containerToken/ContainerTokenState;", "cloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nContainerTokenValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContainerTokenValidator.kt\ncom/atlassian/jira/migration/containerToken/ContainerTokenValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1054#2:70\n1549#2:71\n1620#2,3:72\n288#2,2:75\n1054#2:77\n766#2:78\n857#2,2:79\n1179#2,2:81\n1253#2,4:83\n*S KotlinDebug\n*F\n+ 1 ContainerTokenValidator.kt\ncom/atlassian/jira/migration/containerToken/ContainerTokenValidator\n*L\n41#1:70\n42#1:71\n42#1:72,3\n43#1:75,2\n55#1:77\n56#1:78\n56#1:79,2\n57#1:81,2\n57#1:83,4\n*E\n"})
public final class ContainerTokenValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final ContainerTokenTTLService containerTokenTTLService;
    private static final Logger log = LoggerFactory.getLogger(ContainerTokenValidator.class);

    @Inject
    public ContainerTokenValidator(@NotNull CloudSiteRepository cloudSiteRepository, @NotNull ContainerTokenTTLService containerTokenTTLService) {
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)containerTokenTTLService, (String)"containerTokenTTLService");
        this.cloudSiteRepository = cloudSiteRepository;
        this.containerTokenTTLService = containerTokenTTLService;
    }

    @NotNull
    public final ContainerTokenState validateContainerToken(@Nullable String cloudId2) {
        CharSequence charSequence = cloudId2;
        return charSequence == null || charSequence.length() == 0 ? ContainerTokenState.INVALID : this.validateContainerToken(this.cloudSiteRepository.getSite(cloudId2));
    }

    private final ContainerTokenState validateContainerToken(CloudSite cloudSite2) {
        if (cloudSite2 == null) {
            return ContainerTokenState.INVALID;
        }
        String containerToken = cloudSite2.getContainerToken();
        if (StringUtils.isBlank((CharSequence)containerToken)) {
            return ContainerTokenState.INVALID;
        }
        return !this.isTokenValid(containerToken) ? ContainerTokenState.EXPIRED : ContainerTokenState.VALID;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getValidContainerToken() {
        Object v0;
        block2: {
            void $this$mapTo$iv$iv;
            Iterable $this$sortedByDescending$iv = this.cloudSiteRepository.findAll();
            boolean $i$f$sortedByDescending = false;
            Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    CloudSite it = (CloudSite)b;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getUpdatedTimestamp());
                    it = (CloudSite)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getUpdatedTimestamp()));
                }
            });
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                CloudSite cloudSite2 = (CloudSite)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.getContainerToken());
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String containerToken = (String)element$iv;
                boolean bl = false;
                if (!this.containerTokenTTLService.isValidToken(containerToken)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final String getValidContainerToken(@NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Object object = this.cloudSiteRepository.getSite(cloudId2);
        if (object == null || (object = object.getContainerToken()) == null) {
            return null;
        }
        Object containerToken = object;
        return this.isTokenValid((String)containerToken) ? containerToken : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> getCloudIdsWithValidContainerToken() {
        void $this$associateTo$iv$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$sortedByDescending$iv = this.cloudSiteRepository.findAll();
        boolean $i$f$sortedByDescending = false;
        Iterable $this$filter$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                CloudSite it = (CloudSite)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getUpdatedTimestamp());
                it = (CloudSite)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getUpdatedTimestamp()));
            }
        });
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CloudSite it = (CloudSite)element$iv$iv;
            boolean bl = false;
            if (!this.containerTokenTTLService.isValidToken(it.getContainerToken())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            CloudSite it = (CloudSite)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getCloudId(), (Object)it.getContainerToken());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    private final boolean isTokenValid(String containerToken) {
        boolean bl;
        try {
            bl = this.containerTokenTTLService.isValidToken(containerToken);
        }
        catch (Exception e) {
            log.error("Error while checking if token is valid, exception", (Throwable)e);
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/containerToken/ContainerTokenValidator$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

