/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.context;

import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.context.RequestContext;
import com.atlassian.jira.migration.httpclient.MigrationUserAgentProvider;
import com.atlassian.jira.migration.migration.MigrationRepository;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.sen.JiraSenInfo;
import com.atlassian.jira.migration.sen.SENSupplier;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\fJ\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/atlassian/jira/migration/context/RequestContextBuilder;", "", "senSupplier", "Lcom/atlassian/jira/migration/sen/SENSupplier;", "migrationRepository", "Lcom/atlassian/jira/migration/migration/MigrationRepository;", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "userAgentProvider", "Lcom/atlassian/jira/migration/httpclient/MigrationUserAgentProvider;", "(Lcom/atlassian/jira/migration/sen/SENSupplier;Lcom/atlassian/jira/migration/migration/MigrationRepository;Lcom/atlassian/jira/migration/plan/PlanRepository;Lcom/atlassian/jira/migration/httpclient/MigrationUserAgentProvider;)V", "userAgent", "", "getUserAgent", "()Ljava/lang/String;", "build", "Lcom/atlassian/jira/migration/context/RequestContext;", "buildForExecutionContext", "cloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "planName", "buildForMigrationId", "migrationId", "buildForPlan", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "jira-migration-plugin"})
public final class RequestContextBuilder {
    @NotNull
    private final SENSupplier senSupplier;
    @NotNull
    private final MigrationRepository migrationRepository;
    @NotNull
    private final PlanRepository planRepository;
    @NotNull
    private final MigrationUserAgentProvider userAgentProvider;

    @Inject
    public RequestContextBuilder(@NotNull SENSupplier senSupplier, @NotNull MigrationRepository migrationRepository, @NotNull PlanRepository planRepository, @NotNull MigrationUserAgentProvider userAgentProvider) {
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        Intrinsics.checkNotNullParameter((Object)userAgentProvider, (String)"userAgentProvider");
        this.senSupplier = senSupplier;
        this.migrationRepository = migrationRepository;
        this.planRepository = planRepository;
        this.userAgentProvider = userAgentProvider;
    }

    @NotNull
    public final RequestContext build() {
        String string = this.senSupplier.getFirstSen();
        if (string == null) {
            string = "";
        }
        return new RequestContext(string, null, null, null, null, null, null, null, null, 510, null);
    }

    @NotNull
    public final RequestContext buildForMigrationId(@NotNull String migrationId) {
        String string;
        Plan it;
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        String string2 = this.migrationRepository.findPlanIdByMigrationId(migrationId);
        if (string2 == null) {
            throw new RuntimeException("Invalid migrationId");
        }
        String planId = string2;
        Plan plan2 = this.planRepository.get(planId);
        if (plan2 != null) {
            it = plan2;
            boolean bl = false;
            string = this.senSupplier.getFirstSen();
            if (string == null) {
                string = "";
            }
        } else {
            throw new RuntimeException("Invalid PlanId");
        }
        String string3 = string;
        String string4 = it.getCloudId();
        URI uRI = URI.create(it.getCloudUrl());
        String string5 = it.getPlanName();
        String string6 = this.getUserAgent();
        JiraSenInfo jiraSenInfo = this.senSupplier.getSens();
        return new RequestContext(string3, string4, uRI, migrationId, null, null, string5, string6, jiraSenInfo, 48, null);
    }

    @NotNull
    public final RequestContext buildForPlan(@NotNull Plan plan2) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        String string = this.senSupplier.getFirstSen();
        if (string == null) {
            string = "";
        }
        return new RequestContext(string, plan2.getCloudId(), URI.create(plan2.getCloudUrl()), null, null, null, plan2.getPlanName(), this.getUserAgent(), this.senSupplier.getSens(), 56, null);
    }

    @NotNull
    public final RequestContext buildForExecutionContext(@NotNull CloudSite cloudSite2, @NotNull String planName) {
        Intrinsics.checkNotNullParameter((Object)cloudSite2, (String)"cloudSite");
        Intrinsics.checkNotNullParameter((Object)planName, (String)"planName");
        String string = this.senSupplier.getFirstSen();
        if (string == null) {
            string = "";
        }
        return new RequestContext(string, cloudSite2.getCloudId(), cloudSite2.getCloudUrl(), null, null, null, planName, this.getUserAgent(), this.senSupplier.getSens(), 56, null);
    }

    @NotNull
    public final String getUserAgent() {
        return this.userAgentProvider.getUserAgent();
    }
}

