/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.crypto;

import com.atlassian.jira.migration.crypto.SecretKeyConfigHandler;
import com.atlassian.jira.migration.crypto.SecretKeyLocation;
import com.atlassian.jira.migration.crypto.SecretKeyProvider;
import com.atlassian.jira.migration.crypto.exception.CryptographyException;
import com.atlassian.jira.migration.crypto.exception.InvalidSecretKeyException;
import com.atlassian.jira.migration.crypto.exception.SecretKeyNotFoundException;
import com.atlassian.jira.migration.crypto.util.AesUtil;
import com.atlassian.jira.migration.crypto.util.SecretKeyUtil;
import com.atlassian.jira.migration.events.DecryptionFailedEvent;
import com.atlassian.jira.migration.events.EncryptionFailedEvent;
import com.atlassian.jira.migration.events.InvalidSecretKeyEvent;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import javax.crypto.AEADBadTagException;
import javax.crypto.SecretKey;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fJ\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000fH\u0002J\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010\u001e\u001a\u00020\u001fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/atlassian/jira/migration/crypto/EncryptionService;", "", "secretKeyProvider", "Lcom/atlassian/jira/migration/crypto/SecretKeyProvider;", "secretKeyConfigHandler", "Lcom/atlassian/jira/migration/crypto/SecretKeyConfigHandler;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/migration/crypto/SecretKeyProvider;Lcom/atlassian/jira/migration/crypto/SecretKeyConfigHandler;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "addPrefix", "", "cipherText", "prefix", "", "decrypt", "secretKey", "Ljavax/crypto/SecretKey;", "decryptAll", "", "cipherTextList", "encrypt", "plainText", "isEncrypted", "", "removePrefix", "array", "prefixLength", "", "validateEncryption", "", "Companion", "jira-migration-plugin"})
public final class EncryptionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SecretKeyProvider secretKeyProvider;
    @NotNull
    private final SecretKeyConfigHandler secretKeyConfigHandler;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private static final String ENCRYPTION_PREFIX = "encrypted_";
    private static final Logger log = LoggerFactory.getLogger(EncryptionService.class);
    @NotNull
    private static final String DUMMY_PLAINTEXT = "plain-text";
    @NotNull
    private static final String INVALID_SECRET_KEY_ERROR = "Invalid secret key provided in environment.";
    @NotNull
    private static final String SECRET_KEY_NOT_FOUND_ERROR = "Secret key not found in jira environment.";

    @Inject
    public EncryptionService(@NotNull SecretKeyProvider secretKeyProvider, @NotNull SecretKeyConfigHandler secretKeyConfigHandler, @NotNull MigrationFeatures migrationFeatures, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)secretKeyProvider, (String)"secretKeyProvider");
        Intrinsics.checkNotNullParameter((Object)secretKeyConfigHandler, (String)"secretKeyConfigHandler");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.secretKeyProvider = secretKeyProvider;
        this.secretKeyConfigHandler = secretKeyConfigHandler;
        this.migrationFeatures = migrationFeatures;
        this.migrationEventBus = migrationEventBus;
    }

    @NotNull
    public final String encrypt(@NotNull String plainText) {
        Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
        if (!this.migrationFeatures.getEnableTokenEncryption()) {
            return plainText;
        }
        SecretKey secretKey = this.secretKeyProvider.getSecretKey();
        return this.encrypt(plainText, secretKey);
    }

    @NotNull
    public final String decrypt(@NotNull String cipherText) {
        Intrinsics.checkNotNullParameter((Object)cipherText, (String)"cipherText");
        if (!this.migrationFeatures.getEnableTokenEncryption()) {
            return cipherText;
        }
        SecretKey secretKey = this.secretKeyProvider.getSecretKey();
        return this.decrypt(cipherText, secretKey);
    }

    @NotNull
    public final Collection<String> decryptAll(@NotNull Collection<String> cipherTextList) {
        Intrinsics.checkNotNullParameter(cipherTextList, (String)"cipherTextList");
        if (!this.migrationFeatures.getEnableTokenEncryption()) {
            return cipherTextList;
        }
        SecretKey secretKey = this.secretKeyProvider.getSecretKey();
        List plainTextList = new ArrayList();
        for (String cipherText : cipherTextList) {
            try {
                plainTextList.add(this.decrypt(cipherText, secretKey));
            }
            catch (CryptographyException e) {
                log.warn("Failed to decrypt text. Skipping to next one.");
                plainTextList.add(cipherText);
            }
        }
        return plainTextList;
    }

    public final void validateEncryption() {
        String secretKey;
        String secretKeyLocation = this.secretKeyConfigHandler.getSecretKeyLocation();
        if (Intrinsics.areEqual((Object)secretKeyLocation, (Object)SecretKeyLocation.ENV_VAR.getValue()) && Strings.isNullOrEmpty((String)(secretKey = this.secretKeyConfigHandler.getSecretKeyFromEnv()))) {
            this.migrationEventBus.post(new InvalidSecretKeyEvent(SECRET_KEY_NOT_FOUND_ERROR, secretKeyLocation));
            throw new SecretKeyNotFoundException(SECRET_KEY_NOT_FOUND_ERROR);
        }
        try {
            if (!Intrinsics.areEqual((Object)this.decrypt(this.encrypt(DUMMY_PLAINTEXT)), (Object)DUMMY_PLAINTEXT)) {
                this.migrationEventBus.post(new InvalidSecretKeyEvent(INVALID_SECRET_KEY_ERROR, secretKeyLocation));
                throw new InvalidSecretKeyException(INVALID_SECRET_KEY_ERROR);
            }
        }
        catch (CryptographyException e) {
            log.error("Error occurred while validating encryption: " + e);
            throw e;
        }
    }

    private final String encrypt(String plainText, SecretKey secretKey) {
        if (this.isEncrypted(plainText)) {
            log.warn("Data is already encrypted. Returning without encryption. ");
            return plainText;
        }
        try {
            byte[] iV = SecretKeyUtil.INSTANCE.generateIV(12);
            byte[] byArray = plainText.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] cipherText = AesUtil.INSTANCE.encrypt(byArray, secretKey, iV);
            byte[] mergedCipherText = SecretKeyUtil.INSTANCE.mergeIV(iV, cipherText);
            byte[] byArray2 = Base64.getEncoder().encode(mergedCipherText);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"encode(...)");
            byte[] encodedCipherText = byArray2;
            byte[] prefixedCipherText = this.addPrefix(encodedCipherText, ENCRYPTION_PREFIX);
            return new String(prefixedCipherText, Charsets.UTF_8);
        }
        catch (Exception e) {
            this.migrationEventBus.post(new EncryptionFailedEvent(e.getMessage()));
            throw new CryptographyException("Failed to encrypt data due to: " + e);
        }
    }

    private final String decrypt(String cipherText, SecretKey secretKey) {
        String string;
        if (!this.isEncrypted(cipherText)) {
            log.warn("Data is not encrypted. Returning without decryption");
            return cipherText;
        }
        try {
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] byArray = cipherText.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] decodeCipherText = decoder.decode(this.removePrefix(byArray, 10));
            Intrinsics.checkNotNull((Object)decodeCipherText);
            String[] splitText = SecretKeyUtil.INSTANCE.unmergeIV(decodeCipherText);
            byte[] iV = Base64.getDecoder().decode(splitText[0]);
            byte[] unmergedCipherText = Base64.getDecoder().decode(splitText[1]);
            Intrinsics.checkNotNull((Object)unmergedCipherText);
            Intrinsics.checkNotNull((Object)iV);
            byte[] decryptedText = AesUtil.INSTANCE.decrypt(unmergedCipherText, secretKey, iV);
            string = new String(decryptedText, Charsets.UTF_8);
        }
        catch (AEADBadTagException e) {
            log.warn("Secret key has changed.");
            this.migrationEventBus.post(new DecryptionFailedEvent(e.getMessage()));
            return cipherText;
        }
        catch (Exception e) {
            this.migrationEventBus.post(new DecryptionFailedEvent(e.getMessage()));
            throw new CryptographyException("Failed to decrypt data due to: " + e);
        }
        return string;
    }

    private final byte[] addPrefix(byte[] cipherText, String prefix2) {
        byte[] byArray = prefix2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] prefixBytes = byArray;
        byte[] prefixedCipherText = new byte[prefixBytes.length + cipherText.length];
        System.arraycopy(prefixBytes, 0, prefixedCipherText, 0, prefixBytes.length);
        System.arraycopy(cipherText, 0, prefixedCipherText, prefixBytes.length, cipherText.length);
        return prefixedCipherText;
    }

    private final boolean isEncrypted(String cipherText) {
        return StringsKt.startsWith$default((String)cipherText, (String)ENCRYPTION_PREFIX, (boolean)false, (int)2, null);
    }

    private final byte[] removePrefix(byte[] array, int prefixLength) {
        byte[] removedPrefixArray = new byte[array.length - prefixLength];
        System.arraycopy(array, prefixLength, removedPrefixArray, 0, array.length - prefixLength);
        return removedPrefixArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/crypto/EncryptionService$Companion;", "", "()V", "DUMMY_PLAINTEXT", "", "ENCRYPTION_PREFIX", "INVALID_SECRET_KEY_ERROR", "SECRET_KEY_NOT_FOUND_ERROR", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

