/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.crypto;

import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.migration.common.EnvironmentConfigs;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\b\u0010\f\u001a\u0004\u0018\u00010\u000bJ\b\u0010\r\u001a\u0004\u0018\u00010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000bJ\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000bJ\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/crypto/SecretKeyConfigHandler;", "", "jiraHome", "Lcom/atlassian/jira/config/util/JiraHome;", "(Lcom/atlassian/jira/config/util/JiraHome;)V", "secretKeyConfigFilePath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "createSecretKeyConfigFile", "", "getSecretKeyFromConfig", "", "getSecretKeyFromEnv", "getSecretKeyLocation", "loadSecretKeyConfigFile", "Ljava/util/Properties;", "putSecretKeyInConfig", "secretKey", "setSecretKeyLocation", "secretKeyLocation", "writeToSecretKeyConfigFile", "prop", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nSecretKeyConfigHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecretKeyConfigHandler.kt\ncom/atlassian/jira/migration/crypto/SecretKeyConfigHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
public final class SecretKeyConfigHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Path secretKeyConfigFilePath;
    private static final Logger log = LoggerFactory.getLogger(SecretKeyConfigHandler.class);
    @NotNull
    private static final String SECRET_CONFIG_FILE_NAME = "secret.properties";
    @NotNull
    private static final String SECRET_KEY_LOCATION = "jcma.secret.key.location";
    @NotNull
    private static final String SECRET_KEY = "jcma.secret.key";
    @NotNull
    private static final String SECRET_CONFIG_DIR = "migration-settings";

    @Inject
    public SecretKeyConfigHandler(@NotNull JiraHome jiraHome) {
        Intrinsics.checkNotNullParameter((Object)jiraHome, (String)"jiraHome");
        String[] stringArray = new String[]{SECRET_CONFIG_DIR, SECRET_CONFIG_FILE_NAME};
        this.secretKeyConfigFilePath = Paths.get(jiraHome.getHomePath(), stringArray);
    }

    @Nullable
    public final String getSecretKeyLocation() {
        return this.loadSecretKeyConfigFile().getProperty(SECRET_KEY_LOCATION);
    }

    public final void setSecretKeyLocation(@NotNull String secretKeyLocation) {
        Intrinsics.checkNotNullParameter((Object)secretKeyLocation, (String)"secretKeyLocation");
        Properties prop = this.loadSecretKeyConfigFile();
        prop.setProperty(SECRET_KEY_LOCATION, secretKeyLocation);
        log.info("Setting secret location in config file.");
        this.writeToSecretKeyConfigFile(prop);
    }

    @Nullable
    public final String getSecretKeyFromEnv() {
        return System.getenv(EnvironmentConfigs.Companion.propNameToEnvVar(SECRET_KEY));
    }

    @Nullable
    public final String getSecretKeyFromConfig() {
        return this.loadSecretKeyConfigFile().getProperty(SECRET_KEY);
    }

    public final void putSecretKeyInConfig(@NotNull String secretKey) {
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        Properties prop = this.loadSecretKeyConfigFile();
        prop.setProperty(SECRET_KEY, secretKey);
        log.info("Setting secret key in config file.");
        this.writeToSecretKeyConfigFile(prop);
    }

    private final Properties loadSecretKeyConfigFile() {
        Unit unit;
        this.createSecretKeyConfigFile();
        FileInputStream fis = new FileInputStream(this.secretKeyConfigFilePath.toFile());
        Properties prop = new Properties();
        prop.load(fis);
        Unit $this$loadSecretKeyConfigFile_u24lambda_u240 = unit = Unit.INSTANCE;
        boolean bl = false;
        fis.close();
        return prop;
    }

    private final void createSecretKeyConfigFile() {
        if (Files.notExists(this.secretKeyConfigFilePath.getParent(), new LinkOption[0])) {
            Files.createDirectories(this.secretKeyConfigFilePath.getParent(), new FileAttribute[0]);
        }
        Path path = this.secretKeyConfigFilePath;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"secretKeyConfigFilePath");
        Path path2 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            log.info("Creating secret properties config file.");
            Files.createFile(this.secretKeyConfigFilePath, new FileAttribute[0]).toFile().toPath();
        }
    }

    private final void writeToSecretKeyConfigFile(Properties prop) {
        Unit unit;
        OutputStream out = new FileOutputStream(this.secretKeyConfigFilePath.toFile());
        prop.store(out, "");
        Unit $this$writeToSecretKeyConfigFile_u24lambda_u241 = unit = Unit.INSTANCE;
        boolean bl = false;
        out.close();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/crypto/SecretKeyConfigHandler$Companion;", "", "()V", "SECRET_CONFIG_DIR", "", "SECRET_CONFIG_FILE_NAME", "SECRET_KEY", "SECRET_KEY_LOCATION", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

