/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.crypto;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.jira.migration.common.exception.LockNotAcquiredException;
import com.atlassian.jira.migration.crypto.SecretKeyConfigHandler;
import com.atlassian.jira.migration.crypto.SecretKeyLocation;
import com.atlassian.jira.migration.crypto.exception.CryptographyException;
import com.atlassian.jira.migration.crypto.util.SecretKeyUtil;
import com.atlassian.jira.migration.events.InvalidSecretKeyEvent;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.google.common.base.Strings;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\u000e0\u000e2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010\u0011\u001a\n \u0010*\u0004\u0018\u00010\u00120\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\nJ\b\u0010\u0014\u001a\u00020\nH\u0002J\b\u0010\u0015\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/jira/migration/crypto/SecretKeyProvider;", "", "secretKeyConfigHandler", "Lcom/atlassian/jira/migration/crypto/SecretKeyConfigHandler;", "clusterLockService", "Lcom/atlassian/beehive/ClusterLockService;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/migration/crypto/SecretKeyConfigHandler;Lcom/atlassian/beehive/ClusterLockService;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "addNewSecretKeyToConfig", "Ljavax/crypto/SecretKey;", "decodeKey", "Ljavax/crypto/spec/SecretKeySpec;", "secretKey", "", "encodeKey", "kotlin.jvm.PlatformType", "getClusterLock", "Lcom/atlassian/beehive/ClusterLock;", "getSecretKey", "getSecretKeyFromConfig", "getSecretKeyFromEnv", "getSecretKeyFromLocation", "secretLocation", "Companion", "jira-migration-plugin"})
public final class SecretKeyProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SecretKeyConfigHandler secretKeyConfigHandler;
    @NotNull
    private final ClusterLockService clusterLockService;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    private static final Logger log = LoggerFactory.getLogger(SecretKeyProvider.class);
    @NotNull
    private static final String SECRET_KEY_CONFIG_WRITE_LOCK = "jcma.secret.key.config.write.lock";
    private static final long CLUSTER_LOCK_WAIT_TIME = 20L;

    @Inject
    public SecretKeyProvider(@NotNull SecretKeyConfigHandler secretKeyConfigHandler, @NotNull ClusterLockService clusterLockService, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)secretKeyConfigHandler, (String)"secretKeyConfigHandler");
        Intrinsics.checkNotNullParameter((Object)clusterLockService, (String)"clusterLockService");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.secretKeyConfigHandler = secretKeyConfigHandler;
        this.clusterLockService = clusterLockService;
        this.migrationEventBus = migrationEventBus;
    }

    @NotNull
    public final SecretKey getSecretKey() throws CryptographyException {
        SecretKey secretKey;
        String secretLocation = this.secretKeyConfigHandler.getSecretKeyLocation();
        try {
            SecretKey secretKey2;
            if (Strings.isNullOrEmpty((String)secretLocation)) {
                log.debug("Secret key location not specified. Creating new secret key in config file.");
                this.secretKeyConfigHandler.setSecretKeyLocation(SecretKeyLocation.CONFIG.getValue());
                secretKey2 = this.getSecretKeyFromConfig();
            } else {
                String string = secretLocation;
                Intrinsics.checkNotNull((Object)string);
                secretKey2 = this.getSecretKeyFromLocation(string);
            }
            secretKey = secretKey2;
        }
        catch (Exception e) {
            this.migrationEventBus.post(new InvalidSecretKeyEvent(e.getMessage(), secretLocation));
            throw new CryptographyException("Could not fetch secret key due to error: " + e);
        }
        return secretKey;
    }

    private final SecretKey getSecretKeyFromLocation(String secretLocation) {
        SecretKey secretKey;
        log.debug("Fetching secret key from: " + secretLocation);
        String string = secretLocation;
        if (Intrinsics.areEqual((Object)string, (Object)SecretKeyLocation.CONFIG.getValue())) {
            secretKey = this.getSecretKeyFromConfig();
        } else if (Intrinsics.areEqual((Object)string, (Object)SecretKeyLocation.ENV_VAR.getValue())) {
            secretKey = this.getSecretKeyFromEnv();
        } else {
            throw new CryptographyException("Unsupported secret key location: " + secretLocation);
        }
        return secretKey;
    }

    private final SecretKey getSecretKeyFromEnv() {
        String secretKey = this.secretKeyConfigHandler.getSecretKeyFromEnv();
        if (Strings.isNullOrEmpty((String)secretKey)) {
            throw new CryptographyException("Secret key not found in jira environment.");
        }
        String string = secretKey;
        Intrinsics.checkNotNull((Object)string);
        return this.decodeKey(string);
    }

    private final SecretKey getSecretKeyFromConfig() {
        SecretKey secretKey;
        String secretKey2 = this.secretKeyConfigHandler.getSecretKeyFromConfig();
        if (Strings.isNullOrEmpty((String)secretKey2)) {
            secretKey = this.addNewSecretKeyToConfig();
        } else {
            String string = secretKey2;
            Intrinsics.checkNotNull((Object)string);
            secretKey = this.decodeKey(string);
        }
        return secretKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SecretKey addNewSecretKeyToConfig() {
        log.debug("Adding new secret key in configuration file");
        ClusterLock lock = this.getClusterLock();
        if (lock.tryLock(20L, TimeUnit.SECONDS)) {
            try {
                SecretKey secretKey;
                SecretKey secretKey2;
                String secretKey3 = this.secretKeyConfigHandler.getSecretKeyFromConfig();
                if (Strings.isNullOrEmpty((String)secretKey3)) {
                    SecretKey newSecretKey = SecretKeyUtil.INSTANCE.generateAesKey();
                    String string = this.encodeKey(newSecretKey);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeKey(...)");
                    this.secretKeyConfigHandler.putSecretKeyInConfig(string);
                    secretKey = secretKey2;
                } else {
                    String string = secretKey3;
                    Intrinsics.checkNotNull((Object)string);
                    secretKey = this.decodeKey(string);
                }
                secretKey2 = secretKey;
                return secretKey2;
            }
            finally {
                lock.unlock();
            }
        }
        throw new LockNotAcquiredException("Could not acquire lock to write secret to config file.");
    }

    private final ClusterLock getClusterLock() {
        return this.clusterLockService.getLockForName(SECRET_KEY_CONFIG_WRITE_LOCK);
    }

    private final String encodeKey(SecretKey secretKey) {
        return Base64.getEncoder().encodeToString(secretKey.getEncoded());
    }

    private final SecretKeySpec decodeKey(String secretKey) {
        return new SecretKeySpec(Base64.getDecoder().decode(secretKey), "AES");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/crypto/SecretKeyProvider$Companion;", "", "()V", "CLUSTER_LOCK_WAIT_TIME", "", "SECRET_KEY_CONFIG_WRITE_LOCK", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

