/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.crypto.rest;

import com.atlassian.jira.migration.crypto.EncryptionService;
import com.atlassian.jira.migration.crypto.exception.InvalidSecretKeyException;
import com.atlassian.jira.migration.crypto.exception.SecretKeyNotFoundException;
import com.atlassian.jira.migration.features.MigrationFeatures;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Path(value="encryption")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/crypto/rest/EncryptionResource;", "", "encryptionService", "Lcom/atlassian/jira/migration/crypto/EncryptionService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/crypto/EncryptionService;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "validateEncryption", "Ljavax/ws/rs/core/Response;", "jira-migration-plugin"})
public final class EncryptionResource {
    @NotNull
    private final EncryptionService encryptionService;
    @NotNull
    private final MigrationFeatures migrationFeatures;

    @Inject
    public EncryptionResource(@NotNull EncryptionService encryptionService, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)encryptionService, (String)"encryptionService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.encryptionService = encryptionService;
        this.migrationFeatures = migrationFeatures;
    }

    @GET
    @Path(value="/validate")
    @NotNull
    public final Response validateEncryption() {
        Response response2;
        try {
            if (!this.migrationFeatures.getEnableTokenEncryption()) {
                Response response3 = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"FedRAMP is not enabled").build();
                Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"build(...)");
                return response3;
            }
            this.encryptionService.validateEncryption();
            response2 = Response.ok((Object)"VALID_SECRET_KEY").build();
            Intrinsics.checkNotNull((Object)response2);
        }
        catch (Exception e) {
            Exception exception = e;
            Response response4 = exception instanceof SecretKeyNotFoundException ? Response.ok((Object)"SECRET_KEY_NOT_FOUND").build() : (exception instanceof InvalidSecretKeyException ? Response.ok((Object)"INVALID_SECRET_KEY").build() : Response.serverError().entity((Object)"INTERNAL_SERVER_ERROR").build());
            Intrinsics.checkNotNull((Object)response4);
            response2 = response4;
        }
        return response2;
    }
}

