/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.crypto.util;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004J\u001e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004J(\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/crypto/util/AesUtil;", "", "()V", "decrypt", "", "cipherText", "secretKey", "Ljavax/crypto/SecretKey;", "iv", "encrypt", "plaintext", "process", "text", "mode", "", "jira-migration-plugin"})
public final class AesUtil {
    @NotNull
    public static final AesUtil INSTANCE = new AesUtil();

    private AesUtil() {
    }

    @NotNull
    public final byte[] encrypt(@NotNull byte[] plaintext, @NotNull SecretKey secretKey, @NotNull byte[] iv) {
        Intrinsics.checkNotNullParameter((Object)plaintext, (String)"plaintext");
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        return this.process(plaintext, secretKey, iv, 1);
    }

    @NotNull
    public final byte[] decrypt(@NotNull byte[] cipherText, @NotNull SecretKey secretKey, @NotNull byte[] iv) {
        Intrinsics.checkNotNullParameter((Object)cipherText, (String)"cipherText");
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        return this.process(cipherText, secretKey, iv, 2);
    }

    private final byte[] process(byte[] text, SecretKey secretKey, byte[] iv, int mode) {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        Intrinsics.checkNotNullExpressionValue((Object)cipher, (String)"getInstance(...)");
        Cipher cipher2 = cipher;
        SecretKeySpec keySpec = new SecretKeySpec(secretKey.getEncoded(), "AES");
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
        cipher2.init(mode, (Key)keySpec, gcmParameterSpec);
        byte[] byArray = cipher2.doFinal(text);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
        return byArray;
    }
}

