/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.crypto.util;

import java.security.SecureRandom;
import java.util.Base64;
import java.util.Collection;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ\u0019\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0010\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/jira/migration/crypto/util/SecretKeyUtil;", "", "()V", "IV_SEPARATOR", "", "generateAesKey", "Ljavax/crypto/SecretKey;", "generateIV", "", "size", "", "mergeIV", "iv", "cipherText", "unmergeIV", "", "encryptedText", "([B)[Ljava/lang/String;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nSecretKeyUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecretKeyUtil.kt\ncom/atlassian/jira/migration/crypto/util/SecretKeyUtil\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,36:1\n37#2,2:37\n*S KotlinDebug\n*F\n+ 1 SecretKeyUtil.kt\ncom/atlassian/jira/migration/crypto/util/SecretKeyUtil\n*L\n34#1:37,2\n*E\n"})
public final class SecretKeyUtil {
    @NotNull
    public static final SecretKeyUtil INSTANCE = new SecretKeyUtil();
    @NotNull
    private static final String IV_SEPARATOR = "-";

    private SecretKeyUtil() {
    }

    @NotNull
    public final SecretKey generateAesKey() {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        Intrinsics.checkNotNullExpressionValue((Object)keyGenerator, (String)"getInstance(...)");
        KeyGenerator keyGenerator2 = keyGenerator;
        keyGenerator2.init(256);
        SecretKey secretKey = keyGenerator2.generateKey();
        Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"generateKey(...)");
        return secretKey;
    }

    @NotNull
    public final byte[] generateIV(int size) {
        SecureRandom secureRandom = SecureRandom.getInstanceStrong();
        Intrinsics.checkNotNullExpressionValue((Object)secureRandom, (String)"getInstanceStrong(...)");
        SecureRandom random = secureRandom;
        byte[] iv = new byte[size];
        random.nextBytes(iv);
        return iv;
    }

    @NotNull
    public final byte[] mergeIV(@NotNull byte[] iv, @NotNull byte[] cipherText) {
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)cipherText, (String)"cipherText");
        String encodedIV = Base64.getEncoder().encodeToString(iv);
        String encodedCipherText = Base64.getEncoder().encodeToString(cipherText);
        String mergedText = encodedIV + '-' + encodedCipherText;
        byte[] byArray = mergedText.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }

    @NotNull
    public final String[] unmergeIV(@NotNull byte[] encryptedText) {
        Intrinsics.checkNotNullParameter((Object)encryptedText, (String)"encryptedText");
        String[] stringArray = new String[]{IV_SEPARATOR};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)new String(encryptedText, Charsets.UTF_8), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }
}

