/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.datafilters.service;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.migration.datafilters.model.DataFilterContext;
import com.atlassian.jira.migration.datafilters.validator.AttachmentFilterValidator;
import com.atlassian.jira.migration.datafilters.validator.IssueFilterValidator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ!\u0010\u000b\u001a\u00020\f\"\u0004\b\u0000\u0010\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u0002H\r\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/datafilters/service/DataFilterService;", "", "issueFilterValidator", "Lcom/atlassian/jira/migration/datafilters/validator/IssueFilterValidator;", "attachmentFilterValidator", "Lcom/atlassian/jira/migration/datafilters/validator/AttachmentFilterValidator;", "(Lcom/atlassian/jira/migration/datafilters/validator/IssueFilterValidator;Lcom/atlassian/jira/migration/datafilters/validator/AttachmentFilterValidator;)V", "logFilteringResults", "", "context", "Lcom/atlassian/jira/migration/datafilters/model/DataFilterContext;", "shouldExportEntity", "", "T", "entity", "(Lcom/atlassian/jira/migration/datafilters/model/DataFilterContext;Ljava/lang/Object;)Z", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nDataFilterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataFilterService.kt\ncom/atlassian/jira/migration/datafilters/service/DataFilterService\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,36:1\n215#2,2:37\n*S KotlinDebug\n*F\n+ 1 DataFilterService.kt\ncom/atlassian/jira/migration/datafilters/service/DataFilterService\n*L\n26#1:37,2\n*E\n"})
public final class DataFilterService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IssueFilterValidator issueFilterValidator;
    @NotNull
    private final AttachmentFilterValidator attachmentFilterValidator;
    private static final Logger log = LoggerFactory.getLogger(DataFilterService.class);

    @Inject
    public DataFilterService(@NotNull IssueFilterValidator issueFilterValidator, @NotNull AttachmentFilterValidator attachmentFilterValidator) {
        Intrinsics.checkNotNullParameter((Object)issueFilterValidator, (String)"issueFilterValidator");
        Intrinsics.checkNotNullParameter((Object)attachmentFilterValidator, (String)"attachmentFilterValidator");
        this.issueFilterValidator = issueFilterValidator;
        this.attachmentFilterValidator = attachmentFilterValidator;
    }

    public final <T> boolean shouldExportEntity(@NotNull DataFilterContext context, T entity) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        T t = entity;
        return t instanceof Issue ? this.issueFilterValidator.shouldExport(context, (Issue)entity) : (t instanceof Attachment ? this.attachmentFilterValidator.shouldExport(context, (Attachment)entity) : true);
    }

    public final void logFilteringResults(@NotNull DataFilterContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map<String, List<Long>> $this$forEach$iv = context.getDataFilterResults();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, List<Long>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, List<Long>> element$iv;
            Map.Entry<String, List<Long>> entry = element$iv = iterator2.next();
            boolean bl = false;
            String filterType = entry.getKey();
            List<Long> entityIds = entry.getValue();
            log.info("Data Filter " + filterType + " removed " + entityIds.size() + " entities");
            log.debug("Data Filter {} removed entities with id's {}", (Object)filterType, entityIds);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/datafilters/service/DataFilterService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

